/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.pricer.impl.rate;

import com.opengamma.strata.basics.date.DayCount;
import com.opengamma.strata.basics.date.HolidayCalendar;
import com.opengamma.strata.basics.index.OvernightIndex;
import com.opengamma.strata.basics.index.OvernightIndexObservation;
import com.opengamma.strata.collect.timeseries.LocalDateDoubleTimeSeries;
import com.opengamma.strata.market.explain.ExplainKey;
import com.opengamma.strata.market.explain.ExplainMapBuilder;
import com.opengamma.strata.market.sensitivity.PointSensitivityBuilder;
import com.opengamma.strata.pricer.PricingException;
import com.opengamma.strata.pricer.rate.OvernightIndexRates;
import com.opengamma.strata.pricer.rate.RateComputationFn;
import com.opengamma.strata.pricer.rate.RatesProvider;
import com.opengamma.strata.product.rate.OvernightAveragedRateComputation;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.OptionalDouble;

public class ApproxForwardOvernightAveragedRateComputationFn
implements RateComputationFn<OvernightAveragedRateComputation> {
    public static final ApproxForwardOvernightAveragedRateComputationFn DEFAULT = new ApproxForwardOvernightAveragedRateComputationFn();

    @Override
    public double rate(OvernightAveragedRateComputation computation, LocalDate startDate, LocalDate endDate, RatesProvider provider) {
        LocalDate startFixingDate;
        LocalDate startPublicationDate;
        OvernightIndexRates rates = provider.overnightIndexRates(computation.getIndex());
        LocalDate valuationDate = rates.getValuationDate();
        if (valuationDate.isBefore(startPublicationDate = computation.calculatePublicationFromFixing(startFixingDate = computation.getStartDate()))) {
            return this.rateForward(computation, rates);
        }
        ObservationDetails details = new ObservationDetails(computation, rates);
        return details.calculateRate();
    }

    @Override
    public PointSensitivityBuilder rateSensitivity(OvernightAveragedRateComputation computation, LocalDate startDate, LocalDate endDate, RatesProvider provider) {
        LocalDate startFixingDate;
        LocalDate startPublicationDate;
        OvernightIndexRates rates = provider.overnightIndexRates(computation.getIndex());
        LocalDate valuationDate = rates.getValuationDate();
        if (valuationDate.isBefore(startPublicationDate = computation.calculatePublicationFromFixing(startFixingDate = computation.getStartDate()))) {
            return this.rateForwardSensitivity(computation, rates);
        }
        ObservationDetails details = new ObservationDetails(computation, rates);
        return details.calculateRateSensitivity();
    }

    @Override
    public double explainRate(OvernightAveragedRateComputation computation, LocalDate startDate, LocalDate endDate, RatesProvider provider, ExplainMapBuilder builder) {
        double rate = this.rate(computation, startDate, endDate, provider);
        builder.put(ExplainKey.COMBINED_RATE, (Object)rate);
        return rate;
    }

    private double rateForward(OvernightAveragedRateComputation computation, OvernightIndexRates rates) {
        OvernightIndex index = computation.getIndex();
        HolidayCalendar calendar = computation.getFixingCalendar();
        LocalDate startFixingDate = computation.getStartDate();
        LocalDate endFixingDateP1 = computation.getEndDate();
        LocalDate endFixingDate = calendar.previous(endFixingDateP1);
        LocalDate onRateEndDate = computation.calculateMaturityFromFixing(endFixingDate);
        LocalDate onRateStartDate = computation.calculateEffectiveFromFixing(startFixingDate);
        LocalDate onRateNoCutOffEndDate = onRateEndDate;
        int cutoffOffset = computation.getRateCutOffDays() > 1 ? computation.getRateCutOffDays() : 1;
        double accumulatedInterest = 0.0;
        double accrualFactorTotal = index.getDayCount().yearFraction(onRateStartDate, onRateEndDate);
        if (cutoffOffset > 1) {
            LocalDate currentFixingDate = endFixingDate;
            OvernightIndexObservation lastIndexObs = null;
            double cutOffAccrualFactorTotal = 0.0;
            for (int i = 1; i < cutoffOffset; ++i) {
                currentFixingDate = calendar.previous(currentFixingDate);
                lastIndexObs = computation.observeOn(currentFixingDate);
                onRateNoCutOffEndDate = lastIndexObs.getMaturityDate();
                cutOffAccrualFactorTotal += lastIndexObs.getYearFraction();
            }
            double forwardRateCutOff = rates.rate(lastIndexObs);
            accumulatedInterest += cutOffAccrualFactorTotal * forwardRateCutOff;
        }
        return (accumulatedInterest += ApproxForwardOvernightAveragedRateComputationFn.approximatedInterest(computation.observeOn(onRateStartDate), onRateNoCutOffEndDate, rates)) / accrualFactorTotal;
    }

    private PointSensitivityBuilder rateForwardSensitivity(OvernightAveragedRateComputation computation, OvernightIndexRates rates) {
        OvernightIndex index = computation.getIndex();
        HolidayCalendar calendar = computation.getFixingCalendar();
        LocalDate startFixingDate = computation.getStartDate();
        LocalDate endFixingDateP1 = computation.getEndDate();
        LocalDate endFixingDate = calendar.previous(endFixingDateP1);
        LocalDate onRateEndDate = computation.calculateMaturityFromFixing(endFixingDate);
        LocalDate onRateStartDate = computation.calculateEffectiveFromFixing(startFixingDate);
        LocalDate lastNonCutOffMatDate = onRateEndDate;
        int cutoffOffset = computation.getRateCutOffDays() > 1 ? computation.getRateCutOffDays() : 1;
        PointSensitivityBuilder combinedPointSensitivityBuilder = PointSensitivityBuilder.none();
        double accrualFactorTotal = index.getDayCount().yearFraction(onRateStartDate, onRateEndDate);
        if (cutoffOffset > 1) {
            ArrayList<Double> noCutOffAccrualFactorList = new ArrayList<Double>();
            LocalDate currentFixingDate = endFixingDateP1;
            for (int i = 0; i < cutoffOffset; ++i) {
                currentFixingDate = calendar.previous(currentFixingDate);
                LocalDate cutOffEffectiveDate = computation.calculateEffectiveFromFixing(currentFixingDate);
                lastNonCutOffMatDate = computation.calculateMaturityFromEffective(cutOffEffectiveDate);
                double accrualFactor = index.getDayCount().yearFraction(cutOffEffectiveDate, lastNonCutOffMatDate);
                noCutOffAccrualFactorList.add(accrualFactor);
            }
            OvernightIndexObservation lastIndexObs = computation.observeOn(currentFixingDate);
            PointSensitivityBuilder forwardRateCutOffSensitivity = rates.ratePointSensitivity(lastIndexObs);
            double totalAccrualFactor = 0.0;
            for (int i = 0; i < cutoffOffset - 1; ++i) {
                totalAccrualFactor += ((Double)noCutOffAccrualFactorList.get(i)).doubleValue();
            }
            forwardRateCutOffSensitivity = forwardRateCutOffSensitivity.multipliedBy(totalAccrualFactor);
            combinedPointSensitivityBuilder = combinedPointSensitivityBuilder.combinedWith(forwardRateCutOffSensitivity);
        }
        OvernightIndexObservation indexObs = computation.observeOn(onRateStartDate);
        PointSensitivityBuilder approximatedInterestAndSensitivity = ApproxForwardOvernightAveragedRateComputationFn.approximatedInterestSensitivity(indexObs, lastNonCutOffMatDate, rates);
        combinedPointSensitivityBuilder = combinedPointSensitivityBuilder.combinedWith(approximatedInterestAndSensitivity);
        combinedPointSensitivityBuilder = combinedPointSensitivityBuilder.multipliedBy(1.0 / accrualFactorTotal);
        return combinedPointSensitivityBuilder;
    }

    private static double approximatedInterest(OvernightIndexObservation observation, LocalDate endDate, OvernightIndexRates rates) {
        DayCount dayCount = observation.getIndex().getDayCount();
        double remainingFixingAccrualFactor = dayCount.yearFraction(observation.getEffectiveDate(), endDate);
        double forwardRate = rates.periodRate(observation, endDate);
        return Math.log(1.0 + forwardRate * remainingFixingAccrualFactor);
    }

    private static PointSensitivityBuilder approximatedInterestSensitivity(OvernightIndexObservation observation, LocalDate endDate, OvernightIndexRates rates) {
        DayCount dayCount = observation.getIndex().getDayCount();
        double remainingFixingAccrualFactor = dayCount.yearFraction(observation.getEffectiveDate(), endDate);
        double forwardRate = rates.periodRate(observation, endDate);
        PointSensitivityBuilder forwardRateSensitivity = rates.periodRatePointSensitivity(observation, endDate);
        double rateExp = 1.0 + forwardRate * remainingFixingAccrualFactor;
        forwardRateSensitivity = forwardRateSensitivity.multipliedBy(remainingFixingAccrualFactor / rateExp);
        return forwardRateSensitivity;
    }

    private static final class ObservationDetails {
        private final OvernightIndexRates rates;
        private final List<OvernightIndexObservation> observations;
        private int fixedPeriod;
        private final double accrualFactorTotal;
        private final int nbPeriods;
        private final OvernightIndex index;
        private final int cutoffOffset;

        private ObservationDetails(OvernightAveragedRateComputation computation, OvernightIndexRates rates) {
            this.index = computation.getIndex();
            this.rates = rates;
            LocalDate startFixingDate = computation.getStartDate();
            LocalDate endFixingDateP1 = computation.getEndDate();
            this.cutoffOffset = computation.getRateCutOffDays() > 1 ? computation.getRateCutOffDays() : 1;
            double accrualFactorAccumulated = 0.0;
            LocalDate currentFixing = startFixingDate;
            ArrayList<OvernightIndexObservation> indexObsList = new ArrayList<OvernightIndexObservation>();
            while (currentFixing.isBefore(endFixingDateP1)) {
                OvernightIndexObservation indexObs = computation.observeOn(currentFixing);
                indexObsList.add(indexObs);
                currentFixing = computation.getFixingCalendar().next(currentFixing);
                accrualFactorAccumulated += indexObs.getYearFraction();
            }
            this.accrualFactorTotal = accrualFactorAccumulated;
            this.nbPeriods = indexObsList.size();
            for (int i = 0; i < this.cutoffOffset - 1; ++i) {
                OvernightIndexObservation fixingIndexObs = (OvernightIndexObservation)indexObsList.get(this.nbPeriods - this.cutoffOffset);
                OvernightIndexObservation cutoffIndexObs = (OvernightIndexObservation)indexObsList.get(this.nbPeriods - 1 - i);
                OvernightIndexObservation updatedIndexObs = cutoffIndexObs.toBuilder().fixingDate(fixingIndexObs.getFixingDate()).publicationDate(fixingIndexObs.getPublicationDate()).build();
                indexObsList.set(this.nbPeriods - 1 - i, updatedIndexObs);
            }
            this.observations = Collections.unmodifiableList(indexObsList);
        }

        private double pastAccumulation() {
            double accumulatedInterest = 0.0;
            LocalDateDoubleTimeSeries indexFixingDateSeries = this.rates.getFixings();
            while (this.fixedPeriod < this.nbPeriods && this.rates.getValuationDate().isAfter(this.observations.get(this.fixedPeriod).getPublicationDate())) {
                OvernightIndexObservation obs = this.observations.get(this.fixedPeriod);
                accumulatedInterest += obs.getYearFraction() * ObservationDetails.checkedFixing(obs.getFixingDate(), indexFixingDateSeries, this.index);
                ++this.fixedPeriod;
            }
            return accumulatedInterest;
        }

        private double valuationDateAccumulation() {
            double accumulatedInterest = 0.0;
            LocalDateDoubleTimeSeries indexFixingDateSeries = this.rates.getFixings();
            boolean ratePresent = true;
            while (ratePresent && this.fixedPeriod < this.nbPeriods && this.rates.getValuationDate().isEqual(this.observations.get(this.fixedPeriod).getPublicationDate())) {
                OvernightIndexObservation obs = this.observations.get(this.fixedPeriod);
                OptionalDouble fixedRate = indexFixingDateSeries.get(obs.getFixingDate());
                if (fixedRate.isPresent()) {
                    accumulatedInterest += obs.getYearFraction() * fixedRate.getAsDouble();
                    ++this.fixedPeriod;
                    continue;
                }
                ratePresent = false;
            }
            return accumulatedInterest;
        }

        private double approximatedForwardAccumulation() {
            int nbPeriodNotCutOff = this.nbPeriods - this.cutoffOffset + 1;
            if (this.fixedPeriod < nbPeriodNotCutOff) {
                LocalDate endDateApprox = this.observations.get(nbPeriodNotCutOff - 1).getMaturityDate();
                return ApproxForwardOvernightAveragedRateComputationFn.approximatedInterest(this.observations.get(this.fixedPeriod), endDateApprox, this.rates);
            }
            return 0.0;
        }

        private PointSensitivityBuilder approximatedForwardAccumulationSensitivity() {
            int nbPeriodNotCutOff = this.nbPeriods - this.cutoffOffset + 1;
            if (this.fixedPeriod < nbPeriodNotCutOff) {
                LocalDate endDateApprox = this.observations.get(nbPeriodNotCutOff - 1).getMaturityDate();
                return ApproxForwardOvernightAveragedRateComputationFn.approximatedInterestSensitivity(this.observations.get(this.fixedPeriod), endDateApprox, this.rates);
            }
            return PointSensitivityBuilder.none();
        }

        private double cutOffAccumulation() {
            double accumulatedInterest = 0.0;
            int nbPeriodNotCutOff = this.nbPeriods - this.cutoffOffset + 1;
            for (int i = Math.max(this.fixedPeriod, nbPeriodNotCutOff); i < this.nbPeriods; ++i) {
                OvernightIndexObservation obs = this.observations.get(i);
                double forwardRate = this.rates.rate(obs);
                accumulatedInterest += obs.getYearFraction() * forwardRate;
            }
            return accumulatedInterest;
        }

        private PointSensitivityBuilder cutOffAccumulationSensitivity() {
            PointSensitivityBuilder combinedPointSensitivityBuilder = PointSensitivityBuilder.none();
            int nbPeriodNotCutOff = this.nbPeriods - this.cutoffOffset + 1;
            for (int i = Math.max(this.fixedPeriod, nbPeriodNotCutOff); i < this.nbPeriods; ++i) {
                OvernightIndexObservation obs = this.observations.get(i);
                PointSensitivityBuilder forwardRateSensitivity = this.rates.ratePointSensitivity(obs).multipliedBy(obs.getYearFraction());
                combinedPointSensitivityBuilder = combinedPointSensitivityBuilder.combinedWith(forwardRateSensitivity);
            }
            return combinedPointSensitivityBuilder;
        }

        private double calculateRate() {
            return (this.pastAccumulation() + this.valuationDateAccumulation() + this.approximatedForwardAccumulation() + this.cutOffAccumulation()) / this.accrualFactorTotal;
        }

        private PointSensitivityBuilder calculateRateSensitivity() {
            this.pastAccumulation();
            this.valuationDateAccumulation();
            PointSensitivityBuilder combinedPointSensitivity = this.approximatedForwardAccumulationSensitivity();
            PointSensitivityBuilder cutOffAccumulationSensitivity = this.cutOffAccumulationSensitivity();
            combinedPointSensitivity = combinedPointSensitivity.combinedWith(cutOffAccumulationSensitivity);
            combinedPointSensitivity = combinedPointSensitivity.multipliedBy(1.0 / this.accrualFactorTotal);
            return combinedPointSensitivity;
        }

        private static double checkedFixing(LocalDate currentFixingTs, LocalDateDoubleTimeSeries indexFixingDateSeries, OvernightIndex index) {
            OptionalDouble fixedRate = indexFixingDateSeries.get(currentFixingTs);
            return fixedRate.orElseThrow(() -> new PricingException("Could not get fixing value of index " + index.getName() + " for date " + currentFixingTs));
        }
    }
}

