/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.pricer.impl.rate;

import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.market.explain.ExplainKey;
import com.opengamma.strata.market.explain.ExplainMapBuilder;
import com.opengamma.strata.market.sensitivity.PointSensitivityBuilder;
import com.opengamma.strata.math.MathException;
import com.opengamma.strata.pricer.impl.rate.ApproxForwardOvernightAveragedRateComputationFn;
import com.opengamma.strata.pricer.impl.rate.ForwardIborAveragedRateComputationFn;
import com.opengamma.strata.pricer.impl.rate.ForwardIborInterpolatedRateComputationFn;
import com.opengamma.strata.pricer.impl.rate.ForwardIborRateComputationFn;
import com.opengamma.strata.pricer.impl.rate.ForwardInflationEndInterpolatedRateComputationFn;
import com.opengamma.strata.pricer.impl.rate.ForwardInflationEndMonthRateComputationFn;
import com.opengamma.strata.pricer.impl.rate.ForwardInflationInterpolatedRateComputationFn;
import com.opengamma.strata.pricer.impl.rate.ForwardInflationMonthlyRateComputationFn;
import com.opengamma.strata.pricer.impl.rate.ForwardOvernightAveragedDailyRateComputationFn;
import com.opengamma.strata.pricer.impl.rate.ForwardOvernightCompoundedAnnualRateComputationFn;
import com.opengamma.strata.pricer.impl.rate.ForwardOvernightCompoundedRateComputationFn;
import com.opengamma.strata.pricer.rate.RateComputationFn;
import com.opengamma.strata.pricer.rate.RatesProvider;
import com.opengamma.strata.product.rate.FixedOvernightCompoundedAnnualRateComputation;
import com.opengamma.strata.product.rate.FixedRateComputation;
import com.opengamma.strata.product.rate.IborAveragedRateComputation;
import com.opengamma.strata.product.rate.IborInterpolatedRateComputation;
import com.opengamma.strata.product.rate.IborRateComputation;
import com.opengamma.strata.product.rate.InflationEndInterpolatedRateComputation;
import com.opengamma.strata.product.rate.InflationEndMonthRateComputation;
import com.opengamma.strata.product.rate.InflationInterpolatedRateComputation;
import com.opengamma.strata.product.rate.InflationMonthlyRateComputation;
import com.opengamma.strata.product.rate.OvernightAveragedDailyRateComputation;
import com.opengamma.strata.product.rate.OvernightAveragedRateComputation;
import com.opengamma.strata.product.rate.OvernightCompoundedAnnualRateComputation;
import com.opengamma.strata.product.rate.OvernightCompoundedRateComputation;
import com.opengamma.strata.product.rate.RateComputation;
import java.time.LocalDate;

public class DispatchingRateComputationFn
implements RateComputationFn<RateComputation> {
    public static final DispatchingRateComputationFn DEFAULT = new DispatchingRateComputationFn(ForwardIborRateComputationFn.DEFAULT, ForwardIborInterpolatedRateComputationFn.DEFAULT, ForwardIborAveragedRateComputationFn.DEFAULT, ForwardOvernightCompoundedRateComputationFn.DEFAULT, ForwardOvernightCompoundedAnnualRateComputationFn.DEFAULT, ApproxForwardOvernightAveragedRateComputationFn.DEFAULT, ForwardOvernightAveragedDailyRateComputationFn.DEFAULT, ForwardInflationMonthlyRateComputationFn.DEFAULT, ForwardInflationInterpolatedRateComputationFn.DEFAULT, ForwardInflationEndMonthRateComputationFn.DEFAULT, ForwardInflationEndInterpolatedRateComputationFn.DEFAULT);
    private final RateComputationFn<IborRateComputation> iborRateComputationFn;
    private final RateComputationFn<IborInterpolatedRateComputation> iborInterpolatedRateComputationFn;
    private final RateComputationFn<IborAveragedRateComputation> iborAveragedRateComputationFn;
    private final RateComputationFn<OvernightCompoundedRateComputation> overnightCompoundedRateComputationFn;
    private final RateComputationFn<OvernightCompoundedAnnualRateComputation> overnightCompundedAnnualRateComputationFn;
    private final RateComputationFn<OvernightAveragedRateComputation> overnightAveragedRateComputationFn;
    private final RateComputationFn<OvernightAveragedDailyRateComputation> overnightAveragedDailyRateComputationFn;
    private final RateComputationFn<InflationMonthlyRateComputation> inflationMonthlyRateComputationFn;
    private final RateComputationFn<InflationInterpolatedRateComputation> inflationInterpolatedRateComputationFn;
    private final RateComputationFn<InflationEndMonthRateComputation> inflationEndMonthRateComputationFn;
    private final RateComputationFn<InflationEndInterpolatedRateComputation> inflationEndInterpolatedRateComputationFn;

    public DispatchingRateComputationFn(RateComputationFn<IborRateComputation> iborRateComputationFn, RateComputationFn<IborInterpolatedRateComputation> iborInterpolatedRateComputationFn, RateComputationFn<IborAveragedRateComputation> iborAveragedRateComputationFn, RateComputationFn<OvernightCompoundedRateComputation> overnightCompoundedRateComputationFn, RateComputationFn<OvernightCompoundedAnnualRateComputation> overnightCompundedAnnualRateComputationFn, RateComputationFn<OvernightAveragedRateComputation> overnightAveragedRateComputationFn, RateComputationFn<OvernightAveragedDailyRateComputation> overnightAveragedDailyRateComputationFn, RateComputationFn<InflationMonthlyRateComputation> inflationMonthlyRateComputationFn, RateComputationFn<InflationInterpolatedRateComputation> inflationInterpolatedRateComputationFn, RateComputationFn<InflationEndMonthRateComputation> inflationEndMonthRateComputationFn, RateComputationFn<InflationEndInterpolatedRateComputation> inflationEndInterpolatedRateComputationFn) {
        this.iborRateComputationFn = (RateComputationFn)ArgChecker.notNull(iborRateComputationFn, (String)"iborRateComputationFn");
        this.iborInterpolatedRateComputationFn = (RateComputationFn)ArgChecker.notNull(iborInterpolatedRateComputationFn, (String)"iborInterpolatedRateComputationFn");
        this.iborAveragedRateComputationFn = (RateComputationFn)ArgChecker.notNull(iborAveragedRateComputationFn, (String)"iborAverageRateComputationFn");
        this.overnightCompoundedRateComputationFn = (RateComputationFn)ArgChecker.notNull(overnightCompoundedRateComputationFn, (String)"overnightCompoundedRateComputationFn");
        this.overnightCompundedAnnualRateComputationFn = (RateComputationFn)ArgChecker.notNull(overnightCompundedAnnualRateComputationFn, (String)"overnightCompundedAnnualRateComputationFn");
        this.overnightAveragedRateComputationFn = (RateComputationFn)ArgChecker.notNull(overnightAveragedRateComputationFn, (String)"overnightAveragedRateComputationFn");
        this.overnightAveragedDailyRateComputationFn = (RateComputationFn)ArgChecker.notNull(overnightAveragedDailyRateComputationFn, (String)"overnightAveragedDailyRateComputationFn");
        this.inflationMonthlyRateComputationFn = (RateComputationFn)ArgChecker.notNull(inflationMonthlyRateComputationFn, (String)"inflationMonthlyRateComputationFn");
        this.inflationInterpolatedRateComputationFn = (RateComputationFn)ArgChecker.notNull(inflationInterpolatedRateComputationFn, (String)"inflationInterpolatedRateComputationFn");
        this.inflationEndMonthRateComputationFn = (RateComputationFn)ArgChecker.notNull(inflationEndMonthRateComputationFn, (String)"inflationEndMonthRateComputationFn");
        this.inflationEndInterpolatedRateComputationFn = (RateComputationFn)ArgChecker.notNull(inflationEndInterpolatedRateComputationFn, (String)"inflationEndInterpolatedRateComputationFn");
    }

    @Override
    public double rate(RateComputation computation, LocalDate startDate, LocalDate endDate, RatesProvider provider) {
        double rate = this.rate0(computation, startDate, endDate, provider);
        if (rate != rate) {
            throw new MathException("Unable to calculate rate, NaN found");
        }
        return rate;
    }

    private double rate0(RateComputation computation, LocalDate startDate, LocalDate endDate, RatesProvider provider) {
        if (computation instanceof FixedRateComputation) {
            return ((FixedRateComputation)computation).getRate();
        }
        if (computation instanceof FixedOvernightCompoundedAnnualRateComputation) {
            return ((FixedOvernightCompoundedAnnualRateComputation)computation).getSimpleRate();
        }
        if (computation instanceof IborRateComputation) {
            return this.iborRateComputationFn.rate((IborRateComputation)computation, startDate, endDate, provider);
        }
        if (computation instanceof IborInterpolatedRateComputation) {
            return this.iborInterpolatedRateComputationFn.rate((IborInterpolatedRateComputation)computation, startDate, endDate, provider);
        }
        if (computation instanceof IborAveragedRateComputation) {
            return this.iborAveragedRateComputationFn.rate((IborAveragedRateComputation)computation, startDate, endDate, provider);
        }
        if (computation instanceof OvernightAveragedRateComputation) {
            return this.overnightAveragedRateComputationFn.rate((OvernightAveragedRateComputation)computation, startDate, endDate, provider);
        }
        if (computation instanceof OvernightCompoundedRateComputation) {
            return this.overnightCompoundedRateComputationFn.rate((OvernightCompoundedRateComputation)computation, startDate, endDate, provider);
        }
        if (computation instanceof OvernightCompoundedAnnualRateComputation) {
            return this.overnightCompundedAnnualRateComputationFn.rate((OvernightCompoundedAnnualRateComputation)computation, startDate, endDate, provider);
        }
        if (computation instanceof OvernightAveragedDailyRateComputation) {
            return this.overnightAveragedDailyRateComputationFn.rate((OvernightAveragedDailyRateComputation)computation, startDate, endDate, provider);
        }
        if (computation instanceof InflationMonthlyRateComputation) {
            return this.inflationMonthlyRateComputationFn.rate((InflationMonthlyRateComputation)computation, startDate, endDate, provider);
        }
        if (computation instanceof InflationInterpolatedRateComputation) {
            return this.inflationInterpolatedRateComputationFn.rate((InflationInterpolatedRateComputation)computation, startDate, endDate, provider);
        }
        if (computation instanceof InflationEndMonthRateComputation) {
            return this.inflationEndMonthRateComputationFn.rate((InflationEndMonthRateComputation)computation, startDate, endDate, provider);
        }
        if (computation instanceof InflationEndInterpolatedRateComputation) {
            return this.inflationEndInterpolatedRateComputationFn.rate((InflationEndInterpolatedRateComputation)computation, startDate, endDate, provider);
        }
        throw new IllegalArgumentException("Unknown Rate type: " + computation.getClass().getSimpleName());
    }

    @Override
    public PointSensitivityBuilder rateSensitivity(RateComputation computation, LocalDate startDate, LocalDate endDate, RatesProvider provider) {
        if (computation instanceof FixedRateComputation) {
            return PointSensitivityBuilder.none();
        }
        if (computation instanceof FixedOvernightCompoundedAnnualRateComputation) {
            return PointSensitivityBuilder.none();
        }
        if (computation instanceof IborRateComputation) {
            return this.iborRateComputationFn.rateSensitivity((IborRateComputation)computation, startDate, endDate, provider);
        }
        if (computation instanceof IborInterpolatedRateComputation) {
            return this.iborInterpolatedRateComputationFn.rateSensitivity((IborInterpolatedRateComputation)computation, startDate, endDate, provider);
        }
        if (computation instanceof IborAveragedRateComputation) {
            return this.iborAveragedRateComputationFn.rateSensitivity((IborAveragedRateComputation)computation, startDate, endDate, provider);
        }
        if (computation instanceof OvernightAveragedRateComputation) {
            return this.overnightAveragedRateComputationFn.rateSensitivity((OvernightAveragedRateComputation)computation, startDate, endDate, provider);
        }
        if (computation instanceof OvernightCompoundedRateComputation) {
            return this.overnightCompoundedRateComputationFn.rateSensitivity((OvernightCompoundedRateComputation)computation, startDate, endDate, provider);
        }
        if (computation instanceof OvernightCompoundedAnnualRateComputation) {
            return this.overnightCompundedAnnualRateComputationFn.rateSensitivity((OvernightCompoundedAnnualRateComputation)computation, startDate, endDate, provider);
        }
        if (computation instanceof OvernightAveragedDailyRateComputation) {
            return this.overnightAveragedDailyRateComputationFn.rateSensitivity((OvernightAveragedDailyRateComputation)computation, startDate, endDate, provider);
        }
        if (computation instanceof InflationMonthlyRateComputation) {
            return this.inflationMonthlyRateComputationFn.rateSensitivity((InflationMonthlyRateComputation)computation, startDate, endDate, provider);
        }
        if (computation instanceof InflationInterpolatedRateComputation) {
            return this.inflationInterpolatedRateComputationFn.rateSensitivity((InflationInterpolatedRateComputation)computation, startDate, endDate, provider);
        }
        if (computation instanceof InflationEndMonthRateComputation) {
            return this.inflationEndMonthRateComputationFn.rateSensitivity((InflationEndMonthRateComputation)computation, startDate, endDate, provider);
        }
        if (computation instanceof InflationEndInterpolatedRateComputation) {
            return this.inflationEndInterpolatedRateComputationFn.rateSensitivity((InflationEndInterpolatedRateComputation)computation, startDate, endDate, provider);
        }
        throw new IllegalArgumentException("Unknown Rate type: " + computation.getClass().getSimpleName());
    }

    @Override
    public double explainRate(RateComputation computation, LocalDate startDate, LocalDate endDate, RatesProvider provider, ExplainMapBuilder builder) {
        if (computation instanceof FixedRateComputation) {
            double rate = ((FixedRateComputation)computation).getRate();
            builder.put(ExplainKey.FIXED_RATE, (Object)rate);
            builder.put(ExplainKey.COMBINED_RATE, (Object)rate);
            return rate;
        }
        if (computation instanceof FixedOvernightCompoundedAnnualRateComputation) {
            double rate = ((FixedOvernightCompoundedAnnualRateComputation)computation).getRate();
            double simpleRate = ((FixedOvernightCompoundedAnnualRateComputation)computation).getSimpleRate();
            builder.put(ExplainKey.FIXED_RATE, (Object)rate);
            builder.put(ExplainKey.COMBINED_RATE, (Object)simpleRate);
            return rate;
        }
        if (computation instanceof IborRateComputation) {
            return this.iborRateComputationFn.explainRate((IborRateComputation)computation, startDate, endDate, provider, builder);
        }
        if (computation instanceof IborInterpolatedRateComputation) {
            return this.iborInterpolatedRateComputationFn.explainRate((IborInterpolatedRateComputation)computation, startDate, endDate, provider, builder);
        }
        if (computation instanceof IborAveragedRateComputation) {
            return this.iborAveragedRateComputationFn.explainRate((IborAveragedRateComputation)computation, startDate, endDate, provider, builder);
        }
        if (computation instanceof OvernightAveragedRateComputation) {
            return this.overnightAveragedRateComputationFn.explainRate((OvernightAveragedRateComputation)computation, startDate, endDate, provider, builder);
        }
        if (computation instanceof OvernightCompoundedRateComputation) {
            return this.overnightCompoundedRateComputationFn.explainRate((OvernightCompoundedRateComputation)computation, startDate, endDate, provider, builder);
        }
        if (computation instanceof OvernightCompoundedAnnualRateComputation) {
            return this.overnightCompundedAnnualRateComputationFn.explainRate((OvernightCompoundedAnnualRateComputation)computation, startDate, endDate, provider, builder);
        }
        if (computation instanceof OvernightAveragedDailyRateComputation) {
            return this.overnightAveragedDailyRateComputationFn.explainRate((OvernightAveragedDailyRateComputation)computation, startDate, endDate, provider, builder);
        }
        if (computation instanceof InflationMonthlyRateComputation) {
            return this.inflationMonthlyRateComputationFn.explainRate((InflationMonthlyRateComputation)computation, startDate, endDate, provider, builder);
        }
        if (computation instanceof InflationInterpolatedRateComputation) {
            return this.inflationInterpolatedRateComputationFn.explainRate((InflationInterpolatedRateComputation)computation, startDate, endDate, provider, builder);
        }
        if (computation instanceof InflationEndMonthRateComputation) {
            return this.inflationEndMonthRateComputationFn.explainRate((InflationEndMonthRateComputation)computation, startDate, endDate, provider, builder);
        }
        if (computation instanceof InflationEndInterpolatedRateComputation) {
            return this.inflationEndInterpolatedRateComputationFn.explainRate((InflationEndInterpolatedRateComputation)computation, startDate, endDate, provider, builder);
        }
        throw new IllegalArgumentException("Unknown Rate type: " + computation.getClass().getSimpleName());
    }
}

