/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.pricer.impl.rate;

import com.opengamma.strata.market.explain.ExplainKey;
import com.opengamma.strata.market.explain.ExplainMapBuilder;
import com.opengamma.strata.market.sensitivity.PointSensitivityBuilder;
import com.opengamma.strata.pricer.rate.PriceIndexValues;
import com.opengamma.strata.pricer.rate.RateComputationFn;
import com.opengamma.strata.pricer.rate.RatesProvider;
import com.opengamma.strata.product.rate.InflationEndMonthRateComputation;
import java.time.LocalDate;

public class ForwardInflationEndMonthRateComputationFn
implements RateComputationFn<InflationEndMonthRateComputation> {
    public static final ForwardInflationEndMonthRateComputationFn DEFAULT = new ForwardInflationEndMonthRateComputationFn();

    @Override
    public double rate(InflationEndMonthRateComputation computation, LocalDate startDate, LocalDate endDate, RatesProvider provider) {
        PriceIndexValues values = provider.priceIndexValues(computation.getIndex());
        double indexStart = computation.getStartIndexValue();
        double indexEnd = values.value(computation.getEndObservation());
        return indexEnd / indexStart - 1.0;
    }

    @Override
    public PointSensitivityBuilder rateSensitivity(InflationEndMonthRateComputation computation, LocalDate startDate, LocalDate endDate, RatesProvider provider) {
        PriceIndexValues values = provider.priceIndexValues(computation.getIndex());
        return values.valuePointSensitivity(computation.getEndObservation()).multipliedBy(1.0 / computation.getStartIndexValue());
    }

    @Override
    public double explainRate(InflationEndMonthRateComputation computation, LocalDate startDate, LocalDate endDate, RatesProvider provider, ExplainMapBuilder builder) {
        PriceIndexValues values = provider.priceIndexValues(computation.getIndex());
        double indexEnd = values.value(computation.getEndObservation());
        builder.addListEntry(ExplainKey.OBSERVATIONS, child -> child.put(ExplainKey.ENTRY_TYPE, (Object)"InflationObservation").put(ExplainKey.FIXING_DATE, (Object)computation.getEndObservation().getFixingMonth().atEndOfMonth()).put(ExplainKey.INDEX, (Object)computation.getIndex()).put(ExplainKey.INDEX_VALUE, (Object)indexEnd));
        double rate = this.rate(computation, startDate, endDate, provider);
        builder.put(ExplainKey.COMBINED_RATE, (Object)rate);
        return rate;
    }
}

