/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.pricer.impl.rate;

import com.opengamma.strata.market.explain.ExplainKey;
import com.opengamma.strata.market.explain.ExplainMapBuilder;
import com.opengamma.strata.market.sensitivity.PointSensitivityBuilder;
import com.opengamma.strata.pricer.rate.PriceIndexValues;
import com.opengamma.strata.pricer.rate.RateComputationFn;
import com.opengamma.strata.pricer.rate.RatesProvider;
import com.opengamma.strata.product.rate.InflationInterpolatedRateComputation;
import java.time.LocalDate;

public class ForwardInflationInterpolatedRateComputationFn
implements RateComputationFn<InflationInterpolatedRateComputation> {
    public static final ForwardInflationInterpolatedRateComputationFn DEFAULT = new ForwardInflationInterpolatedRateComputationFn();

    @Override
    public double rate(InflationInterpolatedRateComputation computation, LocalDate startDate, LocalDate endDate, RatesProvider provider) {
        PriceIndexValues values = provider.priceIndexValues(computation.getIndex());
        double indexStart = this.interpolateStart(computation, values);
        double indexEnd = this.interpolateEnd(computation, values);
        return indexEnd / indexStart - 1.0;
    }

    private double interpolateStart(InflationInterpolatedRateComputation computation, PriceIndexValues values) {
        double weight = computation.getWeight();
        double indexValue1 = values.value(computation.getStartObservation());
        double indexValue2 = values.value(computation.getStartSecondObservation());
        return weight * indexValue1 + (1.0 - weight) * indexValue2;
    }

    private double interpolateEnd(InflationInterpolatedRateComputation computation, PriceIndexValues values) {
        double weight = computation.getWeight();
        double indexValue1 = values.value(computation.getEndObservation());
        double indexValue2 = values.value(computation.getEndSecondObservation());
        return weight * indexValue1 + (1.0 - weight) * indexValue2;
    }

    @Override
    public PointSensitivityBuilder rateSensitivity(InflationInterpolatedRateComputation computation, LocalDate startDate, LocalDate endDate, RatesProvider provider) {
        PriceIndexValues values = provider.priceIndexValues(computation.getIndex());
        double indexStart = this.interpolateStart(computation, values);
        double indexEnd = this.interpolateEnd(computation, values);
        double indexStartInv = 1.0 / indexStart;
        PointSensitivityBuilder sensi1 = this.startSensitivity(computation, values).multipliedBy(-indexEnd * indexStartInv * indexStartInv);
        PointSensitivityBuilder sensi2 = this.endSensitivity(computation, values).multipliedBy(indexStartInv);
        return sensi1.combinedWith(sensi2);
    }

    private PointSensitivityBuilder startSensitivity(InflationInterpolatedRateComputation computation, PriceIndexValues values) {
        double weight = computation.getWeight();
        PointSensitivityBuilder sensi1 = values.valuePointSensitivity(computation.getStartObservation()).multipliedBy(weight);
        PointSensitivityBuilder sensi2 = values.valuePointSensitivity(computation.getStartSecondObservation()).multipliedBy(1.0 - weight);
        return sensi1.combinedWith(sensi2);
    }

    private PointSensitivityBuilder endSensitivity(InflationInterpolatedRateComputation computation, PriceIndexValues values) {
        double weight = computation.getWeight();
        PointSensitivityBuilder sensi1 = values.valuePointSensitivity(computation.getEndObservation()).multipliedBy(weight);
        PointSensitivityBuilder sensi2 = values.valuePointSensitivity(computation.getEndSecondObservation()).multipliedBy(1.0 - weight);
        return sensi1.combinedWith(sensi2);
    }

    @Override
    public double explainRate(InflationInterpolatedRateComputation computation, LocalDate startDate, LocalDate endDate, RatesProvider provider, ExplainMapBuilder builder) {
        PriceIndexValues values = provider.priceIndexValues(computation.getIndex());
        double w1 = computation.getWeight();
        double w2 = 1.0 - w1;
        builder.addListEntry(ExplainKey.OBSERVATIONS, child -> child.put(ExplainKey.ENTRY_TYPE, (Object)"InflationObservation").put(ExplainKey.FIXING_DATE, (Object)computation.getStartObservation().getFixingMonth().atEndOfMonth()).put(ExplainKey.INDEX, (Object)computation.getIndex()).put(ExplainKey.INDEX_VALUE, (Object)values.value(computation.getStartObservation())).put(ExplainKey.WEIGHT, (Object)w1));
        builder.addListEntry(ExplainKey.OBSERVATIONS, child -> child.put(ExplainKey.ENTRY_TYPE, (Object)"InflationObservation").put(ExplainKey.FIXING_DATE, (Object)computation.getStartSecondObservation().getFixingMonth().atEndOfMonth()).put(ExplainKey.INDEX, (Object)computation.getIndex()).put(ExplainKey.INDEX_VALUE, (Object)values.value(computation.getStartSecondObservation())).put(ExplainKey.WEIGHT, (Object)w2));
        builder.addListEntry(ExplainKey.OBSERVATIONS, child -> child.put(ExplainKey.ENTRY_TYPE, (Object)"InflationObservation").put(ExplainKey.FIXING_DATE, (Object)computation.getEndObservation().getFixingMonth().atEndOfMonth()).put(ExplainKey.INDEX, (Object)computation.getIndex()).put(ExplainKey.INDEX_VALUE, (Object)values.value(computation.getEndObservation())).put(ExplainKey.WEIGHT, (Object)w1));
        builder.addListEntry(ExplainKey.OBSERVATIONS, child -> child.put(ExplainKey.ENTRY_TYPE, (Object)"InflationObservation").put(ExplainKey.FIXING_DATE, (Object)computation.getEndSecondObservation().getFixingMonth().atEndOfMonth()).put(ExplainKey.INDEX, (Object)computation.getIndex()).put(ExplainKey.INDEX_VALUE, (Object)values.value(computation.getEndSecondObservation())).put(ExplainKey.WEIGHT, (Object)w2));
        double rate = this.rate(computation, startDate, endDate, provider);
        builder.put(ExplainKey.COMBINED_RATE, (Object)rate);
        return rate;
    }
}

