/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.pricer.impl.rate;

import com.opengamma.strata.basics.index.PriceIndex;
import com.opengamma.strata.market.explain.ExplainKey;
import com.opengamma.strata.market.explain.ExplainMapBuilder;
import com.opengamma.strata.market.sensitivity.PointSensitivityBuilder;
import com.opengamma.strata.pricer.rate.PriceIndexValues;
import com.opengamma.strata.pricer.rate.RateComputationFn;
import com.opengamma.strata.pricer.rate.RatesProvider;
import com.opengamma.strata.product.rate.InflationMonthlyRateComputation;
import java.time.LocalDate;

public class ForwardInflationMonthlyRateComputationFn
implements RateComputationFn<InflationMonthlyRateComputation> {
    public static final ForwardInflationMonthlyRateComputationFn DEFAULT = new ForwardInflationMonthlyRateComputationFn();

    @Override
    public double rate(InflationMonthlyRateComputation computation, LocalDate startDate, LocalDate endDate, RatesProvider provider) {
        PriceIndex index = computation.getIndex();
        PriceIndexValues values = provider.priceIndexValues(index);
        double indexStart = values.value(computation.getStartObservation());
        double indexEnd = values.value(computation.getEndObservation());
        return indexEnd / indexStart - 1.0;
    }

    @Override
    public PointSensitivityBuilder rateSensitivity(InflationMonthlyRateComputation computation, LocalDate startDate, LocalDate endDate, RatesProvider provider) {
        PriceIndex index = computation.getIndex();
        PriceIndexValues values = provider.priceIndexValues(index);
        double indexStart = values.value(computation.getStartObservation());
        double indexEnd = values.value(computation.getEndObservation());
        double indexStartInv = 1.0 / indexStart;
        PointSensitivityBuilder sensi1 = values.valuePointSensitivity(computation.getStartObservation()).multipliedBy(-indexEnd * indexStartInv * indexStartInv);
        PointSensitivityBuilder sensi2 = values.valuePointSensitivity(computation.getEndObservation()).multipliedBy(indexStartInv);
        return sensi1.combinedWith(sensi2);
    }

    @Override
    public double explainRate(InflationMonthlyRateComputation computation, LocalDate startDate, LocalDate endDate, RatesProvider provider, ExplainMapBuilder builder) {
        PriceIndex index = computation.getIndex();
        PriceIndexValues values = provider.priceIndexValues(index);
        double indexStart = values.value(computation.getStartObservation());
        double indexEnd = values.value(computation.getEndObservation());
        builder.addListEntry(ExplainKey.OBSERVATIONS, child -> child.put(ExplainKey.ENTRY_TYPE, (Object)"InflationObservation").put(ExplainKey.FIXING_DATE, (Object)computation.getStartObservation().getFixingMonth().atEndOfMonth()).put(ExplainKey.INDEX, (Object)index).put(ExplainKey.INDEX_VALUE, (Object)indexStart));
        builder.addListEntry(ExplainKey.OBSERVATIONS, child -> child.put(ExplainKey.ENTRY_TYPE, (Object)"InflationObservation").put(ExplainKey.FIXING_DATE, (Object)computation.getEndObservation().getFixingMonth().atEndOfMonth()).put(ExplainKey.INDEX, (Object)index).put(ExplainKey.INDEX_VALUE, (Object)indexEnd));
        double rate = this.rate(computation, startDate, endDate, provider);
        builder.put(ExplainKey.COMBINED_RATE, (Object)rate);
        return rate;
    }
}

