/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.pricer.impl.rate;

import com.opengamma.strata.basics.index.OvernightIndex;
import com.opengamma.strata.basics.index.OvernightIndexObservation;
import com.opengamma.strata.market.explain.ExplainKey;
import com.opengamma.strata.market.explain.ExplainMapBuilder;
import com.opengamma.strata.market.sensitivity.PointSensitivityBuilder;
import com.opengamma.strata.pricer.rate.OvernightIndexRates;
import com.opengamma.strata.pricer.rate.RateComputationFn;
import com.opengamma.strata.pricer.rate.RatesProvider;
import com.opengamma.strata.product.rate.OvernightAveragedDailyRateComputation;
import java.time.LocalDate;

public class ForwardOvernightAveragedDailyRateComputationFn
implements RateComputationFn<OvernightAveragedDailyRateComputation> {
    public static final ForwardOvernightAveragedDailyRateComputationFn DEFAULT = new ForwardOvernightAveragedDailyRateComputationFn();

    @Override
    public double rate(OvernightAveragedDailyRateComputation computation, LocalDate startDate, LocalDate endDate, RatesProvider provider) {
        OvernightIndex index = computation.getIndex();
        OvernightIndexRates rates = provider.overnightIndexRates(index);
        LocalDate lastFixingDate = computation.getEndDate();
        double interestSum = 0.0;
        int numberOfDays = 0;
        LocalDate currentFixingDate = computation.getStartDate();
        while (!currentFixingDate.isAfter(lastFixingDate)) {
            LocalDate referenceFixingDate = computation.getFixingCalendar().previousOrSame(currentFixingDate);
            OvernightIndexObservation indexObs = computation.observeOn(referenceFixingDate);
            double forwardRate = rates.rate(indexObs);
            interestSum += forwardRate;
            ++numberOfDays;
            currentFixingDate = currentFixingDate.plusDays(1L);
        }
        return interestSum / (double)numberOfDays;
    }

    @Override
    public PointSensitivityBuilder rateSensitivity(OvernightAveragedDailyRateComputation computation, LocalDate startDate, LocalDate endDate, RatesProvider provider) {
        OvernightIndex index = computation.getIndex();
        OvernightIndexRates rates = provider.overnightIndexRates(index);
        LocalDate lastFixingDate = computation.getEndDate();
        PointSensitivityBuilder pointSensitivityBuilder = PointSensitivityBuilder.none();
        int numberOfDays = 0;
        LocalDate currentFixingDate = computation.getStartDate();
        while (!currentFixingDate.isAfter(lastFixingDate)) {
            LocalDate referenceFixingDate = computation.getFixingCalendar().previousOrSame(currentFixingDate);
            OvernightIndexObservation indexObs = computation.observeOn(referenceFixingDate);
            PointSensitivityBuilder forwardRateSensitivity = rates.ratePointSensitivity(indexObs);
            pointSensitivityBuilder = pointSensitivityBuilder.combinedWith(forwardRateSensitivity);
            ++numberOfDays;
            currentFixingDate = currentFixingDate.plusDays(1L);
        }
        return pointSensitivityBuilder.multipliedBy(1.0 / (double)numberOfDays);
    }

    @Override
    public double explainRate(OvernightAveragedDailyRateComputation computation, LocalDate startDate, LocalDate endDate, RatesProvider provider, ExplainMapBuilder builder) {
        double rate = this.rate(computation, startDate, endDate, provider);
        builder.put(ExplainKey.COMBINED_RATE, (Object)rate);
        return rate;
    }
}

