/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.pricer.impl.rate;

import com.opengamma.strata.basics.index.OvernightIndex;
import com.opengamma.strata.basics.index.OvernightIndexObservation;
import com.opengamma.strata.market.explain.ExplainKey;
import com.opengamma.strata.market.explain.ExplainMapBuilder;
import com.opengamma.strata.market.sensitivity.PointSensitivityBuilder;
import com.opengamma.strata.pricer.rate.OvernightIndexRates;
import com.opengamma.strata.pricer.rate.RateComputationFn;
import com.opengamma.strata.pricer.rate.RatesProvider;
import com.opengamma.strata.product.rate.OvernightAveragedRateComputation;
import java.time.LocalDate;

public class ForwardOvernightAveragedRateComputationFn
implements RateComputationFn<OvernightAveragedRateComputation> {
    public static final ForwardOvernightAveragedRateComputationFn DEFAULT = new ForwardOvernightAveragedRateComputationFn();

    @Override
    public double rate(OvernightAveragedRateComputation computation, LocalDate startDate, LocalDate endDate, RatesProvider provider) {
        OvernightIndex index = computation.getIndex();
        OvernightIndexRates rates = provider.overnightIndexRates(index);
        LocalDate lastNonCutoffFixing = computation.getEndDate();
        int cutoffOffset = computation.getRateCutOffDays() > 1 ? computation.getRateCutOffDays() : 1;
        double accumulatedInterest = 0.0;
        double accrualFactorTotal = 0.0;
        double cutoffAccrualFactor = 0.0;
        OvernightIndexObservation lastIndexObs = null;
        for (int i = 0; i < cutoffOffset; ++i) {
            lastNonCutoffFixing = computation.getFixingCalendar().previous(lastNonCutoffFixing);
            lastIndexObs = computation.observeOn(lastNonCutoffFixing);
            accrualFactorTotal += lastIndexObs.getYearFraction();
            cutoffAccrualFactor += lastIndexObs.getYearFraction();
        }
        double forwardRateCutOff = rates.rate(lastIndexObs);
        accumulatedInterest += cutoffAccrualFactor * forwardRateCutOff;
        LocalDate currentFixingNonCutoff = computation.getStartDate();
        while (currentFixingNonCutoff.isBefore(lastNonCutoffFixing)) {
            OvernightIndexObservation indexObs = computation.observeOn(currentFixingNonCutoff);
            double forwardRate = rates.rate(indexObs);
            accrualFactorTotal += indexObs.getYearFraction();
            accumulatedInterest += indexObs.getYearFraction() * forwardRate;
            currentFixingNonCutoff = computation.getFixingCalendar().next(currentFixingNonCutoff);
        }
        return accumulatedInterest / accrualFactorTotal;
    }

    @Override
    public PointSensitivityBuilder rateSensitivity(OvernightAveragedRateComputation computation, LocalDate startDate, LocalDate endDate, RatesProvider provider) {
        OvernightIndex index = computation.getIndex();
        OvernightIndexRates rates = provider.overnightIndexRates(index);
        LocalDate lastNonCutoffFixing = computation.getEndDate();
        int cutoffOffset = computation.getRateCutOffDays() > 1 ? computation.getRateCutOffDays() : 1;
        double accrualFactorTotal = 0.0;
        double cutoffAccrualFactor = 0.0;
        OvernightIndexObservation lastIndexObs = null;
        for (int i = 0; i < cutoffOffset; ++i) {
            lastNonCutoffFixing = computation.getFixingCalendar().previous(lastNonCutoffFixing);
            lastIndexObs = computation.observeOn(lastNonCutoffFixing);
            accrualFactorTotal += lastIndexObs.getYearFraction();
            cutoffAccrualFactor += lastIndexObs.getYearFraction();
        }
        PointSensitivityBuilder combinedPointSensitivityBuilder = rates.ratePointSensitivity(lastIndexObs).multipliedBy(cutoffAccrualFactor);
        LocalDate currentFixingNonCutoff = computation.getStartDate();
        while (currentFixingNonCutoff.isBefore(lastNonCutoffFixing)) {
            OvernightIndexObservation indexObs = computation.observeOn(currentFixingNonCutoff);
            PointSensitivityBuilder forwardRateSensitivity = rates.ratePointSensitivity(indexObs).multipliedBy(indexObs.getYearFraction());
            combinedPointSensitivityBuilder = combinedPointSensitivityBuilder.combinedWith(forwardRateSensitivity);
            accrualFactorTotal += indexObs.getYearFraction();
            currentFixingNonCutoff = computation.getFixingCalendar().next(currentFixingNonCutoff);
        }
        return combinedPointSensitivityBuilder.multipliedBy(1.0 / accrualFactorTotal);
    }

    @Override
    public double explainRate(OvernightAveragedRateComputation computation, LocalDate startDate, LocalDate endDate, RatesProvider provider, ExplainMapBuilder builder) {
        double rate = this.rate(computation, startDate, endDate, provider);
        builder.put(ExplainKey.COMBINED_RATE, (Object)rate);
        return rate;
    }
}

