/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.pricer.impl.rate.model;

import com.opengamma.strata.basics.value.ValueDerivatives;
import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.collect.array.DoubleArray;
import com.opengamma.strata.collect.array.DoubleMatrix;
import com.opengamma.strata.collect.tuple.Pair;
import com.opengamma.strata.math.impl.rootfinding.BracketRoot;
import com.opengamma.strata.math.impl.rootfinding.RidderSingleRootFinder;
import com.opengamma.strata.pricer.model.HullWhiteOneFactorPiecewiseConstantParameters;
import java.io.Serializable;
import java.lang.invoke.MethodHandles;
import java.util.Arrays;
import java.util.function.Function;
import org.joda.beans.ImmutableBean;
import org.joda.beans.MetaBean;
import org.joda.beans.TypedMetaBean;
import org.joda.beans.gen.BeanDefinition;
import org.joda.beans.impl.light.LightMetaBean;

@BeanDefinition(style="light")
public final class HullWhiteOneFactorPiecewiseConstantInterestRateModel
implements ImmutableBean,
Serializable {
    public static final HullWhiteOneFactorPiecewiseConstantInterestRateModel DEFAULT = new HullWhiteOneFactorPiecewiseConstantInterestRateModel();
    private static final TypedMetaBean<HullWhiteOneFactorPiecewiseConstantInterestRateModel> META_BEAN = LightMetaBean.of(HullWhiteOneFactorPiecewiseConstantInterestRateModel.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private static final long serialVersionUID = 1L;

    public double futuresConvexityFactor(HullWhiteOneFactorPiecewiseConstantParameters data, double t0, double t1, double t2) {
        double factor1 = Math.exp(-data.getMeanReversion() * t1) - Math.exp(-data.getMeanReversion() * t2);
        double numerator = 2.0 * data.getMeanReversion() * data.getMeanReversion() * data.getMeanReversion();
        int indexT0 = 1;
        while (t0 > data.getVolatilityTime().get(indexT0)) {
            ++indexT0;
        }
        double[] s = new double[indexT0 + 1];
        System.arraycopy(data.getVolatilityTime().toArray(), 0, s, 0, indexT0);
        s[indexT0] = t0;
        double factor2 = 0.0;
        for (int loopperiod = 0; loopperiod < indexT0; ++loopperiod) {
            factor2 += data.getVolatility().get(loopperiod) * data.getVolatility().get(loopperiod) * (Math.exp(data.getMeanReversion() * s[loopperiod + 1]) - Math.exp(data.getMeanReversion() * s[loopperiod])) * (2.0 - Math.exp(-data.getMeanReversion() * (t2 - s[loopperiod + 1])) - Math.exp(-data.getMeanReversion() * (t2 - s[loopperiod])));
        }
        return Math.exp(factor1 / numerator * factor2);
    }

    public ValueDerivatives futuresConvexityFactorAdjoint(HullWhiteOneFactorPiecewiseConstantParameters data, double t0, double t1, double t2) {
        double factor1 = Math.exp(-data.getMeanReversion() * t1) - Math.exp(-data.getMeanReversion() * t2);
        double numerator = 2.0 * data.getMeanReversion() * data.getMeanReversion() * data.getMeanReversion();
        int indexT0 = 1;
        while (t0 > data.getVolatilityTime().get(indexT0)) {
            ++indexT0;
        }
        double[] s = new double[indexT0 + 1];
        System.arraycopy(data.getVolatilityTime().toArray(), 0, s, 0, indexT0);
        s[indexT0] = t0;
        double factor2 = 0.0;
        double[] factorExp = new double[indexT0];
        for (int loopperiod = 0; loopperiod < indexT0; ++loopperiod) {
            factorExp[loopperiod] = (Math.exp(data.getMeanReversion() * s[loopperiod + 1]) - Math.exp(data.getMeanReversion() * s[loopperiod])) * (2.0 - Math.exp(-data.getMeanReversion() * (t2 - s[loopperiod + 1])) - Math.exp(-data.getMeanReversion() * (t2 - s[loopperiod])));
            factor2 += data.getVolatility().get(loopperiod) * data.getVolatility().get(loopperiod) * factorExp[loopperiod];
        }
        double factor = Math.exp(factor1 / numerator * factor2);
        double factorBar = 1.0;
        double factor2Bar = factor1 / numerator * factor * factorBar;
        double[] derivatives = new double[data.getVolatility().size()];
        for (int loopperiod = 0; loopperiod < indexT0; ++loopperiod) {
            derivatives[loopperiod] = 2.0 * data.getVolatility().get(loopperiod) * factorExp[loopperiod] * factor2Bar;
        }
        return ValueDerivatives.of((double)factor, (DoubleArray)DoubleArray.ofUnsafe((double[])derivatives));
    }

    public double paymentDelayConvexityFactor(HullWhiteOneFactorPiecewiseConstantParameters parameters, double startExpiry, double endExpiry, double u, double v, double tp) {
        int loopperiod;
        double a = parameters.getMeanReversion();
        double factor1 = (Math.exp(-a * v) - Math.exp(-a * tp)) * (Math.exp(-a * v) - Math.exp(-a * u));
        double numerator = 2.0 * a * a * a;
        int indexStart = Math.abs(Arrays.binarySearch(parameters.getVolatilityTime().toArray(), startExpiry) + 1);
        int indexEnd = Math.abs(Arrays.binarySearch(parameters.getVolatilityTime().toArray(), endExpiry) + 1);
        int sLen = indexEnd - indexStart + 1;
        double[] s = new double[sLen + 1];
        s[0] = startExpiry;
        System.arraycopy(parameters.getVolatilityTime().toArray(), indexStart, s, 1, sLen - 1);
        s[sLen] = endExpiry;
        double factor2 = 0.0;
        double[] exp2as = new double[sLen + 1];
        for (loopperiod = 0; loopperiod < sLen + 1; ++loopperiod) {
            exp2as[loopperiod] = Math.exp(2.0 * a * s[loopperiod]);
        }
        for (loopperiod = 0; loopperiod < sLen; ++loopperiod) {
            factor2 += parameters.getVolatility().get(loopperiod + indexStart - 1) * parameters.getVolatility().get(loopperiod + indexStart - 1) * (exp2as[loopperiod + 1] - exp2as[loopperiod]);
        }
        return Math.exp(factor1 * factor2 / numerator);
    }

    public double alpha(HullWhiteOneFactorPiecewiseConstantParameters data, double startExpiry, double endExpiry, double numeraireTime, double bondMaturity) {
        int loopperiod;
        double factor1 = Math.exp(-data.getMeanReversion() * numeraireTime) - Math.exp(-data.getMeanReversion() * bondMaturity);
        double numerator = 2.0 * data.getMeanReversion() * data.getMeanReversion() * data.getMeanReversion();
        int indexStart = Math.abs(Arrays.binarySearch(data.getVolatilityTime().toArray(), startExpiry) + 1);
        int indexEnd = Math.abs(Arrays.binarySearch(data.getVolatilityTime().toArray(), endExpiry) + 1);
        int sLen = indexEnd - indexStart + 1;
        double[] s = new double[sLen + 1];
        s[0] = startExpiry;
        System.arraycopy(data.getVolatilityTime().toArray(), indexStart, s, 1, sLen - 1);
        s[sLen] = endExpiry;
        double factor2 = 0.0;
        double[] exp2as = new double[sLen + 1];
        for (loopperiod = 0; loopperiod < sLen + 1; ++loopperiod) {
            exp2as[loopperiod] = Math.exp(2.0 * data.getMeanReversion() * s[loopperiod]);
        }
        for (loopperiod = 0; loopperiod < sLen; ++loopperiod) {
            factor2 += data.getVolatility().get(loopperiod + indexStart - 1) * data.getVolatility().get(loopperiod + indexStart - 1) * (exp2as[loopperiod + 1] - exp2as[loopperiod]);
        }
        return factor1 * Math.sqrt(factor2 / numerator);
    }

    public ValueDerivatives alphaAdjoint(HullWhiteOneFactorPiecewiseConstantParameters data, double startExpiry, double endExpiry, double numeraireTime, double bondMaturity) {
        int loopperiod;
        double factor1 = Math.exp(-data.getMeanReversion() * numeraireTime) - Math.exp(-data.getMeanReversion() * bondMaturity);
        double numerator = 2.0 * data.getMeanReversion() * data.getMeanReversion() * data.getMeanReversion();
        int indexStart = Math.abs(Arrays.binarySearch(data.getVolatilityTime().toArray(), startExpiry) + 1);
        int indexEnd = Math.abs(Arrays.binarySearch(data.getVolatilityTime().toArray(), endExpiry) + 1);
        int sLen = indexEnd - indexStart + 1;
        double[] s = new double[sLen + 1];
        s[0] = startExpiry;
        System.arraycopy(data.getVolatilityTime().toArray(), indexStart, s, 1, sLen - 1);
        s[sLen] = endExpiry;
        double factor2 = 0.0;
        double[] exp2as = new double[sLen + 1];
        for (loopperiod = 0; loopperiod < sLen + 1; ++loopperiod) {
            exp2as[loopperiod] = Math.exp(2.0 * data.getMeanReversion() * s[loopperiod]);
        }
        for (loopperiod = 0; loopperiod < sLen; ++loopperiod) {
            factor2 += data.getVolatility().get(loopperiod + indexStart - 1) * data.getVolatility().get(loopperiod + indexStart - 1) * (exp2as[loopperiod + 1] - exp2as[loopperiod]);
        }
        double sqrtFactor2Num = Math.sqrt(factor2 / numerator);
        double alpha = factor1 * sqrtFactor2Num;
        double alphaBar = 1.0;
        double factor2Bar = factor1 / sqrtFactor2Num / 2.0 / numerator * alphaBar;
        double[] derivatives = new double[data.getVolatility().size()];
        for (int loopperiod2 = 0; loopperiod2 < sLen; ++loopperiod2) {
            derivatives[loopperiod2 + indexStart - 1] = 2.0 * data.getVolatility().get(loopperiod2 + indexStart - 1) * (exp2as[loopperiod2 + 1] - exp2as[loopperiod2]) * factor2Bar;
        }
        return ValueDerivatives.of((double)alpha, (DoubleArray)DoubleArray.ofUnsafe((double[])derivatives));
    }

    public double kappa(final DoubleArray discountedCashFlow, final DoubleArray alpha) {
        Function<Double, Double> swapValue = new Function<Double, Double>(){

            @Override
            public Double apply(Double x) {
                double error = 0.0;
                for (int loopcf = 0; loopcf < alpha.size(); ++loopcf) {
                    error += discountedCashFlow.get(loopcf) * Math.exp(-0.5 * alpha.get(loopcf) * alpha.get(loopcf) - (alpha.get(loopcf) - alpha.get(0)) * x);
                }
                return error;
            }
        };
        BracketRoot bracketer = new BracketRoot();
        double accuracy = 1.0E-8;
        RidderSingleRootFinder rootFinder = new RidderSingleRootFinder(accuracy);
        double[] range = bracketer.getBracketedPoints((Function)swapValue, -2.0, 2.0);
        return rootFinder.getRoot((Function)swapValue, Double.valueOf(range[0]), Double.valueOf(range[1]));
    }

    public double beta(HullWhiteOneFactorPiecewiseConstantParameters data, double startExpiry, double endExpiry) {
        double numerator = 2.0 * data.getMeanReversion();
        int indexStart = 1;
        while (startExpiry > data.getVolatilityTime().get(indexStart)) {
            ++indexStart;
        }
        int indexEnd = indexStart;
        while (endExpiry > data.getVolatilityTime().get(indexEnd)) {
            ++indexEnd;
        }
        int sLen = indexEnd - indexStart + 1;
        double[] s = new double[sLen + 1];
        s[0] = startExpiry;
        System.arraycopy(data.getVolatilityTime().toArray(), indexStart, s, 1, sLen - 1);
        s[sLen] = endExpiry;
        double denominator = 0.0;
        for (int loopperiod = 0; loopperiod < sLen; ++loopperiod) {
            denominator += data.getVolatility().get(loopperiod + indexStart - 1) * data.getVolatility().get(loopperiod + indexStart - 1) * (Math.exp(2.0 * data.getMeanReversion() * s[loopperiod + 1]) - Math.exp(2.0 * data.getMeanReversion() * s[loopperiod]));
        }
        return Math.sqrt(denominator / numerator);
    }

    public double lambda(final DoubleArray discountedCashFlow, final DoubleArray alpha2, final DoubleArray hwH) {
        Function<Double, Double> swapValue = new Function<Double, Double>(){

            @Override
            public Double apply(Double x) {
                double value = 0.0;
                for (int loopcf = 0; loopcf < alpha2.size(); ++loopcf) {
                    value += discountedCashFlow.get(loopcf) * Math.exp(-0.5 * alpha2.get(loopcf) - hwH.get(loopcf) * x);
                }
                return value;
            }
        };
        BracketRoot bracketer = new BracketRoot();
        double accuracy = 1.0E-8;
        RidderSingleRootFinder rootFinder = new RidderSingleRootFinder(accuracy);
        double[] range = bracketer.getBracketedPoints((Function)swapValue, -2.0, 2.0);
        return rootFinder.getRoot((Function)swapValue, Double.valueOf(range[0]), Double.valueOf(range[1]));
    }

    public DoubleMatrix volatilityMaturityPart(HullWhiteOneFactorPiecewiseConstantParameters hwParameters, double u, DoubleMatrix v) {
        double a = hwParameters.getMeanReversion();
        double[][] result = new double[v.rowCount()][];
        double expau = Math.exp(-a * u);
        for (int loopcf1 = 0; loopcf1 < v.rowCount(); ++loopcf1) {
            DoubleArray vRow = v.row(loopcf1);
            result[loopcf1] = new double[vRow.size()];
            for (int loopcf2 = 0; loopcf2 < vRow.size(); ++loopcf2) {
                result[loopcf1][loopcf2] = (expau - Math.exp(-a * vRow.get(loopcf2))) / a;
            }
        }
        return DoubleMatrix.copyOf((double[][])result);
    }

    public double swapRate(double x, DoubleArray discountedCashFlowFixed, DoubleArray alphaFixed, DoubleArray discountedCashFlowIbor, DoubleArray alphaIbor) {
        int sizeIbor = discountedCashFlowIbor.size();
        int sizeFixed = discountedCashFlowFixed.size();
        ArgChecker.isTrue((sizeIbor == alphaIbor.size() ? 1 : 0) != 0, (String)"Length should be equal");
        ArgChecker.isTrue((sizeFixed == alphaFixed.size() ? 1 : 0) != 0, (String)"Length should be equal");
        double numerator = 0.0;
        for (int loopcf = 0; loopcf < sizeIbor; ++loopcf) {
            numerator += discountedCashFlowIbor.get(loopcf) * Math.exp(-alphaIbor.get(loopcf) * x - 0.5 * alphaIbor.get(loopcf) * alphaIbor.get(loopcf));
        }
        double denominator = 0.0;
        for (int loopcf = 0; loopcf < sizeFixed; ++loopcf) {
            denominator += discountedCashFlowFixed.get(loopcf) * Math.exp(-alphaFixed.get(loopcf) * x - 0.5 * alphaFixed.get(loopcf) * alphaFixed.get(loopcf));
        }
        return -numerator / denominator;
    }

    public double swapRateDx1(double x, DoubleArray discountedCashFlowFixed, DoubleArray alphaFixed, DoubleArray discountedCashFlowIbor, DoubleArray alphaIbor) {
        double term;
        int sizeIbor = discountedCashFlowIbor.size();
        int sizeFixed = discountedCashFlowFixed.size();
        ArgChecker.isTrue((sizeIbor == alphaIbor.size() ? 1 : 0) != 0, (String)"Length should be equal");
        ArgChecker.isTrue((sizeFixed == alphaFixed.size() ? 1 : 0) != 0, (String)"Length should be equal");
        double f = 0.0;
        double df = 0.0;
        for (int loopcf = 0; loopcf < sizeIbor; ++loopcf) {
            term = discountedCashFlowIbor.get(loopcf) * Math.exp(-alphaIbor.get(loopcf) * x - 0.5 * alphaIbor.get(loopcf) * alphaIbor.get(loopcf));
            f += term;
            df += -alphaIbor.get(loopcf) * term;
        }
        double g = 0.0;
        double dg = 0.0;
        for (int loopcf = 0; loopcf < sizeFixed; ++loopcf) {
            term = discountedCashFlowFixed.get(loopcf) * Math.exp(-alphaFixed.get(loopcf) * x - 0.5 * alphaFixed.get(loopcf) * alphaFixed.get(loopcf));
            g += term;
            dg += -alphaFixed.get(loopcf) * term;
        }
        return -(df * g - f * dg) / (g * g);
    }

    public double swapRateDx2(double x, DoubleArray discountedCashFlowFixed, DoubleArray alphaFixed, DoubleArray discountedCashFlowIbor, DoubleArray alphaIbor) {
        double term;
        int sizeIbor = discountedCashFlowIbor.size();
        int sizeFixed = discountedCashFlowFixed.size();
        ArgChecker.isTrue((sizeIbor == alphaIbor.size() ? 1 : 0) != 0, (String)"Length should be equal");
        ArgChecker.isTrue((sizeFixed == alphaFixed.size() ? 1 : 0) != 0, (String)"Length should be equal");
        double f = 0.0;
        double df = 0.0;
        double df2 = 0.0;
        for (int loopcf = 0; loopcf < sizeIbor; ++loopcf) {
            term = discountedCashFlowIbor.get(loopcf) * Math.exp(-alphaIbor.get(loopcf) * x - 0.5 * alphaIbor.get(loopcf) * alphaIbor.get(loopcf));
            f += term;
            df += -alphaIbor.get(loopcf) * term;
            df2 += alphaIbor.get(loopcf) * alphaIbor.get(loopcf) * term;
        }
        double g = 0.0;
        double dg = 0.0;
        double dg2 = 0.0;
        for (int loopcf = 0; loopcf < sizeFixed; ++loopcf) {
            term = discountedCashFlowFixed.get(loopcf) * Math.exp(-alphaFixed.get(loopcf) * x - 0.5 * alphaFixed.get(loopcf) * alphaFixed.get(loopcf));
            g += term;
            dg += -alphaFixed.get(loopcf) * term;
            dg2 += alphaFixed.get(loopcf) * alphaFixed.get(loopcf) * term;
        }
        double g2 = g * g;
        double g3 = g * g2;
        return -df2 / g + (2.0 * df * dg + f * dg2) / g2 - 2.0 * f * dg * dg / g3;
    }

    public ValueDerivatives swapRateDdcfi1(double x, DoubleArray discountedCashFlowFixed, DoubleArray alphaFixed, DoubleArray discountedCashFlowIbor, DoubleArray alphaIbor) {
        int sizeIbor = discountedCashFlowIbor.size();
        int sizeFixed = discountedCashFlowFixed.size();
        ArgChecker.isTrue((sizeIbor == alphaIbor.size() ? 1 : 0) != 0, (String)"Length should be equal");
        ArgChecker.isTrue((sizeFixed == alphaFixed.size() ? 1 : 0) != 0, (String)"Length should be equal");
        double denominator = 0.0;
        for (int loopcf = 0; loopcf < sizeFixed; ++loopcf) {
            denominator += discountedCashFlowFixed.get(loopcf) * Math.exp(-alphaFixed.get(loopcf) * x - 0.5 * alphaFixed.get(loopcf) * alphaFixed.get(loopcf));
        }
        double numerator = 0.0;
        double[] swapRateDdcfi1 = new double[sizeIbor];
        for (int loopcf = 0; loopcf < sizeIbor; ++loopcf) {
            double exp = Math.exp(-alphaIbor.get(loopcf) * x - 0.5 * alphaIbor.get(loopcf) * alphaIbor.get(loopcf));
            swapRateDdcfi1[loopcf] = -exp / denominator;
            numerator += discountedCashFlowIbor.get(loopcf) * exp;
        }
        return ValueDerivatives.of((double)(-numerator / denominator), (DoubleArray)DoubleArray.ofUnsafe((double[])swapRateDdcfi1));
    }

    public ValueDerivatives swapRateDdcff1(double x, DoubleArray discountedCashFlowFixed, DoubleArray alphaFixed, DoubleArray discountedCashFlowIbor, DoubleArray alphaIbor) {
        int sizeIbor = discountedCashFlowIbor.size();
        int sizeFixed = discountedCashFlowFixed.size();
        ArgChecker.isTrue((sizeIbor == alphaIbor.size() ? 1 : 0) != 0, (String)"Length should be equal");
        ArgChecker.isTrue((sizeFixed == alphaFixed.size() ? 1 : 0) != 0, (String)"Length should be equal");
        double[] expD = new double[sizeIbor];
        double numerator = 0.0;
        for (int loopcf = 0; loopcf < sizeIbor; ++loopcf) {
            numerator += discountedCashFlowIbor.get(loopcf) * Math.exp(-alphaIbor.get(loopcf) * x - 0.5 * alphaIbor.get(loopcf) * alphaIbor.get(loopcf));
        }
        double denominator = 0.0;
        for (int loopcf = 0; loopcf < sizeFixed; ++loopcf) {
            expD[loopcf] = Math.exp(-alphaFixed.get(loopcf) * x - 0.5 * alphaFixed.get(loopcf) * alphaFixed.get(loopcf));
            denominator += discountedCashFlowFixed.get(loopcf) * expD[loopcf];
        }
        double ratio = numerator / (denominator * denominator);
        double[] swapRateDdcff1 = new double[sizeFixed];
        for (int loopcf = 0; loopcf < sizeFixed; ++loopcf) {
            swapRateDdcff1[loopcf] = ratio * expD[loopcf];
        }
        return ValueDerivatives.of((double)(-numerator / denominator), (DoubleArray)DoubleArray.ofUnsafe((double[])swapRateDdcff1));
    }

    public ValueDerivatives swapRateDai1(double x, DoubleArray discountedCashFlowFixed, DoubleArray alphaFixed, DoubleArray discountedCashFlowIbor, DoubleArray alphaIbor) {
        int sizeIbor = discountedCashFlowIbor.size();
        int sizeFixed = discountedCashFlowFixed.size();
        ArgChecker.isTrue((sizeIbor == alphaIbor.size() ? 1 : 0) != 0, (String)"Length should be equal");
        ArgChecker.isTrue((sizeFixed == alphaFixed.size() ? 1 : 0) != 0, (String)"Length should be equal");
        double denominator = 0.0;
        for (int loopcf = 0; loopcf < sizeFixed; ++loopcf) {
            denominator += discountedCashFlowFixed.get(loopcf) * Math.exp(-alphaFixed.get(loopcf) * x - 0.5 * alphaFixed.get(loopcf) * alphaFixed.get(loopcf));
        }
        double numerator = 0.0;
        double[] swapRateDai1 = new double[sizeIbor];
        for (int loopcf = 0; loopcf < sizeIbor; ++loopcf) {
            double exp = Math.exp(-alphaIbor.get(loopcf) * x - 0.5 * alphaIbor.get(loopcf) * alphaIbor.get(loopcf));
            swapRateDai1[loopcf] = discountedCashFlowIbor.get(loopcf) * exp * (x + alphaIbor.get(loopcf)) / denominator;
            numerator += discountedCashFlowIbor.get(loopcf) * exp;
        }
        return ValueDerivatives.of((double)(-numerator / denominator), (DoubleArray)DoubleArray.ofUnsafe((double[])swapRateDai1));
    }

    public ValueDerivatives swapRateDaf1(double x, DoubleArray discountedCashFlowFixed, DoubleArray alphaFixed, DoubleArray discountedCashFlowIbor, DoubleArray alphaIbor) {
        int sizeIbor = discountedCashFlowIbor.size();
        int sizeFixed = discountedCashFlowFixed.size();
        ArgChecker.isTrue((sizeIbor == alphaIbor.size() ? 1 : 0) != 0, (String)"Length should be equal");
        ArgChecker.isTrue((sizeFixed == alphaFixed.size() ? 1 : 0) != 0, (String)"Length should be equal");
        double[] expD = new double[sizeIbor];
        double numerator = 0.0;
        for (int loopcf = 0; loopcf < sizeIbor; ++loopcf) {
            numerator += discountedCashFlowIbor.get(loopcf) * Math.exp(-alphaIbor.get(loopcf) * x - 0.5 * alphaIbor.get(loopcf) * alphaIbor.get(loopcf));
        }
        double denominator = 0.0;
        for (int loopcf = 0; loopcf < sizeFixed; ++loopcf) {
            expD[loopcf] = discountedCashFlowFixed.get(loopcf) * Math.exp(-alphaFixed.get(loopcf) * x - 0.5 * alphaFixed.get(loopcf) * alphaFixed.get(loopcf));
            denominator += expD[loopcf];
        }
        double ratio = numerator / (denominator * denominator);
        double[] swapRateDaf1 = new double[sizeFixed];
        for (int loopcf = 0; loopcf < sizeFixed; ++loopcf) {
            swapRateDaf1[loopcf] = ratio * expD[loopcf] * (-x - alphaFixed.get(loopcf));
        }
        return ValueDerivatives.of((double)(-numerator / denominator), (DoubleArray)DoubleArray.ofUnsafe((double[])swapRateDaf1));
    }

    public Pair<DoubleArray, DoubleArray> swapRateDx2Ddcf1(double x, DoubleArray discountedCashFlowFixed, DoubleArray alphaFixed, DoubleArray discountedCashFlowIbor, DoubleArray alphaIbor) {
        int sizeIbor = discountedCashFlowIbor.size();
        int sizeFixed = discountedCashFlowFixed.size();
        ArgChecker.isTrue((sizeIbor == alphaIbor.size() ? 1 : 0) != 0, (String)"Length should be equal");
        ArgChecker.isTrue((sizeFixed == alphaFixed.size() ? 1 : 0) != 0, (String)"Length should be equal");
        double f = 0.0;
        double df = 0.0;
        double df2 = 0.0;
        double[] termIbor = new double[sizeIbor];
        double[] expIbor = new double[sizeIbor];
        for (int loopcf = 0; loopcf < sizeIbor; ++loopcf) {
            expIbor[loopcf] = Math.exp(-alphaIbor.get(loopcf) * x - 0.5 * alphaIbor.get(loopcf) * alphaIbor.get(loopcf));
            termIbor[loopcf] = discountedCashFlowIbor.get(loopcf) * expIbor[loopcf];
            f += termIbor[loopcf];
            df += -alphaIbor.get(loopcf) * termIbor[loopcf];
            df2 += alphaIbor.get(loopcf) * alphaIbor.get(loopcf) * termIbor[loopcf];
        }
        double g = 0.0;
        double dg = 0.0;
        double dg2 = 0.0;
        double[] termFixed = new double[sizeFixed];
        double[] expFixed = new double[sizeFixed];
        for (int loopcf = 0; loopcf < sizeFixed; ++loopcf) {
            expFixed[loopcf] = Math.exp(-alphaFixed.get(loopcf) * x - 0.5 * alphaFixed.get(loopcf) * alphaFixed.get(loopcf));
            termFixed[loopcf] = discountedCashFlowFixed.get(loopcf) * expFixed[loopcf];
            g += termFixed[loopcf];
            dg += -alphaFixed.get(loopcf) * termFixed[loopcf];
            dg2 += alphaFixed.get(loopcf) * alphaFixed.get(loopcf) * termFixed[loopcf];
        }
        double g2 = g * g;
        double g3 = g * g2;
        double g4 = g * g3;
        double dx2Bar = 1.0;
        double gBar = (df2 / g2 - 2.0 * f * dg2 / g3 - 4.0 * df * dg / g3 + 6.0 * dg * dg * f / g4) * dx2Bar;
        double dgBar = (2.0 * df / g2 - 4.0 * f * dg / g3) * dx2Bar;
        double dg2Bar = f / g2 * dx2Bar;
        double fBar = (dg2 / g2 - 2.0 * dg * dg / g3) * dx2Bar;
        double dfBar = 2.0 * dg / g2 * dx2Bar;
        double df2Bar = -dx2Bar / g;
        double[] discountedCashFlowFixedBar = new double[sizeFixed];
        double[] termFixedBar = new double[sizeFixed];
        for (int loopcf = 0; loopcf < sizeFixed; ++loopcf) {
            termFixedBar[loopcf] = gBar - alphaFixed.get(loopcf) * dgBar + alphaFixed.get(loopcf) * alphaFixed.get(loopcf) * dg2Bar;
            discountedCashFlowFixedBar[loopcf] = expFixed[loopcf] * termFixedBar[loopcf];
        }
        double[] discountedCashFlowIborBar = new double[sizeIbor];
        double[] termIborBar = new double[sizeIbor];
        for (int loopcf = 0; loopcf < sizeIbor; ++loopcf) {
            termIborBar[loopcf] = fBar - alphaIbor.get(loopcf) * dfBar + alphaIbor.get(loopcf) * alphaIbor.get(loopcf) * df2Bar;
            discountedCashFlowIborBar[loopcf] = expIbor[loopcf] * termIborBar[loopcf];
        }
        return Pair.of((Object)DoubleArray.copyOf((double[])discountedCashFlowFixedBar), (Object)DoubleArray.copyOf((double[])discountedCashFlowIborBar));
    }

    public Pair<DoubleArray, DoubleArray> swapRateDx2Da1(double x, DoubleArray discountedCashFlowFixed, DoubleArray alphaFixed, DoubleArray discountedCashFlowIbor, DoubleArray alphaIbor) {
        int sizeIbor = discountedCashFlowIbor.size();
        int sizeFixed = discountedCashFlowFixed.size();
        ArgChecker.isTrue((sizeIbor == alphaIbor.size() ? 1 : 0) != 0, (String)"Length should be equal");
        ArgChecker.isTrue((sizeFixed == alphaFixed.size() ? 1 : 0) != 0, (String)"Length should be equal");
        double f = 0.0;
        double df = 0.0;
        double df2 = 0.0;
        double[] termIbor = new double[sizeIbor];
        double[] expIbor = new double[sizeIbor];
        for (int loopcf = 0; loopcf < sizeIbor; ++loopcf) {
            expIbor[loopcf] = Math.exp(-alphaIbor.get(loopcf) * x - 0.5 * alphaIbor.get(loopcf) * alphaIbor.get(loopcf));
            termIbor[loopcf] = discountedCashFlowIbor.get(loopcf) * expIbor[loopcf];
            f += termIbor[loopcf];
            df += -alphaIbor.get(loopcf) * termIbor[loopcf];
            df2 += alphaIbor.get(loopcf) * alphaIbor.get(loopcf) * termIbor[loopcf];
        }
        double g = 0.0;
        double dg = 0.0;
        double dg2 = 0.0;
        double[] termFixed = new double[sizeFixed];
        double[] expFixed = new double[sizeFixed];
        for (int loopcf = 0; loopcf < sizeFixed; ++loopcf) {
            expFixed[loopcf] = Math.exp(-alphaFixed.get(loopcf) * x - 0.5 * alphaFixed.get(loopcf) * alphaFixed.get(loopcf));
            termFixed[loopcf] = discountedCashFlowFixed.get(loopcf) * expFixed[loopcf];
            g += termFixed[loopcf];
            dg += -alphaFixed.get(loopcf) * termFixed[loopcf];
            dg2 += alphaFixed.get(loopcf) * alphaFixed.get(loopcf) * termFixed[loopcf];
        }
        double g2 = g * g;
        double g3 = g * g2;
        double g4 = g * g3;
        double dx2Bar = 1.0;
        double gBar = (df2 / g2 - 2.0 * f * dg2 / g3 - 4.0 * df * dg / g3 + 6.0 * dg * dg * f / g4) * dx2Bar;
        double dgBar = (2.0 * df / g2 - 4.0 * f * dg / g3) * dx2Bar;
        double dg2Bar = f / g2 * dx2Bar;
        double fBar = (dg2 / g2 - 2.0 * dg * dg / g3) * dx2Bar;
        double dfBar = 2.0 * dg / g2 * dx2Bar;
        double df2Bar = -dx2Bar / g;
        double[] alphaFixedBar = new double[sizeFixed];
        double[] termFixedBar = new double[sizeFixed];
        for (int loopcf = 0; loopcf < sizeFixed; ++loopcf) {
            termFixedBar[loopcf] = gBar - alphaFixed.get(loopcf) * dgBar + alphaFixed.get(loopcf) * alphaFixed.get(loopcf) * dg2Bar;
            alphaFixedBar[loopcf] = termFixed[loopcf] * (-x - alphaFixed.get(loopcf)) * termFixedBar[loopcf] - termFixed[loopcf] * dgBar + 2.0 * alphaFixed.get(loopcf) * termFixed[loopcf] * dg2Bar;
        }
        double[] alphaIborBar = new double[sizeIbor];
        double[] termIborBar = new double[sizeIbor];
        for (int loopcf = 0; loopcf < sizeIbor; ++loopcf) {
            termIborBar[loopcf] = fBar - alphaIbor.get(loopcf) * dfBar + alphaIbor.get(loopcf) * alphaIbor.get(loopcf) * df2Bar;
            alphaIborBar[loopcf] = termIbor[loopcf] * (-x - alphaIbor.get(loopcf)) * termIborBar[loopcf] - termIbor[loopcf] * dfBar + 2.0 * alphaIbor.get(loopcf) * termIbor[loopcf] * df2Bar;
        }
        return Pair.of((Object)DoubleArray.copyOf((double[])alphaFixedBar), (Object)DoubleArray.copyOf((double[])alphaIborBar));
    }

    public static TypedMetaBean<HullWhiteOneFactorPiecewiseConstantInterestRateModel> meta() {
        return META_BEAN;
    }

    private HullWhiteOneFactorPiecewiseConstantInterestRateModel() {
    }

    public TypedMetaBean<HullWhiteOneFactorPiecewiseConstantInterestRateModel> metaBean() {
        return META_BEAN;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        return obj != null && obj.getClass() == this.getClass();
    }

    public int hashCode() {
        int hash = this.getClass().hashCode();
        return hash;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(32);
        buf.append("HullWhiteOneFactorPiecewiseConstantInterestRateModel{");
        buf.append('}');
        return buf.toString();
    }

    static {
        MetaBean.register(META_BEAN);
    }
}

