/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.pricer.impl.swap;

import com.google.common.collect.ImmutableList;
import com.opengamma.strata.basics.currency.Currency;
import com.opengamma.strata.basics.currency.CurrencyAmount;
import com.opengamma.strata.basics.currency.MultiCurrencyAmount;
import com.opengamma.strata.basics.date.DayCount;
import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.market.explain.ExplainKey;
import com.opengamma.strata.market.explain.ExplainMapBuilder;
import com.opengamma.strata.market.sensitivity.PointSensitivityBuilder;
import com.opengamma.strata.pricer.DiscountFactors;
import com.opengamma.strata.pricer.ZeroRateSensitivity;
import com.opengamma.strata.pricer.fx.FxIndexRates;
import com.opengamma.strata.pricer.rate.RateComputationFn;
import com.opengamma.strata.pricer.rate.RatesProvider;
import com.opengamma.strata.pricer.swap.SwapPaymentPeriodPricer;
import com.opengamma.strata.product.rate.RateComputation;
import com.opengamma.strata.product.swap.CompoundingMethod;
import com.opengamma.strata.product.swap.FxReset;
import com.opengamma.strata.product.swap.RateAccrualPeriod;
import com.opengamma.strata.product.swap.RatePaymentPeriod;
import java.time.LocalDate;
import java.time.temporal.ChronoUnit;
import java.util.List;

public class DiscountingRatePaymentPeriodPricer
implements SwapPaymentPeriodPricer<RatePaymentPeriod> {
    public static final DiscountingRatePaymentPeriodPricer DEFAULT = new DiscountingRatePaymentPeriodPricer(RateComputationFn.standard());
    private final RateComputationFn<RateComputation> rateComputationFn;

    public DiscountingRatePaymentPeriodPricer(RateComputationFn<RateComputation> rateComputationFn) {
        this.rateComputationFn = (RateComputationFn)ArgChecker.notNull(rateComputationFn, (String)"rateComputationFn");
    }

    @Override
    public double presentValue(RatePaymentPeriod period, RatesProvider provider) {
        double df = provider.discountFactor(period.getCurrency(), period.getPaymentDate());
        return this.forecastValue(period, provider) * df;
    }

    @Override
    public double forecastValue(RatePaymentPeriod period, RatesProvider provider) {
        double notional = period.getNotional() * this.fxRate(period, provider);
        return this.accrualWithNotional(period, notional, provider);
    }

    @Override
    public double pvbp(RatePaymentPeriod paymentPeriod, RatesProvider provider) {
        ArgChecker.isTrue((!paymentPeriod.getFxReset().isPresent() ? 1 : 0) != 0, (String)"FX reset is not supported");
        int accPeriodCount = paymentPeriod.getAccrualPeriods().size();
        ArgChecker.isTrue((accPeriodCount == 1 || paymentPeriod.getCompoundingMethod().equals((Object)CompoundingMethod.FLAT) ? 1 : 0) != 0, (String)"Only one accrued period or Flat compounding supported");
        if (accPeriodCount == 1) {
            RateAccrualPeriod accrualPeriod = (RateAccrualPeriod)paymentPeriod.getAccrualPeriods().get(0);
            double df = provider.discountFactor(paymentPeriod.getCurrency(), paymentPeriod.getPaymentDate());
            return df * accrualPeriod.getYearFraction() * paymentPeriod.getNotional();
        }
        switch (paymentPeriod.getCompoundingMethod()) {
            case FLAT: {
                return this.pvbpCompoundedFlat(paymentPeriod, provider);
            }
        }
        throw new UnsupportedOperationException("PVBP not implemented yet for non FLAT compounding");
    }

    @Override
    public double accruedInterest(RatePaymentPeriod period, RatesProvider provider) {
        LocalDate valDate = provider.getValuationDate();
        if (valDate.compareTo(period.getStartDate()) <= 0 || valDate.compareTo(period.getEndDate()) > 0) {
            return 0.0;
        }
        ImmutableList.Builder truncated = ImmutableList.builder();
        for (RateAccrualPeriod rap : period.getAccrualPeriods()) {
            if (valDate.compareTo(rap.getEndDate()) > 0) {
                truncated.add((Object)rap);
                continue;
            }
            truncated.add((Object)rap.toBuilder().endDate(provider.getValuationDate()).unadjustedEndDate(provider.getValuationDate()).yearFraction(period.getDayCount().yearFraction(rap.getStartDate(), provider.getValuationDate())).build());
            break;
        }
        RatePaymentPeriod adjustedPaymentPeriod = period.toBuilder().accrualPeriods((List)truncated.build()).build();
        return this.forecastValue(adjustedPaymentPeriod, provider);
    }

    private double fxRate(RatePaymentPeriod paymentPeriod, RatesProvider provider) {
        if (paymentPeriod.getFxReset().isPresent()) {
            FxReset fxReset = (FxReset)paymentPeriod.getFxReset().get();
            FxIndexRates rates = provider.fxIndexRates(fxReset.getObservation().getIndex());
            return rates.rate(fxReset.getObservation(), fxReset.getReferenceCurrency());
        }
        return 1.0;
    }

    private double accrualWithNotional(RatePaymentPeriod period, double notional, RatesProvider provider) {
        if (period.getAccrualPeriods().size() == 1) {
            RateAccrualPeriod accrualPeriod = (RateAccrualPeriod)period.getAccrualPeriods().get(0);
            return this.unitNotionalAccrual(accrualPeriod, accrualPeriod.getSpread(), provider) * notional;
        }
        return this.accrueCompounded(period, notional, provider);
    }

    private double unitNotionalAccrual(RateAccrualPeriod accrualPeriod, double spread, RatesProvider provider) {
        double rawRate = this.rawRate(accrualPeriod, provider);
        return this.unitNotionalAccrualRaw(accrualPeriod, rawRate, spread);
    }

    private double unitNotionalAccrualRaw(RateAccrualPeriod accrualPeriod, double rawRate, double spread) {
        double treatedRate = rawRate * accrualPeriod.getGearing() + spread;
        return accrualPeriod.getNegativeRateMethod().adjust(treatedRate * accrualPeriod.getYearFraction());
    }

    private double rawRate(RateAccrualPeriod accrualPeriod, RatesProvider provider) {
        return this.rateComputationFn.rate(accrualPeriod.getRateComputation(), accrualPeriod.getStartDate(), accrualPeriod.getEndDate(), provider);
    }

    private double accrueCompounded(RatePaymentPeriod paymentPeriod, double notional, RatesProvider provider) {
        switch (paymentPeriod.getCompoundingMethod()) {
            case STRAIGHT: {
                return this.compoundedStraight(paymentPeriod, notional, provider);
            }
            case FLAT: {
                return this.compoundedFlat(paymentPeriod, notional, provider);
            }
            case SPREAD_EXCLUSIVE: {
                return this.compoundedSpreadExclusive(paymentPeriod, notional, provider);
            }
        }
        return this.compoundingNone(paymentPeriod, notional, provider);
    }

    private double compoundedStraight(RatePaymentPeriod paymentPeriod, double notional, RatesProvider provider) {
        double notionalAccrued = notional;
        for (RateAccrualPeriod accrualPeriod : paymentPeriod.getAccrualPeriods()) {
            double investFactor = 1.0 + this.unitNotionalAccrual(accrualPeriod, accrualPeriod.getSpread(), provider);
            notionalAccrued *= investFactor;
        }
        return notionalAccrued - notional;
    }

    private double compoundedFlat(RatePaymentPeriod paymentPeriod, double notional, RatesProvider provider) {
        double cpaAccumulated = 0.0;
        for (RateAccrualPeriod accrualPeriod : paymentPeriod.getAccrualPeriods()) {
            double rate = this.rawRate(accrualPeriod, provider);
            cpaAccumulated += cpaAccumulated * this.unitNotionalAccrualRaw(accrualPeriod, rate, 0.0) + this.unitNotionalAccrualRaw(accrualPeriod, rate, accrualPeriod.getSpread());
        }
        return cpaAccumulated * notional;
    }

    private double compoundedSpreadExclusive(RatePaymentPeriod paymentPeriod, double notional, RatesProvider provider) {
        double notionalAccrued = notional;
        double spreadAccrued = 0.0;
        for (RateAccrualPeriod accrualPeriod : paymentPeriod.getAccrualPeriods()) {
            double investFactor = 1.0 + this.unitNotionalAccrual(accrualPeriod, 0.0, provider);
            notionalAccrued *= investFactor;
            spreadAccrued += notional * accrualPeriod.getSpread() * accrualPeriod.getYearFraction();
        }
        return notionalAccrued - notional + spreadAccrued;
    }

    private double compoundingNone(RatePaymentPeriod paymentPeriod, double notional, RatesProvider provider) {
        return paymentPeriod.getAccrualPeriods().stream().mapToDouble(accrualPeriod -> this.unitNotionalAccrual((RateAccrualPeriod)accrualPeriod, accrualPeriod.getSpread(), provider) * notional).sum();
    }

    @Override
    public PointSensitivityBuilder presentValueSensitivity(RatePaymentPeriod period, RatesProvider provider) {
        Currency ccy = period.getCurrency();
        DiscountFactors discountFactors = provider.discountFactors(ccy);
        LocalDate paymentDate = period.getPaymentDate();
        double df = discountFactors.discountFactor(paymentDate);
        PointSensitivityBuilder forecastSensitivity = this.forecastValueSensitivity(period, provider);
        forecastSensitivity = forecastSensitivity.multipliedBy(df);
        double forecastValue = this.forecastValue(period, provider);
        ZeroRateSensitivity dscSensitivity = discountFactors.zeroRatePointSensitivity(paymentDate);
        dscSensitivity = dscSensitivity.multipliedBy(forecastValue);
        return forecastSensitivity.combinedWith((PointSensitivityBuilder)dscSensitivity);
    }

    @Override
    public PointSensitivityBuilder forecastValueSensitivity(RatePaymentPeriod period, RatesProvider provider) {
        if (period.getPaymentDate().isBefore(provider.getValuationDate())) {
            return PointSensitivityBuilder.none();
        }
        PointSensitivityBuilder sensiFx = this.fxRateSensitivity(period, provider);
        double accrual = this.accrualWithNotional(period, period.getNotional(), provider);
        sensiFx = sensiFx.multipliedBy(accrual);
        PointSensitivityBuilder sensiAccrual = PointSensitivityBuilder.none();
        sensiAccrual = period.isCompoundingApplicable() ? this.accrueCompoundedSensitivity(period, provider) : this.unitNotionalSensitivityNoCompounding(period, provider);
        double notional = period.getNotional() * this.fxRate(period, provider);
        sensiAccrual = sensiAccrual.multipliedBy(notional);
        return sensiFx.combinedWith(sensiAccrual);
    }

    @Override
    public PointSensitivityBuilder pvbpSensitivity(RatePaymentPeriod paymentPeriod, RatesProvider provider) {
        ArgChecker.isTrue((!paymentPeriod.getFxReset().isPresent() ? 1 : 0) != 0, (String)"FX reset is not supported");
        int accPeriodCount = paymentPeriod.getAccrualPeriods().size();
        ArgChecker.isTrue((accPeriodCount == 1 || paymentPeriod.getCompoundingMethod().equals((Object)CompoundingMethod.FLAT) ? 1 : 0) != 0, (String)"Only one accrued period or Flat compounding supported");
        if (accPeriodCount == 1) {
            RateAccrualPeriod accrualPeriod = (RateAccrualPeriod)paymentPeriod.getAccrualPeriods().get(0);
            DiscountFactors discountFactors = provider.discountFactors(paymentPeriod.getCurrency());
            return discountFactors.zeroRatePointSensitivity(paymentPeriod.getPaymentDate()).multipliedBy(accrualPeriod.getYearFraction() * paymentPeriod.getNotional());
        }
        switch (paymentPeriod.getCompoundingMethod()) {
            case FLAT: {
                return this.pvbpSensitivtyCompoundedFlat(paymentPeriod, provider);
            }
        }
        throw new UnsupportedOperationException("PVBP not implemented yet for non FLAT compounding");
    }

    private PointSensitivityBuilder fxRateSensitivity(RatePaymentPeriod paymentPeriod, RatesProvider provider) {
        if (paymentPeriod.getFxReset().isPresent()) {
            FxReset fxReset = (FxReset)paymentPeriod.getFxReset().get();
            FxIndexRates rates = provider.fxIndexRates(fxReset.getObservation().getIndex());
            return rates.ratePointSensitivity(fxReset.getObservation(), fxReset.getReferenceCurrency());
        }
        return PointSensitivityBuilder.none();
    }

    private PointSensitivityBuilder unitNotionalSensitivityNoCompounding(RatePaymentPeriod period, RatesProvider provider) {
        Currency ccy = period.getCurrency();
        PointSensitivityBuilder sensi = PointSensitivityBuilder.none();
        for (RateAccrualPeriod accrualPeriod : period.getAccrualPeriods()) {
            sensi = sensi.combinedWith(this.unitNotionalSensitivityAccrual(accrualPeriod, ccy, provider));
        }
        return sensi;
    }

    private PointSensitivityBuilder unitNotionalSensitivityAccrual(RateAccrualPeriod period, Currency ccy, RatesProvider provider) {
        PointSensitivityBuilder sensi = this.rateComputationFn.rateSensitivity(period.getRateComputation(), period.getStartDate(), period.getEndDate(), provider);
        return sensi.multipliedBy(period.getGearing() * period.getYearFraction());
    }

    private PointSensitivityBuilder accrueCompoundedSensitivity(RatePaymentPeriod paymentPeriod, RatesProvider provider) {
        switch (paymentPeriod.getCompoundingMethod()) {
            case STRAIGHT: {
                return this.compoundedStraightSensitivity(paymentPeriod, provider);
            }
            case FLAT: {
                return this.compoundedFlatSensitivity(paymentPeriod, provider);
            }
            case SPREAD_EXCLUSIVE: {
                return this.compoundedSpreadExclusiveSensitivity(paymentPeriod, provider);
            }
        }
        return this.unitNotionalSensitivityNoCompounding(paymentPeriod, provider);
    }

    private PointSensitivityBuilder compoundedStraightSensitivity(RatePaymentPeriod paymentPeriod, RatesProvider provider) {
        double notionalAccrued = 1.0;
        Currency ccy = paymentPeriod.getCurrency();
        PointSensitivityBuilder sensi = PointSensitivityBuilder.none();
        for (RateAccrualPeriod accrualPeriod : paymentPeriod.getAccrualPeriods()) {
            double investFactor = 1.0 + this.unitNotionalAccrual(accrualPeriod, accrualPeriod.getSpread(), provider);
            notionalAccrued *= investFactor;
            PointSensitivityBuilder investFactorSensi = this.unitNotionalSensitivityAccrual(accrualPeriod, ccy, provider).multipliedBy(1.0 / investFactor);
            sensi = sensi.combinedWith(investFactorSensi);
        }
        return sensi.multipliedBy(notionalAccrued);
    }

    private PointSensitivityBuilder compoundedFlatSensitivity(RatePaymentPeriod paymentPeriod, RatesProvider provider) {
        double cpaAccumulated = 0.0;
        Currency ccy = paymentPeriod.getCurrency();
        PointSensitivityBuilder sensiAccumulated = PointSensitivityBuilder.none();
        for (RateAccrualPeriod accrualPeriod : paymentPeriod.getAccrualPeriods()) {
            double rate = this.rawRate(accrualPeriod, provider);
            double accrualZeroSpread = this.unitNotionalAccrualRaw(accrualPeriod, rate, 0.0);
            PointSensitivityBuilder sensiCp = sensiAccumulated.cloned();
            sensiCp = sensiCp.multipliedBy(accrualZeroSpread);
            PointSensitivityBuilder sensi2 = this.unitNotionalSensitivityAccrual(accrualPeriod, ccy, provider).multipliedBy(1.0 + cpaAccumulated);
            cpaAccumulated += cpaAccumulated * accrualZeroSpread + this.unitNotionalAccrualRaw(accrualPeriod, rate, accrualPeriod.getSpread());
            sensiCp = sensiCp.combinedWith(sensi2);
            sensiAccumulated = sensiAccumulated.combinedWith(sensiCp).normalize();
        }
        return sensiAccumulated;
    }

    private PointSensitivityBuilder compoundedSpreadExclusiveSensitivity(RatePaymentPeriod paymentPeriod, RatesProvider provider) {
        double notionalAccrued = 1.0;
        Currency ccy = paymentPeriod.getCurrency();
        PointSensitivityBuilder sensi = PointSensitivityBuilder.none();
        for (RateAccrualPeriod accrualPeriod : paymentPeriod.getAccrualPeriods()) {
            double investFactor = 1.0 + this.unitNotionalAccrual(accrualPeriod, 0.0, provider);
            notionalAccrued *= investFactor;
            PointSensitivityBuilder investFactorSensi = this.unitNotionalSensitivityAccrual(accrualPeriod, ccy, provider).multipliedBy(1.0 / investFactor);
            sensi = sensi.combinedWith(investFactorSensi);
        }
        return sensi.multipliedBy(notionalAccrued);
    }

    @Override
    public void explainPresentValue(RatePaymentPeriod paymentPeriod, RatesProvider provider, ExplainMapBuilder builder) {
        Currency currency = paymentPeriod.getCurrency();
        LocalDate paymentDate = paymentPeriod.getPaymentDate();
        double fxRate = this.fxRate(paymentPeriod, provider);
        double notional = paymentPeriod.getNotional() * fxRate;
        builder.put(ExplainKey.ENTRY_TYPE, (Object)"RatePaymentPeriod");
        builder.put(ExplainKey.PAYMENT_DATE, (Object)paymentDate);
        builder.put(ExplainKey.PAYMENT_CURRENCY, (Object)currency);
        builder.put(ExplainKey.NOTIONAL, (Object)CurrencyAmount.of((Currency)currency, (double)notional));
        builder.put(ExplainKey.TRADE_NOTIONAL, (Object)paymentPeriod.getNotionalAmount());
        if (paymentDate.isBefore(provider.getValuationDate())) {
            builder.put(ExplainKey.COMPLETED, (Object)Boolean.TRUE);
            builder.put(ExplainKey.FORECAST_VALUE, (Object)CurrencyAmount.zero((Currency)currency));
            builder.put(ExplainKey.PRESENT_VALUE, (Object)CurrencyAmount.zero((Currency)currency));
        } else {
            paymentPeriod.getFxReset().ifPresent(fxReset -> builder.addListEntry(ExplainKey.OBSERVATIONS, child -> {
                child.put(ExplainKey.ENTRY_TYPE, (Object)"FxObservation");
                child.put(ExplainKey.INDEX, (Object)fxReset.getObservation().getIndex());
                child.put(ExplainKey.FIXING_DATE, (Object)fxReset.getObservation().getFixingDate());
                child.put(ExplainKey.INDEX_VALUE, (Object)fxRate);
            }));
            for (RateAccrualPeriod accrualPeriod : paymentPeriod.getAccrualPeriods()) {
                builder.addListEntry(ExplainKey.ACCRUAL_PERIODS, child -> this.explainPresentValue(accrualPeriod, paymentPeriod.getDayCount(), currency, notional, provider, (ExplainMapBuilder)child));
            }
            builder.put(ExplainKey.COMPOUNDING, (Object)paymentPeriod.getCompoundingMethod());
            builder.put(ExplainKey.DISCOUNT_FACTOR, (Object)provider.discountFactor(currency, paymentDate));
            builder.put(ExplainKey.FORECAST_VALUE, (Object)CurrencyAmount.of((Currency)currency, (double)this.forecastValue(paymentPeriod, provider)));
            builder.put(ExplainKey.PRESENT_VALUE, (Object)CurrencyAmount.of((Currency)currency, (double)this.presentValue(paymentPeriod, provider)));
        }
    }

    private void explainPresentValue(RateAccrualPeriod accrualPeriod, DayCount dayCount, Currency currency, double notional, RatesProvider provider, ExplainMapBuilder builder) {
        double rawRate = this.rateComputationFn.explainRate(accrualPeriod.getRateComputation(), accrualPeriod.getStartDate(), accrualPeriod.getEndDate(), provider, builder);
        double payOffRate = rawRate * accrualPeriod.getGearing() + accrualPeriod.getSpread();
        double ua = this.unitNotionalAccrual(accrualPeriod, accrualPeriod.getSpread(), provider);
        builder.put(ExplainKey.ENTRY_TYPE, (Object)"AccrualPeriod");
        builder.put(ExplainKey.START_DATE, (Object)accrualPeriod.getStartDate());
        builder.put(ExplainKey.UNADJUSTED_START_DATE, (Object)accrualPeriod.getUnadjustedStartDate());
        builder.put(ExplainKey.END_DATE, (Object)accrualPeriod.getEndDate());
        builder.put(ExplainKey.UNADJUSTED_END_DATE, (Object)accrualPeriod.getUnadjustedEndDate());
        builder.put(ExplainKey.ACCRUAL_YEAR_FRACTION, (Object)accrualPeriod.getYearFraction());
        builder.put(ExplainKey.ACCRUAL_DAYS, (Object)dayCount.days(accrualPeriod.getStartDate(), accrualPeriod.getEndDate()));
        builder.put(ExplainKey.DAYS, (Object)((int)ChronoUnit.DAYS.between(accrualPeriod.getStartDate(), accrualPeriod.getEndDate())));
        builder.put(ExplainKey.GEARING, (Object)accrualPeriod.getGearing());
        builder.put(ExplainKey.SPREAD, (Object)accrualPeriod.getSpread());
        builder.put(ExplainKey.PAY_OFF_RATE, (Object)accrualPeriod.getNegativeRateMethod().adjust(payOffRate));
        builder.put(ExplainKey.UNIT_AMOUNT, (Object)ua);
    }

    @Override
    public MultiCurrencyAmount currencyExposure(RatePaymentPeriod period, RatesProvider provider) {
        double df = provider.discountFactor(period.getCurrency(), period.getPaymentDate());
        if (period.getFxReset().isPresent()) {
            FxReset fxReset = (FxReset)period.getFxReset().get();
            LocalDate fixingDate = fxReset.getObservation().getFixingDate();
            FxIndexRates rates = provider.fxIndexRates(fxReset.getObservation().getIndex());
            if (!fixingDate.isAfter(provider.getValuationDate()) && rates.getFixings().get(fixingDate).isPresent()) {
                double fxRate = rates.rate(fxReset.getObservation(), fxReset.getReferenceCurrency());
                return MultiCurrencyAmount.of((Currency)period.getCurrency(), (double)this.accrualWithNotional(period, period.getNotional() * fxRate * df, provider));
            }
            double fxRateSpotSensitivity = rates.getFxForwardRates().rateFxSpotSensitivity(fxReset.getReferenceCurrency(), fxReset.getObservation().getMaturityDate());
            return MultiCurrencyAmount.of((Currency)fxReset.getReferenceCurrency(), (double)this.accrualWithNotional(period, period.getNotional() * fxRateSpotSensitivity * df, provider));
        }
        return MultiCurrencyAmount.of((Currency)period.getCurrency(), (double)this.accrualWithNotional(period, period.getNotional() * df, provider));
    }

    @Override
    public double currentCash(RatePaymentPeriod period, RatesProvider provider) {
        if (provider.getValuationDate().isEqual(period.getPaymentDate())) {
            return this.forecastValue(period, provider);
        }
        return 0.0;
    }

    private double pvbpCompoundedFlat(RatePaymentPeriod paymentPeriod, RatesProvider provider) {
        int nbCmp = paymentPeriod.getAccrualPeriods().size();
        double[] rate = paymentPeriod.getAccrualPeriods().stream().mapToDouble(ap -> this.rawRate((RateAccrualPeriod)ap, provider)).toArray();
        double df = provider.discountFactor(paymentPeriod.getCurrency(), paymentPeriod.getPaymentDate());
        double rBar = 1.0;
        double[] cpaAccumulatedBar = new double[nbCmp + 1];
        cpaAccumulatedBar[nbCmp] = paymentPeriod.getNotional() * df * rBar;
        double spreadBar = 0.0;
        for (int j = nbCmp - 1; j >= 0; --j) {
            cpaAccumulatedBar[j] = (1.0 + ((RateAccrualPeriod)paymentPeriod.getAccrualPeriods().get(j)).getYearFraction() * rate[j] * ((RateAccrualPeriod)paymentPeriod.getAccrualPeriods().get(j)).getGearing()) * cpaAccumulatedBar[j + 1];
            spreadBar += ((RateAccrualPeriod)paymentPeriod.getAccrualPeriods().get(j)).getYearFraction() * cpaAccumulatedBar[j + 1];
        }
        return spreadBar;
    }

    private PointSensitivityBuilder pvbpSensitivtyCompoundedFlat(RatePaymentPeriod paymentPeriod, RatesProvider provider) {
        Currency ccy = paymentPeriod.getCurrency();
        int nbCmp = paymentPeriod.getAccrualPeriods().size();
        double[] rate = paymentPeriod.getAccrualPeriods().stream().mapToDouble(ap -> this.rawRate((RateAccrualPeriod)ap, provider)).toArray();
        double df = provider.discountFactor(ccy, paymentPeriod.getPaymentDate());
        double rB1 = 1.0;
        double[] cpaAccumulatedB1 = new double[nbCmp + 1];
        cpaAccumulatedB1[nbCmp] = paymentPeriod.getNotional() * df * rB1;
        for (int j = nbCmp - 1; j >= 0; --j) {
            RateAccrualPeriod accrualPeriod = (RateAccrualPeriod)paymentPeriod.getAccrualPeriods().get(j);
            cpaAccumulatedB1[j] = (1.0 + accrualPeriod.getYearFraction() * rate[j] * accrualPeriod.getGearing()) * cpaAccumulatedB1[j + 1];
        }
        double pvbpB2 = 1.0;
        double[] cpaAccumulatedB1B2 = new double[nbCmp + 1];
        double[] rateB2 = new double[nbCmp];
        for (int j = 0; j < nbCmp; ++j) {
            RateAccrualPeriod accrualPeriod = (RateAccrualPeriod)paymentPeriod.getAccrualPeriods().get(j);
            int n = j + 1;
            cpaAccumulatedB1B2[n] = cpaAccumulatedB1B2[n] + accrualPeriod.getYearFraction() * pvbpB2;
            int n2 = j + 1;
            cpaAccumulatedB1B2[n2] = cpaAccumulatedB1B2[n2] + (1.0 + accrualPeriod.getYearFraction() * rate[j] * accrualPeriod.getGearing()) * cpaAccumulatedB1B2[j];
            int n3 = j;
            rateB2[n3] = rateB2[n3] + accrualPeriod.getYearFraction() * accrualPeriod.getGearing() * cpaAccumulatedB1[j + 1] * cpaAccumulatedB1B2[j];
        }
        double dfB2 = paymentPeriod.getNotional() * rB1 * cpaAccumulatedB1B2[nbCmp];
        ZeroRateSensitivity dfdr = provider.discountFactors(ccy).zeroRatePointSensitivity(paymentPeriod.getPaymentDate());
        PointSensitivityBuilder pvbpdr = dfdr.multipliedBy(dfB2);
        for (int j = 0; j < nbCmp; ++j) {
            RateAccrualPeriod accrualPeriod = (RateAccrualPeriod)paymentPeriod.getAccrualPeriods().get(j);
            pvbpdr = pvbpdr.combinedWith(this.rateComputationFn.rateSensitivity(accrualPeriod.getRateComputation(), accrualPeriod.getStartDate(), accrualPeriod.getEndDate(), provider).multipliedBy(rateB2[j]));
        }
        return pvbpdr;
    }
}

