/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.pricer.impl.swap;

import com.opengamma.strata.basics.currency.MultiCurrencyAmount;
import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.market.explain.ExplainMapBuilder;
import com.opengamma.strata.market.sensitivity.PointSensitivityBuilder;
import com.opengamma.strata.pricer.impl.swap.DiscountingFxResetNotionalExchangePricer;
import com.opengamma.strata.pricer.impl.swap.DiscountingNotionalExchangePricer;
import com.opengamma.strata.pricer.rate.RatesProvider;
import com.opengamma.strata.pricer.swap.SwapPaymentEventPricer;
import com.opengamma.strata.product.swap.FxResetNotionalExchange;
import com.opengamma.strata.product.swap.NotionalExchange;
import com.opengamma.strata.product.swap.SwapPaymentEvent;

public class DispatchingSwapPaymentEventPricer
implements SwapPaymentEventPricer<SwapPaymentEvent> {
    public static final DispatchingSwapPaymentEventPricer DEFAULT = new DispatchingSwapPaymentEventPricer(DiscountingNotionalExchangePricer.DEFAULT, DiscountingFxResetNotionalExchangePricer.DEFAULT);
    private final SwapPaymentEventPricer<NotionalExchange> notionalExchangePricer;
    private final SwapPaymentEventPricer<FxResetNotionalExchange> fxResetNotionalExchangePricer;

    public DispatchingSwapPaymentEventPricer(SwapPaymentEventPricer<NotionalExchange> notionalExchangePricer, SwapPaymentEventPricer<FxResetNotionalExchange> fxResetNotionalExchangePricer) {
        this.notionalExchangePricer = (SwapPaymentEventPricer)ArgChecker.notNull(notionalExchangePricer, (String)"notionalExchangePricer");
        this.fxResetNotionalExchangePricer = (SwapPaymentEventPricer)ArgChecker.notNull(fxResetNotionalExchangePricer, (String)"fxResetNotionalExchangePricer");
    }

    @Override
    public double presentValue(SwapPaymentEvent paymentEvent, RatesProvider provider) {
        if (paymentEvent instanceof NotionalExchange) {
            return this.notionalExchangePricer.presentValue((NotionalExchange)paymentEvent, provider);
        }
        if (paymentEvent instanceof FxResetNotionalExchange) {
            return this.fxResetNotionalExchangePricer.presentValue((FxResetNotionalExchange)paymentEvent, provider);
        }
        throw new IllegalArgumentException("Unknown PaymentEvent type: " + paymentEvent.getClass().getSimpleName());
    }

    @Override
    public PointSensitivityBuilder presentValueSensitivity(SwapPaymentEvent paymentEvent, RatesProvider provider) {
        if (paymentEvent instanceof NotionalExchange) {
            return this.notionalExchangePricer.presentValueSensitivity((NotionalExchange)paymentEvent, provider);
        }
        if (paymentEvent instanceof FxResetNotionalExchange) {
            return this.fxResetNotionalExchangePricer.presentValueSensitivity((FxResetNotionalExchange)paymentEvent, provider);
        }
        throw new IllegalArgumentException("Unknown PaymentEvent type: " + paymentEvent.getClass().getSimpleName());
    }

    @Override
    public double forecastValue(SwapPaymentEvent paymentEvent, RatesProvider provider) {
        if (paymentEvent instanceof NotionalExchange) {
            return this.notionalExchangePricer.forecastValue((NotionalExchange)paymentEvent, provider);
        }
        if (paymentEvent instanceof FxResetNotionalExchange) {
            return this.fxResetNotionalExchangePricer.forecastValue((FxResetNotionalExchange)paymentEvent, provider);
        }
        throw new IllegalArgumentException("Unknown PaymentEvent type: " + paymentEvent.getClass().getSimpleName());
    }

    @Override
    public PointSensitivityBuilder forecastValueSensitivity(SwapPaymentEvent paymentEvent, RatesProvider provider) {
        if (paymentEvent instanceof NotionalExchange) {
            return this.notionalExchangePricer.forecastValueSensitivity((NotionalExchange)paymentEvent, provider);
        }
        if (paymentEvent instanceof FxResetNotionalExchange) {
            return this.fxResetNotionalExchangePricer.forecastValueSensitivity((FxResetNotionalExchange)paymentEvent, provider);
        }
        throw new IllegalArgumentException("Unknown PaymentEvent type: " + paymentEvent.getClass().getSimpleName());
    }

    @Override
    public void explainPresentValue(SwapPaymentEvent paymentEvent, RatesProvider provider, ExplainMapBuilder builder) {
        if (paymentEvent instanceof NotionalExchange) {
            this.notionalExchangePricer.explainPresentValue((NotionalExchange)paymentEvent, provider, builder);
        } else if (paymentEvent instanceof FxResetNotionalExchange) {
            this.fxResetNotionalExchangePricer.explainPresentValue((FxResetNotionalExchange)paymentEvent, provider, builder);
        } else {
            throw new IllegalArgumentException("Unknown PaymentEvent type: " + paymentEvent.getClass().getSimpleName());
        }
    }

    @Override
    public MultiCurrencyAmount currencyExposure(SwapPaymentEvent paymentEvent, RatesProvider provider) {
        if (paymentEvent instanceof NotionalExchange) {
            return this.notionalExchangePricer.currencyExposure((NotionalExchange)paymentEvent, provider);
        }
        if (paymentEvent instanceof FxResetNotionalExchange) {
            return this.fxResetNotionalExchangePricer.currencyExposure((FxResetNotionalExchange)paymentEvent, provider);
        }
        throw new IllegalArgumentException("Unknown PaymentEvent type: " + paymentEvent.getClass().getSimpleName());
    }

    @Override
    public double currentCash(SwapPaymentEvent paymentEvent, RatesProvider provider) {
        if (paymentEvent instanceof NotionalExchange) {
            return this.notionalExchangePricer.currentCash((NotionalExchange)paymentEvent, provider);
        }
        if (paymentEvent instanceof FxResetNotionalExchange) {
            return this.fxResetNotionalExchangePricer.currentCash((FxResetNotionalExchange)paymentEvent, provider);
        }
        throw new IllegalArgumentException("Unknown PaymentEvent type: " + paymentEvent.getClass().getSimpleName());
    }
}

