/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.pricer.impl.swap;

import com.opengamma.strata.basics.currency.MultiCurrencyAmount;
import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.market.explain.ExplainMapBuilder;
import com.opengamma.strata.market.sensitivity.PointSensitivityBuilder;
import com.opengamma.strata.pricer.impl.swap.DiscountingKnownAmountPaymentPeriodPricer;
import com.opengamma.strata.pricer.impl.swap.DiscountingRatePaymentPeriodPricer;
import com.opengamma.strata.pricer.rate.RatesProvider;
import com.opengamma.strata.pricer.swap.SwapPaymentPeriodPricer;
import com.opengamma.strata.product.swap.KnownAmountSwapPaymentPeriod;
import com.opengamma.strata.product.swap.RatePaymentPeriod;
import com.opengamma.strata.product.swap.SwapPaymentPeriod;

public class DispatchingSwapPaymentPeriodPricer
implements SwapPaymentPeriodPricer<SwapPaymentPeriod> {
    public static final DispatchingSwapPaymentPeriodPricer DEFAULT = new DispatchingSwapPaymentPeriodPricer(DiscountingRatePaymentPeriodPricer.DEFAULT, DiscountingKnownAmountPaymentPeriodPricer.DEFAULT);
    private final SwapPaymentPeriodPricer<RatePaymentPeriod> ratePaymentPeriodPricer;
    private final SwapPaymentPeriodPricer<KnownAmountSwapPaymentPeriod> knownAmountPaymentPeriodPricer;

    public DispatchingSwapPaymentPeriodPricer(SwapPaymentPeriodPricer<RatePaymentPeriod> ratePaymentPeriodPricer, SwapPaymentPeriodPricer<KnownAmountSwapPaymentPeriod> knownAmountPaymentPeriodPricer) {
        this.ratePaymentPeriodPricer = (SwapPaymentPeriodPricer)ArgChecker.notNull(ratePaymentPeriodPricer, (String)"ratePaymentPeriodPricer");
        this.knownAmountPaymentPeriodPricer = (SwapPaymentPeriodPricer)ArgChecker.notNull(knownAmountPaymentPeriodPricer, (String)"knownAmountPaymentPeriodPricer");
    }

    @Override
    public double presentValue(SwapPaymentPeriod paymentPeriod, RatesProvider provider) {
        if (paymentPeriod instanceof RatePaymentPeriod) {
            return this.ratePaymentPeriodPricer.presentValue((RatePaymentPeriod)paymentPeriod, provider);
        }
        if (paymentPeriod instanceof KnownAmountSwapPaymentPeriod) {
            return this.knownAmountPaymentPeriodPricer.presentValue((KnownAmountSwapPaymentPeriod)paymentPeriod, provider);
        }
        throw new IllegalArgumentException("Unknown PaymentPeriod type: " + paymentPeriod.getClass().getSimpleName());
    }

    @Override
    public PointSensitivityBuilder presentValueSensitivity(SwapPaymentPeriod paymentPeriod, RatesProvider provider) {
        if (paymentPeriod instanceof RatePaymentPeriod) {
            return this.ratePaymentPeriodPricer.presentValueSensitivity((RatePaymentPeriod)paymentPeriod, provider);
        }
        if (paymentPeriod instanceof KnownAmountSwapPaymentPeriod) {
            return this.knownAmountPaymentPeriodPricer.presentValueSensitivity((KnownAmountSwapPaymentPeriod)paymentPeriod, provider);
        }
        throw new IllegalArgumentException("Unknown PaymentPeriod type: " + paymentPeriod.getClass().getSimpleName());
    }

    @Override
    public double forecastValue(SwapPaymentPeriod paymentPeriod, RatesProvider provider) {
        if (paymentPeriod instanceof RatePaymentPeriod) {
            return this.ratePaymentPeriodPricer.forecastValue((RatePaymentPeriod)paymentPeriod, provider);
        }
        if (paymentPeriod instanceof KnownAmountSwapPaymentPeriod) {
            return this.knownAmountPaymentPeriodPricer.forecastValue((KnownAmountSwapPaymentPeriod)paymentPeriod, provider);
        }
        throw new IllegalArgumentException("Unknown PaymentPeriod type: " + paymentPeriod.getClass().getSimpleName());
    }

    @Override
    public PointSensitivityBuilder forecastValueSensitivity(SwapPaymentPeriod paymentPeriod, RatesProvider provider) {
        if (paymentPeriod instanceof RatePaymentPeriod) {
            return this.ratePaymentPeriodPricer.forecastValueSensitivity((RatePaymentPeriod)paymentPeriod, provider);
        }
        if (paymentPeriod instanceof KnownAmountSwapPaymentPeriod) {
            return this.knownAmountPaymentPeriodPricer.forecastValueSensitivity((KnownAmountSwapPaymentPeriod)paymentPeriod, provider);
        }
        throw new IllegalArgumentException("Unknown PaymentPeriod type: " + paymentPeriod.getClass().getSimpleName());
    }

    @Override
    public double pvbp(SwapPaymentPeriod paymentPeriod, RatesProvider provider) {
        if (paymentPeriod instanceof RatePaymentPeriod) {
            return this.ratePaymentPeriodPricer.pvbp((RatePaymentPeriod)paymentPeriod, provider);
        }
        if (paymentPeriod instanceof KnownAmountSwapPaymentPeriod) {
            return this.knownAmountPaymentPeriodPricer.pvbp((KnownAmountSwapPaymentPeriod)paymentPeriod, provider);
        }
        throw new IllegalArgumentException("Unknown PaymentPeriod type: " + paymentPeriod.getClass().getSimpleName());
    }

    @Override
    public PointSensitivityBuilder pvbpSensitivity(SwapPaymentPeriod paymentPeriod, RatesProvider provider) {
        if (paymentPeriod instanceof RatePaymentPeriod) {
            return this.ratePaymentPeriodPricer.pvbpSensitivity((RatePaymentPeriod)paymentPeriod, provider);
        }
        if (paymentPeriod instanceof KnownAmountSwapPaymentPeriod) {
            return this.knownAmountPaymentPeriodPricer.pvbpSensitivity((KnownAmountSwapPaymentPeriod)paymentPeriod, provider);
        }
        throw new IllegalArgumentException("Unknown PaymentPeriod type: " + paymentPeriod.getClass().getSimpleName());
    }

    @Override
    public double accruedInterest(SwapPaymentPeriod paymentPeriod, RatesProvider provider) {
        if (paymentPeriod instanceof RatePaymentPeriod) {
            return this.ratePaymentPeriodPricer.accruedInterest((RatePaymentPeriod)paymentPeriod, provider);
        }
        if (paymentPeriod instanceof KnownAmountSwapPaymentPeriod) {
            return this.knownAmountPaymentPeriodPricer.accruedInterest((KnownAmountSwapPaymentPeriod)paymentPeriod, provider);
        }
        throw new IllegalArgumentException("Unknown PaymentPeriod type: " + paymentPeriod.getClass().getSimpleName());
    }

    @Override
    public void explainPresentValue(SwapPaymentPeriod paymentPeriod, RatesProvider provider, ExplainMapBuilder builder) {
        if (paymentPeriod instanceof RatePaymentPeriod) {
            this.ratePaymentPeriodPricer.explainPresentValue((RatePaymentPeriod)paymentPeriod, provider, builder);
        } else if (paymentPeriod instanceof KnownAmountSwapPaymentPeriod) {
            this.knownAmountPaymentPeriodPricer.explainPresentValue((KnownAmountSwapPaymentPeriod)paymentPeriod, provider, builder);
        } else {
            throw new IllegalArgumentException("Unknown PaymentEvent type: " + paymentPeriod.getClass().getSimpleName());
        }
    }

    @Override
    public MultiCurrencyAmount currencyExposure(SwapPaymentPeriod paymentPeriod, RatesProvider provider) {
        if (paymentPeriod instanceof RatePaymentPeriod) {
            return this.ratePaymentPeriodPricer.currencyExposure((RatePaymentPeriod)paymentPeriod, provider);
        }
        if (paymentPeriod instanceof KnownAmountSwapPaymentPeriod) {
            return this.knownAmountPaymentPeriodPricer.currencyExposure((KnownAmountSwapPaymentPeriod)paymentPeriod, provider);
        }
        throw new IllegalArgumentException("Unknown PaymentEvent type: " + paymentPeriod.getClass().getSimpleName());
    }

    @Override
    public double currentCash(SwapPaymentPeriod paymentPeriod, RatesProvider provider) {
        if (paymentPeriod instanceof RatePaymentPeriod) {
            return this.ratePaymentPeriodPricer.currentCash((RatePaymentPeriod)paymentPeriod, provider);
        }
        if (paymentPeriod instanceof KnownAmountSwapPaymentPeriod) {
            return this.knownAmountPaymentPeriodPricer.currentCash((KnownAmountSwapPaymentPeriod)paymentPeriod, provider);
        }
        throw new IllegalArgumentException("Unknown PaymentEvent type: " + paymentPeriod.getClass().getSimpleName());
    }
}

