/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.pricer.impl.tree;

import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.collect.array.DoubleArray;
import com.opengamma.strata.pricer.impl.tree.SingleBarrierKnockoutFunction;
import com.opengamma.strata.product.common.PutCall;
import com.opengamma.strata.product.option.BarrierType;
import java.io.Serializable;
import java.util.Map;
import java.util.NoSuchElementException;
import org.joda.beans.Bean;
import org.joda.beans.BeanBuilder;
import org.joda.beans.ImmutableBean;
import org.joda.beans.JodaBeanUtils;
import org.joda.beans.MetaBean;
import org.joda.beans.MetaProperty;
import org.joda.beans.gen.BeanDefinition;
import org.joda.beans.gen.PropertyDefinition;
import org.joda.beans.impl.direct.DirectMetaBean;
import org.joda.beans.impl.direct.DirectMetaProperty;
import org.joda.beans.impl.direct.DirectMetaPropertyMap;
import org.joda.beans.impl.direct.DirectPrivateBeanBuilder;

@BeanDefinition(builderScope="private")
public final class ConstantContinuousSingleBarrierKnockoutFunction
extends SingleBarrierKnockoutFunction
implements ImmutableBean,
Serializable {
    @PropertyDefinition(overrideGet=true)
    private final double strike;
    @PropertyDefinition(overrideGet=true)
    private final double timeToExpiry;
    @PropertyDefinition(overrideGet=true)
    private final double sign;
    @PropertyDefinition(overrideGet=true)
    private final int numberOfSteps;
    @PropertyDefinition(validate="notNull", overrideGet=true)
    private final BarrierType barrierType;
    @PropertyDefinition
    private final double barrierLevel;
    @PropertyDefinition(validate="notNull")
    private final DoubleArray rebate;
    private static final long serialVersionUID = 1L;

    public static ConstantContinuousSingleBarrierKnockoutFunction of(double strike, double timeToExpiry, PutCall putCall, int numberOfSteps, BarrierType barrierType, double barrierLevel, DoubleArray rebate) {
        ArgChecker.isTrue((numberOfSteps > 0 ? 1 : 0) != 0, (String)"the number of steps should be positive");
        ArgChecker.isTrue((numberOfSteps + 1 == rebate.size() ? 1 : 0) != 0, (String)"the size of rebate should be numberOfSteps + 1");
        double sign = putCall.isCall() ? 1.0 : -1.0;
        return new ConstantContinuousSingleBarrierKnockoutFunction(strike, timeToExpiry, sign, numberOfSteps, barrierType, barrierLevel, rebate);
    }

    @Override
    public double getBarrierLevel(int step) {
        return this.barrierLevel;
    }

    @Override
    public double getRebate(int step) {
        return this.rebate.get(step);
    }

    public static Meta meta() {
        return Meta.INSTANCE;
    }

    private ConstantContinuousSingleBarrierKnockoutFunction(double strike, double timeToExpiry, double sign, int numberOfSteps, BarrierType barrierType, double barrierLevel, DoubleArray rebate) {
        JodaBeanUtils.notNull((Object)barrierType, (String)"barrierType");
        JodaBeanUtils.notNull((Object)rebate, (String)"rebate");
        this.strike = strike;
        this.timeToExpiry = timeToExpiry;
        this.sign = sign;
        this.numberOfSteps = numberOfSteps;
        this.barrierType = barrierType;
        this.barrierLevel = barrierLevel;
        this.rebate = rebate;
    }

    public Meta metaBean() {
        return Meta.INSTANCE;
    }

    @Override
    public double getStrike() {
        return this.strike;
    }

    @Override
    public double getTimeToExpiry() {
        return this.timeToExpiry;
    }

    @Override
    public double getSign() {
        return this.sign;
    }

    @Override
    public int getNumberOfSteps() {
        return this.numberOfSteps;
    }

    @Override
    public BarrierType getBarrierType() {
        return this.barrierType;
    }

    public double getBarrierLevel() {
        return this.barrierLevel;
    }

    public DoubleArray getRebate() {
        return this.rebate;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == this.getClass()) {
            ConstantContinuousSingleBarrierKnockoutFunction other = (ConstantContinuousSingleBarrierKnockoutFunction)obj;
            return JodaBeanUtils.equal((double)this.strike, (double)other.strike) && JodaBeanUtils.equal((double)this.timeToExpiry, (double)other.timeToExpiry) && JodaBeanUtils.equal((double)this.sign, (double)other.sign) && this.numberOfSteps == other.numberOfSteps && JodaBeanUtils.equal((Object)this.barrierType, (Object)other.barrierType) && JodaBeanUtils.equal((double)this.barrierLevel, (double)other.barrierLevel) && JodaBeanUtils.equal((Object)this.rebate, (Object)other.rebate);
        }
        return false;
    }

    public int hashCode() {
        int hash = this.getClass().hashCode();
        hash = hash * 31 + JodaBeanUtils.hashCode((double)this.strike);
        hash = hash * 31 + JodaBeanUtils.hashCode((double)this.timeToExpiry);
        hash = hash * 31 + JodaBeanUtils.hashCode((double)this.sign);
        hash = hash * 31 + JodaBeanUtils.hashCode((int)this.numberOfSteps);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.barrierType);
        hash = hash * 31 + JodaBeanUtils.hashCode((double)this.barrierLevel);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.rebate);
        return hash;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(256);
        buf.append("ConstantContinuousSingleBarrierKnockoutFunction{");
        buf.append("strike").append('=').append(JodaBeanUtils.toString((Object)this.strike)).append(',').append(' ');
        buf.append("timeToExpiry").append('=').append(JodaBeanUtils.toString((Object)this.timeToExpiry)).append(',').append(' ');
        buf.append("sign").append('=').append(JodaBeanUtils.toString((Object)this.sign)).append(',').append(' ');
        buf.append("numberOfSteps").append('=').append(JodaBeanUtils.toString((Object)this.numberOfSteps)).append(',').append(' ');
        buf.append("barrierType").append('=').append(JodaBeanUtils.toString((Object)this.barrierType)).append(',').append(' ');
        buf.append("barrierLevel").append('=').append(JodaBeanUtils.toString((Object)this.barrierLevel)).append(',').append(' ');
        buf.append("rebate").append('=').append(JodaBeanUtils.toString((Object)this.rebate));
        buf.append('}');
        return buf.toString();
    }

    static {
        MetaBean.register((MetaBean)Meta.INSTANCE);
    }

    private static final class Builder
    extends DirectPrivateBeanBuilder<ConstantContinuousSingleBarrierKnockoutFunction> {
        private double strike;
        private double timeToExpiry;
        private double sign;
        private int numberOfSteps;
        private BarrierType barrierType;
        private double barrierLevel;
        private DoubleArray rebate;

        private Builder() {
        }

        public Object get(String propertyName) {
            switch (propertyName.hashCode()) {
                case -891985998: {
                    return this.strike;
                }
                case -1831499397: {
                    return this.timeToExpiry;
                }
                case 3530173: {
                    return this.sign;
                }
                case -1323103225: {
                    return this.numberOfSteps;
                }
                case 1029043089: {
                    return this.barrierType;
                }
                case 1827586573: {
                    return this.barrierLevel;
                }
                case -934952029: {
                    return this.rebate;
                }
            }
            throw new NoSuchElementException("Unknown property: " + propertyName);
        }

        public Builder set(String propertyName, Object newValue) {
            switch (propertyName.hashCode()) {
                case -891985998: {
                    this.strike = (Double)newValue;
                    break;
                }
                case -1831499397: {
                    this.timeToExpiry = (Double)newValue;
                    break;
                }
                case 3530173: {
                    this.sign = (Double)newValue;
                    break;
                }
                case -1323103225: {
                    this.numberOfSteps = (Integer)newValue;
                    break;
                }
                case 1029043089: {
                    this.barrierType = (BarrierType)newValue;
                    break;
                }
                case 1827586573: {
                    this.barrierLevel = (Double)newValue;
                    break;
                }
                case -934952029: {
                    this.rebate = (DoubleArray)newValue;
                    break;
                }
                default: {
                    throw new NoSuchElementException("Unknown property: " + propertyName);
                }
            }
            return this;
        }

        public ConstantContinuousSingleBarrierKnockoutFunction build() {
            return new ConstantContinuousSingleBarrierKnockoutFunction(this.strike, this.timeToExpiry, this.sign, this.numberOfSteps, this.barrierType, this.barrierLevel, this.rebate);
        }

        public String toString() {
            StringBuilder buf = new StringBuilder(256);
            buf.append("ConstantContinuousSingleBarrierKnockoutFunction.Builder{");
            buf.append("strike").append('=').append(JodaBeanUtils.toString((Object)this.strike)).append(',').append(' ');
            buf.append("timeToExpiry").append('=').append(JodaBeanUtils.toString((Object)this.timeToExpiry)).append(',').append(' ');
            buf.append("sign").append('=').append(JodaBeanUtils.toString((Object)this.sign)).append(',').append(' ');
            buf.append("numberOfSteps").append('=').append(JodaBeanUtils.toString((Object)this.numberOfSteps)).append(',').append(' ');
            buf.append("barrierType").append('=').append(JodaBeanUtils.toString((Object)this.barrierType)).append(',').append(' ');
            buf.append("barrierLevel").append('=').append(JodaBeanUtils.toString((Object)this.barrierLevel)).append(',').append(' ');
            buf.append("rebate").append('=').append(JodaBeanUtils.toString((Object)this.rebate));
            buf.append('}');
            return buf.toString();
        }
    }

    public static final class Meta
    extends DirectMetaBean {
        static final Meta INSTANCE = new Meta();
        private final MetaProperty<Double> strike = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"strike", ConstantContinuousSingleBarrierKnockoutFunction.class, Double.TYPE);
        private final MetaProperty<Double> timeToExpiry = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"timeToExpiry", ConstantContinuousSingleBarrierKnockoutFunction.class, Double.TYPE);
        private final MetaProperty<Double> sign = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"sign", ConstantContinuousSingleBarrierKnockoutFunction.class, Double.TYPE);
        private final MetaProperty<Integer> numberOfSteps = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"numberOfSteps", ConstantContinuousSingleBarrierKnockoutFunction.class, Integer.TYPE);
        private final MetaProperty<BarrierType> barrierType = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"barrierType", ConstantContinuousSingleBarrierKnockoutFunction.class, BarrierType.class);
        private final MetaProperty<Double> barrierLevel = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"barrierLevel", ConstantContinuousSingleBarrierKnockoutFunction.class, Double.TYPE);
        private final MetaProperty<DoubleArray> rebate = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"rebate", ConstantContinuousSingleBarrierKnockoutFunction.class, DoubleArray.class);
        private final Map<String, MetaProperty<?>> metaPropertyMap$ = new DirectMetaPropertyMap((DirectMetaBean)this, null, new String[]{"strike", "timeToExpiry", "sign", "numberOfSteps", "barrierType", "barrierLevel", "rebate"});

        private Meta() {
        }

        protected MetaProperty<?> metaPropertyGet(String propertyName) {
            switch (propertyName.hashCode()) {
                case -891985998: {
                    return this.strike;
                }
                case -1831499397: {
                    return this.timeToExpiry;
                }
                case 3530173: {
                    return this.sign;
                }
                case -1323103225: {
                    return this.numberOfSteps;
                }
                case 1029043089: {
                    return this.barrierType;
                }
                case 1827586573: {
                    return this.barrierLevel;
                }
                case -934952029: {
                    return this.rebate;
                }
            }
            return super.metaPropertyGet(propertyName);
        }

        public BeanBuilder<? extends ConstantContinuousSingleBarrierKnockoutFunction> builder() {
            return new Builder();
        }

        public Class<? extends ConstantContinuousSingleBarrierKnockoutFunction> beanType() {
            return ConstantContinuousSingleBarrierKnockoutFunction.class;
        }

        public Map<String, MetaProperty<?>> metaPropertyMap() {
            return this.metaPropertyMap$;
        }

        public MetaProperty<Double> strike() {
            return this.strike;
        }

        public MetaProperty<Double> timeToExpiry() {
            return this.timeToExpiry;
        }

        public MetaProperty<Double> sign() {
            return this.sign;
        }

        public MetaProperty<Integer> numberOfSteps() {
            return this.numberOfSteps;
        }

        public MetaProperty<BarrierType> barrierType() {
            return this.barrierType;
        }

        public MetaProperty<Double> barrierLevel() {
            return this.barrierLevel;
        }

        public MetaProperty<DoubleArray> rebate() {
            return this.rebate;
        }

        protected Object propertyGet(Bean bean, String propertyName, boolean quiet) {
            switch (propertyName.hashCode()) {
                case -891985998: {
                    return ((ConstantContinuousSingleBarrierKnockoutFunction)bean).getStrike();
                }
                case -1831499397: {
                    return ((ConstantContinuousSingleBarrierKnockoutFunction)bean).getTimeToExpiry();
                }
                case 3530173: {
                    return ((ConstantContinuousSingleBarrierKnockoutFunction)bean).getSign();
                }
                case -1323103225: {
                    return ((ConstantContinuousSingleBarrierKnockoutFunction)bean).getNumberOfSteps();
                }
                case 1029043089: {
                    return ((ConstantContinuousSingleBarrierKnockoutFunction)bean).getBarrierType();
                }
                case 1827586573: {
                    return ((ConstantContinuousSingleBarrierKnockoutFunction)bean).getBarrierLevel();
                }
                case -934952029: {
                    return ((ConstantContinuousSingleBarrierKnockoutFunction)bean).getRebate();
                }
            }
            return super.propertyGet(bean, propertyName, quiet);
        }

        protected void propertySet(Bean bean, String propertyName, Object newValue, boolean quiet) {
            this.metaProperty(propertyName);
            if (quiet) {
                return;
            }
            throw new UnsupportedOperationException("Property cannot be written: " + propertyName);
        }
    }
}

