/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.pricer.impl.tree;

import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.collect.array.DoubleArray;
import com.opengamma.strata.pricer.impl.tree.OptionFunction;
import com.opengamma.strata.product.common.PutCall;
import java.io.Serializable;
import java.util.Map;
import java.util.NoSuchElementException;
import org.joda.beans.Bean;
import org.joda.beans.BeanBuilder;
import org.joda.beans.ImmutableBean;
import org.joda.beans.JodaBeanUtils;
import org.joda.beans.MetaBean;
import org.joda.beans.MetaProperty;
import org.joda.beans.gen.BeanDefinition;
import org.joda.beans.gen.PropertyDefinition;
import org.joda.beans.impl.direct.DirectMetaBean;
import org.joda.beans.impl.direct.DirectMetaProperty;
import org.joda.beans.impl.direct.DirectMetaPropertyMap;
import org.joda.beans.impl.direct.DirectPrivateBeanBuilder;

@BeanDefinition(builderScope="private")
public final class EuropeanVanillaOptionFunction
implements OptionFunction,
ImmutableBean,
Serializable {
    @PropertyDefinition
    private final double strike;
    @PropertyDefinition(overrideGet=true)
    private final double timeToExpiry;
    @PropertyDefinition
    private final double sign;
    @PropertyDefinition(overrideGet=true)
    private final int numberOfSteps;
    private static final long serialVersionUID = 1L;

    public static EuropeanVanillaOptionFunction of(double strike, double timeToExpiry, PutCall putCall, int numberOfSteps) {
        double sign = putCall.isCall() ? 1.0 : -1.0;
        ArgChecker.isTrue((numberOfSteps > 0 ? 1 : 0) != 0, (String)"the number of steps should be positive");
        return new EuropeanVanillaOptionFunction(strike, timeToExpiry, sign, numberOfSteps);
    }

    @Override
    public DoubleArray getPayoffAtExpiryTrinomial(DoubleArray stateValue) {
        int nNodes = stateValue.size();
        double[] values = new double[nNodes];
        for (int i = 0; i < nNodes; ++i) {
            values[i] = Math.max(this.sign * (stateValue.get(i) - this.strike), 0.0);
        }
        return DoubleArray.ofUnsafe((double[])values);
    }

    public static Meta meta() {
        return Meta.INSTANCE;
    }

    private EuropeanVanillaOptionFunction(double strike, double timeToExpiry, double sign, int numberOfSteps) {
        this.strike = strike;
        this.timeToExpiry = timeToExpiry;
        this.sign = sign;
        this.numberOfSteps = numberOfSteps;
    }

    public Meta metaBean() {
        return Meta.INSTANCE;
    }

    public double getStrike() {
        return this.strike;
    }

    @Override
    public double getTimeToExpiry() {
        return this.timeToExpiry;
    }

    public double getSign() {
        return this.sign;
    }

    @Override
    public int getNumberOfSteps() {
        return this.numberOfSteps;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == this.getClass()) {
            EuropeanVanillaOptionFunction other = (EuropeanVanillaOptionFunction)obj;
            return JodaBeanUtils.equal((double)this.strike, (double)other.strike) && JodaBeanUtils.equal((double)this.timeToExpiry, (double)other.timeToExpiry) && JodaBeanUtils.equal((double)this.sign, (double)other.sign) && this.numberOfSteps == other.numberOfSteps;
        }
        return false;
    }

    public int hashCode() {
        int hash = this.getClass().hashCode();
        hash = hash * 31 + JodaBeanUtils.hashCode((double)this.strike);
        hash = hash * 31 + JodaBeanUtils.hashCode((double)this.timeToExpiry);
        hash = hash * 31 + JodaBeanUtils.hashCode((double)this.sign);
        hash = hash * 31 + JodaBeanUtils.hashCode((int)this.numberOfSteps);
        return hash;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(160);
        buf.append("EuropeanVanillaOptionFunction{");
        buf.append("strike").append('=').append(JodaBeanUtils.toString((Object)this.strike)).append(',').append(' ');
        buf.append("timeToExpiry").append('=').append(JodaBeanUtils.toString((Object)this.timeToExpiry)).append(',').append(' ');
        buf.append("sign").append('=').append(JodaBeanUtils.toString((Object)this.sign)).append(',').append(' ');
        buf.append("numberOfSteps").append('=').append(JodaBeanUtils.toString((Object)this.numberOfSteps));
        buf.append('}');
        return buf.toString();
    }

    static {
        MetaBean.register((MetaBean)Meta.INSTANCE);
    }

    private static final class Builder
    extends DirectPrivateBeanBuilder<EuropeanVanillaOptionFunction> {
        private double strike;
        private double timeToExpiry;
        private double sign;
        private int numberOfSteps;

        private Builder() {
        }

        public Object get(String propertyName) {
            switch (propertyName.hashCode()) {
                case -891985998: {
                    return this.strike;
                }
                case -1831499397: {
                    return this.timeToExpiry;
                }
                case 3530173: {
                    return this.sign;
                }
                case -1323103225: {
                    return this.numberOfSteps;
                }
            }
            throw new NoSuchElementException("Unknown property: " + propertyName);
        }

        public Builder set(String propertyName, Object newValue) {
            switch (propertyName.hashCode()) {
                case -891985998: {
                    this.strike = (Double)newValue;
                    break;
                }
                case -1831499397: {
                    this.timeToExpiry = (Double)newValue;
                    break;
                }
                case 3530173: {
                    this.sign = (Double)newValue;
                    break;
                }
                case -1323103225: {
                    this.numberOfSteps = (Integer)newValue;
                    break;
                }
                default: {
                    throw new NoSuchElementException("Unknown property: " + propertyName);
                }
            }
            return this;
        }

        public EuropeanVanillaOptionFunction build() {
            return new EuropeanVanillaOptionFunction(this.strike, this.timeToExpiry, this.sign, this.numberOfSteps);
        }

        public String toString() {
            StringBuilder buf = new StringBuilder(160);
            buf.append("EuropeanVanillaOptionFunction.Builder{");
            buf.append("strike").append('=').append(JodaBeanUtils.toString((Object)this.strike)).append(',').append(' ');
            buf.append("timeToExpiry").append('=').append(JodaBeanUtils.toString((Object)this.timeToExpiry)).append(',').append(' ');
            buf.append("sign").append('=').append(JodaBeanUtils.toString((Object)this.sign)).append(',').append(' ');
            buf.append("numberOfSteps").append('=').append(JodaBeanUtils.toString((Object)this.numberOfSteps));
            buf.append('}');
            return buf.toString();
        }
    }

    public static final class Meta
    extends DirectMetaBean {
        static final Meta INSTANCE = new Meta();
        private final MetaProperty<Double> strike = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"strike", EuropeanVanillaOptionFunction.class, Double.TYPE);
        private final MetaProperty<Double> timeToExpiry = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"timeToExpiry", EuropeanVanillaOptionFunction.class, Double.TYPE);
        private final MetaProperty<Double> sign = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"sign", EuropeanVanillaOptionFunction.class, Double.TYPE);
        private final MetaProperty<Integer> numberOfSteps = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"numberOfSteps", EuropeanVanillaOptionFunction.class, Integer.TYPE);
        private final Map<String, MetaProperty<?>> metaPropertyMap$ = new DirectMetaPropertyMap((DirectMetaBean)this, null, new String[]{"strike", "timeToExpiry", "sign", "numberOfSteps"});

        private Meta() {
        }

        protected MetaProperty<?> metaPropertyGet(String propertyName) {
            switch (propertyName.hashCode()) {
                case -891985998: {
                    return this.strike;
                }
                case -1831499397: {
                    return this.timeToExpiry;
                }
                case 3530173: {
                    return this.sign;
                }
                case -1323103225: {
                    return this.numberOfSteps;
                }
            }
            return super.metaPropertyGet(propertyName);
        }

        public BeanBuilder<? extends EuropeanVanillaOptionFunction> builder() {
            return new Builder();
        }

        public Class<? extends EuropeanVanillaOptionFunction> beanType() {
            return EuropeanVanillaOptionFunction.class;
        }

        public Map<String, MetaProperty<?>> metaPropertyMap() {
            return this.metaPropertyMap$;
        }

        public MetaProperty<Double> strike() {
            return this.strike;
        }

        public MetaProperty<Double> timeToExpiry() {
            return this.timeToExpiry;
        }

        public MetaProperty<Double> sign() {
            return this.sign;
        }

        public MetaProperty<Integer> numberOfSteps() {
            return this.numberOfSteps;
        }

        protected Object propertyGet(Bean bean, String propertyName, boolean quiet) {
            switch (propertyName.hashCode()) {
                case -891985998: {
                    return ((EuropeanVanillaOptionFunction)bean).getStrike();
                }
                case -1831499397: {
                    return ((EuropeanVanillaOptionFunction)bean).getTimeToExpiry();
                }
                case 3530173: {
                    return ((EuropeanVanillaOptionFunction)bean).getSign();
                }
                case -1323103225: {
                    return ((EuropeanVanillaOptionFunction)bean).getNumberOfSteps();
                }
            }
            return super.propertyGet(bean, propertyName, quiet);
        }

        protected void propertySet(Bean bean, String propertyName, Object newValue, boolean quiet) {
            this.metaProperty(propertyName);
            if (quiet) {
                return;
            }
            throw new UnsupportedOperationException("Property cannot be written: " + propertyName);
        }
    }
}

