/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.pricer.impl.tree;

import com.opengamma.strata.collect.array.DoubleArray;
import com.opengamma.strata.collect.array.DoubleMatrix;
import java.util.Arrays;

public interface OptionFunction {
    public double getTimeToExpiry();

    public int getNumberOfSteps();

    default public DoubleArray getPayoffAtExpiryTrinomial(double spot, double downFactor, double middleFactor) {
        int nNodes = 2 * this.getNumberOfSteps() + 1;
        double[] values = new double[nNodes];
        for (int i = 0; i < nNodes; ++i) {
            values[i] = spot * Math.pow(downFactor, this.getNumberOfSteps() - i) * Math.pow(middleFactor, i);
        }
        return this.getPayoffAtExpiryTrinomial(DoubleArray.ofUnsafe((double[])values));
    }

    public DoubleArray getPayoffAtExpiryTrinomial(DoubleArray var1);

    default public DoubleArray getNextOptionValues(double discountFactor, double upProbability, double middleProbability, double downProbability, DoubleArray value, double spot, double downFactor, double middleFactor, int i) {
        int nNodes = 2 * i + 1;
        double[] probsAtNode = new double[]{downProbability, middleProbability, upProbability};
        double[][] probs = new double[nNodes][];
        Arrays.fill((Object[])probs, probsAtNode);
        DoubleArray stateValue = DoubleArray.of((int)nNodes, k -> spot * Math.pow(downFactor, i - k) * Math.pow(middleFactor, k));
        return this.getNextOptionValues(discountFactor, DoubleMatrix.ofUnsafe((double[][])probs), stateValue, value, i);
    }

    default public DoubleArray getNextOptionValues(double discountFactor, DoubleMatrix transitionProbability, DoubleArray stateValue, DoubleArray value, int i) {
        int nNodes = 2 * i + 1;
        return DoubleArray.of((int)nNodes, j -> discountFactor * (transitionProbability.get(j, 2) * value.get(j + 2) + transitionProbability.get(j, 1) * value.get(j + 1) + transitionProbability.get(j, 0) * value.get(j)));
    }
}

