/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.pricer.impl.tree;

import com.opengamma.strata.collect.array.DoubleArray;
import com.opengamma.strata.pricer.impl.tree.LatticeSpecification;

public final class TrigeorgisLatticeSpecification
implements LatticeSpecification {
    @Override
    public DoubleArray getParametersTrinomial(double volatility, double interestRate, double dt) {
        double volSq = volatility * volatility;
        double mu = interestRate - 0.5 * volSq;
        double mudt = mu * dt;
        double mudtSq = mudt * mudt;
        double dx = volatility * Math.sqrt(3.0 * dt);
        double upFactor = Math.exp(dx);
        double downFactor = Math.exp(-dx);
        double part = (volSq * dt + mudtSq) / dx / dx;
        double upProbability = 0.5 * (part + mudt / dx);
        double middleProbability = 1.0 - part;
        double downProbability = 0.5 * (part - mudt / dx);
        return DoubleArray.of((double)upFactor, (double)1.0, (double)downFactor, (double)upProbability, (double)middleProbability, (double)downProbability);
    }
}

