/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.pricer.impl.volatility.smile;

import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.collect.array.DoubleArray;
import com.opengamma.strata.collect.array.DoubleMatrix;
import com.opengamma.strata.math.impl.linearalgebra.DecompositionFactory;
import com.opengamma.strata.math.impl.matrix.MatrixAlgebra;
import com.opengamma.strata.math.impl.matrix.OGMatrixAlgebra;
import com.opengamma.strata.math.impl.minimization.NonLinearParameterTransforms;
import com.opengamma.strata.math.impl.minimization.NonLinearTransformFunction;
import com.opengamma.strata.math.impl.statistics.leastsquare.LeastSquareResults;
import com.opengamma.strata.math.impl.statistics.leastsquare.LeastSquareResultsWithTransform;
import com.opengamma.strata.math.impl.statistics.leastsquare.NonLinearLeastSquare;
import com.opengamma.strata.pricer.impl.volatility.smile.SmileModelData;
import com.opengamma.strata.pricer.impl.volatility.smile.VolatilityFunctionProvider;
import java.util.BitSet;
import java.util.function.Function;

public abstract class SmileModelFitter<T extends SmileModelData> {
    private static final MatrixAlgebra MA = new OGMatrixAlgebra();
    private static final NonLinearLeastSquare SOLVER = new NonLinearLeastSquare(DecompositionFactory.SV_COMMONS, MA, 1.0E-12);
    private static final Function<DoubleArray, Boolean> UNCONSTRAINED = new Function<DoubleArray, Boolean>(){

        @Override
        public Boolean apply(DoubleArray x) {
            return true;
        }
    };
    private final VolatilityFunctionProvider<T> model;
    private final Function<DoubleArray, DoubleArray> volFunc;
    private final Function<DoubleArray, DoubleMatrix> volAdjointFunc;
    private final DoubleArray marketValues;
    private final DoubleArray errors;

    public SmileModelFitter(final double forward, final DoubleArray strikes, final double timeToExpiry, DoubleArray impliedVols, DoubleArray error, final VolatilityFunctionProvider<T> model) {
        ArgChecker.notNull((Object)strikes, (String)"strikes");
        ArgChecker.notNull((Object)impliedVols, (String)"implied vols");
        ArgChecker.notNull((Object)error, (String)"errors");
        ArgChecker.notNull(model, (String)"model");
        final int n = strikes.size();
        ArgChecker.isTrue((n == impliedVols.size() ? 1 : 0) != 0, (String)"vols not the same length as strikes");
        ArgChecker.isTrue((n == error.size() ? 1 : 0) != 0, (String)"errors not the same length as strikes");
        this.marketValues = impliedVols;
        this.errors = error;
        this.model = model;
        this.volFunc = new Function<DoubleArray, DoubleArray>(){

            @Override
            public DoubleArray apply(DoubleArray x) {
                Object data = SmileModelFitter.this.toSmileModelData(x);
                double[] res = new double[n];
                for (int i = 0; i < n; ++i) {
                    res[i] = model.volatility(forward, strikes.get(i), timeToExpiry, data);
                }
                return DoubleArray.copyOf((double[])res);
            }
        };
        this.volAdjointFunc = new Function<DoubleArray, DoubleMatrix>(){

            @Override
            public DoubleMatrix apply(DoubleArray x) {
                Object data = SmileModelFitter.this.toSmileModelData(x);
                double[][] resAdj = new double[n][];
                for (int i = 0; i < n; ++i) {
                    DoubleArray deriv = model.volatilityAdjoint(forward, strikes.get(i), timeToExpiry, data).getDerivatives();
                    resAdj[i] = deriv.subArray(2).toArrayUnsafe();
                }
                return DoubleMatrix.copyOf((double[][])resAdj);
            }
        };
    }

    public LeastSquareResultsWithTransform solve(DoubleArray start) {
        return this.solve(start, new BitSet());
    }

    public LeastSquareResultsWithTransform solve(DoubleArray start, BitSet fixed) {
        NonLinearParameterTransforms transform = this.getTransform(start, fixed);
        return this.solve(start, transform);
    }

    public LeastSquareResultsWithTransform solve(DoubleArray start, NonLinearParameterTransforms transform) {
        NonLinearTransformFunction transFunc = new NonLinearTransformFunction(this.volFunc, this.volAdjointFunc, transform);
        LeastSquareResults solRes = SOLVER.solve(this.marketValues, this.errors, transFunc.getFittingFunction(), transFunc.getFittingJacobian(), transform.transform(start), this.getConstraintFunction(transform), this.getMaximumStep());
        return new LeastSquareResultsWithTransform(solRes, transform);
    }

    protected Function<DoubleArray, DoubleArray> getModelValueFunction() {
        return this.volFunc;
    }

    protected Function<DoubleArray, DoubleMatrix> getModelJacobianFunction() {
        return this.volAdjointFunc;
    }

    protected abstract DoubleArray getMaximumStep();

    protected abstract NonLinearParameterTransforms getTransform(DoubleArray var1);

    protected abstract NonLinearParameterTransforms getTransform(DoubleArray var1, BitSet var2);

    public abstract T toSmileModelData(DoubleArray var1);

    protected Function<DoubleArray, Boolean> getConstraintFunction(NonLinearParameterTransforms t) {
        return UNCONSTRAINED;
    }

    public VolatilityFunctionProvider<T> getModel() {
        return this.model;
    }
}

