/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.pricer.index;

import com.opengamma.strata.basics.date.DayCount;
import com.opengamma.strata.basics.index.OvernightIndex;
import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.data.MarketDataName;
import com.opengamma.strata.market.ValueType;
import com.opengamma.strata.market.model.MoneynessType;
import com.opengamma.strata.market.param.CurrencyParameterSensitivities;
import com.opengamma.strata.market.param.CurrencyParameterSensitivity;
import com.opengamma.strata.market.param.ParameterMetadata;
import com.opengamma.strata.market.param.ParameterPerturbation;
import com.opengamma.strata.market.param.UnitParameterSensitivity;
import com.opengamma.strata.market.sensitivity.PointSensitivities;
import com.opengamma.strata.market.sensitivity.PointSensitivity;
import com.opengamma.strata.market.surface.Surface;
import com.opengamma.strata.market.surface.SurfaceInfoType;
import com.opengamma.strata.pricer.index.NormalOvernightFutureOptionVolatilities;
import com.opengamma.strata.pricer.index.OvernightFutureOptionSensitivity;
import com.opengamma.strata.pricer.index.OvernightFutureOptionVolatilitiesName;
import java.io.Serializable;
import java.time.LocalDate;
import java.time.ZonedDateTime;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.OptionalInt;
import org.joda.beans.Bean;
import org.joda.beans.ImmutableBean;
import org.joda.beans.JodaBeanUtils;
import org.joda.beans.MetaBean;
import org.joda.beans.MetaProperty;
import org.joda.beans.gen.BeanDefinition;
import org.joda.beans.gen.ImmutableConstructor;
import org.joda.beans.gen.PropertyDefinition;
import org.joda.beans.impl.direct.DirectFieldsBeanBuilder;
import org.joda.beans.impl.direct.DirectMetaBean;
import org.joda.beans.impl.direct.DirectMetaProperty;
import org.joda.beans.impl.direct.DirectMetaPropertyMap;

@BeanDefinition
public final class NormalOvernightFutureOptionExpirySimpleMoneynessVolatilities
implements NormalOvernightFutureOptionVolatilities,
ImmutableBean,
Serializable {
    @PropertyDefinition(validate="notNull", overrideGet=true)
    private final OvernightIndex index;
    @PropertyDefinition(validate="notNull", overrideGet=true)
    private final ZonedDateTime valuationDateTime;
    @PropertyDefinition(validate="notNull")
    private final Surface surface;
    private final transient boolean moneynessOnPrice;
    private final transient DayCount dayCount;
    private static final long serialVersionUID = 1L;

    public static NormalOvernightFutureOptionExpirySimpleMoneynessVolatilities of(OvernightIndex index, ZonedDateTime valuationDateTime, Surface surface) {
        return new NormalOvernightFutureOptionExpirySimpleMoneynessVolatilities(index, valuationDateTime, surface);
    }

    @ImmutableConstructor
    private NormalOvernightFutureOptionExpirySimpleMoneynessVolatilities(OvernightIndex index, ZonedDateTime valuationDateTime, Surface surface) {
        ArgChecker.notNull((Object)index, (String)"index");
        ArgChecker.notNull((Object)valuationDateTime, (String)"valuationDateTime");
        ArgChecker.notNull((Object)surface, (String)"surface");
        surface.getMetadata().getXValueType().checkEquals(ValueType.YEAR_FRACTION, "Incorrect x-value type for Normal volatilities");
        surface.getMetadata().getYValueType().checkEquals(ValueType.SIMPLE_MONEYNESS, "Incorrect y-value type for Normal volatilities");
        surface.getMetadata().getZValueType().checkEquals(ValueType.NORMAL_VOLATILITY, "Incorrect z-value type for Normal volatilities");
        DayCount dayCount = (DayCount)surface.getMetadata().findInfo(SurfaceInfoType.DAY_COUNT).orElseThrow(() -> new IllegalArgumentException("Incorrect surface metadata, missing DayCount"));
        MoneynessType moneynessType = (MoneynessType)surface.getMetadata().findInfo(SurfaceInfoType.MONEYNESS_TYPE).orElseThrow(() -> new IllegalArgumentException("Incorrect surface metadata, missing MoneynessType"));
        this.index = index;
        this.valuationDateTime = valuationDateTime;
        this.surface = surface;
        this.moneynessOnPrice = moneynessType == MoneynessType.PRICE;
        this.dayCount = dayCount;
    }

    private Object readResolve() {
        return new NormalOvernightFutureOptionExpirySimpleMoneynessVolatilities(this.index, this.valuationDateTime, this.surface);
    }

    @Override
    public OvernightFutureOptionVolatilitiesName getName() {
        return OvernightFutureOptionVolatilitiesName.of(this.surface.getName().getName());
    }

    public <T> Optional<T> findData(MarketDataName<T> name) {
        if (this.surface.getName().equals(name)) {
            return Optional.of(name.getMarketDataType().cast(this.surface));
        }
        return Optional.empty();
    }

    public int getParameterCount() {
        return this.surface.getParameterCount();
    }

    public double getParameter(int parameterIndex) {
        return this.surface.getParameter(parameterIndex);
    }

    public ParameterMetadata getParameterMetadata(int parameterIndex) {
        return this.surface.getParameterMetadata(parameterIndex);
    }

    public OptionalInt findParameterIndex(ParameterMetadata metadata) {
        return this.surface.findParameterIndex(metadata);
    }

    @Override
    public NormalOvernightFutureOptionExpirySimpleMoneynessVolatilities withParameter(int parameterIndex, double newValue) {
        return new NormalOvernightFutureOptionExpirySimpleMoneynessVolatilities(this.index, this.valuationDateTime, this.surface.withParameter(parameterIndex, newValue));
    }

    @Override
    public NormalOvernightFutureOptionExpirySimpleMoneynessVolatilities withPerturbation(ParameterPerturbation perturbation) {
        return new NormalOvernightFutureOptionExpirySimpleMoneynessVolatilities(this.index, this.valuationDateTime, this.surface.withPerturbation(perturbation));
    }

    @Override
    public double volatility(double expiry, LocalDate fixingDate, double strikePrice, double futurePrice) {
        double simpleMoneyness = this.moneynessOnPrice ? strikePrice - futurePrice : futurePrice - strikePrice;
        return this.surface.zValue(expiry, simpleMoneyness);
    }

    @Override
    public CurrencyParameterSensitivities parameterSensitivity(PointSensitivities pointSensitivities) {
        CurrencyParameterSensitivities sens = CurrencyParameterSensitivities.empty();
        for (PointSensitivity point : pointSensitivities.getSensitivities()) {
            OvernightFutureOptionSensitivity pt;
            if (!(point instanceof OvernightFutureOptionSensitivity) || !(pt = (OvernightFutureOptionSensitivity)point).getVolatilitiesName().equals(this.getName())) continue;
            sens = sens.combinedWith(this.parameterSensitivity(pt));
        }
        return sens;
    }

    private CurrencyParameterSensitivity parameterSensitivity(OvernightFutureOptionSensitivity point) {
        double simpleMoneyness = this.moneynessOnPrice ? point.getStrikePrice() - point.getFuturePrice() : point.getFuturePrice() - point.getStrikePrice();
        UnitParameterSensitivity unitSens = this.surface.zValueParameterSensitivity(point.getExpiry(), simpleMoneyness);
        return unitSens.multipliedBy(point.getCurrency(), point.getSensitivity());
    }

    @Override
    public double relativeTime(ZonedDateTime zonedDateTime) {
        ArgChecker.notNull((Object)zonedDateTime, (String)"date");
        return this.dayCount.relativeYearFraction(this.valuationDateTime.toLocalDate(), zonedDateTime.toLocalDate());
    }

    public static Meta meta() {
        return Meta.INSTANCE;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Meta metaBean() {
        return Meta.INSTANCE;
    }

    @Override
    public OvernightIndex getIndex() {
        return this.index;
    }

    @Override
    public ZonedDateTime getValuationDateTime() {
        return this.valuationDateTime;
    }

    public Surface getSurface() {
        return this.surface;
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == this.getClass()) {
            NormalOvernightFutureOptionExpirySimpleMoneynessVolatilities other = (NormalOvernightFutureOptionExpirySimpleMoneynessVolatilities)obj;
            return JodaBeanUtils.equal((Object)this.index, (Object)other.index) && JodaBeanUtils.equal((Object)this.valuationDateTime, (Object)other.valuationDateTime) && JodaBeanUtils.equal((Object)this.surface, (Object)other.surface);
        }
        return false;
    }

    public int hashCode() {
        int hash = this.getClass().hashCode();
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.index);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.valuationDateTime);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.surface);
        return hash;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(128);
        buf.append("NormalOvernightFutureOptionExpirySimpleMoneynessVolatilities{");
        buf.append("index").append('=').append(JodaBeanUtils.toString((Object)this.index)).append(',').append(' ');
        buf.append("valuationDateTime").append('=').append(JodaBeanUtils.toString((Object)this.valuationDateTime)).append(',').append(' ');
        buf.append("surface").append('=').append(JodaBeanUtils.toString((Object)this.surface));
        buf.append('}');
        return buf.toString();
    }

    static {
        MetaBean.register((MetaBean)Meta.INSTANCE);
    }

    public static final class Builder
    extends DirectFieldsBeanBuilder<NormalOvernightFutureOptionExpirySimpleMoneynessVolatilities> {
        private OvernightIndex index;
        private ZonedDateTime valuationDateTime;
        private Surface surface;

        private Builder() {
        }

        private Builder(NormalOvernightFutureOptionExpirySimpleMoneynessVolatilities beanToCopy) {
            this.index = beanToCopy.getIndex();
            this.valuationDateTime = beanToCopy.getValuationDateTime();
            this.surface = beanToCopy.getSurface();
        }

        public Object get(String propertyName) {
            switch (propertyName.hashCode()) {
                case 100346066: {
                    return this.index;
                }
                case -949589828: {
                    return this.valuationDateTime;
                }
                case -1853231955: {
                    return this.surface;
                }
            }
            throw new NoSuchElementException("Unknown property: " + propertyName);
        }

        public Builder set(String propertyName, Object newValue) {
            switch (propertyName.hashCode()) {
                case 100346066: {
                    this.index = (OvernightIndex)newValue;
                    break;
                }
                case -949589828: {
                    this.valuationDateTime = (ZonedDateTime)newValue;
                    break;
                }
                case -1853231955: {
                    this.surface = (Surface)newValue;
                    break;
                }
                default: {
                    throw new NoSuchElementException("Unknown property: " + propertyName);
                }
            }
            return this;
        }

        public Builder set(MetaProperty<?> property, Object value) {
            super.set(property, value);
            return this;
        }

        public NormalOvernightFutureOptionExpirySimpleMoneynessVolatilities build() {
            return new NormalOvernightFutureOptionExpirySimpleMoneynessVolatilities(this.index, this.valuationDateTime, this.surface);
        }

        public Builder index(OvernightIndex index) {
            JodaBeanUtils.notNull((Object)index, (String)"index");
            this.index = index;
            return this;
        }

        public Builder valuationDateTime(ZonedDateTime valuationDateTime) {
            JodaBeanUtils.notNull((Object)valuationDateTime, (String)"valuationDateTime");
            this.valuationDateTime = valuationDateTime;
            return this;
        }

        public Builder surface(Surface surface) {
            JodaBeanUtils.notNull((Object)surface, (String)"surface");
            this.surface = surface;
            return this;
        }

        public String toString() {
            StringBuilder buf = new StringBuilder(128);
            buf.append("NormalOvernightFutureOptionExpirySimpleMoneynessVolatilities.Builder{");
            buf.append("index").append('=').append(JodaBeanUtils.toString((Object)this.index)).append(',').append(' ');
            buf.append("valuationDateTime").append('=').append(JodaBeanUtils.toString((Object)this.valuationDateTime)).append(',').append(' ');
            buf.append("surface").append('=').append(JodaBeanUtils.toString((Object)this.surface));
            buf.append('}');
            return buf.toString();
        }
    }

    public static final class Meta
    extends DirectMetaBean {
        static final Meta INSTANCE = new Meta();
        private final MetaProperty<OvernightIndex> index = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"index", NormalOvernightFutureOptionExpirySimpleMoneynessVolatilities.class, OvernightIndex.class);
        private final MetaProperty<ZonedDateTime> valuationDateTime = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"valuationDateTime", NormalOvernightFutureOptionExpirySimpleMoneynessVolatilities.class, ZonedDateTime.class);
        private final MetaProperty<Surface> surface = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"surface", NormalOvernightFutureOptionExpirySimpleMoneynessVolatilities.class, Surface.class);
        private final Map<String, MetaProperty<?>> metaPropertyMap$ = new DirectMetaPropertyMap((DirectMetaBean)this, null, new String[]{"index", "valuationDateTime", "surface"});

        private Meta() {
        }

        protected MetaProperty<?> metaPropertyGet(String propertyName) {
            switch (propertyName.hashCode()) {
                case 100346066: {
                    return this.index;
                }
                case -949589828: {
                    return this.valuationDateTime;
                }
                case -1853231955: {
                    return this.surface;
                }
            }
            return super.metaPropertyGet(propertyName);
        }

        public Builder builder() {
            return new Builder();
        }

        public Class<? extends NormalOvernightFutureOptionExpirySimpleMoneynessVolatilities> beanType() {
            return NormalOvernightFutureOptionExpirySimpleMoneynessVolatilities.class;
        }

        public Map<String, MetaProperty<?>> metaPropertyMap() {
            return this.metaPropertyMap$;
        }

        public MetaProperty<OvernightIndex> index() {
            return this.index;
        }

        public MetaProperty<ZonedDateTime> valuationDateTime() {
            return this.valuationDateTime;
        }

        public MetaProperty<Surface> surface() {
            return this.surface;
        }

        protected Object propertyGet(Bean bean, String propertyName, boolean quiet) {
            switch (propertyName.hashCode()) {
                case 100346066: {
                    return ((NormalOvernightFutureOptionExpirySimpleMoneynessVolatilities)bean).getIndex();
                }
                case -949589828: {
                    return ((NormalOvernightFutureOptionExpirySimpleMoneynessVolatilities)bean).getValuationDateTime();
                }
                case -1853231955: {
                    return ((NormalOvernightFutureOptionExpirySimpleMoneynessVolatilities)bean).getSurface();
                }
            }
            return super.propertyGet(bean, propertyName, quiet);
        }

        protected void propertySet(Bean bean, String propertyName, Object newValue, boolean quiet) {
            this.metaProperty(propertyName);
            if (quiet) {
                return;
            }
            throw new UnsupportedOperationException("Property cannot be written: " + propertyName);
        }
    }
}

