/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.pricer.index;

import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.market.sensitivity.PointSensitivities;
import com.opengamma.strata.pricer.impl.option.NormalFormulaRepository;
import com.opengamma.strata.pricer.index.DiscountingOvernightFutureProductPricer;
import com.opengamma.strata.pricer.index.NormalOvernightFutureOptionVolatilities;
import com.opengamma.strata.pricer.index.OvernightFutureOptionSensitivity;
import com.opengamma.strata.pricer.rate.RatesProvider;
import com.opengamma.strata.product.index.ResolvedOvernightFuture;
import com.opengamma.strata.product.index.ResolvedOvernightFutureOption;
import com.opengamma.strata.product.option.FutureOptionPremiumStyle;

public class NormalOvernightFutureOptionMarginedProductPricer {
    public static final NormalOvernightFutureOptionMarginedProductPricer DEFAULT = new NormalOvernightFutureOptionMarginedProductPricer(DiscountingOvernightFutureProductPricer.DEFAULT);
    private final DiscountingOvernightFutureProductPricer futurePricer;

    public NormalOvernightFutureOptionMarginedProductPricer(DiscountingOvernightFutureProductPricer futurePricer) {
        this.futurePricer = (DiscountingOvernightFutureProductPricer)ArgChecker.notNull((Object)futurePricer, (String)"futurePricer");
    }

    DiscountingOvernightFutureProductPricer getFuturePricer() {
        return this.futurePricer;
    }

    double marginIndex(ResolvedOvernightFutureOption option, double price) {
        double notional = option.getUnderlyingFuture().getNotional();
        double accrualFactor = option.getUnderlyingFuture().getAccrualFactor();
        return price * notional * accrualFactor;
    }

    PointSensitivities marginIndexSensitivity(ResolvedOvernightFutureOption option, PointSensitivities priceSensitivity) {
        double notional = option.getUnderlyingFuture().getNotional();
        double accrualFactor = option.getUnderlyingFuture().getAccrualFactor();
        return priceSensitivity.multipliedBy(notional * accrualFactor);
    }

    public double price(ResolvedOvernightFutureOption futureOption, RatesProvider ratesProvider, NormalOvernightFutureOptionVolatilities volatilities) {
        double futurePrice = this.futurePrice(futureOption, ratesProvider);
        return this.price(futureOption, volatilities, futurePrice);
    }

    public double price(ResolvedOvernightFutureOption futureOption, NormalOvernightFutureOptionVolatilities volatilities, double futurePrice) {
        ArgChecker.isTrue((boolean)futureOption.getPremiumStyle().equals((Object)FutureOptionPremiumStyle.DAILY_MARGIN), (String)"Premium style should be DAILY_MARGIN");
        ArgChecker.isTrue((boolean)futureOption.getUnderlyingFuture().getIndex().equals(volatilities.getIndex()), (String)"Future index should be the same as data index");
        double timeToExpiry = volatilities.relativeTime(futureOption.getExpiry());
        double strike = futureOption.getStrikePrice();
        ResolvedOvernightFuture future = futureOption.getUnderlyingFuture();
        double volatility = volatilities.volatility(timeToExpiry, future.getLastTradeDate(), strike, futurePrice);
        return NormalFormulaRepository.price(futurePrice, strike, timeToExpiry, volatility, futureOption.getPutCall());
    }

    public double deltaStickyStrike(ResolvedOvernightFutureOption futureOption, RatesProvider ratesProvider, NormalOvernightFutureOptionVolatilities volatilities) {
        double futurePrice = this.futurePrice(futureOption, ratesProvider);
        return this.deltaStickyStrike(futureOption, volatilities, futurePrice);
    }

    public double deltaStickyStrike(ResolvedOvernightFutureOption futureOption, NormalOvernightFutureOptionVolatilities volatilities, double futurePrice) {
        ArgChecker.isTrue((boolean)futureOption.getPremiumStyle().equals((Object)FutureOptionPremiumStyle.DAILY_MARGIN), (String)"Premium style should be DAILY_MARGIN");
        double timeToExpiry = volatilities.relativeTime(futureOption.getExpiry());
        double strike = futureOption.getStrikePrice();
        ResolvedOvernightFuture future = futureOption.getUnderlyingFuture();
        double volatility = volatilities.volatility(timeToExpiry, future.getLastTradeDate(), strike, futurePrice);
        return NormalFormulaRepository.delta(futurePrice, strike, timeToExpiry, volatility, futureOption.getPutCall());
    }

    public PointSensitivities priceSensitivityRatesStickyStrike(ResolvedOvernightFutureOption futureOption, RatesProvider ratesProvider, NormalOvernightFutureOptionVolatilities volatilities) {
        ArgChecker.isTrue((boolean)futureOption.getPremiumStyle().equals((Object)FutureOptionPremiumStyle.DAILY_MARGIN), (String)"Premium style should be DAILY_MARGIN");
        double futurePrice = this.futurePrice(futureOption, ratesProvider);
        return this.priceSensitivityRatesStickyStrike(futureOption, ratesProvider, volatilities, futurePrice);
    }

    public PointSensitivities priceSensitivityRatesStickyStrike(ResolvedOvernightFutureOption futureOption, RatesProvider ratesProvider, NormalOvernightFutureOptionVolatilities volatilities, double futurePrice) {
        double delta = this.deltaStickyStrike(futureOption, volatilities, futurePrice);
        PointSensitivities futurePriceSensitivity = this.futurePricer.priceSensitivity(futureOption.getUnderlyingFuture(), ratesProvider);
        return futurePriceSensitivity.multipliedBy(delta);
    }

    public OvernightFutureOptionSensitivity priceSensitivityModelParamsVolatility(ResolvedOvernightFutureOption futureOption, RatesProvider ratesProvider, NormalOvernightFutureOptionVolatilities volatilities) {
        double futurePrice = this.futurePrice(futureOption, ratesProvider);
        return this.priceSensitivityModelParamsVolatility(futureOption, volatilities, futurePrice);
    }

    public OvernightFutureOptionSensitivity priceSensitivityModelParamsVolatility(ResolvedOvernightFutureOption futureOption, NormalOvernightFutureOptionVolatilities volatilities, double futurePrice) {
        ArgChecker.isTrue((boolean)futureOption.getPremiumStyle().equals((Object)FutureOptionPremiumStyle.DAILY_MARGIN), (String)"Premium style should be DAILY_MARGIN");
        double timeToExpiry = volatilities.relativeTime(futureOption.getExpiry());
        double strike = futureOption.getStrikePrice();
        ResolvedOvernightFuture future = futureOption.getUnderlyingFuture();
        double volatility = volatilities.volatility(timeToExpiry, future.getLastTradeDate(), strike, futurePrice);
        double vega = NormalFormulaRepository.vega(futurePrice, strike, timeToExpiry, volatility, futureOption.getPutCall());
        return OvernightFutureOptionSensitivity.of(volatilities.getName(), timeToExpiry, future.getLastTradeDate(), strike, futurePrice, future.getCurrency(), vega);
    }

    private double futurePrice(ResolvedOvernightFutureOption futureOption, RatesProvider ratesProvider) {
        ResolvedOvernightFuture future = futureOption.getUnderlyingFuture();
        return this.futurePricer.price(future, ratesProvider);
    }
}

