/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.pricer.index;

import com.opengamma.strata.basics.currency.Currency;
import com.opengamma.strata.basics.currency.CurrencyAmount;
import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.market.sensitivity.PointSensitivities;
import com.opengamma.strata.pricer.index.NormalOvernightFutureOptionMarginedProductPricer;
import com.opengamma.strata.pricer.index.NormalOvernightFutureOptionVolatilities;
import com.opengamma.strata.pricer.index.OvernightFutureOptionSensitivity;
import com.opengamma.strata.pricer.rate.RatesProvider;
import com.opengamma.strata.product.TradedPrice;
import com.opengamma.strata.product.index.ResolvedOvernightFuture;
import com.opengamma.strata.product.index.ResolvedOvernightFutureOption;
import com.opengamma.strata.product.index.ResolvedOvernightFutureOptionTrade;
import java.time.LocalDate;

public class NormalOvernightFutureOptionMarginedTradePricer {
    public static final NormalOvernightFutureOptionMarginedTradePricer DEFAULT = new NormalOvernightFutureOptionMarginedTradePricer(NormalOvernightFutureOptionMarginedProductPricer.DEFAULT);
    private final NormalOvernightFutureOptionMarginedProductPricer futureOptionPricer;

    public NormalOvernightFutureOptionMarginedTradePricer(NormalOvernightFutureOptionMarginedProductPricer futureOptionPricer) {
        this.futureOptionPricer = (NormalOvernightFutureOptionMarginedProductPricer)ArgChecker.notNull((Object)futureOptionPricer, (String)"futureOptionPricer");
    }

    public double price(ResolvedOvernightFutureOptionTrade trade, RatesProvider ratesProvider, NormalOvernightFutureOptionVolatilities volatilities) {
        return this.futureOptionPricer.price(trade.getProduct(), ratesProvider, volatilities);
    }

    public CurrencyAmount presentValue(ResolvedOvernightFutureOptionTrade trade, LocalDate valuationDate, double currentOptionPrice, double lastOptionSettlementPrice) {
        ResolvedOvernightFutureOption option = trade.getProduct();
        double referencePrice = this.referencePrice(trade, valuationDate, lastOptionSettlementPrice);
        double priceIndex = this.futureOptionPricer.marginIndex(option, currentOptionPrice);
        double referenceIndex = this.futureOptionPricer.marginIndex(option, referencePrice);
        double pv = (priceIndex - referenceIndex) * trade.getQuantity();
        return CurrencyAmount.of((Currency)option.getUnderlyingFuture().getCurrency(), (double)pv);
    }

    public CurrencyAmount presentValue(ResolvedOvernightFutureOptionTrade trade, RatesProvider ratesProvider, NormalOvernightFutureOptionVolatilities volatilities, double lastOptionSettlementPrice) {
        double price = this.price(trade, ratesProvider, volatilities);
        return this.presentValue(trade, ratesProvider.getValuationDate(), price, lastOptionSettlementPrice);
    }

    public CurrencyAmount presentValue(ResolvedOvernightFutureOptionTrade trade, RatesProvider ratesProvider, NormalOvernightFutureOptionVolatilities volatilities, double futurePrice, double lastOptionSettlementPrice) {
        double optionPrice = this.futureOptionPricer.price(trade.getProduct(), volatilities, futurePrice);
        return this.presentValue(trade, ratesProvider.getValuationDate(), optionPrice, lastOptionSettlementPrice);
    }

    public PointSensitivities presentValueSensitivityRates(ResolvedOvernightFutureOptionTrade trade, RatesProvider ratesProvider, NormalOvernightFutureOptionVolatilities volatilities) {
        ResolvedOvernightFutureOption product = trade.getProduct();
        PointSensitivities priceSensi = this.futureOptionPricer.priceSensitivityRatesStickyStrike(product, ratesProvider, volatilities);
        PointSensitivities marginIndexSensi = this.futureOptionPricer.marginIndexSensitivity(product, priceSensi);
        return marginIndexSensi.multipliedBy(trade.getQuantity());
    }

    public OvernightFutureOptionSensitivity presentValueSensitivityModelParamsVolatility(ResolvedOvernightFutureOptionTrade futureOptionTrade, RatesProvider ratesProvider, NormalOvernightFutureOptionVolatilities volatilities) {
        ResolvedOvernightFuture future = futureOptionTrade.getProduct().getUnderlyingFuture();
        double futurePrice = this.futureOptionPricer.getFuturePricer().price(future, ratesProvider);
        return this.presentValueSensitivityModelParamsVolatility(futureOptionTrade, volatilities, futurePrice);
    }

    public OvernightFutureOptionSensitivity presentValueSensitivityModelParamsVolatility(ResolvedOvernightFutureOptionTrade futureOptionTrade, NormalOvernightFutureOptionVolatilities volatilities, double futurePrice) {
        ResolvedOvernightFutureOption product = futureOptionTrade.getProduct();
        OvernightFutureOptionSensitivity priceSensitivity = this.futureOptionPricer.priceSensitivityModelParamsVolatility(product, volatilities, futurePrice);
        double factor = this.futureOptionPricer.marginIndex(product, 1.0) * futureOptionTrade.getQuantity();
        return priceSensitivity.multipliedBy(factor);
    }

    private double referencePrice(ResolvedOvernightFutureOptionTrade trade, LocalDate valuationDate, double lastSettlementPrice) {
        ArgChecker.notNull((Object)valuationDate, (String)"valuationDate");
        return trade.getTradedPrice().filter(tp -> tp.getTradeDate().equals(valuationDate)).map(TradedPrice::getPrice).orElse(lastSettlementPrice);
    }
}

