/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.pricer.model;

import com.opengamma.strata.basics.date.DayCount;
import com.opengamma.strata.basics.value.ValueDerivatives;
import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.market.ValueType;
import com.opengamma.strata.market.param.ParameterMetadata;
import com.opengamma.strata.market.param.ParameterPerturbation;
import com.opengamma.strata.market.param.ParameterizedData;
import com.opengamma.strata.market.param.ParameterizedDataCombiner;
import com.opengamma.strata.market.surface.ConstantSurface;
import com.opengamma.strata.market.surface.Surface;
import com.opengamma.strata.market.surface.SurfaceInfoType;
import com.opengamma.strata.pricer.model.SabrVolatilityFormula;
import java.io.Serializable;
import java.lang.invoke.MethodHandles;
import org.joda.beans.ImmutableBean;
import org.joda.beans.JodaBeanUtils;
import org.joda.beans.MetaBean;
import org.joda.beans.TypedMetaBean;
import org.joda.beans.gen.BeanDefinition;
import org.joda.beans.gen.ImmutableConstructor;
import org.joda.beans.gen.PropertyDefinition;
import org.joda.beans.impl.light.LightMetaBean;

@BeanDefinition(style="light")
public final class SabrInterestRateParameters
implements ParameterizedData,
ImmutableBean,
Serializable {
    private static final ConstantSurface ZERO_SHIFT = ConstantSurface.of((String)"Zero shift", (double)0.0);
    @PropertyDefinition(validate="notNull")
    private final Surface alphaSurface;
    @PropertyDefinition(validate="notNull")
    private final Surface betaSurface;
    @PropertyDefinition(validate="notNull")
    private final Surface rhoSurface;
    @PropertyDefinition(validate="notNull")
    private final Surface nuSurface;
    @PropertyDefinition(validate="notNull")
    private final Surface shiftSurface;
    @PropertyDefinition(validate="notNull")
    private final SabrVolatilityFormula sabrVolatilityFormula;
    private final transient DayCount dayCount;
    private final transient ParameterizedDataCombiner paramCombiner;
    private static final TypedMetaBean<SabrInterestRateParameters> META_BEAN = LightMetaBean.of(SabrInterestRateParameters.class, (MethodHandles.Lookup)MethodHandles.lookup(), (String[])new String[]{"alphaSurface", "betaSurface", "rhoSurface", "nuSurface", "shiftSurface", "sabrVolatilityFormula"}, (Object[])new Object[0]);
    private static final long serialVersionUID = 1L;

    public static SabrInterestRateParameters of(Surface alphaSurface, Surface betaSurface, Surface rhoSurface, Surface nuSurface, SabrVolatilityFormula sabrFormula) {
        return new SabrInterestRateParameters(alphaSurface, betaSurface, rhoSurface, nuSurface, (Surface)ZERO_SHIFT, sabrFormula);
    }

    public static SabrInterestRateParameters of(Surface alphaSurface, Surface betaSurface, Surface rhoSurface, Surface nuSurface, Surface shiftSurface, SabrVolatilityFormula sabrFormula) {
        return new SabrInterestRateParameters(alphaSurface, betaSurface, rhoSurface, nuSurface, shiftSurface, sabrFormula);
    }

    @ImmutableConstructor
    private SabrInterestRateParameters(Surface alphaSurface, Surface betaSurface, Surface rhoSurface, Surface nuSurface, Surface shiftSurface, SabrVolatilityFormula sabrFormula) {
        SabrInterestRateParameters.validate(alphaSurface, "alphaSurface", ValueType.SABR_ALPHA);
        SabrInterestRateParameters.validate(betaSurface, "betaSurface", ValueType.SABR_BETA);
        SabrInterestRateParameters.validate(rhoSurface, "rhoSurface", ValueType.SABR_RHO);
        SabrInterestRateParameters.validate(nuSurface, "nuSurface", ValueType.SABR_NU);
        ArgChecker.notNull((Object)shiftSurface, (String)"shiftSurface");
        ArgChecker.notNull((Object)sabrFormula, (String)"sabrFormula");
        DayCount dayCount = (DayCount)alphaSurface.getMetadata().findInfo(SurfaceInfoType.DAY_COUNT).orElseThrow(() -> new IllegalArgumentException("Incorrect surface metadata, missing DayCount"));
        SabrInterestRateParameters.validate(betaSurface, dayCount);
        SabrInterestRateParameters.validate(rhoSurface, dayCount);
        SabrInterestRateParameters.validate(nuSurface, dayCount);
        SabrInterestRateParameters.validate(shiftSurface, dayCount);
        this.alphaSurface = alphaSurface;
        this.betaSurface = betaSurface;
        this.rhoSurface = rhoSurface;
        this.nuSurface = nuSurface;
        this.shiftSurface = shiftSurface;
        this.sabrVolatilityFormula = sabrFormula;
        this.dayCount = dayCount;
        this.paramCombiner = ParameterizedDataCombiner.of((ParameterizedData[])new ParameterizedData[]{alphaSurface, betaSurface, rhoSurface, nuSurface, shiftSurface});
    }

    private static void validate(Surface surface, String name, ValueType zType) {
        ArgChecker.notNull((Object)surface, (String)name);
        surface.getMetadata().getXValueType().checkEquals(ValueType.YEAR_FRACTION, "Incorrect x-value type for SABR volatilities");
        surface.getMetadata().getYValueType().checkEquals(ValueType.YEAR_FRACTION, "Incorrect y-value type for SABR volatilities");
        ValueType zValueType = surface.getMetadata().getZValueType();
        zValueType.checkEquals(zType, "Incorrect z-value type for SABR volatilities");
    }

    private static void validate(Surface surface, DayCount dayCount) {
        if (!surface.getMetadata().findInfo(SurfaceInfoType.DAY_COUNT).orElse(dayCount).equals(dayCount)) {
            throw new IllegalArgumentException("SABR surfaces must have the same day count");
        }
    }

    private Object readResolve() {
        return new SabrInterestRateParameters(this.alphaSurface, this.betaSurface, this.rhoSurface, this.nuSurface, this.shiftSurface, this.sabrVolatilityFormula);
    }

    public DayCount getDayCount() {
        return this.dayCount;
    }

    public int getParameterCount() {
        return this.paramCombiner.getParameterCount();
    }

    public double getParameter(int parameterIndex) {
        return this.paramCombiner.getParameter(parameterIndex);
    }

    public ParameterMetadata getParameterMetadata(int parameterIndex) {
        return this.paramCombiner.getParameterMetadata(parameterIndex);
    }

    public SabrInterestRateParameters withParameter(int parameterIndex, double newValue) {
        return new SabrInterestRateParameters((Surface)this.paramCombiner.underlyingWithParameter(0, Surface.class, parameterIndex, newValue), (Surface)this.paramCombiner.underlyingWithParameter(1, Surface.class, parameterIndex, newValue), (Surface)this.paramCombiner.underlyingWithParameter(2, Surface.class, parameterIndex, newValue), (Surface)this.paramCombiner.underlyingWithParameter(3, Surface.class, parameterIndex, newValue), (Surface)this.paramCombiner.underlyingWithParameter(4, Surface.class, parameterIndex, newValue), this.sabrVolatilityFormula);
    }

    public SabrInterestRateParameters withPerturbation(ParameterPerturbation perturbation) {
        return new SabrInterestRateParameters((Surface)this.paramCombiner.underlyingWithPerturbation(0, Surface.class, perturbation), (Surface)this.paramCombiner.underlyingWithPerturbation(1, Surface.class, perturbation), (Surface)this.paramCombiner.underlyingWithPerturbation(2, Surface.class, perturbation), (Surface)this.paramCombiner.underlyingWithPerturbation(3, Surface.class, perturbation), (Surface)this.paramCombiner.underlyingWithPerturbation(4, Surface.class, perturbation), this.sabrVolatilityFormula);
    }

    public double alpha(double expiry, double tenor) {
        return this.alphaSurface.zValue(expiry, tenor);
    }

    public double beta(double expiry, double tenor) {
        return this.betaSurface.zValue(expiry, tenor);
    }

    public double rho(double expiry, double tenor) {
        return this.rhoSurface.zValue(expiry, tenor);
    }

    public double nu(double expiry, double tenor) {
        return this.nuSurface.zValue(expiry, tenor);
    }

    public double shift(double expiry, double tenor) {
        return this.shiftSurface.zValue(expiry, tenor);
    }

    public double volatility(double expiry, double tenor, double strike, double forward) {
        double alpha = this.alpha(expiry, tenor);
        double beta = this.beta(expiry, tenor);
        double rho = this.rho(expiry, tenor);
        double nu = this.nu(expiry, tenor);
        double shift = this.shift(expiry, tenor);
        return this.sabrVolatilityFormula.volatility(forward + shift, strike + shift, expiry, alpha, beta, rho, nu);
    }

    public ValueDerivatives volatilityAdjoint(double expiry, double tenor, double strike, double forward) {
        double alpha = this.alpha(expiry, tenor);
        double beta = this.beta(expiry, tenor);
        double rho = this.rho(expiry, tenor);
        double nu = this.nu(expiry, tenor);
        double shift = this.shift(expiry, tenor);
        return this.sabrVolatilityFormula.volatilityAdjoint(forward + shift, strike + shift, expiry, alpha, beta, rho, nu);
    }

    public static TypedMetaBean<SabrInterestRateParameters> meta() {
        return META_BEAN;
    }

    public TypedMetaBean<SabrInterestRateParameters> metaBean() {
        return META_BEAN;
    }

    public Surface getAlphaSurface() {
        return this.alphaSurface;
    }

    public Surface getBetaSurface() {
        return this.betaSurface;
    }

    public Surface getRhoSurface() {
        return this.rhoSurface;
    }

    public Surface getNuSurface() {
        return this.nuSurface;
    }

    public Surface getShiftSurface() {
        return this.shiftSurface;
    }

    public SabrVolatilityFormula getSabrVolatilityFormula() {
        return this.sabrVolatilityFormula;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == this.getClass()) {
            SabrInterestRateParameters other = (SabrInterestRateParameters)obj;
            return JodaBeanUtils.equal((Object)this.alphaSurface, (Object)other.alphaSurface) && JodaBeanUtils.equal((Object)this.betaSurface, (Object)other.betaSurface) && JodaBeanUtils.equal((Object)this.rhoSurface, (Object)other.rhoSurface) && JodaBeanUtils.equal((Object)this.nuSurface, (Object)other.nuSurface) && JodaBeanUtils.equal((Object)this.shiftSurface, (Object)other.shiftSurface) && JodaBeanUtils.equal((Object)this.sabrVolatilityFormula, (Object)other.sabrVolatilityFormula);
        }
        return false;
    }

    public int hashCode() {
        int hash = this.getClass().hashCode();
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.alphaSurface);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.betaSurface);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.rhoSurface);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.nuSurface);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.shiftSurface);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.sabrVolatilityFormula);
        return hash;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(224);
        buf.append("SabrInterestRateParameters{");
        buf.append("alphaSurface").append('=').append(JodaBeanUtils.toString((Object)this.alphaSurface)).append(',').append(' ');
        buf.append("betaSurface").append('=').append(JodaBeanUtils.toString((Object)this.betaSurface)).append(',').append(' ');
        buf.append("rhoSurface").append('=').append(JodaBeanUtils.toString((Object)this.rhoSurface)).append(',').append(' ');
        buf.append("nuSurface").append('=').append(JodaBeanUtils.toString((Object)this.nuSurface)).append(',').append(' ');
        buf.append("shiftSurface").append('=').append(JodaBeanUtils.toString((Object)this.shiftSurface)).append(',').append(' ');
        buf.append("sabrVolatilityFormula").append('=').append(JodaBeanUtils.toString((Object)this.sabrVolatilityFormula));
        buf.append('}');
        return buf.toString();
    }

    static {
        MetaBean.register(META_BEAN);
    }
}

