/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.pricer.option;

import com.google.common.collect.ImmutableList;
import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.collect.array.DoubleArray;
import com.opengamma.strata.collect.array.DoubleMatrix;
import com.opengamma.strata.collect.tuple.Pair;
import com.opengamma.strata.market.ValueType;
import java.io.Serializable;
import java.lang.invoke.MethodHandles;
import java.time.Period;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.OptionalDouble;
import org.joda.beans.ImmutableBean;
import org.joda.beans.JodaBeanUtils;
import org.joda.beans.MetaBean;
import org.joda.beans.TypedMetaBean;
import org.joda.beans.gen.BeanDefinition;
import org.joda.beans.gen.PropertyDefinition;
import org.joda.beans.impl.light.LightMetaBean;

@BeanDefinition(style="light")
public final class RawOptionData
implements ImmutableBean,
Serializable {
    @PropertyDefinition(validate="notNull")
    private final ImmutableList<Period> expiries;
    @PropertyDefinition(validate="notNull")
    private final DoubleArray strikes;
    @PropertyDefinition(validate="notNull")
    private final ValueType strikeType;
    @PropertyDefinition(validate="notNull")
    private final DoubleMatrix data;
    @PropertyDefinition(get="optional")
    private final DoubleMatrix error;
    @PropertyDefinition(validate="notNull")
    private final ValueType dataType;
    @PropertyDefinition(get="optional")
    private final Double shift;
    private static final TypedMetaBean<RawOptionData> META_BEAN = LightMetaBean.of(RawOptionData.class, (MethodHandles.Lookup)MethodHandles.lookup(), (String[])new String[]{"expiries", "strikes", "strikeType", "data", "error", "dataType", "shift"}, (Object[])new Object[]{ImmutableList.of(), null, null, null, null, null, null});
    private static final long serialVersionUID = 1L;

    public static RawOptionData of(List<Period> expiries, DoubleArray strikes, ValueType strikeType, DoubleMatrix data, ValueType dataType) {
        ArgChecker.isTrue((expiries.size() == data.rowCount() ? 1 : 0) != 0, (String)"expiries list should be of the same size as the external data dimension");
        for (int i = 0; i < expiries.size(); ++i) {
            ArgChecker.isTrue((strikes.size() == data.columnCount() ? 1 : 0) != 0, (String)"strikes should be of the same size as the inner data dimension");
        }
        return new RawOptionData(expiries, strikes, strikeType, data, null, dataType, 0.0);
    }

    public static RawOptionData ofBlackVolatility(List<Period> expiries, DoubleArray strikes, ValueType strikeType, DoubleMatrix data, Double shift) {
        ArgChecker.isTrue((expiries.size() == data.rowCount() ? 1 : 0) != 0, (String)"expiries list should be of the same size as the external data dimension");
        for (int i = 0; i < expiries.size(); ++i) {
            ArgChecker.isTrue((strikes.size() == data.columnCount() ? 1 : 0) != 0, (String)"strikes should be of the same size as the inner data dimension");
        }
        return new RawOptionData(expiries, strikes, strikeType, data, null, ValueType.BLACK_VOLATILITY, shift);
    }

    public static RawOptionData of(List<Period> expiries, DoubleArray strikes, ValueType strikeType, DoubleMatrix data, DoubleMatrix error, ValueType dataType) {
        ArgChecker.isTrue((expiries.size() == data.rowCount() ? 1 : 0) != 0, (String)"expiries list should be of the same size as the external data dimension");
        ArgChecker.isTrue((error.rowCount() == data.rowCount() ? 1 : 0) != 0, (String)"the error row count should be the same as the data raw count");
        ArgChecker.isTrue((error.columnCount() == data.columnCount() ? 1 : 0) != 0, (String)"the error column count should the same as the data column count");
        for (int i = 0; i < expiries.size(); ++i) {
            ArgChecker.isTrue((strikes.size() == data.columnCount() ? 1 : 0) != 0, (String)"strikes should be of the same size as the inner data dimension");
        }
        return new RawOptionData(expiries, strikes, strikeType, data, error, dataType, 0.0);
    }

    public static RawOptionData ofBlackVolatility(List<Period> expiries, DoubleArray strikes, ValueType strikeType, DoubleMatrix data, DoubleMatrix error, Double shift) {
        ArgChecker.isTrue((expiries.size() == data.rowCount() ? 1 : 0) != 0, (String)"expiries list should be of the same size as the external data dimension");
        for (int i = 0; i < expiries.size(); ++i) {
            ArgChecker.isTrue((strikes.size() == data.columnCount() ? 1 : 0) != 0, (String)"strikes should be of the same size as the inner data dimension");
        }
        return new RawOptionData(expiries, strikes, strikeType, data, error, ValueType.BLACK_VOLATILITY, shift);
    }

    public Pair<DoubleArray, DoubleArray> availableSmileAtExpiry(Period expiry) {
        int index = this.expiries.indexOf((Object)expiry);
        ArgChecker.isTrue((index >= 0 ? 1 : 0) != 0, (String)"expiry not available");
        ArrayList<Double> strikesAvailable = new ArrayList<Double>();
        ArrayList<Double> volatilitiesAvailable = new ArrayList<Double>();
        for (int i = 0; i < this.strikes.size(); ++i) {
            if (Double.isNaN(this.data.get(index, i))) continue;
            strikesAvailable.add(this.strikes.get(i));
            volatilitiesAvailable.add(this.data.get(index, i));
        }
        return Pair.of((Object)DoubleArray.copyOf(strikesAvailable), (Object)DoubleArray.copyOf(volatilitiesAvailable));
    }

    public static TypedMetaBean<RawOptionData> meta() {
        return META_BEAN;
    }

    private RawOptionData(List<Period> expiries, DoubleArray strikes, ValueType strikeType, DoubleMatrix data, DoubleMatrix error, ValueType dataType, Double shift) {
        JodaBeanUtils.notNull(expiries, (String)"expiries");
        JodaBeanUtils.notNull((Object)strikes, (String)"strikes");
        JodaBeanUtils.notNull((Object)strikeType, (String)"strikeType");
        JodaBeanUtils.notNull((Object)data, (String)"data");
        JodaBeanUtils.notNull((Object)dataType, (String)"dataType");
        this.expiries = ImmutableList.copyOf(expiries);
        this.strikes = strikes;
        this.strikeType = strikeType;
        this.data = data;
        this.error = error;
        this.dataType = dataType;
        this.shift = shift;
    }

    public TypedMetaBean<RawOptionData> metaBean() {
        return META_BEAN;
    }

    public ImmutableList<Period> getExpiries() {
        return this.expiries;
    }

    public DoubleArray getStrikes() {
        return this.strikes;
    }

    public ValueType getStrikeType() {
        return this.strikeType;
    }

    public DoubleMatrix getData() {
        return this.data;
    }

    public Optional<DoubleMatrix> getError() {
        return Optional.ofNullable(this.error);
    }

    public ValueType getDataType() {
        return this.dataType;
    }

    public OptionalDouble getShift() {
        return this.shift != null ? OptionalDouble.of(this.shift) : OptionalDouble.empty();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == this.getClass()) {
            RawOptionData other = (RawOptionData)obj;
            return JodaBeanUtils.equal(this.expiries, other.expiries) && JodaBeanUtils.equal((Object)this.strikes, (Object)other.strikes) && JodaBeanUtils.equal((Object)this.strikeType, (Object)other.strikeType) && JodaBeanUtils.equal((Object)this.data, (Object)other.data) && JodaBeanUtils.equal((Object)this.error, (Object)other.error) && JodaBeanUtils.equal((Object)this.dataType, (Object)other.dataType) && JodaBeanUtils.equal((Object)this.shift, (Object)other.shift);
        }
        return false;
    }

    public int hashCode() {
        int hash = this.getClass().hashCode();
        hash = hash * 31 + JodaBeanUtils.hashCode(this.expiries);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.strikes);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.strikeType);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.data);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.error);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.dataType);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.shift);
        return hash;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(256);
        buf.append("RawOptionData{");
        buf.append("expiries").append('=').append(JodaBeanUtils.toString(this.expiries)).append(',').append(' ');
        buf.append("strikes").append('=').append(JodaBeanUtils.toString((Object)this.strikes)).append(',').append(' ');
        buf.append("strikeType").append('=').append(JodaBeanUtils.toString((Object)this.strikeType)).append(',').append(' ');
        buf.append("data").append('=').append(JodaBeanUtils.toString((Object)this.data)).append(',').append(' ');
        buf.append("error").append('=').append(JodaBeanUtils.toString((Object)this.error)).append(',').append(' ');
        buf.append("dataType").append('=').append(JodaBeanUtils.toString((Object)this.dataType)).append(',').append(' ');
        buf.append("shift").append('=').append(JodaBeanUtils.toString((Object)this.shift));
        buf.append('}');
        return buf.toString();
    }

    static {
        MetaBean.register(META_BEAN);
    }
}

