/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.pricer.payment;

import com.opengamma.strata.basics.currency.CurrencyAmount;
import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.market.amount.CashFlows;
import com.opengamma.strata.market.explain.ExplainMap;
import com.opengamma.strata.market.sensitivity.PointSensitivities;
import com.opengamma.strata.pricer.BaseProvider;
import com.opengamma.strata.pricer.DiscountingPaymentPricer;
import com.opengamma.strata.product.payment.ResolvedBulletPaymentTrade;

public class DiscountingBulletPaymentTradePricer {
    public static final DiscountingBulletPaymentTradePricer DEFAULT = new DiscountingBulletPaymentTradePricer(DiscountingPaymentPricer.DEFAULT);
    private final DiscountingPaymentPricer paymentPricer;

    public DiscountingBulletPaymentTradePricer(DiscountingPaymentPricer paymentPricer) {
        this.paymentPricer = (DiscountingPaymentPricer)ArgChecker.notNull((Object)paymentPricer, (String)"paymentPricer");
    }

    public DiscountingPaymentPricer getPaymentPricer() {
        return this.paymentPricer;
    }

    public CurrencyAmount presentValue(ResolvedBulletPaymentTrade trade, BaseProvider provider) {
        return this.paymentPricer.presentValue(trade.getProduct().getPayment(), provider);
    }

    public ExplainMap explainPresentValue(ResolvedBulletPaymentTrade trade, BaseProvider provider) {
        return this.paymentPricer.explainPresentValue(trade.getProduct().getPayment(), provider);
    }

    public PointSensitivities presentValueSensitivity(ResolvedBulletPaymentTrade trade, BaseProvider provider) {
        return this.paymentPricer.presentValueSensitivity(trade.getProduct().getPayment(), provider).build();
    }

    public CashFlows cashFlows(ResolvedBulletPaymentTrade trade, BaseProvider provider) {
        return this.paymentPricer.cashFlows(trade.getProduct().getPayment(), provider);
    }

    public CurrencyAmount currencyExposure(ResolvedBulletPaymentTrade trade, BaseProvider provider) {
        return this.paymentPricer.presentValue(trade.getProduct().getPayment(), provider);
    }

    public CurrencyAmount currentCash(ResolvedBulletPaymentTrade trade, BaseProvider provider) {
        return this.paymentPricer.currentCash(trade.getProduct().getPayment(), provider);
    }
}

