/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.pricer.rate;

import com.opengamma.strata.basics.currency.Currency;
import com.opengamma.strata.basics.index.IborIndex;
import com.opengamma.strata.basics.index.IborIndexObservation;
import com.opengamma.strata.collect.Messages;
import com.opengamma.strata.collect.array.DoubleArray;
import com.opengamma.strata.collect.timeseries.LocalDateDoubleTimeSeries;
import com.opengamma.strata.data.MarketDataName;
import com.opengamma.strata.market.param.CurrencyParameterSensitivities;
import com.opengamma.strata.market.param.ParameterMetadata;
import com.opengamma.strata.market.param.ParameterPerturbation;
import com.opengamma.strata.market.sensitivity.PointSensitivityBuilder;
import com.opengamma.strata.pricer.DiscountFactors;
import com.opengamma.strata.pricer.ZeroRateSensitivity;
import com.opengamma.strata.pricer.rate.IborIndexRates;
import com.opengamma.strata.pricer.rate.IborRateSensitivity;
import java.io.Serializable;
import java.time.LocalDate;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import org.joda.beans.Bean;
import org.joda.beans.BeanBuilder;
import org.joda.beans.ImmutableBean;
import org.joda.beans.JodaBeanUtils;
import org.joda.beans.MetaBean;
import org.joda.beans.MetaProperty;
import org.joda.beans.gen.BeanDefinition;
import org.joda.beans.gen.ImmutableDefaults;
import org.joda.beans.gen.PropertyDefinition;
import org.joda.beans.impl.direct.DirectMetaBean;
import org.joda.beans.impl.direct.DirectMetaProperty;
import org.joda.beans.impl.direct.DirectMetaPropertyMap;
import org.joda.beans.impl.direct.DirectPrivateBeanBuilder;

@BeanDefinition(builderScope="private")
public final class DiscountIborIndexRates
implements IborIndexRates,
ImmutableBean,
Serializable {
    @PropertyDefinition(validate="notNull", overrideGet=true)
    private final IborIndex index;
    @PropertyDefinition(validate="notNull")
    private final DiscountFactors discountFactors;
    @PropertyDefinition(validate="notNull", overrideGet=true)
    private final LocalDateDoubleTimeSeries fixings;
    private static final long serialVersionUID = 1L;

    public static DiscountIborIndexRates of(IborIndex index, DiscountFactors discountFactors) {
        return DiscountIborIndexRates.of(index, discountFactors, LocalDateDoubleTimeSeries.empty());
    }

    public static DiscountIborIndexRates of(IborIndex index, DiscountFactors discountFactors, LocalDateDoubleTimeSeries fixings) {
        return new DiscountIborIndexRates(index, discountFactors, fixings);
    }

    @ImmutableDefaults
    private static void applyDefaults(Builder builder) {
        builder.fixings = LocalDateDoubleTimeSeries.empty();
    }

    public LocalDate getValuationDate() {
        return this.discountFactors.getValuationDate();
    }

    public <T> Optional<T> findData(MarketDataName<T> name) {
        return this.discountFactors.findData(name);
    }

    public int getParameterCount() {
        return this.discountFactors.getParameterCount();
    }

    public double getParameter(int parameterIndex) {
        return this.discountFactors.getParameter(parameterIndex);
    }

    public ParameterMetadata getParameterMetadata(int parameterIndex) {
        return this.discountFactors.getParameterMetadata(parameterIndex);
    }

    public OptionalInt findParameterIndex(ParameterMetadata metadata) {
        return this.discountFactors.findParameterIndex(metadata);
    }

    @Override
    public DiscountIborIndexRates withParameter(int parameterIndex, double newValue) {
        return this.withDiscountFactors(this.discountFactors.withParameter(parameterIndex, newValue));
    }

    @Override
    public DiscountIborIndexRates withPerturbation(ParameterPerturbation perturbation) {
        return this.withDiscountFactors(this.discountFactors.withPerturbation(perturbation));
    }

    @Override
    public double rate(IborIndexObservation observation) {
        if (!observation.getFixingDate().isAfter(this.getValuationDate())) {
            return this.historicRate(observation);
        }
        return this.rateIgnoringFixings(observation);
    }

    private double historicRate(IborIndexObservation observation) {
        LocalDate fixingDate = observation.getFixingDate();
        OptionalDouble fixedRate = this.fixings.get(fixingDate);
        if (fixedRate.isPresent()) {
            return fixedRate.getAsDouble();
        }
        if (fixingDate.isBefore(this.getValuationDate())) {
            if (this.fixings.isEmpty()) {
                throw new IllegalArgumentException(Messages.format((String)"Unable to get fixing for {} on date {}, no time-series supplied", (Object[])new Object[]{this.index, fixingDate}));
            }
            throw new IllegalArgumentException(Messages.format((String)"Unable to get fixing for {} on date {}", (Object[])new Object[]{this.index, fixingDate}));
        }
        return this.rateIgnoringFixings(observation);
    }

    @Override
    public double rateIgnoringFixings(IborIndexObservation observation) {
        LocalDate fixingStartDate = observation.getEffectiveDate();
        LocalDate fixingEndDate = observation.getMaturityDate();
        double accrualFactor = observation.getYearFraction();
        double dfStart = this.discountFactors.discountFactor(fixingStartDate);
        double dfEnd = this.discountFactors.discountFactor(fixingEndDate);
        return (dfStart / dfEnd - 1.0) / accrualFactor;
    }

    @Override
    public PointSensitivityBuilder ratePointSensitivity(IborIndexObservation observation) {
        LocalDate valuationDate;
        LocalDate fixingDate = observation.getFixingDate();
        if (fixingDate.isBefore(valuationDate = this.getValuationDate()) || fixingDate.equals(valuationDate) && this.fixings.get(fixingDate).isPresent()) {
            return PointSensitivityBuilder.none();
        }
        return IborRateSensitivity.of(observation, 1.0);
    }

    @Override
    public PointSensitivityBuilder rateIgnoringFixingsPointSensitivity(IborIndexObservation observation) {
        return IborRateSensitivity.of(observation, 1.0);
    }

    @Override
    public CurrencyParameterSensitivities parameterSensitivity(IborRateSensitivity pointSensitivity) {
        LocalDate fixingStartDate = pointSensitivity.getObservation().getEffectiveDate();
        LocalDate fixingEndDate = pointSensitivity.getObservation().getMaturityDate();
        double accrualFactor = pointSensitivity.getObservation().getYearFraction();
        double forwardBar = pointSensitivity.getSensitivity();
        double dfForwardStart = this.discountFactors.discountFactor(fixingStartDate);
        double dfForwardEnd = this.discountFactors.discountFactor(fixingEndDate);
        double dfStartBar = forwardBar / (accrualFactor * dfForwardEnd);
        double dfEndBar = -forwardBar * dfForwardStart / (accrualFactor * dfForwardEnd * dfForwardEnd);
        ZeroRateSensitivity zrsStart = this.discountFactors.zeroRatePointSensitivity(fixingStartDate, pointSensitivity.getCurrency());
        ZeroRateSensitivity zrsEnd = this.discountFactors.zeroRatePointSensitivity(fixingEndDate, pointSensitivity.getCurrency());
        CurrencyParameterSensitivities psStart = this.discountFactors.parameterSensitivity(zrsStart).multipliedBy(dfStartBar);
        CurrencyParameterSensitivities psEnd = this.discountFactors.parameterSensitivity(zrsEnd).multipliedBy(dfEndBar);
        return psStart.combinedWith(psEnd);
    }

    @Override
    public CurrencyParameterSensitivities createParameterSensitivity(Currency currency, DoubleArray sensitivities) {
        return this.discountFactors.createParameterSensitivity(currency, sensitivities);
    }

    public DiscountIborIndexRates withDiscountFactors(DiscountFactors factors) {
        return new DiscountIborIndexRates(this.index, factors, this.fixings);
    }

    public static Meta meta() {
        return Meta.INSTANCE;
    }

    private DiscountIborIndexRates(IborIndex index, DiscountFactors discountFactors, LocalDateDoubleTimeSeries fixings) {
        JodaBeanUtils.notNull((Object)index, (String)"index");
        JodaBeanUtils.notNull((Object)discountFactors, (String)"discountFactors");
        JodaBeanUtils.notNull((Object)fixings, (String)"fixings");
        this.index = index;
        this.discountFactors = discountFactors;
        this.fixings = fixings;
    }

    public Meta metaBean() {
        return Meta.INSTANCE;
    }

    @Override
    public IborIndex getIndex() {
        return this.index;
    }

    public DiscountFactors getDiscountFactors() {
        return this.discountFactors;
    }

    @Override
    public LocalDateDoubleTimeSeries getFixings() {
        return this.fixings;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == this.getClass()) {
            DiscountIborIndexRates other = (DiscountIborIndexRates)obj;
            return JodaBeanUtils.equal((Object)this.index, (Object)other.index) && JodaBeanUtils.equal((Object)this.discountFactors, (Object)other.discountFactors) && JodaBeanUtils.equal((Object)this.fixings, (Object)other.fixings);
        }
        return false;
    }

    public int hashCode() {
        int hash = this.getClass().hashCode();
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.index);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.discountFactors);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.fixings);
        return hash;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(128);
        buf.append("DiscountIborIndexRates{");
        buf.append("index").append('=').append(JodaBeanUtils.toString((Object)this.index)).append(',').append(' ');
        buf.append("discountFactors").append('=').append(JodaBeanUtils.toString((Object)this.discountFactors)).append(',').append(' ');
        buf.append("fixings").append('=').append(JodaBeanUtils.toString((Object)this.fixings));
        buf.append('}');
        return buf.toString();
    }

    static {
        MetaBean.register((MetaBean)Meta.INSTANCE);
    }

    private static final class Builder
    extends DirectPrivateBeanBuilder<DiscountIborIndexRates> {
        private IborIndex index;
        private DiscountFactors discountFactors;
        private LocalDateDoubleTimeSeries fixings;

        private Builder() {
            DiscountIborIndexRates.applyDefaults(this);
        }

        public Object get(String propertyName) {
            switch (propertyName.hashCode()) {
                case 100346066: {
                    return this.index;
                }
                case -91613053: {
                    return this.discountFactors;
                }
                case -843784602: {
                    return this.fixings;
                }
            }
            throw new NoSuchElementException("Unknown property: " + propertyName);
        }

        public Builder set(String propertyName, Object newValue) {
            switch (propertyName.hashCode()) {
                case 100346066: {
                    this.index = (IborIndex)newValue;
                    break;
                }
                case -91613053: {
                    this.discountFactors = (DiscountFactors)newValue;
                    break;
                }
                case -843784602: {
                    this.fixings = (LocalDateDoubleTimeSeries)newValue;
                    break;
                }
                default: {
                    throw new NoSuchElementException("Unknown property: " + propertyName);
                }
            }
            return this;
        }

        public DiscountIborIndexRates build() {
            return new DiscountIborIndexRates(this.index, this.discountFactors, this.fixings);
        }

        public String toString() {
            StringBuilder buf = new StringBuilder(128);
            buf.append("DiscountIborIndexRates.Builder{");
            buf.append("index").append('=').append(JodaBeanUtils.toString((Object)this.index)).append(',').append(' ');
            buf.append("discountFactors").append('=').append(JodaBeanUtils.toString((Object)this.discountFactors)).append(',').append(' ');
            buf.append("fixings").append('=').append(JodaBeanUtils.toString((Object)this.fixings));
            buf.append('}');
            return buf.toString();
        }
    }

    public static final class Meta
    extends DirectMetaBean {
        static final Meta INSTANCE = new Meta();
        private final MetaProperty<IborIndex> index = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"index", DiscountIborIndexRates.class, IborIndex.class);
        private final MetaProperty<DiscountFactors> discountFactors = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"discountFactors", DiscountIborIndexRates.class, DiscountFactors.class);
        private final MetaProperty<LocalDateDoubleTimeSeries> fixings = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"fixings", DiscountIborIndexRates.class, LocalDateDoubleTimeSeries.class);
        private final Map<String, MetaProperty<?>> metaPropertyMap$ = new DirectMetaPropertyMap((DirectMetaBean)this, null, new String[]{"index", "discountFactors", "fixings"});

        private Meta() {
        }

        protected MetaProperty<?> metaPropertyGet(String propertyName) {
            switch (propertyName.hashCode()) {
                case 100346066: {
                    return this.index;
                }
                case -91613053: {
                    return this.discountFactors;
                }
                case -843784602: {
                    return this.fixings;
                }
            }
            return super.metaPropertyGet(propertyName);
        }

        public BeanBuilder<? extends DiscountIborIndexRates> builder() {
            return new Builder();
        }

        public Class<? extends DiscountIborIndexRates> beanType() {
            return DiscountIborIndexRates.class;
        }

        public Map<String, MetaProperty<?>> metaPropertyMap() {
            return this.metaPropertyMap$;
        }

        public MetaProperty<IborIndex> index() {
            return this.index;
        }

        public MetaProperty<DiscountFactors> discountFactors() {
            return this.discountFactors;
        }

        public MetaProperty<LocalDateDoubleTimeSeries> fixings() {
            return this.fixings;
        }

        protected Object propertyGet(Bean bean, String propertyName, boolean quiet) {
            switch (propertyName.hashCode()) {
                case 100346066: {
                    return ((DiscountIborIndexRates)bean).getIndex();
                }
                case -91613053: {
                    return ((DiscountIborIndexRates)bean).getDiscountFactors();
                }
                case -843784602: {
                    return ((DiscountIborIndexRates)bean).getFixings();
                }
            }
            return super.propertyGet(bean, propertyName, quiet);
        }

        protected void propertySet(Bean bean, String propertyName, Object newValue, boolean quiet) {
            this.metaProperty(propertyName);
            if (quiet) {
                return;
            }
            throw new UnsupportedOperationException("Property cannot be written: " + propertyName);
        }
    }
}

