/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.pricer.rate;

import com.opengamma.strata.basics.currency.Currency;
import com.opengamma.strata.basics.index.OvernightIndex;
import com.opengamma.strata.basics.index.OvernightIndexObservation;
import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.collect.Messages;
import com.opengamma.strata.collect.array.DoubleArray;
import com.opengamma.strata.collect.timeseries.LocalDateDoubleTimeSeries;
import com.opengamma.strata.data.MarketDataName;
import com.opengamma.strata.market.param.CurrencyParameterSensitivities;
import com.opengamma.strata.market.param.ParameterMetadata;
import com.opengamma.strata.market.param.ParameterPerturbation;
import com.opengamma.strata.market.sensitivity.PointSensitivityBuilder;
import com.opengamma.strata.pricer.DiscountFactors;
import com.opengamma.strata.pricer.ZeroRateSensitivity;
import com.opengamma.strata.pricer.rate.OvernightIndexRates;
import com.opengamma.strata.pricer.rate.OvernightRateSensitivity;
import java.io.Serializable;
import java.time.LocalDate;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import org.joda.beans.Bean;
import org.joda.beans.BeanBuilder;
import org.joda.beans.ImmutableBean;
import org.joda.beans.JodaBeanUtils;
import org.joda.beans.MetaBean;
import org.joda.beans.MetaProperty;
import org.joda.beans.gen.BeanDefinition;
import org.joda.beans.gen.ImmutableDefaults;
import org.joda.beans.gen.PropertyDefinition;
import org.joda.beans.impl.direct.DirectMetaBean;
import org.joda.beans.impl.direct.DirectMetaProperty;
import org.joda.beans.impl.direct.DirectMetaPropertyMap;
import org.joda.beans.impl.direct.DirectPrivateBeanBuilder;

@BeanDefinition(builderScope="private")
public final class DiscountOvernightIndexRates
implements OvernightIndexRates,
ImmutableBean,
Serializable {
    @PropertyDefinition(validate="notNull", overrideGet=true)
    private final OvernightIndex index;
    @PropertyDefinition(validate="notNull")
    private final DiscountFactors discountFactors;
    @PropertyDefinition(validate="notNull", overrideGet=true)
    private final LocalDateDoubleTimeSeries fixings;
    private static final long serialVersionUID = 1L;

    public static DiscountOvernightIndexRates of(OvernightIndex index, DiscountFactors discountFactors) {
        return DiscountOvernightIndexRates.of(index, discountFactors, LocalDateDoubleTimeSeries.empty());
    }

    public static DiscountOvernightIndexRates of(OvernightIndex index, DiscountFactors discountFactors, LocalDateDoubleTimeSeries fixings) {
        return new DiscountOvernightIndexRates(index, discountFactors, fixings);
    }

    @ImmutableDefaults
    private static void applyDefaults(Builder builder) {
        builder.fixings = LocalDateDoubleTimeSeries.empty();
    }

    public LocalDate getValuationDate() {
        return this.discountFactors.getValuationDate();
    }

    public <T> Optional<T> findData(MarketDataName<T> name) {
        return this.discountFactors.findData(name);
    }

    public int getParameterCount() {
        return this.discountFactors.getParameterCount();
    }

    public double getParameter(int parameterIndex) {
        return this.discountFactors.getParameter(parameterIndex);
    }

    public ParameterMetadata getParameterMetadata(int parameterIndex) {
        return this.discountFactors.getParameterMetadata(parameterIndex);
    }

    public OptionalInt findParameterIndex(ParameterMetadata metadata) {
        return this.discountFactors.findParameterIndex(metadata);
    }

    @Override
    public DiscountOvernightIndexRates withParameter(int parameterIndex, double newValue) {
        return this.withDiscountFactors(this.discountFactors.withParameter(parameterIndex, newValue));
    }

    @Override
    public DiscountOvernightIndexRates withPerturbation(ParameterPerturbation perturbation) {
        return this.withDiscountFactors(this.discountFactors.withPerturbation(perturbation));
    }

    @Override
    public double rate(OvernightIndexObservation observation) {
        if (!observation.getPublicationDate().isAfter(this.getValuationDate())) {
            return this.historicRate(observation);
        }
        return this.rateIgnoringFixings(observation);
    }

    private double historicRate(OvernightIndexObservation observation) {
        LocalDate fixingDate = observation.getFixingDate();
        OptionalDouble fixedRate = this.fixings.get(fixingDate);
        if (fixedRate.isPresent()) {
            return fixedRate.getAsDouble();
        }
        if (observation.getPublicationDate().isBefore(this.getValuationDate())) {
            if (this.fixings.isEmpty()) {
                throw new IllegalArgumentException(Messages.format((String)"Unable to get fixing for {} on date {}, no time-series supplied", (Object[])new Object[]{this.index, fixingDate}));
            }
            throw new IllegalArgumentException(Messages.format((String)"Unable to get fixing for {} on date {}", (Object[])new Object[]{this.index, fixingDate}));
        }
        return this.rateIgnoringFixings(observation);
    }

    @Override
    public double rateIgnoringFixings(OvernightIndexObservation observation) {
        LocalDate effectiveDate = observation.getEffectiveDate();
        LocalDate maturityDate = observation.getMaturityDate();
        double accrualFactor = observation.getYearFraction();
        return this.simplyCompoundForwardRate(effectiveDate, maturityDate, accrualFactor);
    }

    private double simplyCompoundForwardRate(LocalDate startDate, LocalDate endDate, double accrualFactor) {
        return (this.discountFactors.discountFactor(startDate) / this.discountFactors.discountFactor(endDate) - 1.0) / accrualFactor;
    }

    @Override
    public PointSensitivityBuilder ratePointSensitivity(OvernightIndexObservation observation) {
        LocalDate valuationDate = this.getValuationDate();
        LocalDate fixingDate = observation.getFixingDate();
        LocalDate publicationDate = observation.getPublicationDate();
        if (publicationDate.isBefore(valuationDate) || publicationDate.equals(valuationDate) && this.fixings.get(fixingDate).isPresent()) {
            return PointSensitivityBuilder.none();
        }
        return OvernightRateSensitivity.of(observation, 1.0);
    }

    @Override
    public PointSensitivityBuilder rateIgnoringFixingsPointSensitivity(OvernightIndexObservation observation) {
        return OvernightRateSensitivity.of(observation, 1.0);
    }

    @Override
    public double periodRate(OvernightIndexObservation startDateObservation, LocalDate endDate) {
        LocalDate effectiveDate = startDateObservation.getEffectiveDate();
        ArgChecker.inOrderNotEqual((Comparable)effectiveDate, (Object)endDate, (String)"startDate", (String)"endDate");
        double accrualFactor = startDateObservation.getIndex().getDayCount().yearFraction(effectiveDate, endDate);
        return this.simplyCompoundForwardRate(effectiveDate, endDate, accrualFactor);
    }

    @Override
    public PointSensitivityBuilder periodRatePointSensitivity(OvernightIndexObservation startDateObservation, LocalDate endDate) {
        LocalDate startDate = startDateObservation.getEffectiveDate();
        ArgChecker.inOrderNotEqual((Comparable)startDate, (Object)endDate, (String)"startDate", (String)"endDate");
        return OvernightRateSensitivity.ofPeriod(startDateObservation, endDate, 1.0);
    }

    @Override
    public CurrencyParameterSensitivities parameterSensitivity(OvernightRateSensitivity pointSensitivity) {
        OvernightIndex index = pointSensitivity.getIndex();
        LocalDate startDate = pointSensitivity.getObservation().getEffectiveDate();
        LocalDate endDate = pointSensitivity.getEndDate();
        double accrualFactor = index.getDayCount().yearFraction(startDate, endDate);
        double forwardBar = pointSensitivity.getSensitivity();
        double dfForwardStart = this.discountFactors.discountFactor(startDate);
        double dfForwardEnd = this.discountFactors.discountFactor(endDate);
        double dfStartBar = forwardBar / (accrualFactor * dfForwardEnd);
        double dfEndBar = -forwardBar * dfForwardStart / (accrualFactor * dfForwardEnd * dfForwardEnd);
        ZeroRateSensitivity zrsStart = this.discountFactors.zeroRatePointSensitivity(startDate, pointSensitivity.getCurrency());
        ZeroRateSensitivity zrsEnd = this.discountFactors.zeroRatePointSensitivity(endDate, pointSensitivity.getCurrency());
        CurrencyParameterSensitivities psStart = this.discountFactors.parameterSensitivity(zrsStart).multipliedBy(dfStartBar);
        CurrencyParameterSensitivities psEnd = this.discountFactors.parameterSensitivity(zrsEnd).multipliedBy(dfEndBar);
        return psStart.combinedWith(psEnd);
    }

    @Override
    public CurrencyParameterSensitivities createParameterSensitivity(Currency currency, DoubleArray sensitivities) {
        return this.discountFactors.createParameterSensitivity(currency, sensitivities);
    }

    public DiscountOvernightIndexRates withDiscountFactors(DiscountFactors factors) {
        return new DiscountOvernightIndexRates(this.index, factors, this.fixings);
    }

    public static Meta meta() {
        return Meta.INSTANCE;
    }

    private DiscountOvernightIndexRates(OvernightIndex index, DiscountFactors discountFactors, LocalDateDoubleTimeSeries fixings) {
        JodaBeanUtils.notNull((Object)index, (String)"index");
        JodaBeanUtils.notNull((Object)discountFactors, (String)"discountFactors");
        JodaBeanUtils.notNull((Object)fixings, (String)"fixings");
        this.index = index;
        this.discountFactors = discountFactors;
        this.fixings = fixings;
    }

    public Meta metaBean() {
        return Meta.INSTANCE;
    }

    @Override
    public OvernightIndex getIndex() {
        return this.index;
    }

    public DiscountFactors getDiscountFactors() {
        return this.discountFactors;
    }

    @Override
    public LocalDateDoubleTimeSeries getFixings() {
        return this.fixings;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == this.getClass()) {
            DiscountOvernightIndexRates other = (DiscountOvernightIndexRates)obj;
            return JodaBeanUtils.equal((Object)this.index, (Object)other.index) && JodaBeanUtils.equal((Object)this.discountFactors, (Object)other.discountFactors) && JodaBeanUtils.equal((Object)this.fixings, (Object)other.fixings);
        }
        return false;
    }

    public int hashCode() {
        int hash = this.getClass().hashCode();
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.index);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.discountFactors);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.fixings);
        return hash;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(128);
        buf.append("DiscountOvernightIndexRates{");
        buf.append("index").append('=').append(JodaBeanUtils.toString((Object)this.index)).append(',').append(' ');
        buf.append("discountFactors").append('=').append(JodaBeanUtils.toString((Object)this.discountFactors)).append(',').append(' ');
        buf.append("fixings").append('=').append(JodaBeanUtils.toString((Object)this.fixings));
        buf.append('}');
        return buf.toString();
    }

    static {
        MetaBean.register((MetaBean)Meta.INSTANCE);
    }

    private static final class Builder
    extends DirectPrivateBeanBuilder<DiscountOvernightIndexRates> {
        private OvernightIndex index;
        private DiscountFactors discountFactors;
        private LocalDateDoubleTimeSeries fixings;

        private Builder() {
            DiscountOvernightIndexRates.applyDefaults(this);
        }

        public Object get(String propertyName) {
            switch (propertyName.hashCode()) {
                case 100346066: {
                    return this.index;
                }
                case -91613053: {
                    return this.discountFactors;
                }
                case -843784602: {
                    return this.fixings;
                }
            }
            throw new NoSuchElementException("Unknown property: " + propertyName);
        }

        public Builder set(String propertyName, Object newValue) {
            switch (propertyName.hashCode()) {
                case 100346066: {
                    this.index = (OvernightIndex)newValue;
                    break;
                }
                case -91613053: {
                    this.discountFactors = (DiscountFactors)newValue;
                    break;
                }
                case -843784602: {
                    this.fixings = (LocalDateDoubleTimeSeries)newValue;
                    break;
                }
                default: {
                    throw new NoSuchElementException("Unknown property: " + propertyName);
                }
            }
            return this;
        }

        public DiscountOvernightIndexRates build() {
            return new DiscountOvernightIndexRates(this.index, this.discountFactors, this.fixings);
        }

        public String toString() {
            StringBuilder buf = new StringBuilder(128);
            buf.append("DiscountOvernightIndexRates.Builder{");
            buf.append("index").append('=').append(JodaBeanUtils.toString((Object)this.index)).append(',').append(' ');
            buf.append("discountFactors").append('=').append(JodaBeanUtils.toString((Object)this.discountFactors)).append(',').append(' ');
            buf.append("fixings").append('=').append(JodaBeanUtils.toString((Object)this.fixings));
            buf.append('}');
            return buf.toString();
        }
    }

    public static final class Meta
    extends DirectMetaBean {
        static final Meta INSTANCE = new Meta();
        private final MetaProperty<OvernightIndex> index = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"index", DiscountOvernightIndexRates.class, OvernightIndex.class);
        private final MetaProperty<DiscountFactors> discountFactors = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"discountFactors", DiscountOvernightIndexRates.class, DiscountFactors.class);
        private final MetaProperty<LocalDateDoubleTimeSeries> fixings = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"fixings", DiscountOvernightIndexRates.class, LocalDateDoubleTimeSeries.class);
        private final Map<String, MetaProperty<?>> metaPropertyMap$ = new DirectMetaPropertyMap((DirectMetaBean)this, null, new String[]{"index", "discountFactors", "fixings"});

        private Meta() {
        }

        protected MetaProperty<?> metaPropertyGet(String propertyName) {
            switch (propertyName.hashCode()) {
                case 100346066: {
                    return this.index;
                }
                case -91613053: {
                    return this.discountFactors;
                }
                case -843784602: {
                    return this.fixings;
                }
            }
            return super.metaPropertyGet(propertyName);
        }

        public BeanBuilder<? extends DiscountOvernightIndexRates> builder() {
            return new Builder();
        }

        public Class<? extends DiscountOvernightIndexRates> beanType() {
            return DiscountOvernightIndexRates.class;
        }

        public Map<String, MetaProperty<?>> metaPropertyMap() {
            return this.metaPropertyMap$;
        }

        public MetaProperty<OvernightIndex> index() {
            return this.index;
        }

        public MetaProperty<DiscountFactors> discountFactors() {
            return this.discountFactors;
        }

        public MetaProperty<LocalDateDoubleTimeSeries> fixings() {
            return this.fixings;
        }

        protected Object propertyGet(Bean bean, String propertyName, boolean quiet) {
            switch (propertyName.hashCode()) {
                case 100346066: {
                    return ((DiscountOvernightIndexRates)bean).getIndex();
                }
                case -91613053: {
                    return ((DiscountOvernightIndexRates)bean).getDiscountFactors();
                }
                case -843784602: {
                    return ((DiscountOvernightIndexRates)bean).getFixings();
                }
            }
            return super.propertyGet(bean, propertyName, quiet);
        }

        protected void propertySet(Bean bean, String propertyName, Object newValue, boolean quiet) {
            this.metaProperty(propertyName);
            if (quiet) {
                return;
            }
            throw new UnsupportedOperationException("Property cannot be written: " + propertyName);
        }
    }
}

