/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.pricer.rate;

import com.opengamma.strata.basics.currency.Currency;
import com.opengamma.strata.basics.index.IborIndex;
import com.opengamma.strata.basics.index.IborIndexObservation;
import com.opengamma.strata.collect.Messages;
import com.opengamma.strata.collect.array.DoubleArray;
import com.opengamma.strata.collect.timeseries.LocalDateDoubleTimeSeries;
import com.opengamma.strata.data.MarketDataName;
import com.opengamma.strata.data.MarketDataNotFoundException;
import com.opengamma.strata.market.param.CurrencyParameterSensitivities;
import com.opengamma.strata.market.param.ParameterMetadata;
import com.opengamma.strata.market.param.ParameterPerturbation;
import com.opengamma.strata.market.sensitivity.PointSensitivityBuilder;
import com.opengamma.strata.pricer.rate.IborIndexRates;
import com.opengamma.strata.pricer.rate.IborRateSensitivity;
import java.io.Serializable;
import java.time.LocalDate;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.OptionalDouble;
import org.joda.beans.Bean;
import org.joda.beans.BeanBuilder;
import org.joda.beans.ImmutableBean;
import org.joda.beans.JodaBeanUtils;
import org.joda.beans.MetaBean;
import org.joda.beans.MetaProperty;
import org.joda.beans.gen.BeanDefinition;
import org.joda.beans.gen.PropertyDefinition;
import org.joda.beans.impl.direct.DirectMetaBean;
import org.joda.beans.impl.direct.DirectMetaProperty;
import org.joda.beans.impl.direct.DirectMetaPropertyMap;
import org.joda.beans.impl.direct.DirectPrivateBeanBuilder;

@BeanDefinition(builderScope="private")
public final class HistoricIborIndexRates
implements IborIndexRates,
ImmutableBean,
Serializable {
    @PropertyDefinition(validate="notNull", overrideGet=true)
    private final IborIndex index;
    @PropertyDefinition(validate="notNull", overrideGet=true)
    private final LocalDate valuationDate;
    @PropertyDefinition(validate="notNull", overrideGet=true)
    private final LocalDateDoubleTimeSeries fixings;
    private static final long serialVersionUID = 1L;

    public static HistoricIborIndexRates of(IborIndex index, LocalDate valuationDate, LocalDateDoubleTimeSeries fixings) {
        return new HistoricIborIndexRates(index, valuationDate, fixings);
    }

    public <T> Optional<T> findData(MarketDataName<T> name) {
        return Optional.empty();
    }

    public int getParameterCount() {
        return 0;
    }

    public double getParameter(int parameterIndex) {
        throw new IndexOutOfBoundsException("No parameters for historic index: " + this.index);
    }

    public ParameterMetadata getParameterMetadata(int parameterIndex) {
        throw new IndexOutOfBoundsException("No parameters for historic index: " + this.index);
    }

    @Override
    public HistoricIborIndexRates withParameter(int parameterIndex, double newValue) {
        throw new IndexOutOfBoundsException("No parameters for historic index: " + this.index);
    }

    @Override
    public HistoricIborIndexRates withPerturbation(ParameterPerturbation perturbation) {
        return this;
    }

    @Override
    public double rate(IborIndexObservation observation) {
        if (!observation.getFixingDate().isAfter(this.getValuationDate())) {
            return this.historicRate(observation);
        }
        return this.rateIgnoringFixings(observation);
    }

    private double historicRate(IborIndexObservation observation) {
        LocalDate fixingDate = observation.getFixingDate();
        OptionalDouble fixedRate = this.fixings.get(fixingDate);
        if (fixedRate.isPresent()) {
            return fixedRate.getAsDouble();
        }
        if (fixingDate.isBefore(this.getValuationDate())) {
            if (this.fixings.isEmpty()) {
                throw new IllegalArgumentException(Messages.format((String)"Unable to get fixing for {} on date {}, no time-series supplied", (Object[])new Object[]{this.index, fixingDate}));
            }
            throw new IllegalArgumentException(Messages.format((String)"Unable to get fixing for {} on date {}", (Object[])new Object[]{this.index, fixingDate}));
        }
        return this.rateIgnoringFixings(observation);
    }

    @Override
    public double rateIgnoringFixings(IborIndexObservation observation) {
        throw new MarketDataNotFoundException("Unable to query forward rate for historic index " + this.index);
    }

    @Override
    public PointSensitivityBuilder ratePointSensitivity(IborIndexObservation observation) {
        LocalDate valuationDate;
        LocalDate fixingDate = observation.getFixingDate();
        if (fixingDate.isBefore(valuationDate = this.getValuationDate()) || fixingDate.equals(valuationDate) && this.fixings.get(fixingDate).isPresent()) {
            return PointSensitivityBuilder.none();
        }
        throw new MarketDataNotFoundException("Unable to query forward rate sensitivity for historic index " + this.index);
    }

    @Override
    public PointSensitivityBuilder rateIgnoringFixingsPointSensitivity(IborIndexObservation observation) {
        throw new MarketDataNotFoundException("Unable to query forward rate sensitivity for historic index " + this.index);
    }

    @Override
    public CurrencyParameterSensitivities parameterSensitivity(IborRateSensitivity pointSensitivity) {
        throw new MarketDataNotFoundException("Unable to create sensitivity for historic index " + this.index);
    }

    @Override
    public CurrencyParameterSensitivities createParameterSensitivity(Currency currency, DoubleArray sensitivities) {
        throw new MarketDataNotFoundException("Unable to create sensitivity for historic index " + this.index);
    }

    public static Meta meta() {
        return Meta.INSTANCE;
    }

    private HistoricIborIndexRates(IborIndex index, LocalDate valuationDate, LocalDateDoubleTimeSeries fixings) {
        JodaBeanUtils.notNull((Object)index, (String)"index");
        JodaBeanUtils.notNull((Object)valuationDate, (String)"valuationDate");
        JodaBeanUtils.notNull((Object)fixings, (String)"fixings");
        this.index = index;
        this.valuationDate = valuationDate;
        this.fixings = fixings;
    }

    public Meta metaBean() {
        return Meta.INSTANCE;
    }

    @Override
    public IborIndex getIndex() {
        return this.index;
    }

    public LocalDate getValuationDate() {
        return this.valuationDate;
    }

    @Override
    public LocalDateDoubleTimeSeries getFixings() {
        return this.fixings;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == this.getClass()) {
            HistoricIborIndexRates other = (HistoricIborIndexRates)obj;
            return JodaBeanUtils.equal((Object)this.index, (Object)other.index) && JodaBeanUtils.equal((Object)this.valuationDate, (Object)other.valuationDate) && JodaBeanUtils.equal((Object)this.fixings, (Object)other.fixings);
        }
        return false;
    }

    public int hashCode() {
        int hash = this.getClass().hashCode();
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.index);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.valuationDate);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.fixings);
        return hash;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(128);
        buf.append("HistoricIborIndexRates{");
        buf.append("index").append('=').append(JodaBeanUtils.toString((Object)this.index)).append(',').append(' ');
        buf.append("valuationDate").append('=').append(JodaBeanUtils.toString((Object)this.valuationDate)).append(',').append(' ');
        buf.append("fixings").append('=').append(JodaBeanUtils.toString((Object)this.fixings));
        buf.append('}');
        return buf.toString();
    }

    static {
        MetaBean.register((MetaBean)Meta.INSTANCE);
    }

    private static final class Builder
    extends DirectPrivateBeanBuilder<HistoricIborIndexRates> {
        private IborIndex index;
        private LocalDate valuationDate;
        private LocalDateDoubleTimeSeries fixings;

        private Builder() {
        }

        public Object get(String propertyName) {
            switch (propertyName.hashCode()) {
                case 100346066: {
                    return this.index;
                }
                case 113107279: {
                    return this.valuationDate;
                }
                case -843784602: {
                    return this.fixings;
                }
            }
            throw new NoSuchElementException("Unknown property: " + propertyName);
        }

        public Builder set(String propertyName, Object newValue) {
            switch (propertyName.hashCode()) {
                case 100346066: {
                    this.index = (IborIndex)newValue;
                    break;
                }
                case 113107279: {
                    this.valuationDate = (LocalDate)newValue;
                    break;
                }
                case -843784602: {
                    this.fixings = (LocalDateDoubleTimeSeries)newValue;
                    break;
                }
                default: {
                    throw new NoSuchElementException("Unknown property: " + propertyName);
                }
            }
            return this;
        }

        public HistoricIborIndexRates build() {
            return new HistoricIborIndexRates(this.index, this.valuationDate, this.fixings);
        }

        public String toString() {
            StringBuilder buf = new StringBuilder(128);
            buf.append("HistoricIborIndexRates.Builder{");
            buf.append("index").append('=').append(JodaBeanUtils.toString((Object)this.index)).append(',').append(' ');
            buf.append("valuationDate").append('=').append(JodaBeanUtils.toString((Object)this.valuationDate)).append(',').append(' ');
            buf.append("fixings").append('=').append(JodaBeanUtils.toString((Object)this.fixings));
            buf.append('}');
            return buf.toString();
        }
    }

    public static final class Meta
    extends DirectMetaBean {
        static final Meta INSTANCE = new Meta();
        private final MetaProperty<IborIndex> index = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"index", HistoricIborIndexRates.class, IborIndex.class);
        private final MetaProperty<LocalDate> valuationDate = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"valuationDate", HistoricIborIndexRates.class, LocalDate.class);
        private final MetaProperty<LocalDateDoubleTimeSeries> fixings = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"fixings", HistoricIborIndexRates.class, LocalDateDoubleTimeSeries.class);
        private final Map<String, MetaProperty<?>> metaPropertyMap$ = new DirectMetaPropertyMap((DirectMetaBean)this, null, new String[]{"index", "valuationDate", "fixings"});

        private Meta() {
        }

        protected MetaProperty<?> metaPropertyGet(String propertyName) {
            switch (propertyName.hashCode()) {
                case 100346066: {
                    return this.index;
                }
                case 113107279: {
                    return this.valuationDate;
                }
                case -843784602: {
                    return this.fixings;
                }
            }
            return super.metaPropertyGet(propertyName);
        }

        public BeanBuilder<? extends HistoricIborIndexRates> builder() {
            return new Builder();
        }

        public Class<? extends HistoricIborIndexRates> beanType() {
            return HistoricIborIndexRates.class;
        }

        public Map<String, MetaProperty<?>> metaPropertyMap() {
            return this.metaPropertyMap$;
        }

        public MetaProperty<IborIndex> index() {
            return this.index;
        }

        public MetaProperty<LocalDate> valuationDate() {
            return this.valuationDate;
        }

        public MetaProperty<LocalDateDoubleTimeSeries> fixings() {
            return this.fixings;
        }

        protected Object propertyGet(Bean bean, String propertyName, boolean quiet) {
            switch (propertyName.hashCode()) {
                case 100346066: {
                    return ((HistoricIborIndexRates)bean).getIndex();
                }
                case 113107279: {
                    return ((HistoricIborIndexRates)bean).getValuationDate();
                }
                case -843784602: {
                    return ((HistoricIborIndexRates)bean).getFixings();
                }
            }
            return super.propertyGet(bean, propertyName, quiet);
        }

        protected void propertySet(Bean bean, String propertyName, Object newValue, boolean quiet) {
            this.metaProperty(propertyName);
            if (quiet) {
                return;
            }
            throw new UnsupportedOperationException("Property cannot be written: " + propertyName);
        }
    }
}

