/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.pricer.rate;

import com.google.common.collect.ComparisonChain;
import com.opengamma.strata.basics.currency.Currency;
import com.opengamma.strata.basics.currency.FxRateProvider;
import com.opengamma.strata.basics.index.PriceIndex;
import com.opengamma.strata.basics.index.PriceIndexObservation;
import com.opengamma.strata.market.sensitivity.MutablePointSensitivities;
import com.opengamma.strata.market.sensitivity.PointSensitivity;
import com.opengamma.strata.market.sensitivity.PointSensitivityBuilder;
import java.io.Serializable;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.function.DoubleUnaryOperator;
import org.joda.beans.Bean;
import org.joda.beans.BeanBuilder;
import org.joda.beans.ImmutableBean;
import org.joda.beans.JodaBeanUtils;
import org.joda.beans.MetaBean;
import org.joda.beans.MetaProperty;
import org.joda.beans.gen.BeanDefinition;
import org.joda.beans.gen.PropertyDefinition;
import org.joda.beans.impl.direct.DirectMetaBean;
import org.joda.beans.impl.direct.DirectMetaProperty;
import org.joda.beans.impl.direct.DirectMetaPropertyMap;
import org.joda.beans.impl.direct.DirectPrivateBeanBuilder;

@BeanDefinition(builderScope="private")
public final class InflationRateSensitivity
implements PointSensitivity,
PointSensitivityBuilder,
ImmutableBean,
Serializable {
    @PropertyDefinition(validate="notNull")
    private final PriceIndexObservation observation;
    @PropertyDefinition(validate="notNull", overrideGet=true)
    private final Currency currency;
    @PropertyDefinition(overrideGet=true)
    private final double sensitivity;
    private static final long serialVersionUID = 1L;

    public static InflationRateSensitivity of(PriceIndexObservation observation, double sensitivity) {
        return new InflationRateSensitivity(observation, observation.getCurrency(), sensitivity);
    }

    public static InflationRateSensitivity of(PriceIndexObservation observation, Currency sensitivityCurrency, double sensitivity) {
        return new InflationRateSensitivity(observation, sensitivityCurrency, sensitivity);
    }

    public PriceIndex getIndex() {
        return this.observation.getIndex();
    }

    public InflationRateSensitivity withCurrency(Currency currency) {
        if (this.currency.equals((Object)currency)) {
            return this;
        }
        return new InflationRateSensitivity(this.observation, currency, this.sensitivity);
    }

    public InflationRateSensitivity withSensitivity(double sensitivity) {
        return new InflationRateSensitivity(this.observation, this.currency, sensitivity);
    }

    public int compareKey(PointSensitivity other) {
        if (other instanceof InflationRateSensitivity) {
            InflationRateSensitivity otherInflation = (InflationRateSensitivity)other;
            return ComparisonChain.start().compare((Comparable)((Object)this.getIndex().toString()), (Comparable)((Object)otherInflation.getIndex().toString())).compare((Comparable)this.currency, (Comparable)otherInflation.currency).compare((Comparable)this.observation.getFixingMonth(), (Comparable)otherInflation.observation.getFixingMonth()).result();
        }
        return this.getClass().getSimpleName().compareTo(other.getClass().getSimpleName());
    }

    public InflationRateSensitivity convertedTo(Currency resultCurrency, FxRateProvider rateProvider) {
        return (InflationRateSensitivity)super.convertedTo(resultCurrency, rateProvider);
    }

    public InflationRateSensitivity multipliedBy(double factor) {
        return new InflationRateSensitivity(this.observation, this.currency, this.sensitivity * factor);
    }

    public InflationRateSensitivity mapSensitivity(DoubleUnaryOperator operator) {
        return new InflationRateSensitivity(this.observation, this.currency, operator.applyAsDouble(this.sensitivity));
    }

    public InflationRateSensitivity normalize() {
        return this;
    }

    public MutablePointSensitivities buildInto(MutablePointSensitivities combination) {
        return combination.add((PointSensitivity)this);
    }

    public InflationRateSensitivity cloned() {
        return this;
    }

    public static Meta meta() {
        return Meta.INSTANCE;
    }

    private InflationRateSensitivity(PriceIndexObservation observation, Currency currency, double sensitivity) {
        JodaBeanUtils.notNull((Object)observation, (String)"observation");
        JodaBeanUtils.notNull((Object)currency, (String)"currency");
        this.observation = observation;
        this.currency = currency;
        this.sensitivity = sensitivity;
    }

    public Meta metaBean() {
        return Meta.INSTANCE;
    }

    public PriceIndexObservation getObservation() {
        return this.observation;
    }

    public Currency getCurrency() {
        return this.currency;
    }

    public double getSensitivity() {
        return this.sensitivity;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == this.getClass()) {
            InflationRateSensitivity other = (InflationRateSensitivity)obj;
            return JodaBeanUtils.equal((Object)this.observation, (Object)other.observation) && JodaBeanUtils.equal((Object)this.currency, (Object)other.currency) && JodaBeanUtils.equal((double)this.sensitivity, (double)other.sensitivity);
        }
        return false;
    }

    public int hashCode() {
        int hash = this.getClass().hashCode();
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.observation);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.currency);
        hash = hash * 31 + JodaBeanUtils.hashCode((double)this.sensitivity);
        return hash;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(128);
        buf.append("InflationRateSensitivity{");
        buf.append("observation").append('=').append(JodaBeanUtils.toString((Object)this.observation)).append(',').append(' ');
        buf.append("currency").append('=').append(JodaBeanUtils.toString((Object)this.currency)).append(',').append(' ');
        buf.append("sensitivity").append('=').append(JodaBeanUtils.toString((Object)this.sensitivity));
        buf.append('}');
        return buf.toString();
    }

    static {
        MetaBean.register((MetaBean)Meta.INSTANCE);
    }

    private static final class Builder
    extends DirectPrivateBeanBuilder<InflationRateSensitivity> {
        private PriceIndexObservation observation;
        private Currency currency;
        private double sensitivity;

        private Builder() {
        }

        public Object get(String propertyName) {
            switch (propertyName.hashCode()) {
                case 122345516: {
                    return this.observation;
                }
                case 575402001: {
                    return this.currency;
                }
                case 564403871: {
                    return this.sensitivity;
                }
            }
            throw new NoSuchElementException("Unknown property: " + propertyName);
        }

        public Builder set(String propertyName, Object newValue) {
            switch (propertyName.hashCode()) {
                case 122345516: {
                    this.observation = (PriceIndexObservation)newValue;
                    break;
                }
                case 575402001: {
                    this.currency = (Currency)newValue;
                    break;
                }
                case 564403871: {
                    this.sensitivity = (Double)newValue;
                    break;
                }
                default: {
                    throw new NoSuchElementException("Unknown property: " + propertyName);
                }
            }
            return this;
        }

        public InflationRateSensitivity build() {
            return new InflationRateSensitivity(this.observation, this.currency, this.sensitivity);
        }

        public String toString() {
            StringBuilder buf = new StringBuilder(128);
            buf.append("InflationRateSensitivity.Builder{");
            buf.append("observation").append('=').append(JodaBeanUtils.toString((Object)this.observation)).append(',').append(' ');
            buf.append("currency").append('=').append(JodaBeanUtils.toString((Object)this.currency)).append(',').append(' ');
            buf.append("sensitivity").append('=').append(JodaBeanUtils.toString((Object)this.sensitivity));
            buf.append('}');
            return buf.toString();
        }
    }

    public static final class Meta
    extends DirectMetaBean {
        static final Meta INSTANCE = new Meta();
        private final MetaProperty<PriceIndexObservation> observation = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"observation", InflationRateSensitivity.class, PriceIndexObservation.class);
        private final MetaProperty<Currency> currency = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"currency", InflationRateSensitivity.class, Currency.class);
        private final MetaProperty<Double> sensitivity = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"sensitivity", InflationRateSensitivity.class, Double.TYPE);
        private final Map<String, MetaProperty<?>> metaPropertyMap$ = new DirectMetaPropertyMap((DirectMetaBean)this, null, new String[]{"observation", "currency", "sensitivity"});

        private Meta() {
        }

        protected MetaProperty<?> metaPropertyGet(String propertyName) {
            switch (propertyName.hashCode()) {
                case 122345516: {
                    return this.observation;
                }
                case 575402001: {
                    return this.currency;
                }
                case 564403871: {
                    return this.sensitivity;
                }
            }
            return super.metaPropertyGet(propertyName);
        }

        public BeanBuilder<? extends InflationRateSensitivity> builder() {
            return new Builder();
        }

        public Class<? extends InflationRateSensitivity> beanType() {
            return InflationRateSensitivity.class;
        }

        public Map<String, MetaProperty<?>> metaPropertyMap() {
            return this.metaPropertyMap$;
        }

        public MetaProperty<PriceIndexObservation> observation() {
            return this.observation;
        }

        public MetaProperty<Currency> currency() {
            return this.currency;
        }

        public MetaProperty<Double> sensitivity() {
            return this.sensitivity;
        }

        protected Object propertyGet(Bean bean, String propertyName, boolean quiet) {
            switch (propertyName.hashCode()) {
                case 122345516: {
                    return ((InflationRateSensitivity)bean).getObservation();
                }
                case 575402001: {
                    return ((InflationRateSensitivity)bean).getCurrency();
                }
                case 564403871: {
                    return ((InflationRateSensitivity)bean).getSensitivity();
                }
            }
            return super.propertyGet(bean, propertyName, quiet);
        }

        protected void propertySet(Bean bean, String propertyName, Object newValue, boolean quiet) {
            this.metaProperty(propertyName);
            if (quiet) {
                return;
            }
            throw new UnsupportedOperationException("Property cannot be written: " + propertyName);
        }
    }
}

