/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.pricer.rate;

import com.opengamma.strata.basics.currency.Currency;
import com.opengamma.strata.basics.index.PriceIndex;
import com.opengamma.strata.basics.index.PriceIndexObservation;
import com.opengamma.strata.collect.array.DoubleArray;
import com.opengamma.strata.collect.timeseries.LocalDateDoubleTimeSeries;
import com.opengamma.strata.market.MarketDataView;
import com.opengamma.strata.market.curve.Curve;
import com.opengamma.strata.market.param.CurrencyParameterSensitivities;
import com.opengamma.strata.market.param.ParameterPerturbation;
import com.opengamma.strata.market.param.ParameterizedData;
import com.opengamma.strata.market.sensitivity.PointSensitivityBuilder;
import com.opengamma.strata.pricer.rate.InflationRateSensitivity;
import com.opengamma.strata.pricer.rate.SimplePriceIndexValues;
import java.time.LocalDate;

public interface PriceIndexValues
extends MarketDataView,
ParameterizedData {
    public static PriceIndexValues of(PriceIndex index, LocalDate valuationDate, Curve forwardCurve, LocalDateDoubleTimeSeries fixings) {
        return SimplePriceIndexValues.of(index, valuationDate, forwardCurve, fixings);
    }

    public PriceIndex getIndex();

    public LocalDateDoubleTimeSeries getFixings();

    public PriceIndexValues withParameter(int var1, double var2);

    public PriceIndexValues withPerturbation(ParameterPerturbation var1);

    public double value(PriceIndexObservation var1);

    public PointSensitivityBuilder valuePointSensitivity(PriceIndexObservation var1);

    public CurrencyParameterSensitivities parameterSensitivity(InflationRateSensitivity var1);

    public CurrencyParameterSensitivities createParameterSensitivity(Currency var1, DoubleArray var2);
}

