/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.pricer.rate;

import com.opengamma.strata.basics.currency.Currency;
import com.opengamma.strata.basics.date.DayCount;
import com.opengamma.strata.basics.index.IborIndex;
import com.opengamma.strata.basics.index.IborIndexObservation;
import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.collect.Messages;
import com.opengamma.strata.collect.array.DoubleArray;
import com.opengamma.strata.collect.timeseries.LocalDateDoubleTimeSeries;
import com.opengamma.strata.data.MarketDataName;
import com.opengamma.strata.market.ValueType;
import com.opengamma.strata.market.curve.Curve;
import com.opengamma.strata.market.curve.CurveInfoType;
import com.opengamma.strata.market.param.CurrencyParameterSensitivities;
import com.opengamma.strata.market.param.CurrencyParameterSensitivity;
import com.opengamma.strata.market.param.ParameterMetadata;
import com.opengamma.strata.market.param.ParameterPerturbation;
import com.opengamma.strata.market.param.UnitParameterSensitivity;
import com.opengamma.strata.market.sensitivity.PointSensitivityBuilder;
import com.opengamma.strata.pricer.rate.IborIndexRates;
import com.opengamma.strata.pricer.rate.IborRateSensitivity;
import java.io.Serializable;
import java.time.LocalDate;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import org.joda.beans.Bean;
import org.joda.beans.BeanBuilder;
import org.joda.beans.ImmutableBean;
import org.joda.beans.JodaBeanUtils;
import org.joda.beans.MetaBean;
import org.joda.beans.MetaProperty;
import org.joda.beans.gen.BeanDefinition;
import org.joda.beans.gen.ImmutableConstructor;
import org.joda.beans.gen.PropertyDefinition;
import org.joda.beans.impl.direct.DirectMetaBean;
import org.joda.beans.impl.direct.DirectMetaProperty;
import org.joda.beans.impl.direct.DirectMetaPropertyMap;
import org.joda.beans.impl.direct.DirectPrivateBeanBuilder;

@BeanDefinition(builderScope="private")
public final class SimpleIborIndexRates
implements IborIndexRates,
ImmutableBean,
Serializable {
    @PropertyDefinition(validate="notNull", overrideGet=true)
    private final IborIndex index;
    @PropertyDefinition(validate="notNull", overrideGet=true)
    private final LocalDate valuationDate;
    @PropertyDefinition(validate="notNull")
    private final Curve curve;
    @PropertyDefinition(validate="notNull", overrideGet=true)
    private final LocalDateDoubleTimeSeries fixings;
    private final transient DayCount dayCount;
    private static final long serialVersionUID = 1L;

    public static SimpleIborIndexRates of(IborIndex index, LocalDate valuationDate, Curve curve) {
        return new SimpleIborIndexRates(index, valuationDate, curve, LocalDateDoubleTimeSeries.empty());
    }

    public static SimpleIborIndexRates of(IborIndex index, LocalDate valuationDate, Curve curve, LocalDateDoubleTimeSeries fixings) {
        return new SimpleIborIndexRates(index, valuationDate, curve, fixings);
    }

    @ImmutableConstructor
    private SimpleIborIndexRates(IborIndex index, LocalDate valuationDate, Curve curve, LocalDateDoubleTimeSeries fixings) {
        ArgChecker.notNull((Object)index, (String)"index");
        ArgChecker.notNull((Object)valuationDate, (String)"valuationDate");
        ArgChecker.notNull((Object)curve, (String)"curve");
        ArgChecker.notNull((Object)fixings, (String)"fixings");
        curve.getMetadata().getXValueType().checkEquals(ValueType.YEAR_FRACTION, "Incorrect x-value type for ibor curve");
        curve.getMetadata().getYValueType().checkEquals(ValueType.FORWARD_RATE, "Incorrect y-value type for ibor curve");
        DayCount dayCount = (DayCount)curve.getMetadata().findInfo(CurveInfoType.DAY_COUNT).orElseThrow(() -> new IllegalArgumentException("Incorrect curve metadata, missing DayCount"));
        this.valuationDate = valuationDate;
        this.index = index;
        this.curve = curve;
        this.fixings = fixings;
        this.dayCount = dayCount;
    }

    private Object readResolve() {
        return new SimpleIborIndexRates(this.index, this.valuationDate, this.curve, this.fixings);
    }

    public <T> Optional<T> findData(MarketDataName<T> name) {
        if (this.curve.getName().equals(name)) {
            return Optional.of(name.getMarketDataType().cast(this.curve));
        }
        return Optional.empty();
    }

    public int getParameterCount() {
        return this.curve.getParameterCount();
    }

    public double getParameter(int parameterIndex) {
        return this.curve.getParameter(parameterIndex);
    }

    public ParameterMetadata getParameterMetadata(int parameterIndex) {
        return this.curve.getParameterMetadata(parameterIndex);
    }

    public OptionalInt findParameterIndex(ParameterMetadata metadata) {
        return this.curve.findParameterIndex(metadata);
    }

    @Override
    public SimpleIborIndexRates withParameter(int parameterIndex, double newValue) {
        return this.withCurve(this.curve.withParameter(parameterIndex, newValue));
    }

    @Override
    public SimpleIborIndexRates withPerturbation(ParameterPerturbation perturbation) {
        return this.withCurve(this.curve.withPerturbation(perturbation));
    }

    @Override
    public double rate(IborIndexObservation observation) {
        if (!observation.getFixingDate().isAfter(this.getValuationDate())) {
            return this.historicRate(observation);
        }
        return this.rateIgnoringFixings(observation);
    }

    private double historicRate(IborIndexObservation observation) {
        LocalDate fixingDate = observation.getFixingDate();
        OptionalDouble fixedRate = this.fixings.get(fixingDate);
        if (fixedRate.isPresent()) {
            return fixedRate.getAsDouble();
        }
        if (fixingDate.isBefore(this.getValuationDate())) {
            if (this.fixings.isEmpty()) {
                throw new IllegalArgumentException(Messages.format((String)"Unable to get fixing for {} on date {}, no time-series supplied", (Object[])new Object[]{this.index, fixingDate}));
            }
            throw new IllegalArgumentException(Messages.format((String)"Unable to get fixing for {} on date {}", (Object[])new Object[]{this.index, fixingDate}));
        }
        return this.rateIgnoringFixings(observation);
    }

    @Override
    public double rateIgnoringFixings(IborIndexObservation observation) {
        double relativeYearFraction = this.relativeYearFraction(observation.getMaturityDate());
        return this.curve.yValue(relativeYearFraction);
    }

    @Override
    public PointSensitivityBuilder ratePointSensitivity(IborIndexObservation observation) {
        LocalDate valuationDate;
        LocalDate fixingDate = observation.getFixingDate();
        if (fixingDate.isBefore(valuationDate = this.getValuationDate()) || fixingDate.equals(valuationDate) && this.fixings.get(fixingDate).isPresent()) {
            return PointSensitivityBuilder.none();
        }
        return IborRateSensitivity.of(observation, 1.0);
    }

    @Override
    public PointSensitivityBuilder rateIgnoringFixingsPointSensitivity(IborIndexObservation observation) {
        return IborRateSensitivity.of(observation, 1.0);
    }

    @Override
    public CurrencyParameterSensitivities parameterSensitivity(IborRateSensitivity pointSensitivity) {
        LocalDate maturityDate = pointSensitivity.getObservation().getMaturityDate();
        double relativeYearFraction = this.relativeYearFraction(maturityDate);
        UnitParameterSensitivity unitSensitivity = this.curve.yValueParameterSensitivity(relativeYearFraction);
        CurrencyParameterSensitivity sensitivity = unitSensitivity.multipliedBy(pointSensitivity.getCurrency(), pointSensitivity.getSensitivity());
        return CurrencyParameterSensitivities.of((CurrencyParameterSensitivity)sensitivity);
    }

    @Override
    public CurrencyParameterSensitivities createParameterSensitivity(Currency currency, DoubleArray sensitivities) {
        return CurrencyParameterSensitivities.of((CurrencyParameterSensitivity)this.curve.createParameterSensitivity(currency, sensitivities));
    }

    public SimpleIborIndexRates withCurve(Curve curve) {
        return new SimpleIborIndexRates(this.index, this.valuationDate, curve, this.fixings);
    }

    private double relativeYearFraction(LocalDate date) {
        return this.dayCount.relativeYearFraction(this.valuationDate, date);
    }

    public static Meta meta() {
        return Meta.INSTANCE;
    }

    public Meta metaBean() {
        return Meta.INSTANCE;
    }

    @Override
    public IborIndex getIndex() {
        return this.index;
    }

    public LocalDate getValuationDate() {
        return this.valuationDate;
    }

    public Curve getCurve() {
        return this.curve;
    }

    @Override
    public LocalDateDoubleTimeSeries getFixings() {
        return this.fixings;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == this.getClass()) {
            SimpleIborIndexRates other = (SimpleIborIndexRates)obj;
            return JodaBeanUtils.equal((Object)this.index, (Object)other.index) && JodaBeanUtils.equal((Object)this.valuationDate, (Object)other.valuationDate) && JodaBeanUtils.equal((Object)this.curve, (Object)other.curve) && JodaBeanUtils.equal((Object)this.fixings, (Object)other.fixings);
        }
        return false;
    }

    public int hashCode() {
        int hash = this.getClass().hashCode();
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.index);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.valuationDate);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.curve);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.fixings);
        return hash;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(160);
        buf.append("SimpleIborIndexRates{");
        buf.append("index").append('=').append(JodaBeanUtils.toString((Object)this.index)).append(',').append(' ');
        buf.append("valuationDate").append('=').append(JodaBeanUtils.toString((Object)this.valuationDate)).append(',').append(' ');
        buf.append("curve").append('=').append(JodaBeanUtils.toString((Object)this.curve)).append(',').append(' ');
        buf.append("fixings").append('=').append(JodaBeanUtils.toString((Object)this.fixings));
        buf.append('}');
        return buf.toString();
    }

    static {
        MetaBean.register((MetaBean)Meta.INSTANCE);
    }

    private static final class Builder
    extends DirectPrivateBeanBuilder<SimpleIborIndexRates> {
        private IborIndex index;
        private LocalDate valuationDate;
        private Curve curve;
        private LocalDateDoubleTimeSeries fixings;

        private Builder() {
        }

        public Object get(String propertyName) {
            switch (propertyName.hashCode()) {
                case 100346066: {
                    return this.index;
                }
                case 113107279: {
                    return this.valuationDate;
                }
                case 95027439: {
                    return this.curve;
                }
                case -843784602: {
                    return this.fixings;
                }
            }
            throw new NoSuchElementException("Unknown property: " + propertyName);
        }

        public Builder set(String propertyName, Object newValue) {
            switch (propertyName.hashCode()) {
                case 100346066: {
                    this.index = (IborIndex)newValue;
                    break;
                }
                case 113107279: {
                    this.valuationDate = (LocalDate)newValue;
                    break;
                }
                case 95027439: {
                    this.curve = (Curve)newValue;
                    break;
                }
                case -843784602: {
                    this.fixings = (LocalDateDoubleTimeSeries)newValue;
                    break;
                }
                default: {
                    throw new NoSuchElementException("Unknown property: " + propertyName);
                }
            }
            return this;
        }

        public SimpleIborIndexRates build() {
            return new SimpleIborIndexRates(this.index, this.valuationDate, this.curve, this.fixings);
        }

        public String toString() {
            StringBuilder buf = new StringBuilder(160);
            buf.append("SimpleIborIndexRates.Builder{");
            buf.append("index").append('=').append(JodaBeanUtils.toString((Object)this.index)).append(',').append(' ');
            buf.append("valuationDate").append('=').append(JodaBeanUtils.toString((Object)this.valuationDate)).append(',').append(' ');
            buf.append("curve").append('=').append(JodaBeanUtils.toString((Object)this.curve)).append(',').append(' ');
            buf.append("fixings").append('=').append(JodaBeanUtils.toString((Object)this.fixings));
            buf.append('}');
            return buf.toString();
        }
    }

    public static final class Meta
    extends DirectMetaBean {
        static final Meta INSTANCE = new Meta();
        private final MetaProperty<IborIndex> index = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"index", SimpleIborIndexRates.class, IborIndex.class);
        private final MetaProperty<LocalDate> valuationDate = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"valuationDate", SimpleIborIndexRates.class, LocalDate.class);
        private final MetaProperty<Curve> curve = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"curve", SimpleIborIndexRates.class, Curve.class);
        private final MetaProperty<LocalDateDoubleTimeSeries> fixings = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"fixings", SimpleIborIndexRates.class, LocalDateDoubleTimeSeries.class);
        private final Map<String, MetaProperty<?>> metaPropertyMap$ = new DirectMetaPropertyMap((DirectMetaBean)this, null, new String[]{"index", "valuationDate", "curve", "fixings"});

        private Meta() {
        }

        protected MetaProperty<?> metaPropertyGet(String propertyName) {
            switch (propertyName.hashCode()) {
                case 100346066: {
                    return this.index;
                }
                case 113107279: {
                    return this.valuationDate;
                }
                case 95027439: {
                    return this.curve;
                }
                case -843784602: {
                    return this.fixings;
                }
            }
            return super.metaPropertyGet(propertyName);
        }

        public BeanBuilder<? extends SimpleIborIndexRates> builder() {
            return new Builder();
        }

        public Class<? extends SimpleIborIndexRates> beanType() {
            return SimpleIborIndexRates.class;
        }

        public Map<String, MetaProperty<?>> metaPropertyMap() {
            return this.metaPropertyMap$;
        }

        public MetaProperty<IborIndex> index() {
            return this.index;
        }

        public MetaProperty<LocalDate> valuationDate() {
            return this.valuationDate;
        }

        public MetaProperty<Curve> curve() {
            return this.curve;
        }

        public MetaProperty<LocalDateDoubleTimeSeries> fixings() {
            return this.fixings;
        }

        protected Object propertyGet(Bean bean, String propertyName, boolean quiet) {
            switch (propertyName.hashCode()) {
                case 100346066: {
                    return ((SimpleIborIndexRates)bean).getIndex();
                }
                case 113107279: {
                    return ((SimpleIborIndexRates)bean).getValuationDate();
                }
                case 95027439: {
                    return ((SimpleIborIndexRates)bean).getCurve();
                }
                case -843784602: {
                    return ((SimpleIborIndexRates)bean).getFixings();
                }
            }
            return super.propertyGet(bean, propertyName, quiet);
        }

        protected void propertySet(Bean bean, String propertyName, Object newValue, boolean quiet) {
            this.metaProperty(propertyName);
            if (quiet) {
                return;
            }
            throw new UnsupportedOperationException("Property cannot be written: " + propertyName);
        }
    }
}

