/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.pricer.rate;

import com.opengamma.strata.basics.currency.Currency;
import com.opengamma.strata.basics.index.PriceIndex;
import com.opengamma.strata.basics.index.PriceIndexObservation;
import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.collect.array.DoubleArray;
import com.opengamma.strata.collect.timeseries.LocalDateDoubleTimeSeries;
import com.opengamma.strata.data.MarketDataName;
import com.opengamma.strata.market.ValueType;
import com.opengamma.strata.market.curve.Curve;
import com.opengamma.strata.market.param.CurrencyParameterSensitivities;
import com.opengamma.strata.market.param.CurrencyParameterSensitivity;
import com.opengamma.strata.market.param.ParameterMetadata;
import com.opengamma.strata.market.param.ParameterPerturbation;
import com.opengamma.strata.market.param.UnitParameterSensitivities;
import com.opengamma.strata.market.param.UnitParameterSensitivity;
import com.opengamma.strata.market.sensitivity.PointSensitivityBuilder;
import com.opengamma.strata.pricer.rate.InflationRateSensitivity;
import com.opengamma.strata.pricer.rate.PriceIndexValues;
import java.io.Serializable;
import java.time.LocalDate;
import java.time.YearMonth;
import java.time.temporal.ChronoUnit;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import org.joda.beans.Bean;
import org.joda.beans.BeanBuilder;
import org.joda.beans.ImmutableBean;
import org.joda.beans.JodaBeanUtils;
import org.joda.beans.MetaBean;
import org.joda.beans.MetaProperty;
import org.joda.beans.gen.BeanDefinition;
import org.joda.beans.gen.ImmutableConstructor;
import org.joda.beans.gen.PropertyDefinition;
import org.joda.beans.impl.direct.DirectMetaBean;
import org.joda.beans.impl.direct.DirectMetaProperty;
import org.joda.beans.impl.direct.DirectMetaPropertyMap;
import org.joda.beans.impl.direct.DirectPrivateBeanBuilder;

@BeanDefinition(builderScope="private")
public final class SimplePriceIndexValues
implements PriceIndexValues,
ImmutableBean,
Serializable {
    @PropertyDefinition(validate="notNull", overrideGet=true)
    private final PriceIndex index;
    @PropertyDefinition(validate="notNull", overrideGet=true)
    private final LocalDate valuationDate;
    @PropertyDefinition(validate="notNull")
    private final Curve curve;
    @PropertyDefinition(validate="notNull", overrideGet=true)
    private final LocalDateDoubleTimeSeries fixings;
    private static final long serialVersionUID = 1L;

    public static SimplePriceIndexValues of(PriceIndex index, LocalDate valuationDate, Curve curve, LocalDateDoubleTimeSeries fixings) {
        return new SimplePriceIndexValues(index, valuationDate, curve, fixings);
    }

    @ImmutableConstructor
    private SimplePriceIndexValues(PriceIndex index, LocalDate valuationDate, Curve curve, LocalDateDoubleTimeSeries fixings) {
        ArgChecker.isFalse((boolean)fixings.isEmpty(), (String)"Fixings must not be empty");
        curve.getMetadata().getXValueType().checkEquals(ValueType.MONTHS, "Incorrect x-value type for price curve");
        curve.getMetadata().getYValueType().checkEquals(ValueType.PRICE_INDEX, "Incorrect y-value type for price curve");
        this.index = (PriceIndex)ArgChecker.notNull((Object)index, (String)"index");
        this.valuationDate = (LocalDate)ArgChecker.notNull((Object)valuationDate, (String)"valuationDate");
        this.fixings = (LocalDateDoubleTimeSeries)ArgChecker.notNull((Object)fixings, (String)"fixings");
        this.curve = (Curve)ArgChecker.notNull((Object)curve, (String)"curve");
    }

    public <T> Optional<T> findData(MarketDataName<T> name) {
        if (this.curve.getName().equals(name)) {
            return Optional.of(name.getMarketDataType().cast(this.curve));
        }
        return Optional.empty();
    }

    public int getParameterCount() {
        return this.curve.getParameterCount();
    }

    public double getParameter(int parameterIndex) {
        return this.curve.getParameter(parameterIndex);
    }

    public ParameterMetadata getParameterMetadata(int parameterIndex) {
        return this.curve.getParameterMetadata(parameterIndex);
    }

    public OptionalInt findParameterIndex(ParameterMetadata metadata) {
        return this.curve.findParameterIndex(metadata);
    }

    @Override
    public SimplePriceIndexValues withParameter(int parameterIndex, double newValue) {
        return this.withCurve(this.curve.withParameter(parameterIndex, newValue));
    }

    @Override
    public SimplePriceIndexValues withPerturbation(ParameterPerturbation perturbation) {
        return this.withCurve(this.curve.withPerturbation(perturbation));
    }

    @Override
    public double value(PriceIndexObservation observation) {
        OptionalDouble fixing;
        YearMonth fixingMonth = observation.getFixingMonth();
        if (fixingMonth.isBefore(YearMonth.from(this.valuationDate)) && (fixing = this.fixings.get(fixingMonth.atEndOfMonth())).isPresent()) {
            return fixing.getAsDouble();
        }
        double nbMonth = this.numberOfMonths(fixingMonth);
        return this.curve.yValue(nbMonth);
    }

    @Override
    public PointSensitivityBuilder valuePointSensitivity(PriceIndexObservation observation) {
        YearMonth fixingMonth = observation.getFixingMonth();
        if (fixingMonth.isBefore(YearMonth.from(this.valuationDate)) && this.fixings.get(fixingMonth.atEndOfMonth()).isPresent()) {
            return PointSensitivityBuilder.none();
        }
        return InflationRateSensitivity.of(observation, 1.0);
    }

    @Override
    public CurrencyParameterSensitivities parameterSensitivity(InflationRateSensitivity pointSensitivity) {
        UnitParameterSensitivities sens = this.unitParameterSensitivity(pointSensitivity.getObservation().getFixingMonth());
        return sens.multipliedBy(pointSensitivity.getCurrency(), pointSensitivity.getSensitivity());
    }

    private UnitParameterSensitivities unitParameterSensitivity(YearMonth month) {
        if (month.isBefore(YearMonth.from(this.valuationDate)) && this.fixings.get(month.atEndOfMonth()).isPresent()) {
            return UnitParameterSensitivities.empty();
        }
        double nbMonth = this.numberOfMonths(month);
        return UnitParameterSensitivities.of((UnitParameterSensitivity)this.curve.yValueParameterSensitivity(nbMonth));
    }

    @Override
    public CurrencyParameterSensitivities createParameterSensitivity(Currency currency, DoubleArray sensitivities) {
        return CurrencyParameterSensitivities.of((CurrencyParameterSensitivity)this.curve.createParameterSensitivity(currency, sensitivities));
    }

    public SimplePriceIndexValues withCurve(Curve curve) {
        return new SimplePriceIndexValues(this.index, this.valuationDate, curve, this.fixings);
    }

    private double numberOfMonths(YearMonth month) {
        return YearMonth.from(this.valuationDate).until(month, ChronoUnit.MONTHS);
    }

    public static Meta meta() {
        return Meta.INSTANCE;
    }

    public Meta metaBean() {
        return Meta.INSTANCE;
    }

    @Override
    public PriceIndex getIndex() {
        return this.index;
    }

    public LocalDate getValuationDate() {
        return this.valuationDate;
    }

    public Curve getCurve() {
        return this.curve;
    }

    @Override
    public LocalDateDoubleTimeSeries getFixings() {
        return this.fixings;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == this.getClass()) {
            SimplePriceIndexValues other = (SimplePriceIndexValues)obj;
            return JodaBeanUtils.equal((Object)this.index, (Object)other.index) && JodaBeanUtils.equal((Object)this.valuationDate, (Object)other.valuationDate) && JodaBeanUtils.equal((Object)this.curve, (Object)other.curve) && JodaBeanUtils.equal((Object)this.fixings, (Object)other.fixings);
        }
        return false;
    }

    public int hashCode() {
        int hash = this.getClass().hashCode();
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.index);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.valuationDate);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.curve);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.fixings);
        return hash;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(160);
        buf.append("SimplePriceIndexValues{");
        buf.append("index").append('=').append(JodaBeanUtils.toString((Object)this.index)).append(',').append(' ');
        buf.append("valuationDate").append('=').append(JodaBeanUtils.toString((Object)this.valuationDate)).append(',').append(' ');
        buf.append("curve").append('=').append(JodaBeanUtils.toString((Object)this.curve)).append(',').append(' ');
        buf.append("fixings").append('=').append(JodaBeanUtils.toString((Object)this.fixings));
        buf.append('}');
        return buf.toString();
    }

    static {
        MetaBean.register((MetaBean)Meta.INSTANCE);
    }

    private static final class Builder
    extends DirectPrivateBeanBuilder<SimplePriceIndexValues> {
        private PriceIndex index;
        private LocalDate valuationDate;
        private Curve curve;
        private LocalDateDoubleTimeSeries fixings;

        private Builder() {
        }

        public Object get(String propertyName) {
            switch (propertyName.hashCode()) {
                case 100346066: {
                    return this.index;
                }
                case 113107279: {
                    return this.valuationDate;
                }
                case 95027439: {
                    return this.curve;
                }
                case -843784602: {
                    return this.fixings;
                }
            }
            throw new NoSuchElementException("Unknown property: " + propertyName);
        }

        public Builder set(String propertyName, Object newValue) {
            switch (propertyName.hashCode()) {
                case 100346066: {
                    this.index = (PriceIndex)newValue;
                    break;
                }
                case 113107279: {
                    this.valuationDate = (LocalDate)newValue;
                    break;
                }
                case 95027439: {
                    this.curve = (Curve)newValue;
                    break;
                }
                case -843784602: {
                    this.fixings = (LocalDateDoubleTimeSeries)newValue;
                    break;
                }
                default: {
                    throw new NoSuchElementException("Unknown property: " + propertyName);
                }
            }
            return this;
        }

        public SimplePriceIndexValues build() {
            return new SimplePriceIndexValues(this.index, this.valuationDate, this.curve, this.fixings);
        }

        public String toString() {
            StringBuilder buf = new StringBuilder(160);
            buf.append("SimplePriceIndexValues.Builder{");
            buf.append("index").append('=').append(JodaBeanUtils.toString((Object)this.index)).append(',').append(' ');
            buf.append("valuationDate").append('=').append(JodaBeanUtils.toString((Object)this.valuationDate)).append(',').append(' ');
            buf.append("curve").append('=').append(JodaBeanUtils.toString((Object)this.curve)).append(',').append(' ');
            buf.append("fixings").append('=').append(JodaBeanUtils.toString((Object)this.fixings));
            buf.append('}');
            return buf.toString();
        }
    }

    public static final class Meta
    extends DirectMetaBean {
        static final Meta INSTANCE = new Meta();
        private final MetaProperty<PriceIndex> index = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"index", SimplePriceIndexValues.class, PriceIndex.class);
        private final MetaProperty<LocalDate> valuationDate = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"valuationDate", SimplePriceIndexValues.class, LocalDate.class);
        private final MetaProperty<Curve> curve = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"curve", SimplePriceIndexValues.class, Curve.class);
        private final MetaProperty<LocalDateDoubleTimeSeries> fixings = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"fixings", SimplePriceIndexValues.class, LocalDateDoubleTimeSeries.class);
        private final Map<String, MetaProperty<?>> metaPropertyMap$ = new DirectMetaPropertyMap((DirectMetaBean)this, null, new String[]{"index", "valuationDate", "curve", "fixings"});

        private Meta() {
        }

        protected MetaProperty<?> metaPropertyGet(String propertyName) {
            switch (propertyName.hashCode()) {
                case 100346066: {
                    return this.index;
                }
                case 113107279: {
                    return this.valuationDate;
                }
                case 95027439: {
                    return this.curve;
                }
                case -843784602: {
                    return this.fixings;
                }
            }
            return super.metaPropertyGet(propertyName);
        }

        public BeanBuilder<? extends SimplePriceIndexValues> builder() {
            return new Builder();
        }

        public Class<? extends SimplePriceIndexValues> beanType() {
            return SimplePriceIndexValues.class;
        }

        public Map<String, MetaProperty<?>> metaPropertyMap() {
            return this.metaPropertyMap$;
        }

        public MetaProperty<PriceIndex> index() {
            return this.index;
        }

        public MetaProperty<LocalDate> valuationDate() {
            return this.valuationDate;
        }

        public MetaProperty<Curve> curve() {
            return this.curve;
        }

        public MetaProperty<LocalDateDoubleTimeSeries> fixings() {
            return this.fixings;
        }

        protected Object propertyGet(Bean bean, String propertyName, boolean quiet) {
            switch (propertyName.hashCode()) {
                case 100346066: {
                    return ((SimplePriceIndexValues)bean).getIndex();
                }
                case 113107279: {
                    return ((SimplePriceIndexValues)bean).getValuationDate();
                }
                case 95027439: {
                    return ((SimplePriceIndexValues)bean).getCurve();
                }
                case -843784602: {
                    return ((SimplePriceIndexValues)bean).getFixings();
                }
            }
            return super.propertyGet(bean, propertyName, quiet);
        }

        protected void propertySet(Bean bean, String propertyName, Object newValue, boolean quiet) {
            this.metaProperty(propertyName);
            if (quiet) {
                return;
            }
            throw new UnsupportedOperationException("Property cannot be written: " + propertyName);
        }
    }
}

