/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.pricer.sensitivity;

import com.google.common.collect.ImmutableList;
import com.opengamma.strata.basics.currency.Currency;
import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.collect.array.DoubleArray;
import com.opengamma.strata.collect.array.DoubleMatrix;
import com.opengamma.strata.collect.array.Matrix;
import com.opengamma.strata.data.MarketDataName;
import com.opengamma.strata.market.curve.CurveParameterSize;
import com.opengamma.strata.market.param.CurrencyParameterSensitivities;
import com.opengamma.strata.market.param.CurrencyParameterSensitivity;
import com.opengamma.strata.market.param.DatedParameterMetadata;
import com.opengamma.strata.market.param.LabelDateParameterMetadata;
import com.opengamma.strata.market.param.ParameterMetadata;
import com.opengamma.strata.market.param.TenorParameterMetadata;
import com.opengamma.strata.math.impl.matrix.CommonsMatrixAlgebra;
import com.opengamma.strata.math.impl.matrix.MatrixAlgebra;
import com.opengamma.strata.product.ResolvedTrade;
import java.time.LocalDate;
import java.time.temporal.TemporalAmount;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;

public class CurveSensitivityUtils {
    private static final MatrixAlgebra MATRIX_ALGEBRA = new CommonsMatrixAlgebra();

    public static DoubleMatrix jacobianFromMarketQuoteSensitivities(List<CurveParameterSize> curveOrder, List<CurrencyParameterSensitivities> marketQuoteSensitivities) {
        Currency ccy = ((CurrencyParameterSensitivity)marketQuoteSensitivities.get(0).getSensitivities().get(0)).getCurrency();
        DoubleMatrix jacobianMatrix = DoubleMatrix.ofArrayObjects((int)marketQuoteSensitivities.size(), (int)marketQuoteSensitivities.size(), i -> CurveSensitivityUtils.row(curveOrder, (CurrencyParameterSensitivities)marketQuoteSensitivities.get(i), ccy));
        return MATRIX_ALGEBRA.getInverse((Matrix)jacobianMatrix);
    }

    private static DoubleArray row(List<CurveParameterSize> curveOrder, CurrencyParameterSensitivities parameterSensitivities, Currency ccy) {
        DoubleArray row = DoubleArray.EMPTY;
        for (CurveParameterSize curveNameAndSize : curveOrder) {
            Optional sensitivityOneCurve = parameterSensitivities.findSensitivity((MarketDataName)curveNameAndSize.getName(), ccy);
            if (sensitivityOneCurve.isPresent()) {
                row = row.concat(((CurrencyParameterSensitivity)sensitivityOneCurve.get()).getSensitivity());
                continue;
            }
            row = row.concat(DoubleArray.filled((int)curveNameAndSize.getParameterCount()));
        }
        return row;
    }

    public static DoubleMatrix jacobianFromMarketQuoteSensitivities(List<CurveParameterSize> curveOrder, List<ResolvedTrade> trades, Function<ResolvedTrade, CurrencyParameterSensitivities> sensitivityFunction) {
        ArrayList<CurrencyParameterSensitivities> marketQuoteSensitivities = new ArrayList<CurrencyParameterSensitivities>();
        for (ResolvedTrade t : trades) {
            marketQuoteSensitivities.add(sensitivityFunction.apply(t));
        }
        return CurveSensitivityUtils.jacobianFromMarketQuoteSensitivities(curveOrder, marketQuoteSensitivities);
    }

    public static CurrencyParameterSensitivities linearRebucketing(CurrencyParameterSensitivities sensitivities, List<LocalDate> targetDates) {
        CurveSensitivityUtils.checkSortedDates(targetDates);
        int nbBuckets = targetDates.size();
        List pmdTarget = targetDates.stream().map(date -> LabelDateParameterMetadata.of((LocalDate)date, (String)date.toString())).collect(Collectors.toList());
        ImmutableList sensitivitiesList = sensitivities.getSensitivities();
        ArrayList<CurrencyParameterSensitivity> sensitivityTarget = new ArrayList<CurrencyParameterSensitivity>();
        for (CurrencyParameterSensitivity sensitivity : sensitivitiesList) {
            double[] rebucketedSensitivityAmounts = new double[nbBuckets];
            DoubleArray sensitivityAmounts = sensitivity.getSensitivity();
            ImmutableList parameterMetadataList = sensitivity.getParameterMetadata();
            for (int loopnode = 0; loopnode < sensitivityAmounts.size(); ++loopnode) {
                ParameterMetadata nodeMetadata = (ParameterMetadata)parameterMetadataList.get(loopnode);
                ArgChecker.isTrue((boolean)(nodeMetadata instanceof DatedParameterMetadata), (String)"re-bucketing requires sensitivity date for node {} which is of type {} while 'DatedParameterMetadata' is expected", (Object[])new Object[]{nodeMetadata.getLabel(), nodeMetadata.getClass().getName()});
                DatedParameterMetadata datedParameterMetadata = (DatedParameterMetadata)nodeMetadata;
                LocalDate nodeDate = datedParameterMetadata.getDate();
                CurveSensitivityUtils.rebucketingArray(targetDates, rebucketedSensitivityAmounts, sensitivityAmounts.get(loopnode), nodeDate);
            }
            CurrencyParameterSensitivity rebucketedSensitivity = CurrencyParameterSensitivity.of((MarketDataName)sensitivity.getMarketDataName(), pmdTarget, (Currency)sensitivity.getCurrency(), (DoubleArray)DoubleArray.ofUnsafe((double[])rebucketedSensitivityAmounts));
            sensitivityTarget.add(rebucketedSensitivity);
        }
        return CurrencyParameterSensitivities.of(sensitivityTarget);
    }

    public static CurrencyParameterSensitivities linearRebucketing(CurrencyParameterSensitivities sensitivities, List<LocalDate> targetDates, LocalDate sensitivityDate) {
        CurveSensitivityUtils.checkSortedDates(targetDates);
        int nbBuckets = targetDates.size();
        List pmdTarget = targetDates.stream().map(date -> LabelDateParameterMetadata.of((LocalDate)date, (String)date.toString())).collect(Collectors.toList());
        ImmutableList sensitivitiesList = sensitivities.getSensitivities();
        ArrayList<CurrencyParameterSensitivity> sensitivityTarget = new ArrayList<CurrencyParameterSensitivity>();
        for (CurrencyParameterSensitivity sensitivity : sensitivitiesList) {
            double[] rebucketedSensitivityAmounts = new double[nbBuckets];
            DoubleArray sensitivityAmounts = sensitivity.getSensitivity();
            ImmutableList parameterMetadataList = sensitivity.getParameterMetadata();
            for (int loopnode = 0; loopnode < sensitivityAmounts.size(); ++loopnode) {
                LocalDate nodeDate;
                ParameterMetadata nodeMetadata = (ParameterMetadata)parameterMetadataList.get(loopnode);
                ArgChecker.isTrue((nodeMetadata instanceof DatedParameterMetadata || nodeMetadata instanceof TenorParameterMetadata ? 1 : 0) != 0, (String)"re-bucketing requires sensitivity date or node for node {} which is of type {}", (Object[])new Object[]{nodeMetadata.getLabel(), nodeMetadata.getClass().getName()});
                if (nodeMetadata instanceof DatedParameterMetadata) {
                    DatedParameterMetadata datedParameterMetadata = (DatedParameterMetadata)nodeMetadata;
                    nodeDate = datedParameterMetadata.getDate();
                } else {
                    TenorParameterMetadata tenorParameterMetadata = (TenorParameterMetadata)nodeMetadata;
                    nodeDate = sensitivityDate.plus((TemporalAmount)tenorParameterMetadata.getTenor());
                }
                CurveSensitivityUtils.rebucketingArray(targetDates, rebucketedSensitivityAmounts, sensitivityAmounts.get(loopnode), nodeDate);
            }
            CurrencyParameterSensitivity rebucketedSensitivity = CurrencyParameterSensitivity.of((MarketDataName)sensitivity.getMarketDataName(), pmdTarget, (Currency)sensitivity.getCurrency(), (DoubleArray)DoubleArray.ofUnsafe((double[])rebucketedSensitivityAmounts));
            sensitivityTarget.add(rebucketedSensitivity);
        }
        return CurrencyParameterSensitivities.of(sensitivityTarget);
    }

    private static void rebucketingArray(List<LocalDate> targetDates, double[] rebucketedSensitivityAmounts, double sensitivityAmount, LocalDate sensitivityDate) {
        int nbBuckets = targetDates.size();
        if (!sensitivityDate.isAfter(targetDates.get(0))) {
            rebucketedSensitivityAmounts[0] = rebucketedSensitivityAmounts[0] + sensitivityAmount;
        } else if (!sensitivityDate.isBefore(targetDates.get(nbBuckets - 1))) {
            int n = nbBuckets - 1;
            rebucketedSensitivityAmounts[n] = rebucketedSensitivityAmounts[n] + sensitivityAmount;
        } else {
            int indexSensitivityDate = 0;
            while (sensitivityDate.isAfter(targetDates.get(indexSensitivityDate))) {
                ++indexSensitivityDate;
            }
            long intervalLength = targetDates.get(indexSensitivityDate).toEpochDay() - targetDates.get(indexSensitivityDate - 1).toEpochDay();
            double weight = (double)(targetDates.get(indexSensitivityDate).toEpochDay() - sensitivityDate.toEpochDay()) / (double)intervalLength;
            int n = indexSensitivityDate - 1;
            rebucketedSensitivityAmounts[n] = rebucketedSensitivityAmounts[n] + weight * sensitivityAmount;
            int n2 = indexSensitivityDate;
            rebucketedSensitivityAmounts[n2] = rebucketedSensitivityAmounts[n2] + (1.0 - weight) * sensitivityAmount;
        }
    }

    private static void checkSortedDates(List<LocalDate> dates) {
        for (int loopdate = 0; loopdate < dates.size() - 1; ++loopdate) {
            ArgChecker.inOrderNotEqual((Comparable)dates.get(loopdate), (Object)dates.get(loopdate + 1), (String)"first date", (String)"following date");
        }
    }

    private CurveSensitivityUtils() {
    }
}

