/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.pricer.sensitivity;

import com.opengamma.strata.basics.currency.Currency;
import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.collect.array.DoubleArray;
import com.opengamma.strata.data.MarketDataName;
import com.opengamma.strata.market.curve.Curve;
import com.opengamma.strata.market.curve.CurveInfoType;
import com.opengamma.strata.market.curve.CurveName;
import com.opengamma.strata.market.param.CurrencyParameterSensitivities;
import com.opengamma.strata.market.param.CurrencyParameterSensitivity;
import com.opengamma.strata.pricer.rate.RatesProvider;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

public class NotionalEquivalentCalculator {
    public static final NotionalEquivalentCalculator DEFAULT = new NotionalEquivalentCalculator();

    public CurrencyParameterSensitivities notionalEquivalent(CurrencyParameterSensitivities marketQuoteSensitivities, RatesProvider provider) {
        ArrayList<CurrencyParameterSensitivity> equivalentList = new ArrayList<CurrencyParameterSensitivity>();
        for (CurrencyParameterSensitivity s : marketQuoteSensitivities.getSensitivities()) {
            ArgChecker.isTrue((boolean)(s.getMarketDataName() instanceof CurveName), (String)"curve name");
            CurveName name = (CurveName)s.getMarketDataName();
            Optional curveOpt = provider.findData(name);
            ArgChecker.isTrue((boolean)curveOpt.isPresent(), (String)"Curve {} in the sensitiivty is not present in the provider", (Object[])new Object[]{name});
            Curve curve = (Curve)curveOpt.get();
            Optional pvSensiOpt = curve.getMetadata().findInfo(CurveInfoType.PV_SENSITIVITY_TO_MARKET_QUOTE);
            ArgChecker.isTrue((boolean)pvSensiOpt.isPresent(), (String)"Present value sensitivity curve info is required");
            DoubleArray pvSensi = (DoubleArray)pvSensiOpt.get();
            double[] notionalArray = new double[pvSensi.size()];
            for (int i = 0; i < pvSensi.size(); ++i) {
                notionalArray[i] = s.getSensitivity().get(i) / pvSensi.get(i);
            }
            DoubleArray notional = DoubleArray.ofUnsafe((double[])notionalArray);
            equivalentList.add(CurrencyParameterSensitivity.of((MarketDataName)name, (List)s.getParameterMetadata(), (Currency)s.getCurrency(), (DoubleArray)notional));
        }
        return CurrencyParameterSensitivities.of(equivalentList);
    }
}

