/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.pricer.sensitivity;

import com.google.common.collect.ImmutableMap;
import com.opengamma.strata.basics.currency.Currency;
import com.opengamma.strata.basics.currency.CurrencyAmount;
import com.opengamma.strata.basics.index.Index;
import com.opengamma.strata.collect.array.DoubleArray;
import com.opengamma.strata.collect.tuple.Pair;
import com.opengamma.strata.market.curve.Curve;
import com.opengamma.strata.market.curve.NodalCurve;
import com.opengamma.strata.market.param.CurrencyParameterSensitivities;
import com.opengamma.strata.pricer.DiscountFactors;
import com.opengamma.strata.pricer.SimpleDiscountFactors;
import com.opengamma.strata.pricer.ZeroRateDiscountFactors;
import com.opengamma.strata.pricer.bond.ImmutableLegalEntityDiscountingProvider;
import com.opengamma.strata.pricer.bond.LegalEntityDiscountingProvider;
import com.opengamma.strata.pricer.credit.CreditDiscountFactors;
import com.opengamma.strata.pricer.credit.CreditRatesProvider;
import com.opengamma.strata.pricer.credit.ImmutableCreditRatesProvider;
import com.opengamma.strata.pricer.credit.IsdaCreditDiscountFactors;
import com.opengamma.strata.pricer.credit.LegalEntitySurvivalProbabilities;
import com.opengamma.strata.pricer.rate.ImmutableRatesProvider;
import com.opengamma.strata.pricer.rate.RatesProvider;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.joda.beans.Bean;
import org.joda.beans.MetaProperty;

public class RatesFiniteDifferenceSensitivityCalculator {
    public static final RatesFiniteDifferenceSensitivityCalculator DEFAULT = new RatesFiniteDifferenceSensitivityCalculator(1.0E-4);
    private final double shift;

    public RatesFiniteDifferenceSensitivityCalculator(double shift) {
        this.shift = shift;
    }

    public CurrencyParameterSensitivities sensitivity(RatesProvider provider, Function<ImmutableRatesProvider, CurrencyAmount> valueFn) {
        ImmutableRatesProvider immProv = provider.toImmutableRatesProvider();
        CurrencyAmount valueInit = valueFn.apply(immProv);
        CurrencyParameterSensitivities discounting = this.sensitivity(immProv, (Map)immProv.getDiscountCurves(), (base, bumped) -> base.toBuilder().discountCurves((Map<Currency, ? extends Curve>)bumped).build(), valueFn, valueInit);
        CurrencyParameterSensitivities forward = this.sensitivity(immProv, (Map)immProv.getIndexCurves(), (base, bumped) -> base.toBuilder().indexCurves((Map<? extends Index, ? extends Curve>)bumped).build(), valueFn, valueInit);
        return discounting.combinedWith(forward);
    }

    private <T> CurrencyParameterSensitivities sensitivity(ImmutableRatesProvider provider, Map<T, Curve> baseCurves, BiFunction<ImmutableRatesProvider, Map<T, Curve>, ImmutableRatesProvider> storeBumpedFn, Function<ImmutableRatesProvider, CurrencyAmount> valueFn, CurrencyAmount valueInit) {
        CurrencyParameterSensitivities result = CurrencyParameterSensitivities.empty();
        for (Map.Entry entry : baseCurves.entrySet()) {
            Curve curve = entry.getValue();
            DoubleArray sensitivity = DoubleArray.of((int)curve.getParameterCount(), i -> {
                Curve dscBumped = curve.withParameter(i, curve.getParameter(i) + this.shift);
                HashMap mapBumped = new HashMap(baseCurves);
                mapBumped.put(entry.getKey(), dscBumped);
                ImmutableRatesProvider providerDscBumped = (ImmutableRatesProvider)storeBumpedFn.apply(provider, mapBumped);
                return (((CurrencyAmount)valueFn.apply(providerDscBumped)).getAmount() - valueInit.getAmount()) / this.shift;
            });
            result = result.combinedWith(curve.createParameterSensitivity(valueInit.getCurrency(), sensitivity));
        }
        return result;
    }

    public CurrencyParameterSensitivities sensitivity(LegalEntityDiscountingProvider provider, Function<ImmutableLegalEntityDiscountingProvider, CurrencyAmount> valueFn) {
        ImmutableLegalEntityDiscountingProvider immProv = provider.toImmutableLegalEntityDiscountingProvider();
        CurrencyAmount valueInit = valueFn.apply(immProv);
        CurrencyParameterSensitivities discounting = this.sensitivity(immProv, valueFn, ImmutableLegalEntityDiscountingProvider.meta().repoCurves(), valueInit);
        CurrencyParameterSensitivities forward = this.sensitivity(immProv, valueFn, ImmutableLegalEntityDiscountingProvider.meta().issuerCurves(), valueInit);
        return discounting.combinedWith(forward);
    }

    private <T> CurrencyParameterSensitivities sensitivity(ImmutableLegalEntityDiscountingProvider provider, Function<ImmutableLegalEntityDiscountingProvider, CurrencyAmount> valueFn, MetaProperty<ImmutableMap<Pair<T, Currency>, DiscountFactors>> metaProperty, CurrencyAmount valueInit) {
        ImmutableMap baseCurves = (ImmutableMap)metaProperty.get((Bean)provider);
        CurrencyParameterSensitivities result = CurrencyParameterSensitivities.empty();
        for (Pair key : baseCurves.keySet()) {
            DiscountFactors discountFactors = (DiscountFactors)baseCurves.get((Object)key);
            Curve curve = this.checkDiscountFactors(discountFactors);
            int paramCount = curve.getParameterCount();
            double[] sensitivity = new double[paramCount];
            for (int i = 0; i < paramCount; ++i) {
                Curve dscBumped = curve.withParameter(i, curve.getParameter(i) + this.shift);
                HashMap<Pair, DiscountFactors> mapBumped = new HashMap<Pair, DiscountFactors>((Map<Pair, DiscountFactors>)baseCurves);
                mapBumped.put(key, this.createDiscountFactors(discountFactors, dscBumped));
                ImmutableLegalEntityDiscountingProvider providerDscBumped = provider.toBuilder().set(metaProperty, (Object)mapBumped).build();
                sensitivity[i] = (valueFn.apply(providerDscBumped).getAmount() - valueInit.getAmount()) / this.shift;
            }
            result = result.combinedWith(curve.createParameterSensitivity(valueInit.getCurrency(), DoubleArray.copyOf((double[])sensitivity)));
        }
        return result;
    }

    public CurrencyParameterSensitivities sensitivity(CreditRatesProvider provider, Function<ImmutableCreditRatesProvider, CurrencyAmount> valueFn) {
        ImmutableCreditRatesProvider immutableProvider = provider.toImmutableCreditRatesProvider();
        CurrencyAmount valueInit = valueFn.apply(immutableProvider);
        CurrencyParameterSensitivities discounting = this.sensitivityDiscountCurve(immutableProvider, valueFn, ImmutableCreditRatesProvider.meta().discountCurves(), valueInit);
        CurrencyParameterSensitivities credit = this.sensitivityCreidtCurve(immutableProvider, valueFn, ImmutableCreditRatesProvider.meta().creditCurves(), valueInit);
        return discounting.combinedWith(credit);
    }

    private <T> CurrencyParameterSensitivities sensitivityDiscountCurve(ImmutableCreditRatesProvider provider, Function<ImmutableCreditRatesProvider, CurrencyAmount> valueFn, MetaProperty<ImmutableMap<T, CreditDiscountFactors>> metaProperty, CurrencyAmount valueInit) {
        ImmutableMap baseCurves = (ImmutableMap)metaProperty.get((Bean)provider);
        CurrencyParameterSensitivities result = CurrencyParameterSensitivities.empty();
        for (Object key : baseCurves.keySet()) {
            CreditDiscountFactors creditDiscountFactors = (CreditDiscountFactors)baseCurves.get(key);
            DiscountFactors discountFactors = creditDiscountFactors.toDiscountFactors();
            Curve curve = this.checkDiscountFactors(discountFactors);
            int paramCount = curve.getParameterCount();
            double[] sensitivity = new double[paramCount];
            for (int i = 0; i < paramCount; ++i) {
                Curve dscBumped = curve.withParameter(i, curve.getParameter(i) + this.shift);
                HashMap mapBumped = new HashMap(baseCurves);
                mapBumped.put(key, this.createCreditDiscountFactors(creditDiscountFactors, dscBumped));
                ImmutableCreditRatesProvider providerDscBumped = provider.toBuilder().set(metaProperty, (Object)mapBumped).build();
                sensitivity[i] = (valueFn.apply(providerDscBumped).getAmount() - valueInit.getAmount()) / this.shift;
            }
            result = result.combinedWith(curve.createParameterSensitivity(valueInit.getCurrency(), DoubleArray.copyOf((double[])sensitivity)));
        }
        return result;
    }

    private <T> CurrencyParameterSensitivities sensitivityCreidtCurve(ImmutableCreditRatesProvider provider, Function<ImmutableCreditRatesProvider, CurrencyAmount> valueFn, MetaProperty<ImmutableMap<T, LegalEntitySurvivalProbabilities>> metaProperty, CurrencyAmount valueInit) {
        ImmutableMap baseCurves = (ImmutableMap)metaProperty.get((Bean)provider);
        CurrencyParameterSensitivities result = CurrencyParameterSensitivities.empty();
        for (Object key : baseCurves.keySet()) {
            LegalEntitySurvivalProbabilities credit = (LegalEntitySurvivalProbabilities)baseCurves.get(key);
            CreditDiscountFactors creditDiscountFactors = credit.getSurvivalProbabilities();
            DiscountFactors discountFactors = creditDiscountFactors.toDiscountFactors();
            Curve curve = this.checkDiscountFactors(discountFactors);
            int paramCount = curve.getParameterCount();
            double[] sensitivity = new double[paramCount];
            for (int i = 0; i < paramCount; ++i) {
                Curve dscBumped = curve.withParameter(i, curve.getParameter(i) + this.shift);
                HashMap mapBumped = new HashMap(baseCurves);
                mapBumped.put(key, LegalEntitySurvivalProbabilities.of(credit.getLegalEntityId(), this.createCreditDiscountFactors(creditDiscountFactors, dscBumped)));
                ImmutableCreditRatesProvider providerDscBumped = provider.toBuilder().set(metaProperty, (Object)mapBumped).build();
                sensitivity[i] = (valueFn.apply(providerDscBumped).getAmount() - valueInit.getAmount()) / this.shift;
            }
            result = result.combinedWith(curve.createParameterSensitivity(valueInit.getCurrency(), DoubleArray.copyOf((double[])sensitivity)));
        }
        return result;
    }

    private Curve checkDiscountFactors(DiscountFactors discountFactors) {
        if (discountFactors instanceof ZeroRateDiscountFactors) {
            return ((ZeroRateDiscountFactors)discountFactors).getCurve();
        }
        if (discountFactors instanceof SimpleDiscountFactors) {
            return ((SimpleDiscountFactors)discountFactors).getCurve();
        }
        throw new IllegalArgumentException("Not supported");
    }

    private DiscountFactors createDiscountFactors(DiscountFactors originalDsc, Curve bumpedCurve) {
        if (originalDsc instanceof ZeroRateDiscountFactors) {
            return ZeroRateDiscountFactors.of(originalDsc.getCurrency(), originalDsc.getValuationDate(), bumpedCurve);
        }
        if (originalDsc instanceof SimpleDiscountFactors) {
            return SimpleDiscountFactors.of(originalDsc.getCurrency(), originalDsc.getValuationDate(), bumpedCurve);
        }
        throw new IllegalArgumentException("Not supported");
    }

    private CreditDiscountFactors createCreditDiscountFactors(CreditDiscountFactors originalDsc, Curve bumpedCurve) {
        if (originalDsc instanceof IsdaCreditDiscountFactors && bumpedCurve instanceof NodalCurve) {
            IsdaCreditDiscountFactors isdaDsc = (IsdaCreditDiscountFactors)originalDsc;
            return isdaDsc.withCurve((NodalCurve)bumpedCurve);
        }
        throw new IllegalArgumentException("Not supported");
    }
}

