/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.pricer.swap;

import com.google.common.collect.ImmutableList;
import com.opengamma.strata.basics.currency.Currency;
import com.opengamma.strata.basics.currency.CurrencyAmount;
import com.opengamma.strata.basics.currency.MultiCurrencyAmount;
import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.collect.tuple.Triple;
import com.opengamma.strata.market.amount.CashFlows;
import com.opengamma.strata.market.explain.ExplainKey;
import com.opengamma.strata.market.explain.ExplainMap;
import com.opengamma.strata.market.explain.ExplainMapBuilder;
import com.opengamma.strata.market.sensitivity.PointSensitivityBuilder;
import com.opengamma.strata.pricer.ZeroRateSensitivity;
import com.opengamma.strata.pricer.rate.RatesProvider;
import com.opengamma.strata.pricer.swap.DiscountingSwapLegPricer;
import com.opengamma.strata.product.rate.FixedOvernightCompoundedAnnualRateComputation;
import com.opengamma.strata.product.rate.FixedRateComputation;
import com.opengamma.strata.product.swap.CompoundingMethod;
import com.opengamma.strata.product.swap.RateAccrualPeriod;
import com.opengamma.strata.product.swap.RatePaymentPeriod;
import com.opengamma.strata.product.swap.ResolvedSwap;
import com.opengamma.strata.product.swap.ResolvedSwapLeg;
import com.opengamma.strata.product.swap.SwapLegType;
import com.opengamma.strata.product.swap.SwapPaymentPeriod;
import java.util.ArrayList;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.ToDoubleBiFunction;

public class DiscountingSwapProductPricer {
    public static final DiscountingSwapProductPricer DEFAULT = new DiscountingSwapProductPricer(DiscountingSwapLegPricer.DEFAULT);
    private final DiscountingSwapLegPricer legPricer;

    public DiscountingSwapProductPricer(DiscountingSwapLegPricer legPricer) {
        this.legPricer = (DiscountingSwapLegPricer)ArgChecker.notNull((Object)legPricer, (String)"legPricer");
    }

    public DiscountingSwapLegPricer getLegPricer() {
        return this.legPricer;
    }

    public CurrencyAmount presentValue(ResolvedSwap swap, Currency currency, RatesProvider provider) {
        double totalPv = 0.0;
        for (ResolvedSwapLeg leg : swap.getLegs()) {
            double pv = this.legPricer.presentValueInternal(leg, provider);
            totalPv += pv * provider.fxRate(leg.getCurrency(), currency);
        }
        return CurrencyAmount.of((Currency)currency, (double)totalPv);
    }

    public MultiCurrencyAmount presentValue(ResolvedSwap swap, RatesProvider provider) {
        return DiscountingSwapProductPricer.swapValue(provider, swap, this.legPricer::presentValueInternal);
    }

    public MultiCurrencyAmount forecastValue(ResolvedSwap swap, RatesProvider provider) {
        return DiscountingSwapProductPricer.swapValue(provider, swap, this.legPricer::forecastValueInternal);
    }

    private static MultiCurrencyAmount swapValue(RatesProvider provider, ResolvedSwap swap, ToDoubleBiFunction<ResolvedSwapLeg, RatesProvider> legFn) {
        if (swap.isCrossCurrency()) {
            return (MultiCurrencyAmount)swap.getLegs().stream().map(leg -> CurrencyAmount.of((Currency)leg.getCurrency(), (double)legFn.applyAsDouble((ResolvedSwapLeg)leg, provider))).collect(MultiCurrencyAmount.toMultiCurrencyAmount());
        }
        Currency currency = ((ResolvedSwapLeg)swap.getLegs().iterator().next()).getCurrency();
        double total = 0.0;
        for (ResolvedSwapLeg leg2 : swap.getLegs()) {
            total += legFn.applyAsDouble(leg2, provider);
        }
        return MultiCurrencyAmount.of((Currency)currency, (double)total);
    }

    public MultiCurrencyAmount accruedInterest(ResolvedSwap swap, RatesProvider provider) {
        MultiCurrencyAmount result = MultiCurrencyAmount.empty();
        for (ResolvedSwapLeg leg : swap.getLegs()) {
            result = result.plus(this.legPricer.accruedInterest(leg, provider));
        }
        return result;
    }

    public double parRate(ResolvedSwap swap, RatesProvider provider) {
        ResolvedSwapLeg fixedLeg = this.fixedLeg(swap);
        Currency ccyFixedLeg = fixedLeg.getCurrency();
        double otherLegsConvertedPv = 0.0;
        for (ResolvedSwapLeg leg : swap.getLegs()) {
            if (leg == fixedLeg) continue;
            double pvLocal = this.legPricer.presentValueInternal(leg, provider);
            otherLegsConvertedPv += pvLocal * provider.fxRate(leg.getCurrency(), ccyFixedLeg);
        }
        double fixedLegEventsPv = this.legPricer.presentValueEventsInternal(fixedLeg, provider);
        if (fixedLeg.getPaymentPeriods().size() > 1) {
            double pvbpFixedLeg = this.legPricer.pvbp(fixedLeg, provider);
            return -(otherLegsConvertedPv + fixedLegEventsPv) / pvbpFixedLeg;
        }
        SwapPaymentPeriod firstPeriod = (SwapPaymentPeriod)fixedLeg.getPaymentPeriods().get(0);
        ArgChecker.isTrue((boolean)(firstPeriod instanceof RatePaymentPeriod), (String)"PaymentPeriod must be instance of RatePaymentPeriod");
        RatePaymentPeriod payment = (RatePaymentPeriod)firstPeriod;
        if (payment.getAccrualPeriods().size() == 1) {
            RateAccrualPeriod firstAccrualPeriod = (RateAccrualPeriod)payment.getAccrualPeriods().get(0);
            if (firstAccrualPeriod.getRateComputation() instanceof FixedOvernightCompoundedAnnualRateComputation) {
                double accrualFactor = ((RateAccrualPeriod)payment.getAccrualPeriods().get(0)).getYearFraction();
                double notional = payment.getNotional();
                double df = provider.discountFactor(ccyFixedLeg, payment.getPaymentDate());
                return Math.pow(-otherLegsConvertedPv / (notional * df) + 1.0, 1.0 / accrualFactor) - 1.0;
            }
            double pvbpFixedLeg = this.legPricer.pvbp(fixedLeg, provider);
            return -(otherLegsConvertedPv + fixedLegEventsPv) / pvbpFixedLeg;
        }
        Triple<Boolean, Integer, Double> fixedCompounded = this.checkFixedCompounded(fixedLeg);
        ArgChecker.isTrue((boolean)((Boolean)fixedCompounded.getFirst()), (String)"Swap should have a fixed leg and for one payment it should be based on compunding witout spread.");
        double notional = payment.getNotional();
        double df = provider.discountFactor(ccyFixedLeg, payment.getPaymentDate());
        return Math.pow(-(otherLegsConvertedPv + fixedLegEventsPv) / (notional * df) + 1.0, 1.0 / (double)((Integer)fixedCompounded.getSecond()).intValue()) - 1.0;
    }

    public double marketQuote(ResolvedSwap swap, RatesProvider provider) {
        if (!swap.getLegs(SwapLegType.FIXED).isEmpty()) {
            return this.parRate(swap, provider);
        }
        ResolvedSwapLeg referenceLeg = (ResolvedSwapLeg)swap.getLegs().get(0);
        Currency ccyReferenceLeg = referenceLeg.getCurrency();
        ArrayList<RatePaymentPeriod> paymentPeriods0 = new ArrayList<RatePaymentPeriod>();
        for (SwapPaymentPeriod period : referenceLeg.getPaymentPeriods()) {
            ArgChecker.isTrue((boolean)(period instanceof RatePaymentPeriod), (String)"Must be RatePaymentPeriod");
            RatePaymentPeriod ratePeriod = (RatePaymentPeriod)period;
            ArrayList<RateAccrualPeriod> accrualPeriods0 = new ArrayList<RateAccrualPeriod>();
            for (RateAccrualPeriod accrualPeriod : ratePeriod.getAccrualPeriods()) {
                accrualPeriods0.add(accrualPeriod.toBuilder().spread(0.0).build());
            }
            paymentPeriods0.add(ratePeriod.toBuilder().accrualPeriods(accrualPeriods0).build());
        }
        ResolvedSwapLeg referenceLeg0 = referenceLeg.toBuilder().paymentPeriods(paymentPeriods0).build();
        double convertedPvOtherLegs = 0.0;
        for (int i = 1; i < swap.getLegs().size(); ++i) {
            convertedPvOtherLegs += this.legPricer.presentValue((ResolvedSwapLeg)swap.getLegs().get(i), ccyReferenceLeg, provider).getAmount();
        }
        double convertedPvLeg0 = this.legPricer.presentValue(referenceLeg0, provider).getAmount();
        double pvbp = this.legPricer.pvbp(referenceLeg, provider);
        return -(convertedPvOtherLegs + convertedPvLeg0) / pvbp;
    }

    public double parSpread(ResolvedSwap swap, RatesProvider provider) {
        ResolvedSwapLeg fixedLeg;
        Optional<FixedOvernightCompoundedAnnualRateComputation> annualRateCompOpt;
        if (!swap.getLegs(SwapLegType.FIXED).isEmpty() && (annualRateCompOpt = this.findAnnualRateComputation(fixedLeg = this.fixedLeg(swap))).isPresent()) {
            return this.parRate(swap, provider) - annualRateCompOpt.get().getRate();
        }
        ResolvedSwapLeg referenceLeg = (ResolvedSwapLeg)swap.getLegs().get(0);
        Currency ccyReferenceLeg = referenceLeg.getCurrency();
        Triple<Boolean, Integer, Double> fixedCompounded = this.checkFixedCompounded(referenceLeg);
        if (((Boolean)fixedCompounded.getFirst()).booleanValue()) {
            double df = provider.discountFactor(ccyReferenceLeg, ((SwapPaymentPeriod)referenceLeg.getPaymentPeriods().get(0)).getPaymentDate());
            double convertedPv = this.presentValue(swap, ccyReferenceLeg, provider).getAmount();
            double referenceConvertedPv = this.legPricer.presentValue(referenceLeg, provider).getAmount();
            double notional = ((RatePaymentPeriod)referenceLeg.getPaymentPeriods().get(0)).getNotional();
            double parSpread = Math.pow(-(convertedPv - referenceConvertedPv) / (df * notional) + 1.0, 1.0 / (double)((Integer)fixedCompounded.getSecond()).intValue()) - (1.0 + (Double)fixedCompounded.getThird());
            return parSpread;
        }
        double convertedPv = this.presentValue(swap, ccyReferenceLeg, provider).getAmount();
        double pvbp = this.legPricer.pvbp(referenceLeg, provider);
        return -convertedPv / pvbp;
    }

    public PointSensitivityBuilder presentValueSensitivity(ResolvedSwap swap, RatesProvider provider) {
        return DiscountingSwapProductPricer.swapValueSensitivity(swap, provider, this.legPricer::presentValueSensitivity);
    }

    public PointSensitivityBuilder presentValueSensitivity(ResolvedSwap swap, Currency currency, RatesProvider provider) {
        PointSensitivityBuilder builder = PointSensitivityBuilder.none();
        for (ResolvedSwapLeg leg : swap.getLegs()) {
            PointSensitivityBuilder ls = this.legPricer.presentValueSensitivity(leg, provider);
            PointSensitivityBuilder lsConverted = ls.withCurrency(currency).multipliedBy(provider.fxRate(leg.getCurrency(), currency));
            builder = builder.combinedWith(lsConverted);
        }
        return builder;
    }

    public PointSensitivityBuilder forecastValueSensitivity(ResolvedSwap swap, RatesProvider provider) {
        return DiscountingSwapProductPricer.swapValueSensitivity(swap, provider, this.legPricer::forecastValueSensitivity);
    }

    private static PointSensitivityBuilder swapValueSensitivity(ResolvedSwap swap, RatesProvider provider, BiFunction<ResolvedSwapLeg, RatesProvider, PointSensitivityBuilder> legFn) {
        PointSensitivityBuilder builder = PointSensitivityBuilder.none();
        for (ResolvedSwapLeg leg : swap.getLegs()) {
            builder = builder.combinedWith(legFn.apply(leg, provider));
        }
        return builder;
    }

    public PointSensitivityBuilder parRateSensitivity(ResolvedSwap swap, RatesProvider provider) {
        ResolvedSwapLeg fixedLeg = this.fixedLeg(swap);
        Currency ccyFixedLeg = fixedLeg.getCurrency();
        double otherLegsConvertedPv = 0.0;
        for (ResolvedSwapLeg leg : swap.getLegs()) {
            if (leg == fixedLeg) continue;
            double pvLocal = this.legPricer.presentValueInternal(leg, provider);
            otherLegsConvertedPv += pvLocal * provider.fxRate(leg.getCurrency(), ccyFixedLeg);
        }
        Optional<FixedOvernightCompoundedAnnualRateComputation> annualRateCompOpt = this.findAnnualRateComputation(fixedLeg);
        if (annualRateCompOpt.isPresent()) {
            RatePaymentPeriod payment = (RatePaymentPeriod)fixedLeg.getPaymentPeriods().get(0);
            double af = annualRateCompOpt.get().getAccrualFactor();
            double notional = payment.getNotional();
            double df = provider.discountFactor(ccyFixedLeg, payment.getPaymentDate());
            double otherLegsConvertedPvBar = -Math.pow(-otherLegsConvertedPv / (notional * df) + 1.0, 1.0 / af - 1.0) / (af * notional * df);
            double dfBar = Math.pow(-otherLegsConvertedPv / (notional * df) + 1.0, 1.0 / af - 1.0) * otherLegsConvertedPv / (af * notional * df * df);
            PointSensitivityBuilder otherLegsConvertedPvDr = PointSensitivityBuilder.none();
            for (ResolvedSwapLeg leg : swap.getLegs()) {
                if (leg == fixedLeg) continue;
                PointSensitivityBuilder pvLegDr = this.getLegPricer().presentValueSensitivity(leg, provider).multipliedBy(provider.fxRate(leg.getCurrency(), ccyFixedLeg));
                otherLegsConvertedPvDr = otherLegsConvertedPvDr.combinedWith(pvLegDr);
            }
            otherLegsConvertedPvDr = otherLegsConvertedPvDr.withCurrency(ccyFixedLeg);
            ZeroRateSensitivity dfDr = provider.discountFactors(ccyFixedLeg).zeroRatePointSensitivity(((SwapPaymentPeriod)fixedLeg.getPaymentPeriods().get(0)).getPaymentDate());
            return dfDr.multipliedBy(dfBar).combinedWith(otherLegsConvertedPvDr.multipliedBy(otherLegsConvertedPvBar));
        }
        double fixedLegEventsPv = this.legPricer.presentValueEventsInternal(fixedLeg, provider);
        double pvbpFixedLeg = this.legPricer.pvbp(fixedLeg, provider);
        double otherLegsConvertedPvBar = -1.0 / pvbpFixedLeg;
        double fixedLegEventsPvBar = -1.0 / pvbpFixedLeg;
        double pvbpFixedLegBar = (otherLegsConvertedPv + fixedLegEventsPv) / (pvbpFixedLeg * pvbpFixedLeg);
        PointSensitivityBuilder pvbpFixedLegDr = this.legPricer.pvbpSensitivity(fixedLeg, provider);
        PointSensitivityBuilder fixedLegEventsPvDr = this.legPricer.presentValueSensitivityEventsInternal(fixedLeg, provider);
        PointSensitivityBuilder otherLegsConvertedPvDr = PointSensitivityBuilder.none();
        for (ResolvedSwapLeg leg : swap.getLegs()) {
            if (leg == fixedLeg) continue;
            PointSensitivityBuilder pvLegDr = this.legPricer.presentValueSensitivity(leg, provider).multipliedBy(provider.fxRate(leg.getCurrency(), ccyFixedLeg));
            otherLegsConvertedPvDr = otherLegsConvertedPvDr.combinedWith(pvLegDr);
        }
        otherLegsConvertedPvDr = otherLegsConvertedPvDr.withCurrency(ccyFixedLeg);
        return pvbpFixedLegDr.multipliedBy(pvbpFixedLegBar).combinedWith(fixedLegEventsPvDr.multipliedBy(fixedLegEventsPvBar)).combinedWith(otherLegsConvertedPvDr.multipliedBy(otherLegsConvertedPvBar));
    }

    public PointSensitivityBuilder marketQuoteSensitivity(ResolvedSwap swap, RatesProvider provider) {
        if (!swap.getLegs(SwapLegType.FIXED).isEmpty()) {
            return this.parRateSensitivity(swap, provider);
        }
        ResolvedSwapLeg referenceLeg = (ResolvedSwapLeg)swap.getLegs().get(0);
        Currency ccyReferenceLeg = referenceLeg.getCurrency();
        ArrayList<RatePaymentPeriod> paymentPeriods0 = new ArrayList<RatePaymentPeriod>();
        for (SwapPaymentPeriod period : referenceLeg.getPaymentPeriods()) {
            ArgChecker.isTrue((boolean)(period instanceof RatePaymentPeriod), (String)"Must be RatePaymentPeriod");
            RatePaymentPeriod ratePeriod = (RatePaymentPeriod)period;
            ArrayList<RateAccrualPeriod> accrualPeriods0 = new ArrayList<RateAccrualPeriod>();
            for (RateAccrualPeriod accrualPeriod : ratePeriod.getAccrualPeriods()) {
                accrualPeriods0.add(accrualPeriod.toBuilder().spread(0.0).build());
            }
            paymentPeriods0.add(ratePeriod.toBuilder().accrualPeriods(accrualPeriods0).build());
        }
        ResolvedSwapLeg referenceLeg0 = referenceLeg.toBuilder().paymentPeriods(paymentPeriods0).build();
        double convertedPvOtherLegs = 0.0;
        for (int i = 1; i < swap.getLegs().size(); ++i) {
            convertedPvOtherLegs += this.legPricer.presentValue((ResolvedSwapLeg)swap.getLegs().get(i), ccyReferenceLeg, provider).getAmount();
        }
        double convertedPvLeg0 = this.legPricer.presentValue(referenceLeg0, provider).getAmount();
        double pvbp = this.legPricer.pvbp(referenceLeg, provider);
        double marketQuoteBar = 1.0;
        double convertedPvOtherLegsBar = -marketQuoteBar / pvbp;
        double convertedPvLeg0Bar = -marketQuoteBar / pvbp;
        double pvbpBar = (convertedPvOtherLegs + convertedPvLeg0) / (pvbp * pvbp) * marketQuoteBar;
        PointSensitivityBuilder dconvertedPvLeg0dr = this.legPricer.presentValueSensitivity(referenceLeg0, provider);
        PointSensitivityBuilder dconvertedPvOtherLegsdr = PointSensitivityBuilder.none();
        for (int i = 1; i < swap.getLegs().size(); ++i) {
            ResolvedSwapLeg leg = (ResolvedSwapLeg)swap.getLegs().get(i);
            dconvertedPvOtherLegsdr = dconvertedPvOtherLegsdr.combinedWith(this.legPricer.presentValueSensitivity(leg, provider).multipliedBy(provider.fxRate(leg.getCurrency(), ccyReferenceLeg)).withCurrency(ccyReferenceLeg));
        }
        PointSensitivityBuilder dpvbpdr = this.legPricer.pvbpSensitivity(referenceLeg, provider);
        return dconvertedPvLeg0dr.multipliedBy(convertedPvLeg0Bar).combinedWith(dconvertedPvOtherLegsdr.multipliedBy(convertedPvOtherLegsBar)).combinedWith(dpvbpdr.multipliedBy(pvbpBar));
    }

    public PointSensitivityBuilder parSpreadSensitivity(ResolvedSwap swap, RatesProvider provider) {
        ResolvedSwapLeg fixedLeg;
        Optional<FixedOvernightCompoundedAnnualRateComputation> annualRateCompOpt;
        if (!swap.getLegs(SwapLegType.FIXED).isEmpty() && (annualRateCompOpt = this.findAnnualRateComputation(fixedLeg = this.fixedLeg(swap))).isPresent()) {
            return this.parRateSensitivity(swap, provider);
        }
        ResolvedSwapLeg referenceLeg = (ResolvedSwapLeg)swap.getLegs().get(0);
        Currency ccyReferenceLeg = referenceLeg.getCurrency();
        double convertedPv = this.presentValue(swap, ccyReferenceLeg, provider).getAmount();
        PointSensitivityBuilder convertedPvDr = this.presentValueSensitivity(swap, ccyReferenceLeg, provider);
        Triple<Boolean, Integer, Double> fixedCompounded = this.checkFixedCompounded(referenceLeg);
        if (((Boolean)fixedCompounded.getFirst()).booleanValue()) {
            double df = provider.discountFactor(ccyReferenceLeg, ((SwapPaymentPeriod)referenceLeg.getPaymentPeriods().get(0)).getPaymentDate());
            ZeroRateSensitivity dfDr = provider.discountFactors(ccyReferenceLeg).zeroRatePointSensitivity(((SwapPaymentPeriod)referenceLeg.getPaymentPeriods().get(0)).getPaymentDate());
            double referenceConvertedPv = this.legPricer.presentValue(referenceLeg, provider).getAmount();
            PointSensitivityBuilder referenceConvertedPvDr = this.legPricer.presentValueSensitivity(referenceLeg, provider);
            double notional = ((RatePaymentPeriod)referenceLeg.getPaymentPeriods().get(0)).getNotional();
            PointSensitivityBuilder dParSpreadDr = convertedPvDr.combinedWith(referenceConvertedPvDr.multipliedBy(-1.0)).multipliedBy(-1.0 / (df * notional)).combinedWith(dfDr.multipliedBy((convertedPv - referenceConvertedPv) / (df * df * notional))).multipliedBy(1.0 / (double)((Integer)fixedCompounded.getSecond()).intValue() * Math.pow(-(convertedPv - referenceConvertedPv) / (df * notional) + 1.0, 1.0 / (double)((Integer)fixedCompounded.getSecond()).intValue() - 1.0));
            return dParSpreadDr;
        }
        double pvbp = this.legPricer.pvbp(referenceLeg, provider);
        double convertedPvBar = -1.0 / pvbp;
        double pvbpBar = convertedPv / (pvbp * pvbp);
        PointSensitivityBuilder pvbpDr = this.legPricer.pvbpSensitivity(referenceLeg, provider);
        return convertedPvDr.multipliedBy(convertedPvBar).combinedWith(pvbpDr.multipliedBy(pvbpBar));
    }

    public CashFlows cashFlows(ResolvedSwap swap, RatesProvider provider) {
        return swap.getLegs().stream().map(leg -> this.legPricer.cashFlows((ResolvedSwapLeg)leg, provider)).reduce(CashFlows.NONE, CashFlows::combinedWith);
    }

    public ExplainMap explainPresentValue(ResolvedSwap swap, RatesProvider provider) {
        ExplainMapBuilder builder = ExplainMap.builder();
        builder.put(ExplainKey.ENTRY_TYPE, (Object)"Swap");
        for (ResolvedSwapLeg leg : swap.getLegs()) {
            builder.addListEntryWithIndex(ExplainKey.LEGS, child -> this.legPricer.explainPresentValueInternal(leg, provider, (ExplainMapBuilder)child));
        }
        return builder.build();
    }

    public MultiCurrencyAmount currencyExposure(ResolvedSwap swap, RatesProvider provider) {
        MultiCurrencyAmount ce = MultiCurrencyAmount.empty();
        for (ResolvedSwapLeg leg : swap.getLegs()) {
            ce = ce.plus(this.legPricer.currencyExposure(leg, provider));
        }
        return ce;
    }

    public MultiCurrencyAmount currentCash(ResolvedSwap swap, RatesProvider provider) {
        MultiCurrencyAmount ce = MultiCurrencyAmount.empty();
        for (ResolvedSwapLeg leg : swap.getLegs()) {
            ce = ce.plus(this.legPricer.currentCash(leg, provider));
        }
        return ce;
    }

    private Optional<FixedOvernightCompoundedAnnualRateComputation> findAnnualRateComputation(ResolvedSwapLeg fixedLeg) {
        RatePaymentPeriod payment;
        RateAccrualPeriod firstAccrualPeriod;
        SwapPaymentPeriod firstPeriod = (SwapPaymentPeriod)fixedLeg.getPaymentPeriods().get(0);
        if (firstPeriod instanceof RatePaymentPeriod && (firstAccrualPeriod = (RateAccrualPeriod)(payment = (RatePaymentPeriod)firstPeriod).getAccrualPeriods().get(0)).getRateComputation() instanceof FixedOvernightCompoundedAnnualRateComputation) {
            return Optional.of((FixedOvernightCompoundedAnnualRateComputation)firstAccrualPeriod.getRateComputation());
        }
        return Optional.empty();
    }

    private ResolvedSwapLeg fixedLeg(ResolvedSwap swap) {
        ImmutableList fixedLegs = swap.getLegs(SwapLegType.FIXED);
        if (fixedLegs.isEmpty()) {
            throw new IllegalArgumentException("Swap must contain a fixed leg");
        }
        return (ResolvedSwapLeg)fixedLegs.get(0);
    }

    private Triple<Boolean, Integer, Double> checkFixedCompounded(ResolvedSwapLeg leg) {
        if (leg.getPaymentEvents().size() != 0) {
            return Triple.of((Object)false, (Object)0, (Object)0.0);
        }
        RatePaymentPeriod ratePaymentPeriod = (RatePaymentPeriod)leg.getPaymentPeriods().get(0);
        if (ratePaymentPeriod.getCompoundingMethod() == CompoundingMethod.NONE) {
            return Triple.of((Object)false, (Object)0, (Object)0.0);
        }
        ImmutableList accrualPeriods = ratePaymentPeriod.getAccrualPeriods();
        int nbAccrualPeriods = accrualPeriods.size();
        double fixedRate = 0.0;
        for (int i = 0; i < nbAccrualPeriods; ++i) {
            if (!(((RateAccrualPeriod)accrualPeriods.get(i)).getRateComputation() instanceof FixedRateComputation)) {
                return Triple.of((Object)false, (Object)0, (Object)0.0);
            }
            if (i > 0 && ((FixedRateComputation)((RateAccrualPeriod)accrualPeriods.get(i)).getRateComputation()).getRate() != fixedRate) {
                return Triple.of((Object)false, (Object)0, (Object)0.0);
            }
            fixedRate = ((FixedRateComputation)((RateAccrualPeriod)accrualPeriods.get(i)).getRateComputation()).getRate();
            if (((RateAccrualPeriod)accrualPeriods.get(i)).getSpread() != 0.0) {
                return Triple.of((Object)false, (Object)0, (Object)0.0);
            }
            if (((RateAccrualPeriod)accrualPeriods.get(i)).getGearing() != 1.0) {
                return Triple.of((Object)false, (Object)0, (Object)0.0);
            }
            if (((RateAccrualPeriod)accrualPeriods.get(i)).getYearFraction() == 1.0) continue;
            return Triple.of((Object)false, (Object)0, (Object)0.0);
        }
        return Triple.of((Object)true, (Object)nbAccrualPeriods, (Object)fixedRate);
    }
}

