/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.pricer.swap;

import com.opengamma.strata.basics.currency.Currency;
import com.opengamma.strata.basics.currency.CurrencyAmount;
import com.opengamma.strata.basics.currency.MultiCurrencyAmount;
import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.market.amount.CashFlows;
import com.opengamma.strata.market.explain.ExplainMap;
import com.opengamma.strata.market.sensitivity.PointSensitivities;
import com.opengamma.strata.pricer.rate.RatesProvider;
import com.opengamma.strata.pricer.swap.DiscountingSwapProductPricer;
import com.opengamma.strata.product.swap.ResolvedSwapTrade;

public class DiscountingSwapTradePricer {
    public static final DiscountingSwapTradePricer DEFAULT = new DiscountingSwapTradePricer(DiscountingSwapProductPricer.DEFAULT);
    private final DiscountingSwapProductPricer productPricer;

    public DiscountingSwapTradePricer(DiscountingSwapProductPricer productPricer) {
        this.productPricer = (DiscountingSwapProductPricer)ArgChecker.notNull((Object)productPricer, (String)"productPricer");
    }

    public DiscountingSwapProductPricer getProductPricer() {
        return this.productPricer;
    }

    public CurrencyAmount presentValue(ResolvedSwapTrade trade, Currency currency, RatesProvider provider) {
        return this.productPricer.presentValue(trade.getProduct(), currency, provider);
    }

    public MultiCurrencyAmount presentValue(ResolvedSwapTrade trade, RatesProvider provider) {
        return this.productPricer.presentValue(trade.getProduct(), provider);
    }

    public ExplainMap explainPresentValue(ResolvedSwapTrade trade, RatesProvider provider) {
        return this.productPricer.explainPresentValue(trade.getProduct(), provider);
    }

    public PointSensitivities presentValueSensitivity(ResolvedSwapTrade trade, RatesProvider provider) {
        return this.productPricer.presentValueSensitivity(trade.getProduct(), provider).build();
    }

    public MultiCurrencyAmount forecastValue(ResolvedSwapTrade trade, RatesProvider provider) {
        return this.productPricer.forecastValue(trade.getProduct(), provider);
    }

    public PointSensitivities forecastValueSensitivity(ResolvedSwapTrade trade, RatesProvider provider) {
        return this.productPricer.forecastValueSensitivity(trade.getProduct(), provider).build();
    }

    public double parRate(ResolvedSwapTrade trade, RatesProvider provider) {
        return this.productPricer.parRate(trade.getProduct(), provider);
    }

    public PointSensitivities parRateSensitivity(ResolvedSwapTrade trade, RatesProvider provider) {
        return this.productPricer.parRateSensitivity(trade.getProduct(), provider).build();
    }

    public double parSpread(ResolvedSwapTrade trade, RatesProvider provider) {
        return this.productPricer.parSpread(trade.getProduct(), provider);
    }

    public PointSensitivities parSpreadSensitivity(ResolvedSwapTrade trade, RatesProvider provider) {
        return this.productPricer.parSpreadSensitivity(trade.getProduct(), provider).build();
    }

    public CashFlows cashFlows(ResolvedSwapTrade trade, RatesProvider provider) {
        return this.productPricer.cashFlows(trade.getProduct(), provider);
    }

    public MultiCurrencyAmount accruedInterest(ResolvedSwapTrade trade, RatesProvider provider) {
        return this.productPricer.accruedInterest(trade.getProduct(), provider);
    }

    public MultiCurrencyAmount currencyExposure(ResolvedSwapTrade trade, RatesProvider provider) {
        return this.productPricer.currencyExposure(trade.getProduct(), provider);
    }

    public MultiCurrencyAmount currentCash(ResolvedSwapTrade trade, RatesProvider provider) {
        return this.productPricer.currentCash(trade.getProduct(), provider);
    }
}

