/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.pricer.swaption;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.opengamma.strata.basics.currency.Currency;
import com.opengamma.strata.basics.currency.CurrencyAmount;
import com.opengamma.strata.basics.currency.MultiCurrencyAmount;
import com.opengamma.strata.basics.currency.Payment;
import com.opengamma.strata.basics.value.ValueDerivatives;
import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.collect.DoubleArrayMath;
import com.opengamma.strata.collect.array.DoubleArray;
import com.opengamma.strata.market.sensitivity.PointSensitivityBuilder;
import com.opengamma.strata.math.impl.statistics.distribution.NormalDistribution;
import com.opengamma.strata.math.impl.statistics.distribution.ProbabilityDistribution;
import com.opengamma.strata.pricer.DiscountingPaymentPricer;
import com.opengamma.strata.pricer.impl.rate.swap.CashFlowEquivalentCalculator;
import com.opengamma.strata.pricer.model.HullWhiteOneFactorPiecewiseConstantParametersProvider;
import com.opengamma.strata.pricer.rate.RatesProvider;
import com.opengamma.strata.product.common.SettlementType;
import com.opengamma.strata.product.swap.NotionalExchange;
import com.opengamma.strata.product.swap.ResolvedSwap;
import com.opengamma.strata.product.swap.ResolvedSwapLeg;
import com.opengamma.strata.product.swap.SwapLegType;
import com.opengamma.strata.product.swaption.ResolvedSwaption;
import java.time.LocalDate;

public class HullWhiteSwaptionPhysicalProductPricer {
    private static final ProbabilityDistribution<Double> NORMAL = new NormalDistribution(0.0, 1.0);
    private static final double SMALL = 1.0E-9;
    public static final HullWhiteSwaptionPhysicalProductPricer DEFAULT = new HullWhiteSwaptionPhysicalProductPricer(DiscountingPaymentPricer.DEFAULT);
    private final DiscountingPaymentPricer paymentPricer;

    public HullWhiteSwaptionPhysicalProductPricer(DiscountingPaymentPricer paymentPricer) {
        this.paymentPricer = (DiscountingPaymentPricer)ArgChecker.notNull((Object)paymentPricer, (String)"paymentPricer");
    }

    public CurrencyAmount presentValue(ResolvedSwaption swaption, RatesProvider ratesProvider, HullWhiteOneFactorPiecewiseConstantParametersProvider hwProvider) {
        this.validate(swaption, ratesProvider, hwProvider);
        ResolvedSwap swap = swaption.getUnderlying();
        LocalDate expiryDate = swaption.getExpiryDate();
        if (expiryDate.isBefore(ratesProvider.getValuationDate())) {
            return CurrencyAmount.of((Currency)((ResolvedSwapLeg)swap.getLegs().get(0)).getCurrency(), (double)0.0);
        }
        ResolvedSwapLeg cashFlowEquiv = CashFlowEquivalentCalculator.cashFlowEquivalentSwap(swap, ratesProvider);
        int nPayments = cashFlowEquiv.getPaymentEvents().size();
        double[] alpha = new double[nPayments];
        double[] discountedCashFlow = new double[nPayments];
        for (int loopcf = 0; loopcf < nPayments; ++loopcf) {
            NotionalExchange payment = (NotionalExchange)cashFlowEquiv.getPaymentEvents().get(loopcf);
            LocalDate maturityDate = payment.getPaymentDate();
            alpha[loopcf] = hwProvider.alpha(ratesProvider.getValuationDate(), expiryDate, expiryDate, maturityDate);
            discountedCashFlow[loopcf] = this.paymentPricer.presentValueAmount(payment.getPayment(), ratesProvider);
        }
        double omega = ((ResolvedSwapLeg)swap.getLegs(SwapLegType.FIXED).get(0)).getPayReceive().isPay() ? -1.0 : 1.0;
        double kappa = this.computeKappa(hwProvider, discountedCashFlow, alpha, omega);
        double pv = 0.0;
        for (int loopcf = 0; loopcf < nPayments; ++loopcf) {
            pv += discountedCashFlow[loopcf] * NORMAL.getCDF((Object)(omega * (kappa + alpha[loopcf])));
        }
        return CurrencyAmount.of((Currency)cashFlowEquiv.getCurrency(), (double)(pv * (swaption.getLongShort().isLong() ? 1.0 : -1.0)));
    }

    public MultiCurrencyAmount currencyExposure(ResolvedSwaption swaption, RatesProvider ratesProvider, HullWhiteOneFactorPiecewiseConstantParametersProvider hwProvider) {
        return MultiCurrencyAmount.of((CurrencyAmount[])new CurrencyAmount[]{this.presentValue(swaption, ratesProvider, hwProvider)});
    }

    public PointSensitivityBuilder presentValueSensitivityRates(ResolvedSwaption swaption, RatesProvider ratesProvider, HullWhiteOneFactorPiecewiseConstantParametersProvider hwProvider) {
        this.validate(swaption, ratesProvider, hwProvider);
        ResolvedSwap swap = swaption.getUnderlying();
        LocalDate expiryDate = swaption.getExpiryDate();
        if (expiryDate.isBefore(ratesProvider.getValuationDate())) {
            return PointSensitivityBuilder.none();
        }
        ImmutableMap<Payment, PointSensitivityBuilder> cashFlowEquivSensi = CashFlowEquivalentCalculator.cashFlowEquivalentAndSensitivitySwap(swap, ratesProvider);
        ImmutableList list = cashFlowEquivSensi.keySet().asList();
        ImmutableList listSensi = cashFlowEquivSensi.values().asList();
        int nPayments = list.size();
        double[] alpha = new double[nPayments];
        double[] discountedCashFlow = new double[nPayments];
        for (int loopcf = 0; loopcf < nPayments; ++loopcf) {
            Payment payment = (Payment)list.get(loopcf);
            alpha[loopcf] = hwProvider.alpha(ratesProvider.getValuationDate(), expiryDate, expiryDate, payment.getDate());
            discountedCashFlow[loopcf] = this.paymentPricer.presentValueAmount(payment, ratesProvider);
        }
        double omega = ((ResolvedSwapLeg)swap.getLegs(SwapLegType.FIXED).get(0)).getPayReceive().isPay() ? -1.0 : 1.0;
        double kappa = this.computeKappa(hwProvider, discountedCashFlow, alpha, omega);
        PointSensitivityBuilder point = PointSensitivityBuilder.none();
        for (int loopcf = 0; loopcf < nPayments; ++loopcf) {
            Payment payment = (Payment)list.get(loopcf);
            double cdf = NORMAL.getCDF((Object)(omega * (kappa + alpha[loopcf])));
            point = point.combinedWith(this.paymentPricer.presentValueSensitivity(payment, ratesProvider).multipliedBy(cdf));
            if (((PointSensitivityBuilder)listSensi.get(loopcf)).equals(PointSensitivityBuilder.none())) continue;
            point = point.combinedWith(((PointSensitivityBuilder)listSensi.get(loopcf)).multipliedBy(cdf * ratesProvider.discountFactor(payment.getCurrency(), payment.getDate())));
        }
        return swaption.getLongShort().isLong() ? point : point.multipliedBy(-1.0);
    }

    public DoubleArray presentValueSensitivityModelParamsHullWhite(ResolvedSwaption swaption, RatesProvider ratesProvider, HullWhiteOneFactorPiecewiseConstantParametersProvider hwProvider) {
        this.validate(swaption, ratesProvider, hwProvider);
        ResolvedSwap swap = swaption.getUnderlying();
        LocalDate expiryDate = swaption.getExpiryDate();
        if (expiryDate.isBefore(ratesProvider.getValuationDate())) {
            return DoubleArray.EMPTY;
        }
        ResolvedSwapLeg cashFlowEquiv = CashFlowEquivalentCalculator.cashFlowEquivalentSwap(swap, ratesProvider);
        int nPayments = cashFlowEquiv.getPaymentEvents().size();
        double[] alpha = new double[nPayments];
        double[][] alphaAdjoint = new double[nPayments][];
        double[] discountedCashFlow = new double[nPayments];
        for (int loopcf = 0; loopcf < nPayments; ++loopcf) {
            NotionalExchange payment = (NotionalExchange)cashFlowEquiv.getPaymentEvents().get(loopcf);
            ValueDerivatives valueDeriv = hwProvider.alphaAdjoint(ratesProvider.getValuationDate(), expiryDate, expiryDate, payment.getPaymentDate());
            alpha[loopcf] = valueDeriv.getValue();
            alphaAdjoint[loopcf] = valueDeriv.getDerivatives().toArray();
            discountedCashFlow[loopcf] = this.paymentPricer.presentValueAmount(payment.getPayment(), ratesProvider);
        }
        double omega = ((ResolvedSwapLeg)swap.getLegs(SwapLegType.FIXED).get(0)).getPayReceive().isPay() ? -1.0 : 1.0;
        double kappa = this.computeKappa(hwProvider, discountedCashFlow, alpha, omega);
        int nParams = alphaAdjoint[0].length;
        if (Math.abs(kappa) > 9.999999999999999E8) {
            return DoubleArray.filled((int)nParams);
        }
        double[] pvSensi = new double[nParams];
        double sign = swaption.getLongShort().isLong() ? 1.0 : -1.0;
        for (int i = 0; i < nParams; ++i) {
            for (int loopcf = 0; loopcf < nPayments; ++loopcf) {
                int n = i;
                pvSensi[n] = pvSensi[n] + sign * discountedCashFlow[loopcf] * NORMAL.getPDF((Object)(omega * (kappa + alpha[loopcf]))) * omega * alphaAdjoint[loopcf][i];
            }
        }
        return DoubleArray.ofUnsafe((double[])pvSensi);
    }

    private void validate(ResolvedSwaption swaption, RatesProvider ratesProvider, HullWhiteOneFactorPiecewiseConstantParametersProvider hwProvider) {
        ArgChecker.isTrue((boolean)hwProvider.getValuationDateTime().toLocalDate().equals(ratesProvider.getValuationDate()), (String)"Hull-White model data and rate data should be for the same date");
        ArgChecker.isFalse((boolean)swaption.getUnderlying().isCrossCurrency(), (String)"underlying swap should be single currency");
        ArgChecker.isTrue((boolean)swaption.getSwaptionSettlement().getSettlementType().equals((Object)SettlementType.PHYSICAL), (String)"swaption should be physical settlement");
    }

    private double computeKappa(HullWhiteOneFactorPiecewiseConstantParametersProvider hwProvider, double[] discountedCashFlow, double[] alpha, double omega) {
        double totalPv;
        double kappa = 0.0;
        kappa = DoubleArrayMath.fuzzyEqualsZero((double[])alpha, (double)1.0E-9) ? ((totalPv = DoubleArrayMath.sum((double[])discountedCashFlow)) * omega > 0.0 ? Double.POSITIVE_INFINITY : Double.NEGATIVE_INFINITY) : hwProvider.getModel().kappa(DoubleArray.ofUnsafe((double[])discountedCashFlow), DoubleArray.ofUnsafe((double[])alpha));
        return kappa;
    }
}

