/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.pricer.swaption;

import com.google.common.collect.ImmutableList;
import com.opengamma.strata.basics.ReferenceData;
import com.opengamma.strata.basics.date.BusinessDayAdjustment;
import com.opengamma.strata.basics.date.DayCount;
import com.opengamma.strata.basics.date.Tenor;
import com.opengamma.strata.basics.value.ValueDerivatives;
import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.collect.Messages;
import com.opengamma.strata.collect.array.DoubleArray;
import com.opengamma.strata.collect.array.DoubleMatrix;
import com.opengamma.strata.collect.tuple.Pair;
import com.opengamma.strata.market.ValueType;
import com.opengamma.strata.market.surface.InterpolatedNodalSurface;
import com.opengamma.strata.market.surface.Surface;
import com.opengamma.strata.market.surface.SurfaceMetadata;
import com.opengamma.strata.market.surface.Surfaces;
import com.opengamma.strata.market.surface.interpolator.SurfaceInterpolator;
import com.opengamma.strata.math.MathException;
import com.opengamma.strata.math.impl.rootfinding.NewtonRaphsonSingleRootFinder;
import com.opengamma.strata.math.impl.statistics.leastsquare.LeastSquareResultsWithTransform;
import com.opengamma.strata.pricer.impl.option.BlackFormulaRepository;
import com.opengamma.strata.pricer.impl.volatility.smile.SabrFormulaData;
import com.opengamma.strata.pricer.impl.volatility.smile.SabrModelFitter;
import com.opengamma.strata.pricer.model.SabrInterestRateParameters;
import com.opengamma.strata.pricer.model.SabrVolatilityFormula;
import com.opengamma.strata.pricer.option.RawOptionData;
import com.opengamma.strata.pricer.option.TenorRawOptionData;
import com.opengamma.strata.pricer.rate.RatesProvider;
import com.opengamma.strata.pricer.swap.DiscountingSwapProductPricer;
import com.opengamma.strata.pricer.swaption.SabrParametersSwaptionVolatilities;
import com.opengamma.strata.pricer.swaption.SabrSwaptionDefinition;
import com.opengamma.strata.pricer.swaption.SwaptionSurfaceExpiryTenorParameterMetadata;
import com.opengamma.strata.pricer.swaption.SwaptionVolatilities;
import com.opengamma.strata.pricer.swaption.SwaptionVolatilitiesName;
import com.opengamma.strata.product.common.BuySell;
import com.opengamma.strata.product.swap.SwapTrade;
import com.opengamma.strata.product.swap.type.FixedFloatSwapConvention;
import java.time.LocalDate;
import java.time.Period;
import java.time.ZonedDateTime;
import java.time.temporal.TemporalAmount;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import java.util.TreeMap;
import java.util.function.Function;

public final class SabrSwaptionCalibrator {
    private final SabrVolatilityFormula sabrVolatilityFormula;
    private final DiscountingSwapProductPricer swapPricer;
    private final ReferenceData refData;
    private static final NewtonRaphsonSingleRootFinder ROOT_FINDER = new NewtonRaphsonSingleRootFinder();
    public static final SabrSwaptionCalibrator DEFAULT = new SabrSwaptionCalibrator(SabrVolatilityFormula.hagan(), DiscountingSwapProductPricer.DEFAULT, ReferenceData.standard());

    public static SabrSwaptionCalibrator of(SabrVolatilityFormula sabrVolatilityFormula, DiscountingSwapProductPricer swapPricer) {
        return new SabrSwaptionCalibrator(sabrVolatilityFormula, swapPricer, ReferenceData.standard());
    }

    public static SabrSwaptionCalibrator of(SabrVolatilityFormula sabrVolatilityFormula, DiscountingSwapProductPricer swapPricer, ReferenceData refData) {
        return new SabrSwaptionCalibrator(sabrVolatilityFormula, swapPricer, refData);
    }

    private SabrSwaptionCalibrator(SabrVolatilityFormula sabrVolatilityFormula, DiscountingSwapProductPricer swapPricer, ReferenceData refData) {
        this.sabrVolatilityFormula = (SabrVolatilityFormula)ArgChecker.notNull((Object)sabrVolatilityFormula, (String)"sabrVolatilityFormula");
        this.swapPricer = (DiscountingSwapProductPricer)ArgChecker.notNull((Object)swapPricer, (String)"swapPricer");
        this.refData = (ReferenceData)ArgChecker.notNull((Object)refData, (String)"refData");
    }

    public SabrParametersSwaptionVolatilities calibrateWithFixedBetaAndShift(SabrSwaptionDefinition definition, ZonedDateTime calibrationDateTime, TenorRawOptionData data, RatesProvider ratesProvider, Surface betaSurface, Surface shiftSurface) {
        return this.calibrateWithFixedBetaAndShift(definition, calibrationDateTime, data, ratesProvider, betaSurface, shiftSurface, true);
    }

    public SabrParametersSwaptionVolatilities calibrateWithFixedBetaAndShift(SabrSwaptionDefinition definition, ZonedDateTime calibrationDateTime, TenorRawOptionData data, RatesProvider ratesProvider, Surface betaSurface, Surface shiftSurface, boolean stopOnMathException) {
        SwaptionVolatilitiesName name = definition.getName();
        FixedFloatSwapConvention convention = definition.getConvention();
        DayCount dayCount = definition.getDayCount();
        SurfaceInterpolator interpolator = definition.getInterpolator();
        BitSet fixed = new BitSet();
        fixed.set(1);
        BusinessDayAdjustment bda = convention.getFloatingLeg().getStartDateBusinessDayAdjustment();
        LocalDate calibrationDate = calibrationDateTime.toLocalDate();
        TreeMap parameterMetadataTmp = new TreeMap();
        TreeMap dataSensitivityAlphaTmp = new TreeMap();
        TreeMap dataSensitivityRhoTmp = new TreeMap();
        TreeMap dataSensitivityNuTmp = new TreeMap();
        TreeMap sabrPointTmp = new TreeMap();
        for (Tenor tenor : data.getTenors()) {
            RawOptionData tenorData = data.getData(tenor);
            double timeTenor = tenor.getPeriod().getYears() + tenor.getPeriod().getMonths() / 12;
            ImmutableList<Period> expiries = tenorData.getExpiries();
            for (Period expiry : expiries) {
                boolean error;
                DoubleMatrix inverseJacobian;
                SabrFormulaData sabrPoint;
                double timeToExpiry;
                block7: {
                    Pair<DoubleArray, DoubleArray> availableSmile = tenorData.availableSmileAtExpiry(expiry);
                    if (((DoubleArray)availableSmile.getFirst()).size() == 0) continue;
                    LocalDate exerciseDate = this.expirationDate(bda, calibrationDate, expiry);
                    LocalDate effectiveDate = convention.calculateSpotDateFromTradeDate(exerciseDate, this.refData);
                    timeToExpiry = dayCount.relativeYearFraction(calibrationDate, exerciseDate);
                    double beta = betaSurface.zValue(timeToExpiry, timeTenor);
                    double shift = shiftSurface.zValue(timeToExpiry, timeTenor);
                    LocalDate endDate = effectiveDate.plus((TemporalAmount)tenor);
                    SwapTrade swap0 = convention.toTrade(calibrationDate, effectiveDate, endDate, BuySell.BUY, 1.0, 0.0);
                    double forward = this.swapPricer.parRate(swap0.getProduct().resolve(this.refData), ratesProvider);
                    sabrPoint = null;
                    inverseJacobian = null;
                    error = false;
                    try {
                        Pair<SabrFormulaData, DoubleMatrix> calibrationResult = this.calibration(forward, shift, beta, fixed, bda, calibrationDateTime, dayCount, (DoubleArray)availableSmile.getFirst(), (DoubleArray)availableSmile.getSecond(), expiry, tenorData);
                        sabrPoint = (SabrFormulaData)calibrationResult.getFirst();
                        inverseJacobian = (DoubleMatrix)calibrationResult.getSecond();
                    }
                    catch (MathException e) {
                        error = true;
                        if (!stopOnMathException) break block7;
                        String message = Messages.format((String)"{} at expiry {} and tenor {}", (Object[])new Object[]{e.getMessage(), expiry, tenor});
                        throw new MathException(message, (Throwable)e);
                    }
                }
                if (error) continue;
                if (!parameterMetadataTmp.containsKey(timeToExpiry)) {
                    parameterMetadataTmp.put(timeToExpiry, new TreeMap());
                    dataSensitivityAlphaTmp.put(timeToExpiry, new TreeMap());
                    dataSensitivityRhoTmp.put(timeToExpiry, new TreeMap());
                    dataSensitivityNuTmp.put(timeToExpiry, new TreeMap());
                    sabrPointTmp.put(timeToExpiry, new TreeMap());
                }
                TreeMap parameterMetadataExpiryMap = (TreeMap)parameterMetadataTmp.get(timeToExpiry);
                TreeMap dataSensitivityAlphaExpiryMap = (TreeMap)dataSensitivityAlphaTmp.get(timeToExpiry);
                TreeMap dataSensitivityRhoExpiryMap = (TreeMap)dataSensitivityRhoTmp.get(timeToExpiry);
                TreeMap dataSensitivityNuExpiryMap = (TreeMap)dataSensitivityNuTmp.get(timeToExpiry);
                TreeMap sabrPointExpiryMap = (TreeMap)sabrPointTmp.get(timeToExpiry);
                parameterMetadataExpiryMap.put(timeTenor, SwaptionSurfaceExpiryTenorParameterMetadata.of(timeToExpiry, timeTenor, expiry.toString() + "x" + tenor));
                dataSensitivityAlphaExpiryMap.put(timeTenor, inverseJacobian.row(0));
                dataSensitivityRhoExpiryMap.put(timeTenor, inverseJacobian.row(2));
                dataSensitivityNuExpiryMap.put(timeTenor, inverseJacobian.row(3));
                sabrPointExpiryMap.put(timeTenor, sabrPoint);
            }
        }
        DoubleArray timeToExpiryArray = DoubleArray.EMPTY;
        DoubleArray timeTenorArray = DoubleArray.EMPTY;
        DoubleArray alphaArray = DoubleArray.EMPTY;
        DoubleArray rhoArray = DoubleArray.EMPTY;
        DoubleArray nuArray = DoubleArray.EMPTY;
        ArrayList parameterMetadata = new ArrayList();
        ArrayList<DoubleArray> dataSensitivityAlpha = new ArrayList<DoubleArray>();
        ArrayList<DoubleArray> dataSensitivityRho = new ArrayList<DoubleArray>();
        ArrayList<DoubleArray> dataSensitivityNu = new ArrayList<DoubleArray>();
        for (Double timeToExpiry : parameterMetadataTmp.keySet()) {
            TreeMap parameterMetadataExpiryMap = (TreeMap)parameterMetadataTmp.get(timeToExpiry);
            TreeMap dataSensitivityAlphaExpiryMap = (TreeMap)dataSensitivityAlphaTmp.get(timeToExpiry);
            TreeMap dataSensitivityRhoExpiryMap = (TreeMap)dataSensitivityRhoTmp.get(timeToExpiry);
            TreeMap dataSensitivityNuExpiryMap = (TreeMap)dataSensitivityNuTmp.get(timeToExpiry);
            TreeMap sabrPointExpiryMap = (TreeMap)sabrPointTmp.get(timeToExpiry);
            for (Double timeTenor : parameterMetadataExpiryMap.keySet()) {
                parameterMetadata.add(parameterMetadataExpiryMap.get(timeTenor));
                dataSensitivityAlpha.add((DoubleArray)dataSensitivityAlphaExpiryMap.get(timeTenor));
                dataSensitivityRho.add((DoubleArray)dataSensitivityRhoExpiryMap.get(timeTenor));
                dataSensitivityNu.add((DoubleArray)dataSensitivityNuExpiryMap.get(timeTenor));
                timeToExpiryArray = timeToExpiryArray.concat(new double[]{timeToExpiry});
                timeTenorArray = timeTenorArray.concat(new double[]{timeTenor});
                SabrFormulaData sabrPt = (SabrFormulaData)sabrPointExpiryMap.get(timeTenor);
                alphaArray = alphaArray.concat(new double[]{sabrPt.getAlpha()});
                rhoArray = rhoArray.concat(new double[]{sabrPt.getRho()});
                nuArray = nuArray.concat(new double[]{sabrPt.getNu()});
            }
        }
        SurfaceMetadata metadataAlpha = Surfaces.sabrParameterByExpiryTenor((String)(name.getName() + "-Alpha"), (DayCount)dayCount, (ValueType)ValueType.SABR_ALPHA).withParameterMetadata(parameterMetadata);
        SurfaceMetadata metadataRho = Surfaces.sabrParameterByExpiryTenor((String)(name.getName() + "-Rho"), (DayCount)dayCount, (ValueType)ValueType.SABR_RHO).withParameterMetadata(parameterMetadata);
        SurfaceMetadata metadataNu = Surfaces.sabrParameterByExpiryTenor((String)(name.getName() + "-Nu"), (DayCount)dayCount, (ValueType)ValueType.SABR_NU).withParameterMetadata(parameterMetadata);
        InterpolatedNodalSurface alphaSurface = InterpolatedNodalSurface.of((SurfaceMetadata)metadataAlpha, (DoubleArray)timeToExpiryArray, (DoubleArray)timeTenorArray, (DoubleArray)alphaArray, (SurfaceInterpolator)interpolator);
        InterpolatedNodalSurface rhoSurface = InterpolatedNodalSurface.of((SurfaceMetadata)metadataRho, (DoubleArray)timeToExpiryArray, (DoubleArray)timeTenorArray, (DoubleArray)rhoArray, (SurfaceInterpolator)interpolator);
        InterpolatedNodalSurface nuSurface = InterpolatedNodalSurface.of((SurfaceMetadata)metadataNu, (DoubleArray)timeToExpiryArray, (DoubleArray)timeTenorArray, (DoubleArray)nuArray, (SurfaceInterpolator)interpolator);
        SabrInterestRateParameters params = SabrInterestRateParameters.of((Surface)alphaSurface, betaSurface, (Surface)rhoSurface, (Surface)nuSurface, shiftSurface, this.sabrVolatilityFormula);
        return SabrParametersSwaptionVolatilities.builder().name(name).convention(convention).valuationDateTime(calibrationDateTime).parameters(params).dataSensitivityAlpha(dataSensitivityAlpha).dataSensitivityRho(dataSensitivityRho).dataSensitivityNu(dataSensitivityNu).build();
    }

    private Pair<SabrFormulaData, DoubleMatrix> calibration(double forward, double shift, double beta, BitSet fixed, BusinessDayAdjustment bda, ZonedDateTime calibrationDateTime, DayCount dayCount, DoubleArray strike, DoubleArray data, Period expiry, RawOptionData rawData) {
        double[] alphaStart;
        double rhoStart = -0.5 * beta + 0.5 * (1.0 - beta);
        alphaStart = new double[]{0.0025 / Math.pow(forward + shift, beta), alphaStart[0], 4.0 * alphaStart[0], alphaStart[2]};
        double[] nuStart = new double[]{0.1, 0.5, 0.1, 0.5};
        double chi2 = 1.0E12;
        Pair<LeastSquareResultsWithTransform, DoubleArray> sabrCalibrationResult = null;
        for (int i = 0; i < 4; ++i) {
            Pair<LeastSquareResultsWithTransform, DoubleArray> r;
            DoubleArray startParameters = DoubleArray.of((double)alphaStart[i], (double)beta, (double)rhoStart, (double)nuStart[i]);
            if (rawData.getDataType().equals((Object)ValueType.NORMAL_VOLATILITY)) {
                r = this.calibrateLsShiftedFromNormalVolatilities(bda, calibrationDateTime, dayCount, expiry, forward, strike, rawData.getStrikeType(), data, startParameters, fixed, shift);
            } else if (rawData.getDataType().equals((Object)ValueType.PRICE)) {
                r = this.calibrateLsShiftedFromPrices(bda, calibrationDateTime, dayCount, expiry, forward, strike, rawData.getStrikeType(), data, startParameters, fixed, shift);
            } else if (rawData.getDataType().equals((Object)ValueType.BLACK_VOLATILITY)) {
                r = this.calibrateLsShiftedFromBlackVolatilities(bda, calibrationDateTime, dayCount, expiry, forward, strike, rawData.getStrikeType(), data, rawData.getShift().orElse(0.0), startParameters, fixed, shift);
            } else {
                throw new IllegalArgumentException("Data type not supported");
            }
            if (!(((LeastSquareResultsWithTransform)r.getFirst()).getChiSq() < chi2)) continue;
            sabrCalibrationResult = r;
            chi2 = ((LeastSquareResultsWithTransform)r.getFirst()).getChiSq();
        }
        SabrFormulaData sabrParameters = SabrFormulaData.of(((LeastSquareResultsWithTransform)sabrCalibrationResult.getFirst()).getModelParameters().toArrayUnsafe());
        DoubleMatrix parameterSensitivityToBlackShifted = ((LeastSquareResultsWithTransform)sabrCalibrationResult.getFirst()).getModelParameterSensitivityToData();
        DoubleArray blackVolSensitivitytoRawData = (DoubleArray)sabrCalibrationResult.getSecond();
        double[][] parameterSensitivityToDataArray = new double[4][blackVolSensitivitytoRawData.size()];
        for (int loopsabr = 0; loopsabr < 4; ++loopsabr) {
            for (int loopdata = 0; loopdata < blackVolSensitivitytoRawData.size(); ++loopdata) {
                parameterSensitivityToDataArray[loopsabr][loopdata] = parameterSensitivityToBlackShifted.get(loopsabr, loopdata) * blackVolSensitivitytoRawData.get(loopdata);
            }
        }
        DoubleMatrix parameterSensitivityToData = DoubleMatrix.ofUnsafe((double[][])parameterSensitivityToDataArray);
        return Pair.of((Object)sabrParameters, (Object)parameterSensitivityToData);
    }

    public SabrParametersSwaptionVolatilities calibrateAlphaWithAtm(SwaptionVolatilitiesName name, SabrParametersSwaptionVolatilities sabr, RatesProvider ratesProvider, SwaptionVolatilities atmVolatilities, List<Tenor> tenors, List<Period> expiries, SurfaceInterpolator interpolator) {
        FixedFloatSwapConvention convention = sabr.getConvention();
        DayCount dayCount = sabr.getDayCount();
        BusinessDayAdjustment bda = convention.getFloatingLeg().getStartDateBusinessDayAdjustment();
        LocalDate calibrationDate = sabr.getValuationDate();
        DoubleArray timeToExpiryArray = DoubleArray.EMPTY;
        DoubleArray timeTenorArray = DoubleArray.EMPTY;
        DoubleArray alphaArray = DoubleArray.EMPTY;
        ArrayList<SwaptionSurfaceExpiryTenorParameterMetadata> parameterMetadata = new ArrayList<SwaptionSurfaceExpiryTenorParameterMetadata>();
        ArrayList<DoubleArray> dataSensitivityAlpha = new ArrayList<DoubleArray>();
        for (Period expiry : expiries) {
            for (Tenor tenor : tenors) {
                double timeTenor = tenor.getPeriod().getYears() + tenor.getPeriod().getMonths() / 12;
                LocalDate exerciseDate = this.expirationDate(bda, calibrationDate, expiry);
                LocalDate effectiveDate = convention.calculateSpotDateFromTradeDate(exerciseDate, this.refData);
                double timeToExpiry = dayCount.relativeYearFraction(calibrationDate, exerciseDate);
                LocalDate endDate = effectiveDate.plus((TemporalAmount)tenor);
                SwapTrade swap0 = convention.toTrade(calibrationDate, effectiveDate, endDate, BuySell.BUY, 1.0, 0.0);
                double forward = this.swapPricer.parRate(swap0.getProduct().resolve(this.refData), ratesProvider);
                double atmVolatility = atmVolatilities.volatility(timeToExpiry, timeTenor, forward, forward);
                ValueType volatilityType = atmVolatilities.getVolatilityType();
                double beta = sabr.getParameters().beta(timeToExpiry, timeTenor);
                double rho = sabr.getParameters().rho(timeToExpiry, timeTenor);
                double nu = sabr.getParameters().nu(timeToExpiry, timeTenor);
                double shift = sabr.getParameters().shift(timeToExpiry, timeTenor);
                Pair<Double, Double> calibrationResult = this.calibrationAtm(forward, shift, beta, rho, nu, bda, sabr.getValuationDateTime(), dayCount, expiry, atmVolatility, volatilityType);
                timeToExpiryArray = timeToExpiryArray.concat(new double[]{timeToExpiry});
                timeTenorArray = timeTenorArray.concat(new double[]{timeTenor});
                alphaArray = alphaArray.concat(new double[]{(Double)calibrationResult.getFirst()});
                parameterMetadata.add(SwaptionSurfaceExpiryTenorParameterMetadata.of(timeToExpiry, timeTenor, expiry.toString() + "x" + tenor));
                dataSensitivityAlpha.add(DoubleArray.of((double)((Double)calibrationResult.getSecond())));
            }
        }
        SurfaceMetadata metadataAlpha = Surfaces.sabrParameterByExpiryTenor((String)(name.getName() + "-Alpha"), (DayCount)dayCount, (ValueType)ValueType.SABR_ALPHA).withParameterMetadata(parameterMetadata);
        InterpolatedNodalSurface alphaSurface = InterpolatedNodalSurface.of((SurfaceMetadata)metadataAlpha, (DoubleArray)timeToExpiryArray, (DoubleArray)timeTenorArray, (DoubleArray)alphaArray, (SurfaceInterpolator)interpolator);
        SabrInterestRateParameters params = SabrInterestRateParameters.of((Surface)alphaSurface, sabr.getParameters().getBetaSurface(), sabr.getParameters().getRhoSurface(), sabr.getParameters().getNuSurface(), sabr.getParameters().getShiftSurface(), this.sabrVolatilityFormula);
        return SabrParametersSwaptionVolatilities.builder().name(name).convention(convention).valuationDateTime(sabr.getValuationDateTime()).parameters(params).dataSensitivityAlpha(dataSensitivityAlpha).build();
    }

    private Pair<Double, Double> calibrationAtm(double forward, double shift, double beta, double rho, double nu, BusinessDayAdjustment bda, ZonedDateTime calibrationDateTime, DayCount dayCount, Period expiry, double volatility, ValueType volatilityType) {
        Pair<Double, Double> r;
        double alphaStart = volatility / Math.pow(forward + shift, beta);
        DoubleArray startParameters = DoubleArray.of((double)alphaStart, (double)beta, (double)rho, (double)nu);
        if (volatilityType.equals((Object)ValueType.NORMAL_VOLATILITY)) {
            r = this.calibrateAtmShiftedFromNormalVolatilities(bda, calibrationDateTime, dayCount, expiry, forward, volatility, startParameters, shift);
        } else if (volatilityType.equals((Object)ValueType.BLACK_VOLATILITY)) {
            r = this.calibrateAtmShiftedFromBlackVolatilities(bda, calibrationDateTime, dayCount, expiry, forward, volatility, 0.0, startParameters, shift);
        } else {
            throw new IllegalArgumentException("Data type not supported");
        }
        return r;
    }

    public Pair<LeastSquareResultsWithTransform, DoubleArray> calibrateLsShiftedFromBlackVolatilities(BusinessDayAdjustment bda, ZonedDateTime calibrationDateTime, DayCount dayCount, Period periodToExpiry, double forward, DoubleArray strikesLike, ValueType strikeType, DoubleArray blackVolatilitiesInput, double shiftInput, DoubleArray startParameters, BitSet fixedParameters, double shiftOutput) {
        int nbStrikes = strikesLike.size();
        ArgChecker.isTrue((nbStrikes == blackVolatilitiesInput.size() ? 1 : 0) != 0, (String)"size of strikes must be the same as size of volatilities");
        LocalDate calibrationDate = calibrationDateTime.toLocalDate();
        LocalDate exerciseDate = this.expirationDate(bda, calibrationDate, periodToExpiry);
        double timeToExpiry = dayCount.relativeYearFraction(calibrationDate, exerciseDate);
        DoubleArray errors = DoubleArray.filled((int)nbStrikes, (double)1.0E-4);
        DoubleArray strikes = this.strikesShifted(forward, 0.0, strikesLike, strikeType);
        Pair<DoubleArray, DoubleArray> volAndDerivatives = this.blackVolatilitiesShiftedFromBlackVolatilitiesShifted(forward, shiftOutput, timeToExpiry, strikes, blackVolatilitiesInput, shiftInput);
        DoubleArray blackVolatilitiesTransformed = (DoubleArray)volAndDerivatives.getFirst();
        DoubleArray strikesShifted = this.strikesShifted(forward, shiftOutput, strikesLike, strikeType);
        SabrModelFitter fitter = new SabrModelFitter(forward + shiftOutput, strikesShifted, timeToExpiry, blackVolatilitiesTransformed, errors, this.sabrVolatilityFormula);
        LeastSquareResultsWithTransform result = fitter.solve(startParameters, fixedParameters);
        return Pair.of((Object)result, (Object)volAndDerivatives.getSecond());
    }

    public Pair<Double, Double> calibrateAtmShiftedFromBlackVolatilities(BusinessDayAdjustment bda, ZonedDateTime calibrationDateTime, DayCount dayCount, Period periodToExpiry, double forward, double blackVolatility, double shiftInput, DoubleArray startParameters, double shiftOutput) {
        LocalDate calibrationDate = calibrationDateTime.toLocalDate();
        LocalDate exerciseDate = this.expirationDate(bda, calibrationDate, periodToExpiry);
        double timeToExpiry = dayCount.relativeYearFraction(calibrationDate, exerciseDate);
        Pair<DoubleArray, DoubleArray> volAndDerivatives = this.blackVolatilitiesShiftedFromBlackVolatilitiesShifted(forward, shiftOutput, timeToExpiry, DoubleArray.of((double)forward), DoubleArray.of((double)blackVolatility), shiftInput);
        DoubleArray blackVolatilitiesTransformed = (DoubleArray)volAndDerivatives.getFirst();
        Function<Double, Double> volFunction = a -> this.sabrVolatilityFormula.volatility(forward + shiftOutput, forward + shiftOutput, timeToExpiry, (double)a, startParameters.get(1), startParameters.get(2), startParameters.get(3)) - blackVolatilitiesTransformed.get(0);
        double alphaCalibrated = ROOT_FINDER.getRoot(volFunction, Double.valueOf(startParameters.get(0)));
        double dAlphadBlack = 1.0 / this.sabrVolatilityFormula.volatilityAdjoint(forward + shiftOutput, forward + shiftOutput, timeToExpiry, alphaCalibrated, startParameters.get(1), startParameters.get(2), startParameters.get(3)).getDerivative(2);
        return Pair.of((Object)alphaCalibrated, (Object)(dAlphadBlack * ((DoubleArray)volAndDerivatives.getSecond()).get(0)));
    }

    public Pair<DoubleArray, DoubleArray> blackVolatilitiesShiftedFromBlackVolatilitiesShifted(double forward, double shiftOutput, double timeToExpiry, DoubleArray strikes, DoubleArray blackVolatilities, double shiftInput) {
        if (shiftInput == shiftOutput) {
            return Pair.of((Object)blackVolatilities, (Object)DoubleArray.filled((int)blackVolatilities.size(), (double)1.0));
        }
        int nbStrikes = strikes.size();
        double[] impliedVolatility = new double[nbStrikes];
        double[] impliedVolatilityDerivatives = new double[nbStrikes];
        for (int i = 0; i < nbStrikes; ++i) {
            ValueDerivatives price = BlackFormulaRepository.priceAdjoint(forward + shiftInput, strikes.get(i) + shiftInput, timeToExpiry, blackVolatilities.get(i), true);
            ValueDerivatives iv = BlackFormulaRepository.impliedVolatilityAdjoint(price.getValue(), forward + shiftOutput, strikes.get(i) + shiftOutput, timeToExpiry, true);
            impliedVolatility[i] = iv.getValue();
            impliedVolatilityDerivatives[i] = iv.getDerivative(0) * price.getDerivative(3);
        }
        return Pair.of((Object)DoubleArray.ofUnsafe((double[])impliedVolatility), (Object)DoubleArray.ofUnsafe((double[])impliedVolatilityDerivatives));
    }

    public Pair<LeastSquareResultsWithTransform, DoubleArray> calibrateLsShiftedFromPrices(BusinessDayAdjustment bda, ZonedDateTime calibrationDateTime, DayCount dayCount, Period periodToExpiry, double forward, DoubleArray strikesLike, ValueType strikeType, DoubleArray prices, DoubleArray startParameters, BitSet fixedParameters, double shiftOutput) {
        int nbStrikes = strikesLike.size();
        ArgChecker.isTrue((nbStrikes == prices.size() ? 1 : 0) != 0, (String)"size of strikes must be the same as size of prices");
        LocalDate calibrationDate = calibrationDateTime.toLocalDate();
        LocalDate exerciseDate = this.expirationDate(bda, calibrationDate, periodToExpiry);
        double timeToExpiry = dayCount.relativeYearFraction(calibrationDate, exerciseDate);
        DoubleArray errors = DoubleArray.filled((int)nbStrikes, (double)1.0E-4);
        DoubleArray strikes = this.strikesShifted(forward, 0.0, strikesLike, strikeType);
        Pair<DoubleArray, DoubleArray> volAndDerivatives = this.blackVolatilitiesShiftedFromPrices(forward, shiftOutput, timeToExpiry, strikes, prices);
        DoubleArray blackVolatilitiesTransformed = (DoubleArray)volAndDerivatives.getFirst();
        DoubleArray strikesShifted = this.strikesShifted(forward, shiftOutput, strikesLike, strikeType);
        SabrModelFitter fitter = new SabrModelFitter(forward + shiftOutput, strikesShifted, timeToExpiry, blackVolatilitiesTransformed, errors, this.sabrVolatilityFormula);
        return Pair.of((Object)fitter.solve(startParameters, fixedParameters), (Object)volAndDerivatives.getSecond());
    }

    public Pair<DoubleArray, DoubleArray> blackVolatilitiesShiftedFromPrices(double forward, double shiftOutput, double timeToExpiry, DoubleArray strikes, DoubleArray prices) {
        int nbStrikes = strikes.size();
        double[] impliedVolatility = new double[nbStrikes];
        double[] impliedVolatilityDerivatives = new double[nbStrikes];
        for (int i = 0; i < nbStrikes; ++i) {
            ValueDerivatives iv = BlackFormulaRepository.impliedVolatilityAdjoint(prices.get(i), forward + shiftOutput, strikes.get(i) + shiftOutput, timeToExpiry, true);
            impliedVolatility[i] = iv.getValue();
            impliedVolatilityDerivatives[i] = iv.getDerivative(0);
        }
        return Pair.of((Object)DoubleArray.ofUnsafe((double[])impliedVolatility), (Object)DoubleArray.ofUnsafe((double[])impliedVolatilityDerivatives));
    }

    public Pair<LeastSquareResultsWithTransform, DoubleArray> calibrateLsShiftedFromNormalVolatilities(BusinessDayAdjustment bda, ZonedDateTime calibrationDateTime, DayCount dayCount, Period periodToExpiry, double forward, DoubleArray strikesLike, ValueType strikeType, DoubleArray normalVolatilities, DoubleArray startParameters, BitSet fixedParameters, double shiftOutput) {
        int nbStrikes = strikesLike.size();
        ArgChecker.isTrue((nbStrikes == normalVolatilities.size() ? 1 : 0) != 0, (String)"size of strikes must be the same as size of prices");
        LocalDate calibrationDate = calibrationDateTime.toLocalDate();
        LocalDate exerciseDate = this.expirationDate(bda, calibrationDate, periodToExpiry);
        double timeToExpiry = dayCount.relativeYearFraction(calibrationDate, exerciseDate);
        DoubleArray errors = DoubleArray.filled((int)nbStrikes, (double)1.0E-4);
        DoubleArray strikes = this.strikesShifted(forward, 0.0, strikesLike, strikeType);
        Pair<DoubleArray, DoubleArray> volAndDerivatives = this.blackVolatilitiesShiftedFromNormalVolatilities(forward, shiftOutput, timeToExpiry, strikes, normalVolatilities);
        DoubleArray blackVolatilitiesTransformed = (DoubleArray)volAndDerivatives.getFirst();
        DoubleArray strikesShifted = this.strikesShifted(forward, shiftOutput, strikesLike, strikeType);
        SabrModelFitter fitter = new SabrModelFitter(forward + shiftOutput, strikesShifted, timeToExpiry, blackVolatilitiesTransformed, errors, this.sabrVolatilityFormula);
        LeastSquareResultsWithTransform result = fitter.solve(startParameters, fixedParameters);
        return Pair.of((Object)result, (Object)volAndDerivatives.getSecond());
    }

    public Pair<Double, Double> calibrateAtmShiftedFromNormalVolatilities(BusinessDayAdjustment bda, ZonedDateTime calibrationDateTime, DayCount dayCount, Period periodToExpiry, double forward, double normalVolatility, DoubleArray startParameters, double shiftOutput) {
        LocalDate calibrationDate = calibrationDateTime.toLocalDate();
        LocalDate exerciseDate = this.expirationDate(bda, calibrationDate, periodToExpiry);
        double timeToExpiry = dayCount.relativeYearFraction(calibrationDate, exerciseDate);
        Pair<DoubleArray, DoubleArray> volAndDerivatives = this.blackVolatilitiesShiftedFromNormalVolatilities(forward, shiftOutput, timeToExpiry, DoubleArray.of((double)forward), DoubleArray.of((double)normalVolatility));
        DoubleArray blackVolatilitiesTransformed = (DoubleArray)volAndDerivatives.getFirst();
        Function<Double, Double> volFunction = a -> this.sabrVolatilityFormula.volatility(forward + shiftOutput, forward + shiftOutput, timeToExpiry, (double)a, startParameters.get(1), startParameters.get(2), startParameters.get(3)) - blackVolatilitiesTransformed.get(0);
        double alphaCalibrated = ROOT_FINDER.getRoot(volFunction, Double.valueOf(startParameters.get(0)));
        double dAlphadBlack = 1.0 / this.sabrVolatilityFormula.volatilityAdjoint(forward + shiftOutput, forward + shiftOutput, timeToExpiry, alphaCalibrated, startParameters.get(1), startParameters.get(2), startParameters.get(3)).getDerivative(2);
        return Pair.of((Object)alphaCalibrated, (Object)(dAlphadBlack * ((DoubleArray)volAndDerivatives.getSecond()).get(0)));
    }

    public Pair<DoubleArray, DoubleArray> blackVolatilitiesShiftedFromNormalVolatilities(double forward, double shiftOutput, double timeToExpiry, DoubleArray strikes, DoubleArray normalVolatilities) {
        int nbStrikes = strikes.size();
        double[] impliedVolatility = new double[nbStrikes];
        double[] impliedVolatilityDerivatives = new double[nbStrikes];
        for (int i = 0; i < nbStrikes; ++i) {
            ValueDerivatives iv = BlackFormulaRepository.impliedVolatilityFromNormalApproximatedAdjoint(forward + shiftOutput, strikes.get(i) + shiftOutput, timeToExpiry, normalVolatilities.get(i));
            impliedVolatility[i] = iv.getValue();
            impliedVolatilityDerivatives[i] = iv.getDerivative(0);
        }
        return Pair.of((Object)DoubleArray.ofUnsafe((double[])impliedVolatility), (Object)DoubleArray.ofUnsafe((double[])impliedVolatilityDerivatives));
    }

    private DoubleArray strikesShifted(double forward, double shiftOutput, DoubleArray strikesLike, ValueType strikeType) {
        int nbStrikes = strikesLike.size();
        if (strikeType.equals((Object)ValueType.STRIKE)) {
            return DoubleArray.of((int)nbStrikes, i -> strikesLike.get(i) + shiftOutput);
        }
        if (strikeType.equals((Object)ValueType.SIMPLE_MONEYNESS)) {
            return DoubleArray.of((int)nbStrikes, i -> forward + strikesLike.get(i) + shiftOutput);
        }
        if (strikeType.equals((Object)ValueType.LOG_MONEYNESS)) {
            return DoubleArray.of((int)nbStrikes, i -> forward * Math.exp(strikesLike.get(i)) + shiftOutput);
        }
        throw new IllegalArgumentException("Strike type not supported");
    }

    private LocalDate expirationDate(BusinessDayAdjustment bda, LocalDate calibrationDate, Period expiry) {
        return bda.adjust(calibrationDate.plus(expiry), this.refData);
    }
}

