/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.pricer.swaption;

import com.opengamma.strata.basics.currency.Currency;
import com.opengamma.strata.basics.value.ValueDerivatives;
import com.opengamma.strata.collect.array.DoubleArray;
import com.opengamma.strata.market.model.SabrParameterType;
import com.opengamma.strata.market.sensitivity.PointSensitivity;
import com.opengamma.strata.market.sensitivity.PointSensitivityBuilder;
import com.opengamma.strata.pricer.ZeroRateSensitivity;
import com.opengamma.strata.pricer.impl.option.BlackFormulaRepository;
import com.opengamma.strata.pricer.rate.RatesProvider;
import com.opengamma.strata.pricer.swap.DiscountingSwapProductPricer;
import com.opengamma.strata.pricer.swaption.SabrSwaptionVolatilities;
import com.opengamma.strata.pricer.swaption.SwaptionSabrSensitivity;
import com.opengamma.strata.pricer.swaption.SwaptionVolatilitiesName;
import com.opengamma.strata.pricer.swaption.VolatilitySwaptionCashParYieldProductPricer;
import com.opengamma.strata.product.swap.ResolvedSwap;
import com.opengamma.strata.product.swap.ResolvedSwapLeg;
import com.opengamma.strata.product.swaption.CashSwaptionSettlement;
import com.opengamma.strata.product.swaption.ResolvedSwaption;
import java.time.LocalDate;
import java.time.ZonedDateTime;

public class SabrSwaptionCashParYieldProductPricer
extends VolatilitySwaptionCashParYieldProductPricer {
    public static final SabrSwaptionCashParYieldProductPricer DEFAULT = new SabrSwaptionCashParYieldProductPricer(DiscountingSwapProductPricer.DEFAULT);

    public SabrSwaptionCashParYieldProductPricer(DiscountingSwapProductPricer swapPricer) {
        super(swapPricer);
    }

    public PointSensitivityBuilder presentValueSensitivityRatesStickyModel(ResolvedSwaption swaption, RatesProvider ratesProvider, SabrSwaptionVolatilities swaptionVolatilities) {
        this.validate(swaption, ratesProvider, swaptionVolatilities);
        ZonedDateTime expiryDateTime = swaption.getExpiry();
        double expiry = swaptionVolatilities.relativeTime(expiryDateTime);
        ResolvedSwap underlying = swaption.getUnderlying();
        ResolvedSwapLeg fixedLeg = this.fixedLeg(underlying);
        if (expiry < 0.0) {
            return PointSensitivityBuilder.none();
        }
        double forward = this.forwardRate(swaption, ratesProvider);
        ValueDerivatives annuityDerivative = this.getSwapPricer().getLegPricer().annuityCashDerivative(fixedLeg, forward);
        double annuityCash = annuityDerivative.getValue();
        double annuityCashDr = annuityDerivative.getDerivative(0);
        LocalDate settlementDate = ((CashSwaptionSettlement)swaption.getSwaptionSettlement()).getSettlementDate();
        double discountSettle = ratesProvider.discountFactor(fixedLeg.getCurrency(), settlementDate);
        double strike = this.calculateStrike(fixedLeg);
        double tenor = swaptionVolatilities.tenor(fixedLeg.getStartDate(), fixedLeg.getEndDate());
        double shift = swaptionVolatilities.shift(expiry, tenor);
        ValueDerivatives volatilityAdj = swaptionVolatilities.volatilityAdjoint(expiry, tenor, strike, forward);
        boolean isCall = fixedLeg.getPayReceive().isPay();
        double shiftedForward = forward + shift;
        double shiftedStrike = strike + shift;
        double price = BlackFormulaRepository.price(shiftedForward, shiftedStrike, expiry, volatilityAdj.getValue(), isCall);
        double delta = BlackFormulaRepository.delta(shiftedForward, shiftedStrike, expiry, volatilityAdj.getValue(), isCall);
        double vega = BlackFormulaRepository.vega(shiftedForward, shiftedStrike, expiry, volatilityAdj.getValue());
        PointSensitivityBuilder forwardSensi = this.getSwapPricer().parRateSensitivity(underlying, ratesProvider);
        ZeroRateSensitivity discountSettleSensi = ratesProvider.discountFactors(fixedLeg.getCurrency()).zeroRatePointSensitivity(settlementDate);
        double sign = swaption.getLongShort().sign();
        return forwardSensi.multipliedBy(sign * discountSettle * (annuityCash * (delta + vega * volatilityAdj.getDerivative(0)) + annuityCashDr * price)).combinedWith(discountSettleSensi.multipliedBy(sign * annuityCash * price));
    }

    public PointSensitivityBuilder presentValueSensitivityModelParamsSabr(ResolvedSwaption swaption, RatesProvider ratesProvider, SabrSwaptionVolatilities swaptionVolatilities) {
        this.validate(swaption, ratesProvider, swaptionVolatilities);
        double expiry = swaptionVolatilities.relativeTime(swaption.getExpiry());
        ResolvedSwap underlying = swaption.getUnderlying();
        ResolvedSwapLeg fixedLeg = this.fixedLeg(underlying);
        double tenor = swaptionVolatilities.tenor(fixedLeg.getStartDate(), fixedLeg.getEndDate());
        double shift = swaptionVolatilities.shift(expiry, tenor);
        double strike = this.calculateStrike(fixedLeg);
        if (expiry < 0.0) {
            return PointSensitivityBuilder.none();
        }
        double forward = this.forwardRate(swaption, ratesProvider);
        double volatility = swaptionVolatilities.volatility(expiry, tenor, strike, forward);
        double numeraire = this.calculateNumeraire(swaption, fixedLeg, forward, ratesProvider);
        DoubleArray derivative = swaptionVolatilities.volatilityAdjoint(expiry, tenor, strike, forward).getDerivatives();
        double vega = numeraire * (double)swaption.getLongShort().sign() * BlackFormulaRepository.vega(forward + shift, strike + shift, expiry, volatility);
        Currency ccy = fixedLeg.getCurrency();
        SwaptionVolatilitiesName name = swaptionVolatilities.getName();
        return PointSensitivityBuilder.of((PointSensitivity[])new PointSensitivity[]{SwaptionSabrSensitivity.of(name, expiry, tenor, SabrParameterType.ALPHA, ccy, vega * derivative.get(2)), SwaptionSabrSensitivity.of(name, expiry, tenor, SabrParameterType.BETA, ccy, vega * derivative.get(3)), SwaptionSabrSensitivity.of(name, expiry, tenor, SabrParameterType.RHO, ccy, vega * derivative.get(4)), SwaptionSabrSensitivity.of(name, expiry, tenor, SabrParameterType.NU, ccy, vega * derivative.get(5))});
    }
}

