/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.pricer.swaption;

import com.opengamma.strata.collect.tuple.Pair;
import com.opengamma.strata.market.param.ParameterMetadata;
import java.io.Serializable;
import java.util.Map;
import java.util.NoSuchElementException;
import org.joda.beans.Bean;
import org.joda.beans.BeanBuilder;
import org.joda.beans.ImmutableBean;
import org.joda.beans.JodaBeanUtils;
import org.joda.beans.MetaBean;
import org.joda.beans.MetaProperty;
import org.joda.beans.gen.BeanDefinition;
import org.joda.beans.gen.ImmutablePreBuild;
import org.joda.beans.gen.PropertyDefinition;
import org.joda.beans.impl.direct.DirectMetaBean;
import org.joda.beans.impl.direct.DirectMetaProperty;
import org.joda.beans.impl.direct.DirectMetaPropertyMap;
import org.joda.beans.impl.direct.DirectPrivateBeanBuilder;

@BeanDefinition(builderScope="private")
public final class SwaptionSurfaceExpiryTenorParameterMetadata
implements ParameterMetadata,
ImmutableBean,
Serializable {
    @PropertyDefinition
    private final double yearFraction;
    @PropertyDefinition
    private final double tenor;
    @PropertyDefinition(validate="notEmpty", overrideGet=true)
    private final String label;
    private static final long serialVersionUID = 1L;

    public static SwaptionSurfaceExpiryTenorParameterMetadata of(double yearFraction, double tenor) {
        String label = Pair.of((Object)yearFraction, (Object)tenor).toString();
        return new SwaptionSurfaceExpiryTenorParameterMetadata(yearFraction, tenor, label);
    }

    public static SwaptionSurfaceExpiryTenorParameterMetadata of(double yearFraction, double tenor, String label) {
        return new SwaptionSurfaceExpiryTenorParameterMetadata(yearFraction, tenor, label);
    }

    @ImmutablePreBuild
    private static void preBuild(Builder builder) {
        if (builder.label == null) {
            builder.label = Pair.of((Object)builder.yearFraction, (Object)builder.tenor).toString();
        }
    }

    public Pair<Double, Double> getIdentifier() {
        return Pair.of((Object)this.yearFraction, (Object)this.tenor);
    }

    public static Meta meta() {
        return Meta.INSTANCE;
    }

    private SwaptionSurfaceExpiryTenorParameterMetadata(double yearFraction, double tenor, String label) {
        JodaBeanUtils.notEmpty((String)label, (String)"label");
        this.yearFraction = yearFraction;
        this.tenor = tenor;
        this.label = label;
    }

    public Meta metaBean() {
        return Meta.INSTANCE;
    }

    public double getYearFraction() {
        return this.yearFraction;
    }

    public double getTenor() {
        return this.tenor;
    }

    public String getLabel() {
        return this.label;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == this.getClass()) {
            SwaptionSurfaceExpiryTenorParameterMetadata other = (SwaptionSurfaceExpiryTenorParameterMetadata)obj;
            return JodaBeanUtils.equal((double)this.yearFraction, (double)other.yearFraction) && JodaBeanUtils.equal((double)this.tenor, (double)other.tenor) && JodaBeanUtils.equal((Object)this.label, (Object)other.label);
        }
        return false;
    }

    public int hashCode() {
        int hash = this.getClass().hashCode();
        hash = hash * 31 + JodaBeanUtils.hashCode((double)this.yearFraction);
        hash = hash * 31 + JodaBeanUtils.hashCode((double)this.tenor);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.label);
        return hash;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(128);
        buf.append("SwaptionSurfaceExpiryTenorParameterMetadata{");
        buf.append("yearFraction").append('=').append(JodaBeanUtils.toString((Object)this.yearFraction)).append(',').append(' ');
        buf.append("tenor").append('=').append(JodaBeanUtils.toString((Object)this.tenor)).append(',').append(' ');
        buf.append("label").append('=').append(JodaBeanUtils.toString((Object)this.label));
        buf.append('}');
        return buf.toString();
    }

    static {
        MetaBean.register((MetaBean)Meta.INSTANCE);
    }

    private static final class Builder
    extends DirectPrivateBeanBuilder<SwaptionSurfaceExpiryTenorParameterMetadata> {
        private double yearFraction;
        private double tenor;
        private String label;

        private Builder() {
        }

        public Object get(String propertyName) {
            switch (propertyName.hashCode()) {
                case -1731780257: {
                    return this.yearFraction;
                }
                case 110246592: {
                    return this.tenor;
                }
                case 102727412: {
                    return this.label;
                }
            }
            throw new NoSuchElementException("Unknown property: " + propertyName);
        }

        public Builder set(String propertyName, Object newValue) {
            switch (propertyName.hashCode()) {
                case -1731780257: {
                    this.yearFraction = (Double)newValue;
                    break;
                }
                case 110246592: {
                    this.tenor = (Double)newValue;
                    break;
                }
                case 102727412: {
                    this.label = (String)newValue;
                    break;
                }
                default: {
                    throw new NoSuchElementException("Unknown property: " + propertyName);
                }
            }
            return this;
        }

        public SwaptionSurfaceExpiryTenorParameterMetadata build() {
            SwaptionSurfaceExpiryTenorParameterMetadata.preBuild(this);
            return new SwaptionSurfaceExpiryTenorParameterMetadata(this.yearFraction, this.tenor, this.label);
        }

        public String toString() {
            StringBuilder buf = new StringBuilder(128);
            buf.append("SwaptionSurfaceExpiryTenorParameterMetadata.Builder{");
            buf.append("yearFraction").append('=').append(JodaBeanUtils.toString((Object)this.yearFraction)).append(',').append(' ');
            buf.append("tenor").append('=').append(JodaBeanUtils.toString((Object)this.tenor)).append(',').append(' ');
            buf.append("label").append('=').append(JodaBeanUtils.toString((Object)this.label));
            buf.append('}');
            return buf.toString();
        }
    }

    public static final class Meta
    extends DirectMetaBean {
        static final Meta INSTANCE = new Meta();
        private final MetaProperty<Double> yearFraction = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"yearFraction", SwaptionSurfaceExpiryTenorParameterMetadata.class, Double.TYPE);
        private final MetaProperty<Double> tenor = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"tenor", SwaptionSurfaceExpiryTenorParameterMetadata.class, Double.TYPE);
        private final MetaProperty<String> label = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"label", SwaptionSurfaceExpiryTenorParameterMetadata.class, String.class);
        private final Map<String, MetaProperty<?>> metaPropertyMap$ = new DirectMetaPropertyMap((DirectMetaBean)this, null, new String[]{"yearFraction", "tenor", "label"});

        private Meta() {
        }

        protected MetaProperty<?> metaPropertyGet(String propertyName) {
            switch (propertyName.hashCode()) {
                case -1731780257: {
                    return this.yearFraction;
                }
                case 110246592: {
                    return this.tenor;
                }
                case 102727412: {
                    return this.label;
                }
            }
            return super.metaPropertyGet(propertyName);
        }

        public BeanBuilder<? extends SwaptionSurfaceExpiryTenorParameterMetadata> builder() {
            return new Builder();
        }

        public Class<? extends SwaptionSurfaceExpiryTenorParameterMetadata> beanType() {
            return SwaptionSurfaceExpiryTenorParameterMetadata.class;
        }

        public Map<String, MetaProperty<?>> metaPropertyMap() {
            return this.metaPropertyMap$;
        }

        public MetaProperty<Double> yearFraction() {
            return this.yearFraction;
        }

        public MetaProperty<Double> tenor() {
            return this.tenor;
        }

        public MetaProperty<String> label() {
            return this.label;
        }

        protected Object propertyGet(Bean bean, String propertyName, boolean quiet) {
            switch (propertyName.hashCode()) {
                case -1731780257: {
                    return ((SwaptionSurfaceExpiryTenorParameterMetadata)bean).getYearFraction();
                }
                case 110246592: {
                    return ((SwaptionSurfaceExpiryTenorParameterMetadata)bean).getTenor();
                }
                case 102727412: {
                    return ((SwaptionSurfaceExpiryTenorParameterMetadata)bean).getLabel();
                }
            }
            return super.propertyGet(bean, propertyName, quiet);
        }

        protected void propertySet(Bean bean, String propertyName, Object newValue, boolean quiet) {
            this.metaProperty(propertyName);
            if (quiet) {
                return;
            }
            throw new UnsupportedOperationException("Property cannot be written: " + propertyName);
        }
    }
}

