/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.pricer.swaption;

import com.google.common.collect.ImmutableList;
import com.opengamma.strata.basics.currency.Currency;
import com.opengamma.strata.basics.currency.CurrencyAmount;
import com.opengamma.strata.basics.currency.MultiCurrencyAmount;
import com.opengamma.strata.basics.value.ValueDerivatives;
import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.market.sensitivity.PointSensitivityBuilder;
import com.opengamma.strata.pricer.ZeroRateSensitivity;
import com.opengamma.strata.pricer.rate.RatesProvider;
import com.opengamma.strata.pricer.swap.DiscountingSwapProductPricer;
import com.opengamma.strata.pricer.swaption.SwaptionSensitivity;
import com.opengamma.strata.pricer.swaption.SwaptionVolatilities;
import com.opengamma.strata.product.common.PutCall;
import com.opengamma.strata.product.common.SettlementType;
import com.opengamma.strata.product.rate.FixedRateComputation;
import com.opengamma.strata.product.rate.RateComputation;
import com.opengamma.strata.product.swap.RateAccrualPeriod;
import com.opengamma.strata.product.swap.RatePaymentPeriod;
import com.opengamma.strata.product.swap.ResolvedSwap;
import com.opengamma.strata.product.swap.ResolvedSwapLeg;
import com.opengamma.strata.product.swap.SwapLegType;
import com.opengamma.strata.product.swap.SwapPaymentPeriod;
import com.opengamma.strata.product.swaption.CashSwaptionSettlement;
import com.opengamma.strata.product.swaption.CashSwaptionSettlementMethod;
import com.opengamma.strata.product.swaption.ResolvedSwaption;
import java.time.LocalDate;

public class VolatilitySwaptionCashParYieldProductPricer {
    public static final VolatilitySwaptionCashParYieldProductPricer DEFAULT = new VolatilitySwaptionCashParYieldProductPricer(DiscountingSwapProductPricer.DEFAULT);
    private final DiscountingSwapProductPricer swapPricer;

    public VolatilitySwaptionCashParYieldProductPricer(DiscountingSwapProductPricer swapPricer) {
        this.swapPricer = (DiscountingSwapProductPricer)ArgChecker.notNull((Object)swapPricer, (String)"swapPricer");
    }

    protected DiscountingSwapProductPricer getSwapPricer() {
        return this.swapPricer;
    }

    public CurrencyAmount presentValue(ResolvedSwaption swaption, RatesProvider ratesProvider, SwaptionVolatilities swaptionVolatilities) {
        this.validate(swaption, ratesProvider, swaptionVolatilities);
        double expiry = swaptionVolatilities.relativeTime(swaption.getExpiry());
        ResolvedSwap underlying = swaption.getUnderlying();
        ResolvedSwapLeg fixedLeg = this.fixedLeg(underlying);
        if (expiry < 0.0) {
            return CurrencyAmount.of((Currency)fixedLeg.getCurrency(), (double)0.0);
        }
        double forward = this.forwardRate(swaption, ratesProvider);
        double numeraire = this.calculateNumeraire(swaption, fixedLeg, forward, ratesProvider);
        double strike = this.calculateStrike(fixedLeg);
        double tenor = swaptionVolatilities.tenor(fixedLeg.getStartDate(), fixedLeg.getEndDate());
        double volatility = swaptionVolatilities.volatility(expiry, tenor, strike, forward);
        PutCall putCall = PutCall.ofPut((boolean)fixedLeg.getPayReceive().isReceive());
        double price = numeraire * swaptionVolatilities.price(expiry, tenor, putCall, strike, forward, volatility);
        return CurrencyAmount.of((Currency)fixedLeg.getCurrency(), (double)(price * (double)swaption.getLongShort().sign()));
    }

    public MultiCurrencyAmount currencyExposure(ResolvedSwaption swaption, RatesProvider ratesProvider, SwaptionVolatilities swaptionVolatilities) {
        return MultiCurrencyAmount.of((CurrencyAmount[])new CurrencyAmount[]{this.presentValue(swaption, ratesProvider, swaptionVolatilities)});
    }

    public double impliedVolatility(ResolvedSwaption swaption, RatesProvider ratesProvider, SwaptionVolatilities swaptionVolatilities) {
        this.validate(swaption, ratesProvider, swaptionVolatilities);
        double expiry = swaptionVolatilities.relativeTime(swaption.getExpiry());
        ResolvedSwap underlying = swaption.getUnderlying();
        ResolvedSwapLeg fixedLeg = this.fixedLeg(underlying);
        ArgChecker.isTrue((expiry >= 0.0 ? 1 : 0) != 0, (String)"Option must be before expiry to compute an implied volatility");
        double forward = this.forwardRate(swaption, ratesProvider);
        double strike = this.calculateStrike(fixedLeg);
        double tenor = swaptionVolatilities.tenor(fixedLeg.getStartDate(), fixedLeg.getEndDate());
        return swaptionVolatilities.volatility(expiry, tenor, strike, forward);
    }

    public double forwardRate(ResolvedSwaption swaption, RatesProvider ratesProvider) {
        return this.swapPricer.parRate(swaption.getUnderlying(), ratesProvider);
    }

    public CurrencyAmount presentValueDelta(ResolvedSwaption swaption, RatesProvider ratesProvider, SwaptionVolatilities swaptionVolatilities) {
        this.validate(swaption, ratesProvider, swaptionVolatilities);
        double expiry = swaptionVolatilities.relativeTime(swaption.getExpiry());
        ResolvedSwap underlying = swaption.getUnderlying();
        ResolvedSwapLeg fixedLeg = this.fixedLeg(underlying);
        if (expiry < 0.0) {
            return CurrencyAmount.of((Currency)fixedLeg.getCurrency(), (double)0.0);
        }
        double forward = this.forwardRate(swaption, ratesProvider);
        double numeraire = this.calculateNumeraire(swaption, fixedLeg, forward, ratesProvider);
        double strike = this.calculateStrike(fixedLeg);
        double tenor = swaptionVolatilities.tenor(fixedLeg.getStartDate(), fixedLeg.getEndDate());
        double volatility = swaptionVolatilities.volatility(expiry, tenor, strike, forward);
        PutCall putCall = PutCall.ofPut((boolean)fixedLeg.getPayReceive().isReceive());
        double delta = numeraire * swaptionVolatilities.priceDelta(expiry, tenor, putCall, strike, forward, volatility);
        return CurrencyAmount.of((Currency)fixedLeg.getCurrency(), (double)(delta * (double)swaption.getLongShort().sign()));
    }

    public CurrencyAmount presentValueGamma(ResolvedSwaption swaption, RatesProvider ratesProvider, SwaptionVolatilities swaptionVolatilities) {
        this.validate(swaption, ratesProvider, swaptionVolatilities);
        double expiry = swaptionVolatilities.relativeTime(swaption.getExpiry());
        ResolvedSwap underlying = swaption.getUnderlying();
        ResolvedSwapLeg fixedLeg = this.fixedLeg(underlying);
        if (expiry < 0.0) {
            return CurrencyAmount.of((Currency)fixedLeg.getCurrency(), (double)0.0);
        }
        double forward = this.forwardRate(swaption, ratesProvider);
        double numeraire = this.calculateNumeraire(swaption, fixedLeg, forward, ratesProvider);
        double strike = this.calculateStrike(fixedLeg);
        double tenor = swaptionVolatilities.tenor(fixedLeg.getStartDate(), fixedLeg.getEndDate());
        double volatility = swaptionVolatilities.volatility(expiry, tenor, strike, forward);
        PutCall putCall = PutCall.ofPut((boolean)fixedLeg.getPayReceive().isReceive());
        double gamma = numeraire * swaptionVolatilities.priceGamma(expiry, tenor, putCall, strike, forward, volatility);
        return CurrencyAmount.of((Currency)fixedLeg.getCurrency(), (double)(gamma * (double)swaption.getLongShort().sign()));
    }

    public CurrencyAmount presentValueTheta(ResolvedSwaption swaption, RatesProvider ratesProvider, SwaptionVolatilities swaptionVolatilities) {
        this.validate(swaption, ratesProvider, swaptionVolatilities);
        double expiry = swaptionVolatilities.relativeTime(swaption.getExpiry());
        ResolvedSwap underlying = swaption.getUnderlying();
        ResolvedSwapLeg fixedLeg = this.fixedLeg(underlying);
        if (expiry < 0.0) {
            return CurrencyAmount.of((Currency)fixedLeg.getCurrency(), (double)0.0);
        }
        double forward = this.forwardRate(swaption, ratesProvider);
        double numeraire = this.calculateNumeraire(swaption, fixedLeg, forward, ratesProvider);
        double strike = this.calculateStrike(fixedLeg);
        double tenor = swaptionVolatilities.tenor(fixedLeg.getStartDate(), fixedLeg.getEndDate());
        double volatility = swaptionVolatilities.volatility(expiry, tenor, strike, forward);
        PutCall putCall = PutCall.ofPut((boolean)fixedLeg.getPayReceive().isReceive());
        double theta = numeraire * swaptionVolatilities.priceTheta(expiry, tenor, putCall, strike, forward, volatility);
        return CurrencyAmount.of((Currency)fixedLeg.getCurrency(), (double)(theta * (double)swaption.getLongShort().sign()));
    }

    public PointSensitivityBuilder presentValueSensitivityRatesStickyStrike(ResolvedSwaption swaption, RatesProvider ratesProvider, SwaptionVolatilities swaptionVolatilities) {
        this.validate(swaption, ratesProvider, swaptionVolatilities);
        double expiry = swaptionVolatilities.relativeTime(swaption.getExpiry());
        ResolvedSwap underlying = swaption.getUnderlying();
        ResolvedSwapLeg fixedLeg = this.fixedLeg(underlying);
        if (expiry < 0.0) {
            return PointSensitivityBuilder.none();
        }
        double forward = this.forwardRate(swaption, ratesProvider);
        ValueDerivatives annuityDerivative = this.getSwapPricer().getLegPricer().annuityCashDerivative(fixedLeg, forward);
        double annuityCash = annuityDerivative.getValue();
        double annuityCashDr = annuityDerivative.getDerivative(0);
        LocalDate settlementDate = ((CashSwaptionSettlement)swaption.getSwaptionSettlement()).getSettlementDate();
        double discountSettle = ratesProvider.discountFactor(fixedLeg.getCurrency(), settlementDate);
        double strike = this.calculateStrike(fixedLeg);
        double tenor = swaptionVolatilities.tenor(fixedLeg.getStartDate(), fixedLeg.getEndDate());
        double volatility = swaptionVolatilities.volatility(expiry, tenor, strike, forward);
        PutCall putCall = PutCall.ofPut((boolean)fixedLeg.getPayReceive().isReceive());
        double price = swaptionVolatilities.price(expiry, tenor, putCall, strike, forward, volatility);
        double delta = swaptionVolatilities.priceDelta(expiry, tenor, putCall, strike, forward, volatility);
        PointSensitivityBuilder forwardSensi = this.getSwapPricer().parRateSensitivity(underlying, ratesProvider);
        ZeroRateSensitivity discountSettleSensi = ratesProvider.discountFactors(fixedLeg.getCurrency()).zeroRatePointSensitivity(settlementDate);
        double sign = swaption.getLongShort().sign();
        return forwardSensi.multipliedBy(sign * discountSettle * (annuityCash * delta + annuityCashDr * price)).combinedWith(discountSettleSensi.multipliedBy(sign * annuityCash * price));
    }

    public SwaptionSensitivity presentValueSensitivityModelParamsVolatility(ResolvedSwaption swaption, RatesProvider ratesProvider, SwaptionVolatilities swaptionVolatilities) {
        this.validate(swaption, ratesProvider, swaptionVolatilities);
        double expiry = swaptionVolatilities.relativeTime(swaption.getExpiry());
        ResolvedSwap underlying = swaption.getUnderlying();
        ResolvedSwapLeg fixedLeg = this.fixedLeg(underlying);
        double tenor = swaptionVolatilities.tenor(fixedLeg.getStartDate(), fixedLeg.getEndDate());
        double strike = this.calculateStrike(fixedLeg);
        if (expiry < 0.0) {
            return SwaptionSensitivity.of(swaptionVolatilities.getName(), expiry, tenor, strike, 0.0, fixedLeg.getCurrency(), 0.0);
        }
        double forward = this.forwardRate(swaption, ratesProvider);
        double numeraire = this.calculateNumeraire(swaption, fixedLeg, forward, ratesProvider);
        double volatility = swaptionVolatilities.volatility(expiry, tenor, strike, forward);
        PutCall putCall = PutCall.ofPut((boolean)fixedLeg.getPayReceive().isReceive());
        double vega = numeraire * swaptionVolatilities.priceVega(expiry, tenor, putCall, strike, forward, volatility);
        return SwaptionSensitivity.of(swaptionVolatilities.getName(), expiry, tenor, strike, forward, fixedLeg.getCurrency(), vega * (double)swaption.getLongShort().sign());
    }

    protected double calculateNumeraire(ResolvedSwaption swaption, ResolvedSwapLeg fixedLeg, double forward, RatesProvider ratesProvider) {
        double annuityCash = this.swapPricer.getLegPricer().annuityCash(fixedLeg, forward);
        CashSwaptionSettlement cashSettlement = (CashSwaptionSettlement)swaption.getSwaptionSettlement();
        double discountSettle = ratesProvider.discountFactor(fixedLeg.getCurrency(), cashSettlement.getSettlementDate());
        return Math.abs(annuityCash * discountSettle);
    }

    protected double calculateStrike(ResolvedSwapLeg fixedLeg) {
        SwapPaymentPeriod paymentPeriod = (SwapPaymentPeriod)fixedLeg.getPaymentPeriods().get(0);
        ArgChecker.isTrue((boolean)(paymentPeriod instanceof RatePaymentPeriod), (String)"Payment period must be RatePaymentPeriod");
        RatePaymentPeriod ratePaymentPeriod = (RatePaymentPeriod)paymentPeriod;
        RateComputation rateComputation = ((RateAccrualPeriod)ratePaymentPeriod.getAccrualPeriods().get(0)).getRateComputation();
        ArgChecker.isTrue((boolean)(rateComputation instanceof FixedRateComputation), (String)"Swap leg must be fixed leg");
        return ((FixedRateComputation)rateComputation).getRate();
    }

    protected ResolvedSwapLeg fixedLeg(ResolvedSwap swap) {
        ArgChecker.isFalse((boolean)swap.isCrossCurrency(), (String)"Swap must be single currency");
        ImmutableList fixedLegs = swap.getLegs(SwapLegType.FIXED);
        if (fixedLegs.isEmpty()) {
            throw new IllegalArgumentException("Swap must contain a fixed leg");
        }
        return (ResolvedSwapLeg)fixedLegs.get(0);
    }

    protected void validate(ResolvedSwaption swaption, RatesProvider ratesProvider, SwaptionVolatilities swaptionVolatilities) {
        ArgChecker.isTrue((boolean)swaptionVolatilities.getValuationDate().equals(ratesProvider.getValuationDate()), (String)"Volatility and rate data must be for the same date");
        this.validateSwaption(swaption);
    }

    protected void validateSwaption(ResolvedSwaption swaption) {
        ArgChecker.isFalse((boolean)swaption.getUnderlying().isCrossCurrency(), (String)"Underlying swap must be single currency");
        ArgChecker.isTrue((boolean)swaption.getSwaptionSettlement().getSettlementType().equals((Object)SettlementType.CASH), (String)"Swaption must be cash settlement");
        CashSwaptionSettlement cashSettle = (CashSwaptionSettlement)swaption.getSwaptionSettlement();
        ArgChecker.isTrue((boolean)cashSettle.getMethod().equals((Object)CashSwaptionSettlementMethod.PAR_YIELD), (String)"Cash settlement method must be par yield");
    }
}

