/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.pricer.swaption;

import com.opengamma.strata.basics.currency.CurrencyAmount;
import com.opengamma.strata.basics.currency.MultiCurrencyAmount;
import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.market.sensitivity.PointSensitivityBuilder;
import com.opengamma.strata.pricer.rate.RatesProvider;
import com.opengamma.strata.pricer.swaption.SwaptionSensitivity;
import com.opengamma.strata.pricer.swaption.SwaptionVolatilities;
import com.opengamma.strata.pricer.swaption.VolatilitySwaptionCashParYieldProductPricer;
import com.opengamma.strata.pricer.swaption.VolatilitySwaptionPhysicalProductPricer;
import com.opengamma.strata.product.common.SettlementType;
import com.opengamma.strata.product.swaption.ResolvedSwaption;

public class VolatilitySwaptionProductPricer {
    public static final VolatilitySwaptionProductPricer DEFAULT = new VolatilitySwaptionProductPricer(VolatilitySwaptionCashParYieldProductPricer.DEFAULT, VolatilitySwaptionPhysicalProductPricer.DEFAULT);
    private final VolatilitySwaptionCashParYieldProductPricer cashParYieldPricer;
    private final VolatilitySwaptionPhysicalProductPricer physicalPricer;

    public VolatilitySwaptionProductPricer(VolatilitySwaptionCashParYieldProductPricer cashParYieldPricer, VolatilitySwaptionPhysicalProductPricer physicalPricer) {
        this.cashParYieldPricer = (VolatilitySwaptionCashParYieldProductPricer)ArgChecker.notNull((Object)cashParYieldPricer, (String)"cashParYieldPricer");
        this.physicalPricer = (VolatilitySwaptionPhysicalProductPricer)ArgChecker.notNull((Object)physicalPricer, (String)"physicalPricer");
    }

    public CurrencyAmount presentValue(ResolvedSwaption swaption, RatesProvider ratesProvider, SwaptionVolatilities swaptionVolatilities) {
        if (this.isCash(swaption)) {
            return this.cashParYieldPricer.presentValue(swaption, ratesProvider, swaptionVolatilities);
        }
        return this.physicalPricer.presentValue(swaption, ratesProvider, swaptionVolatilities);
    }

    public MultiCurrencyAmount currencyExposure(ResolvedSwaption swaption, RatesProvider ratesProvider, SwaptionVolatilities swaptionVolatilities) {
        if (this.isCash(swaption)) {
            return this.cashParYieldPricer.currencyExposure(swaption, ratesProvider, swaptionVolatilities);
        }
        return this.physicalPricer.currencyExposure(swaption, ratesProvider, swaptionVolatilities);
    }

    public double impliedVolatility(ResolvedSwaption swaption, RatesProvider ratesProvider, SwaptionVolatilities swaptionVolatilities) {
        if (this.isCash(swaption)) {
            return this.cashParYieldPricer.impliedVolatility(swaption, ratesProvider, swaptionVolatilities);
        }
        return this.physicalPricer.impliedVolatility(swaption, ratesProvider, swaptionVolatilities);
    }

    public double forwardRate(ResolvedSwaption swaption, RatesProvider ratesProvider) {
        if (this.isCash(swaption)) {
            return this.cashParYieldPricer.forwardRate(swaption, ratesProvider);
        }
        return this.physicalPricer.forwardRate(swaption, ratesProvider);
    }

    public CurrencyAmount presentValueDelta(ResolvedSwaption swaption, RatesProvider ratesProvider, SwaptionVolatilities swaptionVolatilities) {
        if (this.isCash(swaption)) {
            return this.cashParYieldPricer.presentValueDelta(swaption, ratesProvider, swaptionVolatilities);
        }
        return this.physicalPricer.presentValueDelta(swaption, ratesProvider, swaptionVolatilities);
    }

    public CurrencyAmount presentValueGamma(ResolvedSwaption swaption, RatesProvider ratesProvider, SwaptionVolatilities swaptionVolatilities) {
        if (this.isCash(swaption)) {
            return this.cashParYieldPricer.presentValueGamma(swaption, ratesProvider, swaptionVolatilities);
        }
        return this.physicalPricer.presentValueGamma(swaption, ratesProvider, swaptionVolatilities);
    }

    public CurrencyAmount presentValueTheta(ResolvedSwaption swaption, RatesProvider ratesProvider, SwaptionVolatilities swaptionVolatilities) {
        if (this.isCash(swaption)) {
            return this.cashParYieldPricer.presentValueTheta(swaption, ratesProvider, swaptionVolatilities);
        }
        return this.physicalPricer.presentValueTheta(swaption, ratesProvider, swaptionVolatilities);
    }

    public PointSensitivityBuilder presentValueSensitivityRatesStickyStrike(ResolvedSwaption swaption, RatesProvider ratesProvider, SwaptionVolatilities swaptionVolatilities) {
        if (this.isCash(swaption)) {
            return this.cashParYieldPricer.presentValueSensitivityRatesStickyStrike(swaption, ratesProvider, swaptionVolatilities);
        }
        return this.physicalPricer.presentValueSensitivityRatesStickyStrike(swaption, ratesProvider, swaptionVolatilities);
    }

    public SwaptionSensitivity presentValueSensitivityModelParamsVolatility(ResolvedSwaption swaption, RatesProvider ratesProvider, SwaptionVolatilities swaptionVolatilities) {
        if (this.isCash(swaption)) {
            return this.cashParYieldPricer.presentValueSensitivityModelParamsVolatility(swaption, ratesProvider, swaptionVolatilities);
        }
        return this.physicalPricer.presentValueSensitivityModelParamsVolatility(swaption, ratesProvider, swaptionVolatilities);
    }

    private boolean isCash(ResolvedSwaption product) {
        return product.getSwaptionSettlement().getSettlementType().equals((Object)SettlementType.CASH);
    }
}

