/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.product;

import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.collect.named.Named;
import com.opengamma.strata.product.common.BuySell;
import com.opengamma.strata.product.common.CcpId;
import java.io.Serializable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;
import org.joda.convert.FromString;
import org.joda.convert.StringConvert;
import org.joda.convert.ToString;
import org.joda.convert.TypedStringConverter;

public final class AttributeType<T>
implements Named,
Comparable<AttributeType<T>>,
Serializable {
    private static final ConcurrentMap<String, AttributeType<?>> INSTANCES = new ConcurrentHashMap();
    public static final AttributeType<String> DESCRIPTION = AttributeType.registerInstance("description", String.class, new String[0]);
    public static final AttributeType<String> NAME = AttributeType.registerInstance("name", String.class, new String[0]);
    public static final AttributeType<CcpId> CCP = AttributeType.registerInstance("ccp", CcpId.class, new String[0]);
    public static final AttributeType<BuySell> BUY_SELL = AttributeType.registerInstance("BuySell", BuySell.class, new String[0]);
    private static final long serialVersionUID = 1L;
    private final String name;
    private final transient Class<T> type;
    private final transient Function<T, Object> toStoredFormConverter;
    private final transient Function<Object, T> fromStoredFormConverter;

    @FromString
    public static <T> AttributeType<T> of(String name) {
        ArgChecker.notEmpty((String)name, (String)"name");
        return INSTANCES.computeIfAbsent(name, key -> new AttributeType((String)key));
    }

    public static <T> AttributeType<T> registerInstance(String name, Class<T> type, String ... aliases) {
        ArgChecker.notEmpty((String)name, (String)"name");
        ArgChecker.notNull(type, (String)"type");
        ArgChecker.notNull((Object)aliases, (String)"aliases");
        AttributeType<T> instance = new AttributeType<T>(name, type);
        INSTANCES.put(name, instance);
        for (String alias : aliases) {
            ArgChecker.notNull((Object)alias, (String)"alias");
            INSTANCES.put(alias, instance);
        }
        return instance;
    }

    private AttributeType(String name) {
        this.name = ArgChecker.notEmpty((String)name, (String)"name");
        this.type = null;
        this.toStoredFormConverter = value -> value;
        this.fromStoredFormConverter = value -> value;
    }

    private AttributeType(String name, Class<T> type) {
        this.name = ArgChecker.notEmpty((String)name, (String)"name");
        this.type = (Class)ArgChecker.notNull(type, (String)"type");
        if (StringConvert.INSTANCE.isConvertible(type)) {
            TypedStringConverter converter = StringConvert.INSTANCE.findTypedConverter(type);
            this.toStoredFormConverter = value -> converter.convertToString(value);
            this.fromStoredFormConverter = value -> value instanceof String ? converter.convertFromString(type, (String)value) : converter.convertFromString(type, StringConvert.INSTANCE.convertToString(value));
        } else {
            this.toStoredFormConverter = value -> type.cast(value);
            this.fromStoredFormConverter = value -> type.cast(value);
        }
    }

    private Object readResolve() {
        ArgChecker.notEmpty((String)this.name, (String)"name");
        return AttributeType.of(this.name);
    }

    public String getName() {
        return this.name;
    }

    public <R> AttributeType<R> captureWildcard() {
        return this;
    }

    public AttributeType<T> normalized() {
        return this.type == null ? AttributeType.of(this.name) : this;
    }

    public Object toStoredForm(T value) {
        if (value == null) {
            return null;
        }
        return this.normalized().toStoredFormConverter.apply(value);
    }

    public T fromStoredForm(Object storedValue) {
        if (storedValue == null) {
            return null;
        }
        return this.normalized().fromStoredFormConverter.apply(storedValue);
    }

    @Override
    public final int compareTo(AttributeType<T> other) {
        return this.name.compareTo(other.toString());
    }

    public final boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == this.getClass()) {
            AttributeType other = (AttributeType)obj;
            return this.name.equals(other.name);
        }
        return false;
    }

    public final int hashCode() {
        return this.name.hashCode() ^ this.getClass().hashCode();
    }

    @ToString
    public final String toString() {
        return this.name;
    }
}

