/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.product;

import com.google.common.collect.ImmutableSet;
import com.opengamma.strata.collect.Messages;
import com.opengamma.strata.product.AttributeType;
import com.opengamma.strata.product.SimpleAttributes;
import java.util.Optional;

public interface Attributes {
    public static Attributes empty() {
        return SimpleAttributes.empty();
    }

    public static <T> Attributes of(AttributeType<T> type, T value) {
        return SimpleAttributes.of(type, value);
    }

    default public ImmutableSet<AttributeType<?>> getAttributeTypes() {
        return ImmutableSet.of();
    }

    default public <T> T getAttribute(AttributeType<T> type) {
        return this.findAttribute(type).orElseThrow(() -> new IllegalArgumentException(Messages.format((String)"Attribute not found for type '{}'", (Object)type)));
    }

    default public <T> boolean containsAttribute(AttributeType<T> type) {
        return this.findAttribute(type).isPresent();
    }

    default public <T> boolean containsAttribute(AttributeType<T> type, T attributeValue) {
        return this.findAttribute(type).map(attribute -> attribute.equals(attributeValue)).orElse(false);
    }

    public <T> Optional<T> findAttribute(AttributeType<T> var1);

    public <T> Attributes withAttribute(AttributeType<T> var1, T var2);

    default public Attributes withAttributes(Attributes other) {
        Attributes combined = this;
        for (AttributeType type : other.getAttributeTypes()) {
            combined = combined.withAttribute(type.captureWildcard(), other.getAttribute(type));
        }
        return combined;
    }
}

