/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.product;

import com.google.common.collect.ImmutableSet;
import com.opengamma.strata.basics.ReferenceData;
import com.opengamma.strata.basics.currency.Currency;
import com.opengamma.strata.product.GenericSecurityPosition;
import com.opengamma.strata.product.GenericSecurityTrade;
import com.opengamma.strata.product.PositionInfo;
import com.opengamma.strata.product.SecuritizedProduct;
import com.opengamma.strata.product.Security;
import com.opengamma.strata.product.SecurityId;
import com.opengamma.strata.product.SecurityInfo;
import com.opengamma.strata.product.TradeInfo;
import java.io.Serializable;
import java.util.Map;
import java.util.NoSuchElementException;
import org.joda.beans.Bean;
import org.joda.beans.BeanBuilder;
import org.joda.beans.ImmutableBean;
import org.joda.beans.JodaBeanUtils;
import org.joda.beans.MetaBean;
import org.joda.beans.MetaProperty;
import org.joda.beans.gen.BeanDefinition;
import org.joda.beans.gen.PropertyDefinition;
import org.joda.beans.impl.direct.DirectMetaBean;
import org.joda.beans.impl.direct.DirectMetaProperty;
import org.joda.beans.impl.direct.DirectMetaPropertyMap;
import org.joda.beans.impl.direct.DirectPrivateBeanBuilder;

@BeanDefinition(builderScope="private")
public final class GenericSecurity
implements Security,
SecuritizedProduct,
ImmutableBean,
Serializable {
    @PropertyDefinition(validate="notNull", overrideGet=true)
    private final SecurityInfo info;
    private static final long serialVersionUID = 1L;

    public static GenericSecurity of(SecurityInfo securityInfo) {
        return new GenericSecurity(securityInfo);
    }

    @Override
    public SecurityId getSecurityId() {
        return Security.super.getSecurityId();
    }

    @Override
    public Currency getCurrency() {
        return Security.super.getCurrency();
    }

    @Override
    public ImmutableSet<SecurityId> getUnderlyingIds() {
        return ImmutableSet.of();
    }

    @Override
    public GenericSecurity withInfo(SecurityInfo info) {
        return new GenericSecurity(info);
    }

    @Override
    public GenericSecurity createProduct(ReferenceData refData) {
        return this;
    }

    @Override
    public GenericSecurityTrade createTrade(TradeInfo info, double quantity, double tradePrice, ReferenceData refData) {
        return new GenericSecurityTrade(info, this, quantity, tradePrice);
    }

    @Override
    public GenericSecurityPosition createPosition(PositionInfo tradeInfo, double quantity, ReferenceData refData) {
        return GenericSecurityPosition.ofNet(tradeInfo, this, quantity);
    }

    @Override
    public GenericSecurityPosition createPosition(PositionInfo positionInfo, double longQuantity, double shortQuantity, ReferenceData refData) {
        return GenericSecurityPosition.ofLongShort(positionInfo, this, longQuantity, shortQuantity);
    }

    public static Meta meta() {
        return Meta.INSTANCE;
    }

    private GenericSecurity(SecurityInfo info) {
        JodaBeanUtils.notNull((Object)info, (String)"info");
        this.info = info;
    }

    public Meta metaBean() {
        return Meta.INSTANCE;
    }

    @Override
    public SecurityInfo getInfo() {
        return this.info;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == this.getClass()) {
            GenericSecurity other = (GenericSecurity)obj;
            return JodaBeanUtils.equal((Object)this.info, (Object)other.info);
        }
        return false;
    }

    public int hashCode() {
        int hash = this.getClass().hashCode();
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.info);
        return hash;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(64);
        buf.append("GenericSecurity{");
        buf.append("info").append('=').append(JodaBeanUtils.toString((Object)this.info));
        buf.append('}');
        return buf.toString();
    }

    static {
        MetaBean.register((MetaBean)Meta.INSTANCE);
    }

    private static final class Builder
    extends DirectPrivateBeanBuilder<GenericSecurity> {
        private SecurityInfo info;

        private Builder() {
        }

        public Object get(String propertyName) {
            switch (propertyName.hashCode()) {
                case 3237038: {
                    return this.info;
                }
            }
            throw new NoSuchElementException("Unknown property: " + propertyName);
        }

        public Builder set(String propertyName, Object newValue) {
            switch (propertyName.hashCode()) {
                case 3237038: {
                    this.info = (SecurityInfo)newValue;
                    break;
                }
                default: {
                    throw new NoSuchElementException("Unknown property: " + propertyName);
                }
            }
            return this;
        }

        public GenericSecurity build() {
            return new GenericSecurity(this.info);
        }

        public String toString() {
            StringBuilder buf = new StringBuilder(64);
            buf.append("GenericSecurity.Builder{");
            buf.append("info").append('=').append(JodaBeanUtils.toString((Object)this.info));
            buf.append('}');
            return buf.toString();
        }
    }

    public static final class Meta
    extends DirectMetaBean {
        static final Meta INSTANCE = new Meta();
        private final MetaProperty<SecurityInfo> info = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"info", GenericSecurity.class, SecurityInfo.class);
        private final Map<String, MetaProperty<?>> metaPropertyMap$ = new DirectMetaPropertyMap((DirectMetaBean)this, null, new String[]{"info"});

        private Meta() {
        }

        protected MetaProperty<?> metaPropertyGet(String propertyName) {
            switch (propertyName.hashCode()) {
                case 3237038: {
                    return this.info;
                }
            }
            return super.metaPropertyGet(propertyName);
        }

        public BeanBuilder<? extends GenericSecurity> builder() {
            return new Builder();
        }

        public Class<? extends GenericSecurity> beanType() {
            return GenericSecurity.class;
        }

        public Map<String, MetaProperty<?>> metaPropertyMap() {
            return this.metaPropertyMap$;
        }

        public MetaProperty<SecurityInfo> info() {
            return this.info;
        }

        protected Object propertyGet(Bean bean, String propertyName, boolean quiet) {
            switch (propertyName.hashCode()) {
                case 3237038: {
                    return ((GenericSecurity)bean).getInfo();
                }
            }
            return super.propertyGet(bean, propertyName, quiet);
        }

        protected void propertySet(Bean bean, String propertyName, Object newValue, boolean quiet) {
            this.metaProperty(propertyName);
            if (quiet) {
                return;
            }
            throw new UnsupportedOperationException("Property cannot be written: " + propertyName);
        }
    }
}

