/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.product;

import com.opengamma.strata.basics.currency.Currency;
import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.product.GenericSecurity;
import com.opengamma.strata.product.PortfolioItemInfo;
import com.opengamma.strata.product.PortfolioItemSummary;
import com.opengamma.strata.product.PositionInfo;
import com.opengamma.strata.product.ProductType;
import com.opengamma.strata.product.SecuritizedProductPosition;
import com.opengamma.strata.product.SecurityId;
import com.opengamma.strata.product.common.SummarizerUtils;
import java.io.Serializable;
import java.util.Map;
import java.util.NoSuchElementException;
import org.joda.beans.Bean;
import org.joda.beans.ImmutableBean;
import org.joda.beans.JodaBeanUtils;
import org.joda.beans.MetaBean;
import org.joda.beans.MetaProperty;
import org.joda.beans.gen.BeanDefinition;
import org.joda.beans.gen.DerivedProperty;
import org.joda.beans.gen.ImmutableDefaults;
import org.joda.beans.gen.PropertyDefinition;
import org.joda.beans.impl.direct.DirectFieldsBeanBuilder;
import org.joda.beans.impl.direct.DirectMetaBean;
import org.joda.beans.impl.direct.DirectMetaProperty;
import org.joda.beans.impl.direct.DirectMetaPropertyMap;

@BeanDefinition(constructorScope="package")
public final class GenericSecurityPosition
implements SecuritizedProductPosition<GenericSecurity>,
ImmutableBean,
Serializable {
    @PropertyDefinition(validate="notNull", overrideGet=true)
    private final PositionInfo info;
    @PropertyDefinition(validate="notNull")
    private final GenericSecurity security;
    @PropertyDefinition(validate="ArgChecker.notNegative")
    private final double longQuantity;
    @PropertyDefinition(validate="ArgChecker.notNegative")
    private final double shortQuantity;
    private static final long serialVersionUID = 1L;

    public static GenericSecurityPosition ofNet(GenericSecurity security, double netQuantity) {
        return GenericSecurityPosition.ofNet(PositionInfo.empty(), security, netQuantity);
    }

    public static GenericSecurityPosition ofNet(PositionInfo positionInfo, GenericSecurity security, double netQuantity) {
        double longQuantity = netQuantity >= 0.0 ? netQuantity : 0.0;
        double shortQuantity = netQuantity >= 0.0 ? 0.0 : -netQuantity;
        return new GenericSecurityPosition(positionInfo, security, longQuantity, shortQuantity);
    }

    public static GenericSecurityPosition ofLongShort(GenericSecurity security, double longQuantity, double shortQuantity) {
        return GenericSecurityPosition.ofLongShort(PositionInfo.empty(), security, longQuantity, shortQuantity);
    }

    public static GenericSecurityPosition ofLongShort(PositionInfo positionInfo, GenericSecurity security, double longQuantity, double shortQuantity) {
        return new GenericSecurityPosition(positionInfo, security, longQuantity, shortQuantity);
    }

    @ImmutableDefaults
    private static void applyDefaults(Builder builder) {
        builder.info = PositionInfo.empty();
    }

    @Override
    public SecurityId getSecurityId() {
        return this.security.getSecurityId();
    }

    @Override
    public GenericSecurity getProduct() {
        return this.security;
    }

    @Override
    public Currency getCurrency() {
        return this.security.getCurrency();
    }

    @Override
    @DerivedProperty
    public double getQuantity() {
        return this.longQuantity - this.shortQuantity;
    }

    @Override
    public GenericSecurityPosition withInfo(PortfolioItemInfo info) {
        return new GenericSecurityPosition(PositionInfo.from(info), this.security, this.longQuantity, this.shortQuantity);
    }

    @Override
    public GenericSecurityPosition withQuantity(double quantity) {
        return GenericSecurityPosition.ofNet(this.info, this.security, quantity);
    }

    @Override
    public PortfolioItemSummary summarize() {
        String description = this.getSecurityId().getStandardId().getValue() + " x " + SummarizerUtils.value(this.getQuantity());
        return SummarizerUtils.summary(this, ProductType.SECURITY, description, this.getCurrency());
    }

    public static Meta meta() {
        return Meta.INSTANCE;
    }

    public static Builder builder() {
        return new Builder();
    }

    GenericSecurityPosition(PositionInfo info, GenericSecurity security, double longQuantity, double shortQuantity) {
        JodaBeanUtils.notNull((Object)info, (String)"info");
        JodaBeanUtils.notNull((Object)security, (String)"security");
        ArgChecker.notNegative((double)longQuantity, (String)"longQuantity");
        ArgChecker.notNegative((double)shortQuantity, (String)"shortQuantity");
        this.info = info;
        this.security = security;
        this.longQuantity = longQuantity;
        this.shortQuantity = shortQuantity;
    }

    public Meta metaBean() {
        return Meta.INSTANCE;
    }

    @Override
    public PositionInfo getInfo() {
        return this.info;
    }

    public GenericSecurity getSecurity() {
        return this.security;
    }

    public double getLongQuantity() {
        return this.longQuantity;
    }

    public double getShortQuantity() {
        return this.shortQuantity;
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == this.getClass()) {
            GenericSecurityPosition other = (GenericSecurityPosition)obj;
            return JodaBeanUtils.equal((Object)this.info, (Object)other.info) && JodaBeanUtils.equal((Object)this.security, (Object)other.security) && JodaBeanUtils.equal((double)this.longQuantity, (double)other.longQuantity) && JodaBeanUtils.equal((double)this.shortQuantity, (double)other.shortQuantity);
        }
        return false;
    }

    public int hashCode() {
        int hash = this.getClass().hashCode();
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.info);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.security);
        hash = hash * 31 + JodaBeanUtils.hashCode((double)this.longQuantity);
        hash = hash * 31 + JodaBeanUtils.hashCode((double)this.shortQuantity);
        return hash;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(192);
        buf.append("GenericSecurityPosition{");
        buf.append("info").append('=').append(JodaBeanUtils.toString((Object)this.info)).append(',').append(' ');
        buf.append("security").append('=').append(JodaBeanUtils.toString((Object)this.security)).append(',').append(' ');
        buf.append("longQuantity").append('=').append(JodaBeanUtils.toString((Object)this.longQuantity)).append(',').append(' ');
        buf.append("shortQuantity").append('=').append(JodaBeanUtils.toString((Object)this.shortQuantity)).append(',').append(' ');
        buf.append("quantity").append('=').append(JodaBeanUtils.toString((Object)this.getQuantity()));
        buf.append('}');
        return buf.toString();
    }

    static {
        MetaBean.register((MetaBean)Meta.INSTANCE);
    }

    public static final class Builder
    extends DirectFieldsBeanBuilder<GenericSecurityPosition> {
        private PositionInfo info;
        private GenericSecurity security;
        private double longQuantity;
        private double shortQuantity;

        private Builder() {
            GenericSecurityPosition.applyDefaults(this);
        }

        private Builder(GenericSecurityPosition beanToCopy) {
            this.info = beanToCopy.getInfo();
            this.security = beanToCopy.getSecurity();
            this.longQuantity = beanToCopy.getLongQuantity();
            this.shortQuantity = beanToCopy.getShortQuantity();
        }

        public Object get(String propertyName) {
            switch (propertyName.hashCode()) {
                case 3237038: {
                    return this.info;
                }
                case 949122880: {
                    return this.security;
                }
                case 611668775: {
                    return this.longQuantity;
                }
                case -2094395097: {
                    return this.shortQuantity;
                }
            }
            throw new NoSuchElementException("Unknown property: " + propertyName);
        }

        public Builder set(String propertyName, Object newValue) {
            switch (propertyName.hashCode()) {
                case 3237038: {
                    this.info = (PositionInfo)newValue;
                    break;
                }
                case 949122880: {
                    this.security = (GenericSecurity)newValue;
                    break;
                }
                case 611668775: {
                    this.longQuantity = (Double)newValue;
                    break;
                }
                case -2094395097: {
                    this.shortQuantity = (Double)newValue;
                    break;
                }
                default: {
                    throw new NoSuchElementException("Unknown property: " + propertyName);
                }
            }
            return this;
        }

        public Builder set(MetaProperty<?> property, Object value) {
            super.set(property, value);
            return this;
        }

        public GenericSecurityPosition build() {
            return new GenericSecurityPosition(this.info, this.security, this.longQuantity, this.shortQuantity);
        }

        public Builder info(PositionInfo info) {
            JodaBeanUtils.notNull((Object)info, (String)"info");
            this.info = info;
            return this;
        }

        public Builder security(GenericSecurity security) {
            JodaBeanUtils.notNull((Object)security, (String)"security");
            this.security = security;
            return this;
        }

        public Builder longQuantity(double longQuantity) {
            ArgChecker.notNegative((double)longQuantity, (String)"longQuantity");
            this.longQuantity = longQuantity;
            return this;
        }

        public Builder shortQuantity(double shortQuantity) {
            ArgChecker.notNegative((double)shortQuantity, (String)"shortQuantity");
            this.shortQuantity = shortQuantity;
            return this;
        }

        public String toString() {
            StringBuilder buf = new StringBuilder(192);
            buf.append("GenericSecurityPosition.Builder{");
            buf.append("info").append('=').append(JodaBeanUtils.toString((Object)this.info)).append(',').append(' ');
            buf.append("security").append('=').append(JodaBeanUtils.toString((Object)this.security)).append(',').append(' ');
            buf.append("longQuantity").append('=').append(JodaBeanUtils.toString((Object)this.longQuantity)).append(',').append(' ');
            buf.append("shortQuantity").append('=').append(JodaBeanUtils.toString((Object)this.shortQuantity)).append(',').append(' ');
            buf.append("quantity").append('=').append(JodaBeanUtils.toString(null));
            buf.append('}');
            return buf.toString();
        }
    }

    public static final class Meta
    extends DirectMetaBean {
        static final Meta INSTANCE = new Meta();
        private final MetaProperty<PositionInfo> info = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"info", GenericSecurityPosition.class, PositionInfo.class);
        private final MetaProperty<GenericSecurity> security = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"security", GenericSecurityPosition.class, GenericSecurity.class);
        private final MetaProperty<Double> longQuantity = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"longQuantity", GenericSecurityPosition.class, Double.TYPE);
        private final MetaProperty<Double> shortQuantity = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"shortQuantity", GenericSecurityPosition.class, Double.TYPE);
        private final MetaProperty<Double> quantity = DirectMetaProperty.ofDerived((MetaBean)this, (String)"quantity", GenericSecurityPosition.class, Double.TYPE);
        private final Map<String, MetaProperty<?>> metaPropertyMap$ = new DirectMetaPropertyMap((DirectMetaBean)this, null, new String[]{"info", "security", "longQuantity", "shortQuantity", "quantity"});

        private Meta() {
        }

        protected MetaProperty<?> metaPropertyGet(String propertyName) {
            switch (propertyName.hashCode()) {
                case 3237038: {
                    return this.info;
                }
                case 949122880: {
                    return this.security;
                }
                case 611668775: {
                    return this.longQuantity;
                }
                case -2094395097: {
                    return this.shortQuantity;
                }
                case -1285004149: {
                    return this.quantity;
                }
            }
            return super.metaPropertyGet(propertyName);
        }

        public Builder builder() {
            return new Builder();
        }

        public Class<? extends GenericSecurityPosition> beanType() {
            return GenericSecurityPosition.class;
        }

        public Map<String, MetaProperty<?>> metaPropertyMap() {
            return this.metaPropertyMap$;
        }

        public MetaProperty<PositionInfo> info() {
            return this.info;
        }

        public MetaProperty<GenericSecurity> security() {
            return this.security;
        }

        public MetaProperty<Double> longQuantity() {
            return this.longQuantity;
        }

        public MetaProperty<Double> shortQuantity() {
            return this.shortQuantity;
        }

        public MetaProperty<Double> quantity() {
            return this.quantity;
        }

        protected Object propertyGet(Bean bean, String propertyName, boolean quiet) {
            switch (propertyName.hashCode()) {
                case 3237038: {
                    return ((GenericSecurityPosition)bean).getInfo();
                }
                case 949122880: {
                    return ((GenericSecurityPosition)bean).getSecurity();
                }
                case 611668775: {
                    return ((GenericSecurityPosition)bean).getLongQuantity();
                }
                case -2094395097: {
                    return ((GenericSecurityPosition)bean).getShortQuantity();
                }
                case -1285004149: {
                    return ((GenericSecurityPosition)bean).getQuantity();
                }
            }
            return super.propertyGet(bean, propertyName, quiet);
        }

        protected void propertySet(Bean bean, String propertyName, Object newValue, boolean quiet) {
            this.metaProperty(propertyName);
            if (quiet) {
                return;
            }
            throw new UnsupportedOperationException("Property cannot be written: " + propertyName);
        }
    }
}

