/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.product;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.opengamma.strata.basics.StandardId;
import com.opengamma.strata.product.AttributeType;
import com.opengamma.strata.product.Attributes;
import com.opengamma.strata.product.PortfolioItemInfo;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.function.Function;
import org.joda.beans.ImmutableBean;
import org.joda.beans.JodaBeanUtils;
import org.joda.beans.MetaBean;
import org.joda.beans.TypedMetaBean;
import org.joda.beans.gen.BeanDefinition;
import org.joda.beans.gen.PropertyDefinition;
import org.joda.beans.impl.direct.DirectPrivateBeanBuilder;
import org.joda.beans.impl.direct.MinimalMetaBean;

@BeanDefinition(style="minimal", builderScope="private", constructorScope="package")
final class ItemInfo
implements PortfolioItemInfo,
ImmutableBean,
Serializable {
    private static final ItemInfo EMPTY = new ItemInfo(null, (Map<AttributeType<?>, Object>)ImmutableMap.of());
    @PropertyDefinition(get="optional", overrideGet=true)
    private final StandardId id;
    @PropertyDefinition(validate="notNull")
    private final ImmutableMap<AttributeType<?>, Object> attributes;
    private static final TypedMetaBean<ItemInfo> META_BEAN = MinimalMetaBean.of(ItemInfo.class, (String[])new String[]{"id", "attributes"}, () -> new Builder(), (Function[])new Function[]{b -> b.id, b -> b.getAttributes()});
    private static final long serialVersionUID = 1L;

    static ItemInfo empty() {
        return EMPTY;
    }

    @Override
    public ItemInfo withId(StandardId identifier) {
        return new ItemInfo(identifier, (Map<AttributeType<?>, Object>)this.attributes);
    }

    @Override
    public ImmutableSet<AttributeType<?>> getAttributeTypes() {
        return this.attributes.keySet();
    }

    @Override
    public <T> Optional<T> findAttribute(AttributeType<T> type) {
        return Optional.ofNullable(type.fromStoredForm(this.attributes.get(type)));
    }

    @Override
    public <T> ItemInfo withAttribute(AttributeType<T> type, T value) {
        HashMap updatedAttributes = new HashMap((Map<AttributeType<?>, Object>)this.attributes);
        if (value == null) {
            updatedAttributes.remove(type);
        } else {
            updatedAttributes.put(type, type.toStoredForm(value));
        }
        return new ItemInfo(this.id, updatedAttributes);
    }

    @Override
    public ItemInfo withAttributes(Attributes other) {
        HashMap updatedAttributes = new HashMap((Map<AttributeType<?>, Object>)this.attributes);
        for (AttributeType type : other.getAttributeTypes()) {
            updatedAttributes.put(type, type.captureWildcard().toStoredForm(other.getAttribute(type)));
        }
        return new ItemInfo(this.id, updatedAttributes);
    }

    public static TypedMetaBean<ItemInfo> meta() {
        return META_BEAN;
    }

    ItemInfo(StandardId id, Map<AttributeType<?>, Object> attributes) {
        JodaBeanUtils.notNull(attributes, (String)"attributes");
        this.id = id;
        this.attributes = ImmutableMap.copyOf(attributes);
    }

    public TypedMetaBean<ItemInfo> metaBean() {
        return META_BEAN;
    }

    @Override
    public Optional<StandardId> getId() {
        return Optional.ofNullable(this.id);
    }

    public ImmutableMap<AttributeType<?>, Object> getAttributes() {
        return this.attributes;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == this.getClass()) {
            ItemInfo other = (ItemInfo)obj;
            return JodaBeanUtils.equal((Object)this.id, (Object)other.id) && JodaBeanUtils.equal(this.attributes, other.attributes);
        }
        return false;
    }

    public int hashCode() {
        int hash = this.getClass().hashCode();
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.id);
        hash = hash * 31 + JodaBeanUtils.hashCode(this.attributes);
        return hash;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(96);
        buf.append("ItemInfo{");
        buf.append("id").append('=').append(JodaBeanUtils.toString((Object)this.id)).append(',').append(' ');
        buf.append("attributes").append('=').append(JodaBeanUtils.toString(this.attributes));
        buf.append('}');
        return buf.toString();
    }

    static {
        MetaBean.register(META_BEAN);
    }

    private static final class Builder
    extends DirectPrivateBeanBuilder<ItemInfo> {
        private StandardId id;
        private Map<AttributeType<?>, Object> attributes = ImmutableMap.of();

        private Builder() {
        }

        public Object get(String propertyName) {
            switch (propertyName.hashCode()) {
                case 3355: {
                    return this.id;
                }
                case 405645655: {
                    return this.attributes;
                }
            }
            throw new NoSuchElementException("Unknown property: " + propertyName);
        }

        public Builder set(String propertyName, Object newValue) {
            switch (propertyName.hashCode()) {
                case 3355: {
                    this.id = (StandardId)newValue;
                    break;
                }
                case 405645655: {
                    this.attributes = (Map)newValue;
                    break;
                }
                default: {
                    throw new NoSuchElementException("Unknown property: " + propertyName);
                }
            }
            return this;
        }

        public ItemInfo build() {
            return new ItemInfo(this.id, this.attributes);
        }

        public String toString() {
            StringBuilder buf = new StringBuilder(96);
            buf.append("ItemInfo.Builder{");
            buf.append("id").append('=').append(JodaBeanUtils.toString((Object)this.id)).append(',').append(' ');
            buf.append("attributes").append('=').append(JodaBeanUtils.toString(this.attributes));
            buf.append('}');
            return buf.toString();
        }
    }
}

