/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.product;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.opengamma.strata.basics.StandardId;
import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.product.AttributeType;
import com.opengamma.strata.product.Attributes;
import com.opengamma.strata.product.ItemInfo;
import com.opengamma.strata.product.PortfolioItemInfoBuilder;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

public interface PortfolioItemInfo
extends Attributes {
    public static PortfolioItemInfo empty() {
        return ItemInfo.empty();
    }

    public static <T> PortfolioItemInfo of(AttributeType<T> type, T value) {
        return new ItemInfo(null, (Map<AttributeType<?>, Object>)ImmutableMap.of(type, (Object)type.toStoredForm(value)));
    }

    public static PortfolioItemInfoBuilder<PortfolioItemInfo> builder() {
        return new PortfolioItemInfoBuilder<PortfolioItemInfo>(){
            private StandardId id;
            private final Map<AttributeType<?>, Object> attributes = new HashMap();

            @Override
            public PortfolioItemInfoBuilder<PortfolioItemInfo> id(StandardId id) {
                this.id = id;
                return this;
            }

            @Override
            public <V> PortfolioItemInfoBuilder<PortfolioItemInfo> addAttribute(AttributeType<V> attributeType, V attributeValue) {
                ArgChecker.notNull(attributeType, (String)"attributeType");
                ArgChecker.notNull(attributeValue, (String)"attributeValue");
                this.attributes.put(attributeType, attributeType.toStoredForm(attributeValue));
                return this;
            }

            @Override
            public PortfolioItemInfo build() {
                return new ItemInfo(this.id, this.attributes);
            }
        };
    }

    public Optional<StandardId> getId();

    public PortfolioItemInfo withId(StandardId var1);

    @Override
    public ImmutableSet<AttributeType<?>> getAttributeTypes();

    @Override
    public <T> PortfolioItemInfo withAttribute(AttributeType<T> var1, T var2);

    @Override
    default public PortfolioItemInfo withAttributes(Attributes other) {
        return (PortfolioItemInfo)Attributes.super.withAttributes(other);
    }

    default public PortfolioItemInfo combinedWith(PortfolioItemInfo other) {
        Attributes combinedInfo = this;
        if (!combinedInfo.getId().isPresent() && other.getId().isPresent()) {
            combinedInfo = combinedInfo.withId(other.getId().get());
        }
        for (AttributeType attrType : other.getAttributeTypes()) {
            if (combinedInfo.getAttributeTypes().contains((Object)attrType)) continue;
            combinedInfo = combinedInfo.withAttribute(attrType.captureWildcard(), other.getAttribute(attrType));
        }
        return combinedInfo;
    }

    default public PortfolioItemInfo overrideWith(PortfolioItemInfo other) {
        Attributes combinedInfo = this;
        if (other.getId().isPresent()) {
            combinedInfo = combinedInfo.withId(other.getId().get());
        }
        for (AttributeType attrType : other.getAttributeTypes()) {
            combinedInfo = combinedInfo.withAttribute(attrType.captureWildcard(), other.getAttribute(attrType));
        }
        return combinedInfo;
    }
}

