/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.product;

import com.google.common.collect.ImmutableSet;
import com.opengamma.strata.basics.StandardId;
import com.opengamma.strata.basics.currency.Currency;
import com.opengamma.strata.collect.named.Described;
import com.opengamma.strata.product.PortfolioItemType;
import com.opengamma.strata.product.ProductType;
import java.io.Serializable;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import org.joda.beans.ImmutableBean;
import org.joda.beans.JodaBeanUtils;
import org.joda.beans.MetaBean;
import org.joda.beans.MetaProperty;
import org.joda.beans.TypedMetaBean;
import org.joda.beans.gen.BeanDefinition;
import org.joda.beans.gen.PropertyDefinition;
import org.joda.beans.impl.direct.DirectFieldsBeanBuilder;
import org.joda.beans.impl.direct.MinimalMetaBean;

@BeanDefinition(style="minimal", metaScope="private", factoryName="of")
public final class PortfolioItemSummary
implements Described,
ImmutableBean,
Serializable {
    @PropertyDefinition(get="optional")
    private final StandardId id;
    @PropertyDefinition(validate="notNull")
    private final PortfolioItemType portfolioItemType;
    @PropertyDefinition(validate="notNull")
    private final ProductType productType;
    @PropertyDefinition(validate="notNull")
    private final ImmutableSet<Currency> currencies;
    @PropertyDefinition(validate="notBlank", overrideGet=true)
    private final String description;
    private static final TypedMetaBean<PortfolioItemSummary> META_BEAN = MinimalMetaBean.of(PortfolioItemSummary.class, (String[])new String[]{"id", "portfolioItemType", "productType", "currencies", "description"}, () -> new Builder(), (Function[])new Function[]{b -> b.id, b -> b.getPortfolioItemType(), b -> b.getProductType(), b -> b.getCurrencies(), b -> b.getDescription()});
    private static final long serialVersionUID = 1L;

    public static TypedMetaBean<PortfolioItemSummary> meta() {
        return META_BEAN;
    }

    public static PortfolioItemSummary of(StandardId id, PortfolioItemType portfolioItemType, ProductType productType, Set<Currency> currencies, String description) {
        return new PortfolioItemSummary(id, portfolioItemType, productType, currencies, description);
    }

    public static Builder builder() {
        return new Builder();
    }

    private PortfolioItemSummary(StandardId id, PortfolioItemType portfolioItemType, ProductType productType, Set<Currency> currencies, String description) {
        JodaBeanUtils.notNull((Object)((Object)portfolioItemType), (String)"portfolioItemType");
        JodaBeanUtils.notNull((Object)((Object)productType), (String)"productType");
        JodaBeanUtils.notNull(currencies, (String)"currencies");
        JodaBeanUtils.notBlank((String)description, (String)"description");
        this.id = id;
        this.portfolioItemType = portfolioItemType;
        this.productType = productType;
        this.currencies = ImmutableSet.copyOf(currencies);
        this.description = description;
    }

    public TypedMetaBean<PortfolioItemSummary> metaBean() {
        return META_BEAN;
    }

    public Optional<StandardId> getId() {
        return Optional.ofNullable(this.id);
    }

    public PortfolioItemType getPortfolioItemType() {
        return this.portfolioItemType;
    }

    public ProductType getProductType() {
        return this.productType;
    }

    public ImmutableSet<Currency> getCurrencies() {
        return this.currencies;
    }

    public String getDescription() {
        return this.description;
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == this.getClass()) {
            PortfolioItemSummary other = (PortfolioItemSummary)obj;
            return JodaBeanUtils.equal((Object)this.id, (Object)other.id) && JodaBeanUtils.equal((Object)((Object)this.portfolioItemType), (Object)((Object)other.portfolioItemType)) && JodaBeanUtils.equal((Object)((Object)this.productType), (Object)((Object)other.productType)) && JodaBeanUtils.equal(this.currencies, other.currencies) && JodaBeanUtils.equal((Object)this.description, (Object)other.description);
        }
        return false;
    }

    public int hashCode() {
        int hash = this.getClass().hashCode();
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.id);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)((Object)this.portfolioItemType));
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)((Object)this.productType));
        hash = hash * 31 + JodaBeanUtils.hashCode(this.currencies);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.description);
        return hash;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(192);
        buf.append("PortfolioItemSummary{");
        buf.append("id").append('=').append(JodaBeanUtils.toString((Object)this.id)).append(',').append(' ');
        buf.append("portfolioItemType").append('=').append(JodaBeanUtils.toString((Object)((Object)this.portfolioItemType))).append(',').append(' ');
        buf.append("productType").append('=').append(JodaBeanUtils.toString((Object)((Object)this.productType))).append(',').append(' ');
        buf.append("currencies").append('=').append(JodaBeanUtils.toString(this.currencies)).append(',').append(' ');
        buf.append("description").append('=').append(JodaBeanUtils.toString((Object)this.description));
        buf.append('}');
        return buf.toString();
    }

    static {
        MetaBean.register(META_BEAN);
    }

    public static final class Builder
    extends DirectFieldsBeanBuilder<PortfolioItemSummary> {
        private StandardId id;
        private PortfolioItemType portfolioItemType;
        private ProductType productType;
        private Set<Currency> currencies = ImmutableSet.of();
        private String description;

        private Builder() {
        }

        private Builder(PortfolioItemSummary beanToCopy) {
            this.id = beanToCopy.id;
            this.portfolioItemType = beanToCopy.getPortfolioItemType();
            this.productType = beanToCopy.getProductType();
            this.currencies = beanToCopy.getCurrencies();
            this.description = beanToCopy.getDescription();
        }

        public Object get(String propertyName) {
            switch (propertyName.hashCode()) {
                case 3355: {
                    return this.id;
                }
                case 1766940245: {
                    return this.portfolioItemType;
                }
                case -1491615543: {
                    return this.productType;
                }
                case -1089470353: {
                    return this.currencies;
                }
                case -1724546052: {
                    return this.description;
                }
            }
            throw new NoSuchElementException("Unknown property: " + propertyName);
        }

        public Builder set(String propertyName, Object newValue) {
            switch (propertyName.hashCode()) {
                case 3355: {
                    this.id = (StandardId)newValue;
                    break;
                }
                case 1766940245: {
                    this.portfolioItemType = (PortfolioItemType)((Object)newValue);
                    break;
                }
                case -1491615543: {
                    this.productType = (ProductType)((Object)newValue);
                    break;
                }
                case -1089470353: {
                    this.currencies = (Set)newValue;
                    break;
                }
                case -1724546052: {
                    this.description = (String)newValue;
                    break;
                }
                default: {
                    throw new NoSuchElementException("Unknown property: " + propertyName);
                }
            }
            return this;
        }

        public Builder set(MetaProperty<?> property, Object value) {
            super.set(property, value);
            return this;
        }

        public PortfolioItemSummary build() {
            return new PortfolioItemSummary(this.id, this.portfolioItemType, this.productType, this.currencies, this.description);
        }

        public Builder id(StandardId id) {
            this.id = id;
            return this;
        }

        public Builder portfolioItemType(PortfolioItemType portfolioItemType) {
            JodaBeanUtils.notNull((Object)((Object)portfolioItemType), (String)"portfolioItemType");
            this.portfolioItemType = portfolioItemType;
            return this;
        }

        public Builder productType(ProductType productType) {
            JodaBeanUtils.notNull((Object)((Object)productType), (String)"productType");
            this.productType = productType;
            return this;
        }

        public Builder currencies(Set<Currency> currencies) {
            JodaBeanUtils.notNull(currencies, (String)"currencies");
            this.currencies = currencies;
            return this;
        }

        public Builder currencies(Currency ... currencies) {
            return this.currencies((Set<Currency>)ImmutableSet.copyOf((Object[])currencies));
        }

        public Builder description(String description) {
            JodaBeanUtils.notBlank((String)description, (String)"description");
            this.description = description;
            return this;
        }

        public String toString() {
            StringBuilder buf = new StringBuilder(192);
            buf.append("PortfolioItemSummary.Builder{");
            buf.append("id").append('=').append(JodaBeanUtils.toString((Object)this.id)).append(',').append(' ');
            buf.append("portfolioItemType").append('=').append(JodaBeanUtils.toString((Object)((Object)this.portfolioItemType))).append(',').append(' ');
            buf.append("productType").append('=').append(JodaBeanUtils.toString((Object)((Object)this.productType))).append(',').append(' ');
            buf.append("currencies").append('=').append(JodaBeanUtils.toString(this.currencies)).append(',').append(' ');
            buf.append("description").append('=').append(JodaBeanUtils.toString((Object)this.description));
            buf.append('}');
            return buf.toString();
        }
    }
}

