/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.product;

import com.opengamma.strata.basics.currency.Currency;
import com.opengamma.strata.product.PortfolioItem;
import com.opengamma.strata.product.PortfolioItemInfo;
import com.opengamma.strata.product.PortfolioItemSummary;
import com.opengamma.strata.product.PositionInfo;
import com.opengamma.strata.product.ProductType;
import com.opengamma.strata.product.SecurityId;
import com.opengamma.strata.product.SecurityQuantity;
import com.opengamma.strata.product.common.SummarizerUtils;

public interface Position
extends PortfolioItem,
SecurityQuantity {
    @Override
    default public PortfolioItemSummary summarize() {
        String description = this.getSecurityId().getStandardId().getValue() + " x " + SummarizerUtils.value(this.getQuantity());
        return SummarizerUtils.summary(this, ProductType.SECURITY, description, new Currency[0]);
    }

    @Override
    public PositionInfo getInfo();

    @Override
    public SecurityId getSecurityId();

    @Override
    public double getQuantity();

    @Override
    public Position withInfo(PortfolioItemInfo var1);

    public Position withQuantity(double var1);
}

