/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.product;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.opengamma.strata.basics.StandardId;
import com.opengamma.strata.product.AttributeType;
import com.opengamma.strata.product.Attributes;
import com.opengamma.strata.product.PortfolioItemInfo;
import com.opengamma.strata.product.PositionInfoBuilder;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import org.joda.beans.Bean;
import org.joda.beans.BeanBuilder;
import org.joda.beans.ImmutableBean;
import org.joda.beans.JodaBeanUtils;
import org.joda.beans.MetaBean;
import org.joda.beans.MetaProperty;
import org.joda.beans.gen.BeanDefinition;
import org.joda.beans.gen.PropertyDefinition;
import org.joda.beans.impl.direct.DirectMetaBean;
import org.joda.beans.impl.direct.DirectMetaProperty;
import org.joda.beans.impl.direct.DirectMetaPropertyMap;
import org.joda.beans.impl.direct.DirectPrivateBeanBuilder;

@BeanDefinition(builderScope="private", constructorScope="package")
public final class PositionInfo
implements PortfolioItemInfo,
ImmutableBean,
Serializable {
    private static final PositionInfo EMPTY = new PositionInfo(null, (Map<AttributeType<?>, Object>)ImmutableMap.of());
    @PropertyDefinition(get="optional", overrideGet=true)
    private final StandardId id;
    @PropertyDefinition(validate="notNull")
    private final ImmutableMap<AttributeType<?>, Object> attributes;
    private static final long serialVersionUID = 1L;

    public static PositionInfo empty() {
        return EMPTY;
    }

    public static PositionInfo of(StandardId positionId) {
        return new PositionInfo(positionId, (Map<AttributeType<?>, Object>)ImmutableMap.of());
    }

    public static PositionInfo from(PortfolioItemInfo info) {
        if (info instanceof PositionInfo) {
            return (PositionInfo)info;
        }
        return PositionInfo.empty().combinedWith(info);
    }

    public static PositionInfoBuilder builder() {
        return new PositionInfoBuilder();
    }

    @Override
    public PositionInfo withId(StandardId identifier) {
        return new PositionInfo(identifier, (Map<AttributeType<?>, Object>)this.attributes);
    }

    @Override
    public ImmutableSet<AttributeType<?>> getAttributeTypes() {
        return this.attributes.keySet();
    }

    @Override
    public <T> Optional<T> findAttribute(AttributeType<T> type) {
        return Optional.ofNullable(type.fromStoredForm(this.attributes.get(type)));
    }

    @Override
    public <T> PositionInfo withAttribute(AttributeType<T> type, T value) {
        HashMap updatedAttributes = new HashMap((Map<AttributeType<?>, Object>)this.attributes);
        if (value == null) {
            updatedAttributes.remove(type);
        } else {
            updatedAttributes.put(type, type.toStoredForm(value));
        }
        return new PositionInfo(this.id, updatedAttributes);
    }

    @Override
    public PositionInfo withAttributes(Attributes other) {
        PositionInfoBuilder builder = this.toBuilder();
        for (AttributeType attrType : other.getAttributeTypes()) {
            builder.addAttribute(attrType.captureWildcard(), other.getAttribute(attrType));
        }
        return builder.build();
    }

    @Override
    public PositionInfo combinedWith(PortfolioItemInfo other) {
        PositionInfoBuilder builder = this.toBuilder();
        other.getId().filter(ignored -> this.id == null).ifPresent(builder::id);
        for (AttributeType attrType : other.getAttributeTypes()) {
            if (this.attributes.keySet().contains((Object)attrType)) continue;
            builder.addAttribute(attrType.captureWildcard(), other.getAttribute(attrType));
        }
        return builder.build();
    }

    @Override
    public PositionInfo overrideWith(PortfolioItemInfo other) {
        PositionInfoBuilder builder = this.toBuilder();
        other.getId().ifPresent(builder::id);
        for (AttributeType attrType : other.getAttributeTypes()) {
            builder.addAttribute(attrType.captureWildcard(), other.getAttribute(attrType));
        }
        return builder.build();
    }

    public PositionInfoBuilder toBuilder() {
        return new PositionInfoBuilder(this.id, (Map<AttributeType<?>, Object>)this.attributes);
    }

    public static Meta meta() {
        return Meta.INSTANCE;
    }

    PositionInfo(StandardId id, Map<AttributeType<?>, Object> attributes) {
        JodaBeanUtils.notNull(attributes, (String)"attributes");
        this.id = id;
        this.attributes = ImmutableMap.copyOf(attributes);
    }

    public Meta metaBean() {
        return Meta.INSTANCE;
    }

    @Override
    public Optional<StandardId> getId() {
        return Optional.ofNullable(this.id);
    }

    public ImmutableMap<AttributeType<?>, Object> getAttributes() {
        return this.attributes;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == this.getClass()) {
            PositionInfo other = (PositionInfo)obj;
            return JodaBeanUtils.equal((Object)this.id, (Object)other.id) && JodaBeanUtils.equal(this.attributes, other.attributes);
        }
        return false;
    }

    public int hashCode() {
        int hash = this.getClass().hashCode();
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.id);
        hash = hash * 31 + JodaBeanUtils.hashCode(this.attributes);
        return hash;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(96);
        buf.append("PositionInfo{");
        buf.append("id").append('=').append(JodaBeanUtils.toString((Object)this.id)).append(',').append(' ');
        buf.append("attributes").append('=').append(JodaBeanUtils.toString(this.attributes));
        buf.append('}');
        return buf.toString();
    }

    static {
        MetaBean.register((MetaBean)Meta.INSTANCE);
    }

    private static final class Builder
    extends DirectPrivateBeanBuilder<PositionInfo> {
        private StandardId id;
        private Map<AttributeType<?>, Object> attributes = ImmutableMap.of();

        private Builder() {
        }

        public Object get(String propertyName) {
            switch (propertyName.hashCode()) {
                case 3355: {
                    return this.id;
                }
                case 405645655: {
                    return this.attributes;
                }
            }
            throw new NoSuchElementException("Unknown property: " + propertyName);
        }

        public Builder set(String propertyName, Object newValue) {
            switch (propertyName.hashCode()) {
                case 3355: {
                    this.id = (StandardId)newValue;
                    break;
                }
                case 405645655: {
                    this.attributes = (Map)newValue;
                    break;
                }
                default: {
                    throw new NoSuchElementException("Unknown property: " + propertyName);
                }
            }
            return this;
        }

        public PositionInfo build() {
            return new PositionInfo(this.id, this.attributes);
        }

        public String toString() {
            StringBuilder buf = new StringBuilder(96);
            buf.append("PositionInfo.Builder{");
            buf.append("id").append('=').append(JodaBeanUtils.toString((Object)this.id)).append(',').append(' ');
            buf.append("attributes").append('=').append(JodaBeanUtils.toString(this.attributes));
            buf.append('}');
            return buf.toString();
        }
    }

    public static final class Meta
    extends DirectMetaBean {
        static final Meta INSTANCE = new Meta();
        private final MetaProperty<StandardId> id = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"id", PositionInfo.class, StandardId.class);
        private final MetaProperty<ImmutableMap<AttributeType<?>, Object>> attributes = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"attributes", PositionInfo.class, ImmutableMap.class);
        private final Map<String, MetaProperty<?>> metaPropertyMap$ = new DirectMetaPropertyMap((DirectMetaBean)this, null, new String[]{"id", "attributes"});

        private Meta() {
        }

        protected MetaProperty<?> metaPropertyGet(String propertyName) {
            switch (propertyName.hashCode()) {
                case 3355: {
                    return this.id;
                }
                case 405645655: {
                    return this.attributes;
                }
            }
            return super.metaPropertyGet(propertyName);
        }

        public BeanBuilder<? extends PositionInfo> builder() {
            return new Builder();
        }

        public Class<? extends PositionInfo> beanType() {
            return PositionInfo.class;
        }

        public Map<String, MetaProperty<?>> metaPropertyMap() {
            return this.metaPropertyMap$;
        }

        public MetaProperty<StandardId> id() {
            return this.id;
        }

        public MetaProperty<ImmutableMap<AttributeType<?>, Object>> attributes() {
            return this.attributes;
        }

        protected Object propertyGet(Bean bean, String propertyName, boolean quiet) {
            switch (propertyName.hashCode()) {
                case 3355: {
                    return ((PositionInfo)bean).id;
                }
                case 405645655: {
                    return ((PositionInfo)bean).getAttributes();
                }
            }
            return super.propertyGet(bean, propertyName, quiet);
        }

        protected void propertySet(Bean bean, String propertyName, Object newValue, boolean quiet) {
            this.metaProperty(propertyName);
            if (quiet) {
                return;
            }
            throw new UnsupportedOperationException("Property cannot be written: " + propertyName);
        }
    }
}

