/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.product;

import com.opengamma.strata.basics.StandardId;
import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.product.AttributeType;
import com.opengamma.strata.product.PortfolioItemInfoBuilder;
import com.opengamma.strata.product.PositionInfo;
import java.util.HashMap;
import java.util.Map;

public final class PositionInfoBuilder
implements PortfolioItemInfoBuilder<PositionInfo> {
    private StandardId id;
    private final Map<AttributeType<?>, Object> attributes = new HashMap();

    PositionInfoBuilder() {
    }

    PositionInfoBuilder(StandardId id, Map<AttributeType<?>, Object> attributes) {
        this.id = id;
        this.attributes.putAll(attributes);
    }

    public PositionInfoBuilder id(StandardId id) {
        this.id = id;
        return this;
    }

    public <T> PositionInfoBuilder addAttribute(AttributeType<T> attributeType, T attributeValue) {
        ArgChecker.notNull(attributeType, (String)"attributeType");
        ArgChecker.notNull(attributeValue, (String)"attributeValue");
        this.attributes.put(attributeType, attributeType.toStoredForm(attributeValue));
        return this;
    }

    @Override
    public PositionInfo build() {
        return new PositionInfo(this.id, this.attributes);
    }
}

